<?php
if (!defined("ABSPATH")) {
    exit();
}

//Check Woocommerce
function check_for_woocommerce()
{
    include_once ABSPATH . "wp-admin/includes/plugin.php";

    if (!is_plugin_active("woocommerce/woocommerce.php")) {
        add_action("admin_notices", "woocommerce_install_or_activate_notice");
    }
}
add_action("admin_init", "check_for_woocommerce");

function woocommerce_install_or_activate_notice()
{
    $plugin_file = "woocommerce/woocommerce.php";

    if (file_exists(WP_PLUGIN_DIR . "/" . $plugin_file)) { ?>
        <div class="notice notice-warning">
            <p><?php _e(
                "افزونه نوبت پلاس نیاز به نصب و فعالسازی افزونه ووکامرس دارد."
            ); ?></p>
            <p>
                <a href="<?php echo esc_url(
                    admin_url(
                        "plugins.php?action=activate&plugin=" .
                            urlencode($plugin_file) .
                            "&_wpnonce=" .
                            wp_create_nonce("activate-plugin_" . $plugin_file)
                    )
                ); ?>" class="button button-primary">
                    <?php _e("فعال سازی ووکامرس", "your-plugin-textdomain"); ?>
                </a>
            </p>
        </div>
        <?php } else { ?>
        <div class="notice notice-error">
            <p><?php _e(
                "افزونه نوبت پلاس نیاز به نصب و فعالسازی افزونه ووکامرس دارد."
            ); ?></p>
            <p>
                <a href="<?php echo esc_url(
                    admin_url(
                        "plugin-install.php?s=woocommerce&tab=search&type=term"
                    )
                ); ?>" class="button button-primary">
                    <?php _e("نصب ووکامرس", "your-plugin-textdomain"); ?>
                </a>
            </p>
        </div>
        <?php }
}

//Email Setting Page
function sab_email_settings_page()
{
    if (isset($_POST["sab_save_email_settings"])) {

		$admin_emails = isset($_POST['admin_email']) ? sanitize_text_field($_POST['admin_email']) : '';
        if (!empty($admin_emails)) {
            $email_array = array_map('trim', explode(',', $admin_emails));
            $valid_emails = array_filter($email_array, 'is_email');
            if (empty($valid_emails)) {
                echo '<div class="error"><p>هیچ ایمیل معتبری وارد نشده است.</p></div>';
            } else {
                update_option('sab_admin_email', implode(',', $valid_emails));
            }
        } else {
            update_option('sab_admin_email', '');
        }
        update_option("sab_admin_email_subject", sanitize_text_field($_POST["admin_email_subject"]));
        update_option("sab_admin_email_body", wp_kses_post($_POST["admin_email_body"]));
        update_option("sab_user_email_subject", sanitize_text_field($_POST["user_email_subject"]));
        update_option("sab_user_email_body", wp_kses_post($_POST["user_email_body"]));
        update_option("sab_sms_username", sanitize_text_field($_POST["sms_username"]));
        update_option("sab_sms_password", sanitize_text_field($_POST["sms_password"]));
        update_option("sab_sms_from", sanitize_text_field($_POST["sms_from"]));
        update_option('sab_sms_use_template_user', isset($_POST['sms_use_template_user']) ? 1 : 0);
        update_option('sab_sms_template_id_user', sanitize_text_field($_POST['sms_template_id_user']));
        update_option('sab_sms_use_template_admin', isset($_POST['sms_use_template_admin']) ? 1 : 0);
        update_option('sab_sms_template_id_admin', sanitize_text_field($_POST['sms_template_id_admin']));
        update_option('sab_sms_use_template_doctor', isset($_POST['sms_use_template_doctor']) ? 1 : 0);
        update_option('sab_sms_template_id_doctor', sanitize_text_field($_POST['sms_template_id_doctor']));
        update_option("sab_ippanel_username", sanitize_text_field($_POST["ippanel_username"]));
        update_option("sab_ippanel_password", sanitize_text_field($_POST["ippanel_password"]));
        update_option("sab_ippanel_from", sanitize_text_field($_POST["ippanel_from"]));
        update_option("sab_ippanel_admin_mobile", sanitize_text_field($_POST["ippanel_admin_mobile"]));
        update_option("sab_sms_admin_mobile", sanitize_text_field($_POST["sms_admin_mobile"]));
        update_option("sab_doctor_sms_mobile", sanitize_text_field($_POST["doctor_sms_mobile"]));
        update_option("sab_doctor_faraz_mobile",  sanitize_text_field($_POST["doctor_faraz_mobile"]));
        update_option("sab_sms_message_user", sanitize_textarea_field($_POST["sms_message_user"]));
        update_option("sab_sms_message_admin", sanitize_textarea_field($_POST["sms_message_admin"]));
        update_option("sab_sms_message_doctor", sanitize_textarea_field($_POST["sms_message_doctor"]));
        update_option("sab_ippanel_message_user", sanitize_textarea_field($_POST["ippanel_message_user"]));
        update_option("sab_ippanel_message_admin", sanitize_textarea_field($_POST["ippanel_message_admin"]));
        update_option("sab_ippanel_message_doctor", sanitize_textarea_field($_POST["ippanel_message_doctor"]));        

		update_option('sab_sms_use_template_user_24h', isset($_POST['sms_use_template_user_24h']) ? 1 : 0);
		update_option('sab_sms_template_id_user_24h', sanitize_text_field($_POST['sms_template_id_user_24h']));
		update_option('sab_sms_message_user_24h', sanitize_textarea_field($_POST['sms_message_user_24h']));
		update_option('sab_sms_use_template_user_2h', isset($_POST['sms_use_template_user_2h']) ? 1 : 0);
		update_option('sab_sms_template_id_user_2h', sanitize_text_field($_POST['sms_template_id_user_2h']));
		update_option('sab_sms_message_user_2h', sanitize_textarea_field($_POST['sms_message_user_2h']));

		update_option('sab_ippanel_message_user_24h', sanitize_textarea_field($_POST['ippanel_message_user_24h']));
		update_option('sab_ippanel_message_user_2h', sanitize_textarea_field($_POST['ippanel_message_user_2h']));
        echo '<div class="updated"><p>تنظیمات با موفقیت ذخیره شد.</p></div>';
    }

    $admin_email = get_option("sab_admin_email", get_option("admin_email"));
    $admin_email_subject = get_option(
        "sab_admin_email_subject",
        "رزرو نوبت جدید"
    );
    $admin_email_body = get_option(
        "sab_admin_email_body",
        "<p>فرم ثبت شد:</p><p>نام ارسال کننده: {name}</p><p>ایمیل: {email}</p><p>تلفن: {phone}</p><p>تلفن همراه: {mobile}</p><p>خدمات: {service}</p><p>ارائه دهنده: {doctor}</p><p>تاریخ: {date}</p><p>زمان: {time}</p>"
    );
    $user_email_subject = get_option(
        "sab_user_email_subject",
        "تایید رزرو نوبت"
    );
    $user_email_body = get_option(
        "sab_user_email_body",
        "<p>فرم ثبت شد:</p><p>نام ارسال کننده: {name}</p><p>ایمیل: {email}</p><p>تلفن: {phone}</p><p>تلفن همراه: {mobile}</p><p>خدمات: {service}</p><p>ارائه دهنده: {doctor}</p><p>تاریخ: {date}</p><p>زمان: {time}</p>"
    );

    // Melipayamak
    $sms_username = get_option("sab_sms_username", "");
    $sms_password = get_option("sab_sms_password", "");
    $sms_from = get_option("sab_sms_from", "");

    $sms_user_message = get_option('sab_sms_message_user', 'با تشکر از رزرو شما {name} گرامی
شما زمان: {time} در تاریخ: {date} را جهت خدمات: {service} توسط: {doctor} رزرو نموده اید.');
    $sms_admin_message = get_option('sab_sms_message_admin', 'شخصی با نام {name} زمان: {time}  تاریخ: {date} را جهت خدمات: {service} توسط: {doctor} رزرو نمود.');
    $sms_doctor_message = get_option('sab_sms_message_doctor', 'کاربری با نام {name} زمان: {time}  تاریخ: {date} را جهت خدمات: {service} توسط: {doctor} رزرو نمود.');

    // Faraz SMS
    $ippanel_username = get_option("sab_ippanel_username", "");
    $ippanel_password = get_option("sab_ippanel_password", "");
    $ippanel_from = get_option("sab_ippanel_from", "3000505");

    $ippanel_user_message = get_option('sab_ippanel_message_user', 'با تشکر از رزرو شما {name} گرامی
شما زمان: {time} در تاریخ: {date} را جهت خدمات: {service} توسط: {doctor} رزرو نموده اید.');
    $ippanel_admin_message = get_option('sab_ippanel_message_admin', 'شخصی با نام {name} زمان: {time}  تاریخ: {date} را جهت خدمات: {service} توسط: {doctor} رزرو نمود.');
    $ippanel_doctor_message = get_option('sab_ippanel_message_doctor', 'کاربری با نام {name} زمان: {time}  تاریخ: {date} را جهت خدمات: {service} توسط: {doctor} رزرو نمود.');    

    ?>
    <div class="wrap-nobat">
        <form method="post">        
            <div class="melpayamak">
                <h2 style="color: green;">تنظیمات ملی پیامک</h2>
                <hr>
                <h4>هر یک از متغیرهای زیر مقدار ورودی کاربر در فرم را به متن پیامک اضافه می کند</h4>
                <p class="changer-info">
                    نام ارسال کننده: {name} 
                    <span>تلفن: {phone}</span>
                    <span>تلفن همراه: {mobile}</span>
                    <span>خدمات: {service}</span>
                    <span>ارائه دهنده: {doctor}</span>
                    <span>تاریخ: {date}</span>
                    <span>زمان: {time}</span>
                    <span>فیلد  1: {custom-1}</span>
                    <span>فیلد  2: {custom-2}</span>
                    <span>فیلد  3: {custom-3}</span>
                    <span>فیلد  4: {custom-4}</span>
                </p>
                <div class="form-table">
                    <div class="befor-labalandfield">
                        <div class="in-labalandfield">
                            <div scope="row"><label for="sms_username">نام کاربری ملی پیامک</label></div>
                            <div><input class="nobat-put" name="sms_username" type="text" id="sms_username" value="<?php echo esc_attr($sms_username); ?>" class="regular-text"></div>
                        </div>
                        <div class="in-labalandfield">
                            <div scope="row"><label for="sms_password">رمز عبور ملی پیامک</label></div>
                            <div><input class="nobat-put" name="sms_password" id="sms_password" value="<?php echo esc_attr($sms_password); ?>" class="regular-text"></div>
                        </div>
                        <div class="in-labalandfield">
                            <div scope="row"><label for="sms_from">شماره فرستنده ملی پیامک</label></div>
                            <div><input class="nobat-put" name="sms_from" type="text" id "sms_from" value="<?php echo esc_attr($sms_from); ?>" class="regular-text"></div>
                        </div>
                        <div class="in-labalandfield">
                            <div scope="row"><label for="sms_admin_mobile">شماره مدیر</label></div>
                            <div><input class="nobat-put" name="sms_admin_mobile" type="text" id="sms_admin_mobile" value="<?php echo esc_attr(get_option('sab_sms_admin_mobile')); ?>" class="regular-text"></div>
                        </div>
                        <div class="in-labalandfield">
                            <div scope="row"><label for="doctor_sms_mobile">شماره ارائه دهنده</label></div>
                            <div>
                                <input class="nobat-put" name="doctor_sms_mobile" type="text" id="doctor_sms_mobile" value="<?php echo esc_attr(get_option('sab_doctor_sms_mobile')); ?>" class="regular-text">
                                <p class="description">برای استفاده از موبایل ثبت شده در فرم ارائه دهنده خالی بگذارید</p>
                            </div>
                        </div>
                    </div> 
                    <div class="in-labalandfield" style="background: #f0f0f1;">
                        <label style="margin-bottom: 20px;" for="sab_sms_message_user">متن پیامک برای کاربر</label> 
                        <div class="olgoo">
                            <div scope="row">
                                <input type="checkbox" name="sms_use_template_user" id="sms_use_template_user" value="1" <?php checked(get_option('sab_sms_use_template_user'), 1); ?>>
                                <label for="sms_use_template_user">استفاده از الگو</label>
                            </div>
                            <div>
                                <input class="nobat-put" name="sms_template_id_user" type="text" id="sms_template_id_user" value="<?php echo esc_attr(get_option('sab_sms_template_id_user')); ?>" placeholder="شناسه الگو برای کاربر">
                            </div>
                        </div>
                        <?php wp_editor(
                            esc_textarea($sms_user_message),
                            "sms_message_user",
                            [
                                "textarea_name" => "sms_message_user",
                                "media_buttons" => false,
                                "textarea_rows" => 5,
                                "teeny" => true,
                                "tinymce" => false,
                                "quicktags" => false,
                                "editor_class" => "text-only-editor",
                            ]
                        ); ?>
                    </div>
					<div class="in-labalandfield" style="background: #f0f0f1;">
						<label style="margin-bottom: 20px;" for="sab_sms_message_user_24h">متن پیامک یادآوری 24 ساعته برای کاربر</label> 
						<div class="olgoo">
							<div scope="row">
								<input type="checkbox" name="sms_use_template_user_24h" id="sms_use_template_user_24h" value="1" <?php checked(get_option('sab_sms_use_template_user_24h'), 1); ?>>
								<label for="sms_use_template_user_24h">استفاده از الگو</label>
							</div>
							<div>
								<input class="nobat-put" name="sms_template_id_user_24h" type="text" id="sms_template_id_user_24h" value="<?php echo esc_attr(get_option('sab_sms_template_id_user_24h')); ?>" placeholder="شناسه الگو برای کاربر">
							</div>
						</div>
						<?php wp_editor(
							esc_textarea(get_option('sab_sms_message_user_24h', 'یادآوری: نوبت شما در تاریخ {date} ساعت {time} است.')),
							"sms_message_user_24h",
							[
								"textarea_name" => "sms_message_user_24h",
								"media_buttons" => false,
								"textarea_rows" => 5,
								"teeny" => true,
								"tinymce" => false,
								"quicktags" => false,
								"editor_class" => "text-only-editor",
							]
						); ?>
					</div>

					<div class="in-labalandfield" style="background: #f0f0f1;">
						<label style="margin-bottom: 20px;" for="sab_sms_message_user_2h">متن پیامک یادآوری 2 ساعته برای کاربر</label> 
						<div class="olgoo">
							<div scope="row">
								<input type="checkbox" name="sms_use_template_user_2h" id="sms_use_template_user_2h" value="1" <?php checked(get_option('sab_sms_use_template_user_2h'), 1); ?>>
								<label for="sms_use_template_user_2h">استفاده از الگو</label>
							</div>
							<div>
								<input class="nobat-put" name="sms_template_id_user_2h" type="text" id="sms_template_id_user_2h" value="<?php echo esc_attr(get_option('sab_sms_template_id_user_2h')); ?>" placeholder="شناسه الگو برای کاربر">
							</div>
						</div>
						<?php wp_editor(
							esc_textarea(get_option('sab_sms_message_user_2h', 'یادآوری: نوبت شما در {date} ساعت {time} به زودی است.')),
							"sms_message_user_2h",
							[
								"textarea_name" => "sms_message_user_2h",
								"media_buttons" => false,
								"textarea_rows" => 5,
								"teeny" => true,
								"tinymce" => false,
								"quicktags" => false,
								"editor_class" => "text-only-editor",
							]
						); ?>
					</div>					
                    <div class="in-labalandfield" style="background: #f0f0f1;">
                        <label style="margin-bottom: 20px;" for="sab_sms_message_admin">متن پیامک برای ادمین</label> 
                        <div class="olgoo">
                            <div scope="row">
                                <input type="checkbox" name="sms_use_template_admin" id="sms_use_template_admin" value="1" <?php checked(get_option('sab_sms_use_template_admin'), 1); ?>>
                                <label for="sms_use_template_admin">استفاده از الگو</label>
                            </div>
                            <div>
                                <input class="nobat-put" name="sms_template_id_admin" type="text" id="sms_template_id_admin" value="<?php echo esc_attr(get_option('sab_sms_template_id_admin')); ?>" placeholder="شناسه الگو برای ادمین">
                            </div>
                        </div>
                        <?php wp_editor(
                            esc_textarea($sms_admin_message),
                            "sms_message_admin",
                            [
                                "textarea_name" => "sms_message_admin",
                                "media_buttons" => false,
                                "textarea_rows" => 5,
                                "teeny" => true,
                                "tinymce" => false,
                                "quicktags" => false,
                                "editor_class" => "text-only-editor",
                            ]
                        ); ?>
                    </div>
                    <div class="in-labalandfield" style="background: #f0f0f1;">
                        <label style="margin-bottom: 20px;" for="sab_sms_message_doctor">متن پیامک برای ارائه دهنده</label> 
                        <div class="olgoo">
                            <div scope="row">
                                <input type="checkbox" name="sms_use_template_doctor" id="sms_use_template_doctor" value="1" <?php checked(get_option('sab_sms_use_template_doctor'), 1); ?>>
                                <label for="sms_use_template_doctor">استفاده از الگو</label>
                            </div>
                            <div>
                                <input class="nobat-put" name="sms_template_id_doctor" type="text" id="sms_template_id_doctor" value="<?php echo esc_attr(get_option('sab_sms_template_id_doctor')); ?>" placeholder="شناسه الگو برای ارائه دهنده">
                            </div>
                        </div>
                        <?php wp_editor(
                            esc_textarea($sms_doctor_message),
                            "sms_message_doctor",
                            [
                                "textarea_name" => "sms_message_doctor",
                                "media_buttons" => false,
                                "textarea_rows" => 5,
                                "teeny" => true,
                                "tinymce" => false,
                                "quicktags" => false,
                                "editor_class" => "text-only-editor",
                            ]
                        ); ?>   
                    </div>
                </div>
                <p class="submit">
                    <input type="submit" name="sab_save_email_settings" class="button button-primary" value="ذخیره تنظیمات">
                </p>               
            </div>
            <div class="farazsms">
                <h3 style="color: green;">تنظیمات فراز sms</h3>
                <hr>
                <h4>هر یک از متغیرهای زیر مقدار ورودی کاربر در فرم را به متن پیامک اضافه می کند</h4>
                <p class="changer-info">
                    نام ارسال کننده: {name} 
                    <span>تلفن: {phone}</span>
                    <span>تلفن همراه: {mobile}</span>
                    <span>خدمات: {service}</span>
                    <span>ارائه دهنده: {doctor}</span>
                    <span>تاریخ: {date}</span>
                    <span>زمان: {time}</span>
                    <span>فیلد  1: {custom-1}</span>
                    <span>فیلد  2: {custom-2}</span>
                    <span>فیلد  3: {custom-3}</span>
                    <span>فیلد  4: {custom-4}</span>
                </p>
                <div class="form-table">
                    <div class="befor-labalandfield">                
                        <div class="in-labalandfield">
                            <div scope="row"><label for="ippanel_username">نام کاربری فراز sms</label></div>
                            <div><input class="nobat-put" name="ippanel_username" type="text" id="ippanel_username" value="<?php echo esc_attr($ippanel_username); ?>" class="regular-text"></div>
                        </div>
                        <div class="in-labalandfield">
                            <div scope="row"><label for="ippanel_password">رمز عبور فراز sms</label></div>
                            <div><input class="nobat-put" name="ippanel_password" id="ippanel_password" value="<?php echo esc_attr($ippanel_password); ?>" class="regular-text"></div>
                        </div>
                        <div class="in-labalandfield">
                            <div scope="row"><label for="ippanel_from">شماره فرستنده فراز sms</label></div>
                            <div><input class="nobat-put" name="ippanel_from" type="text" id="ippanel_from" value="<?php echo esc_attr($ippanel_from); ?>" class="regular-text"></div>
                        </div>
                        <div class="in-labalandfield">
                            <div scope="row"><label for="ippanel_admin_mobile">موبایل مدیر</label></div>
                            <div><input class="nobat-put" name="ippanel_admin_mobile" type="text" id="ippanel_admin_mobile" value="<?php echo esc_attr(get_option('sab_ippanel_admin_mobile')); ?>" class="regular-text"></div>
                        </div>
                        <div class="in-labalandfield">
                            <div scope="row"><label for="doctor_faraz_mobile">موبایل ارائه دهنده</label></div>
                            <div>
                                <input class="nobat-put" name="doctor_faraz_mobile" type="text" id="doctor_faraz_mobile" value="<?php echo esc_attr(get_option('sab_doctor_faraz_mobile')); ?>" class="regular-text">
                                <p class="description">برای استفاده از موبایل ثبت شده در فرم ارائه دهنده خالی بگذارید</p>
                            </div>
                        </div>					
                    </div>
                    <div class="in-labalandfield" style="background: #f0f0f1;">
                        <label style="margin-bottom: 20px;" for="sab_ippanel_message_user">متن پیامک برای کاربر</label> 
                        <?php wp_editor(
                            esc_textarea($ippanel_user_message),
                            "ippanel_message_user",
                            [
                                "textarea_name" => "ippanel_message_user",
                                "media_buttons" => false,
                                "textarea_rows" => 5,
                                "teeny" => true,
                                "tinymce" => false,
                                "quicktags" => false,
                                "editor_class" => "text-only-editor",
                            ]
                        ); ?>
                    </div>
					<div class="in-labalandfield" style="background: #f0f0f1;">
						<label style="margin-bottom: 20px;" for="sab_ippanel_message_user_24h">متن پیامک یادآوری 24 ساعته برای کاربر</label> 
						<?php wp_editor(
							esc_textarea(get_option('sab_ippanel_message_user_24h', 'یادآوری: نوبت شما در تاریخ {date} ساعت {time} است.')),
							"ippanel_message_user_24h",
							[
								"textarea_name" => "ippanel_message_user_24h",
								"media_buttons" => false,
								"textarea_rows" => 5,
								"teeny" => true,
								"tinymce" => false,
								"quicktags" => false,
								"editor_class" => "text-only-editor",
							]
						); ?>
					</div>

					<div class="in-labalandfield" style="background: #f0f0f1;">
						<label style="margin-bottom: 20px;" for="sab_ippanel_message_user_2h">متن پیامک یادآوری 2 ساعته برای کاربر</label> 
						<?php wp_editor(
							esc_textarea(get_option('sab_ippanel_message_user_2h', 'یادآوری: نوبت شما در {date} ساعت {time} به زودی است.')),
							"ippanel_message_user_2h",
							[
								"textarea_name" => "ippanel_message_user_2h",
								"media_buttons" => false,
								"textarea_rows" => 5,
								"teeny" => true,
								"tinymce" => false,
								"quicktags" => false,
								"editor_class" => "text-only-editor",
							]
						); ?>
					</div>					
                    <div class="in-labalandfield" style="background: #f0f0f1;">
                        <label style="margin-bottom: 20px;" for="sab_ippanel_message_admin">متن پیامک برای ادمین</label> 
                        <?php wp_editor(
                            esc_textarea($ippanel_admin_message),
                            "ippanel_message_admin",
                            [
                                "textarea_name" => "ippanel_message_admin",
                                "media_buttons" => false,
                                "textarea_rows" => 5,
                                "teeny" => true,
                                "tinymce" => false,
                                "quicktags" => false,
                                "editor_class" => "text-only-editor",
                            ]
                        ); ?>
                    </div>
                    <div class="in-labalandfield" style="background: #f0f0f1;">
                        <label style="margin-bottom: 20px;" for="sab_ippanel_message_doctor">متن پیامک برای ارائه دهنده</label> 
                        <?php wp_editor(
                            esc_textarea($ippanel_doctor_message),
                            "ippanel_message_doctor",
                            [
                                "textarea_name" => "ippanel_message_doctor",
                                "media_buttons" => false,
                                "textarea_rows" => 5,
                                "teeny" => true,
                                "tinymce" => false,
                                "quicktags" => false,
                                "editor_class" => "text-only-editor",
                            ]
                        ); ?>                
                    </div>
                </div>           
                <p class="submit">
                    <input type="submit" name="sab_save_email_settings" class="button button-primary" value="ذخیره تنظیمات">
                </p>                           
            </div>
            <div class="emailadminbox">
                <h3 style="color: green;">تنظیمات ایمیل مدیر</h3>
                <hr>
                <h4>هر یک از متغیرهای زیر مقدار ورودی کاربر در فرم را به متن ایمیل اضافه می کند</h4>
                <p class="changer-info">
                    نام ارسال کننده: {name} 
                    <span>تلفن: {phone}</span>
                    <span>تلفن همراه: {mobile}</span>
                    <span>خدمات: {service}</span>
                    <span>ارائه دهنده: {doctor}</span>
                    <span>تاریخ: {date}</span>
                    <span>زمان: {time}</span>
                    <span>فیلد  1: {custom-1}</span>
                    <span>فیلد  2: {custom-2}</span>
                    <span>فیلد  3: {custom-3}</span>
                    <span>فیلد  4: {custom-4}</span>                    				
                </p>
                <div class="form-table">
                        <div class="in-labalandfield">
                            <div><label for="admin_email">ایمیل مدیر: می توانید ایمیل ها را با کاما (,) جدا کنید</label></div>
                            <div><input class="nobat-put" type="text" name="admin_email" id="admin_email" value="<?php echo esc_attr($admin_email); ?>" class="regular-text"></div>
                        </div>  
                        <div class="in-labalandfield">  
                            <div><label for="admin_email_subject">موضوع ایمیل مدیر</label></div>
                            <div><input class="nobat-put" type="text" name="admin_email_subject" id="admin_email_subject" value="<?php echo esc_attr(
                                $admin_email_subject
                            ); ?>" class="regular-text"></div>
                        </div>  
                    <div class="labalandfield"> 
                        <div><label for="admin_email_body">متن ایمیل مدیر</label></div>
                        <div>
                            <?php wp_editor(
                                $admin_email_body,
                                "admin_email_body",
                                [
                                    "textarea_name" => "admin_email_body",
                                    "media_buttons" => false,
                                    "textarea_rows" => 15,
                                    "teeny" => true,
                                ]
                            ); ?>
                        </div>
                    </div>
                    <p class="submit">
                        <input type="submit" name="sab_save_email_settings" class="button button-primary" value="ذخیره تنظیمات">
                    </p>                      
                </div>
            </div>
            <div class="emailuserbox">
                <h3 style="color: green;">تنظیمات ایمیل کاربر</h3>
                <hr>
                <h4>هر یک از متغیرهای زیر مقدار ورودی کاربر در فرم را به متن ایمیل اضافه می کند</h4>
                <p class="changer-info">
                    نام ارسال کننده: {name} 
                    <span>تلفن: {phone}</span>
                    <span>تلفن همراه: {mobile}</span>
                    <span>خدمات: {service}</span>
                    <span>ارائه دهنده: {doctor}</span>
                    <span>تاریخ: {date}</span>
                    <span>زمان: {time}</span>
                    <span>فیلد  1: {custom-1}</span>
                    <span>فیلد  2: {custom-2}</span>
                    <span>فیلد  3: {custom-3}</span>
                    <span>فیلد  4: {custom-4}</span>                    			
                </p>
                <div class="form-table">
                    <div class="in-labalandfield">
                        <div><label for="user_email_subject">موضوع ایمیل کاربر</label></div>
                        <div><input class="nobat-put" type="text" name="user_email_subject" id="user_email_subject" value="<?php echo esc_attr(
                            $user_email_subject
                        ); ?>" class="regular-text"></div>
                    </div>
                    <div class="labalandfield">
                        <div><label for="user_email_body">متن ایمیل کاربر</label></div>
                        <div>
                            <?php wp_editor(
                                $user_email_body,
                                "user_email_body",
                                [
                                    "textarea_name" => "user_email_body",
                                    "media_buttons" => false,
                                    "textarea_rows" => 15,
                                    "teeny" => true,
                                ]
                            ); ?>
                        </div>
                    </div>
                </div>
                <p class="submit">
                    <input type="submit" name="sab_save_email_settings" class="button button-primary" value="ذخیره تنظیمات">
                </p>               
            </div>
        </form>
    </div>
    <?php
}