<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}	

// Form Assets
function sab_booking_form_assets() {
    $has_shortcode = is_page() && has_shortcode(get_post()->post_content, 'nobat_plus_form');
    if ($has_shortcode) {
        wp_enqueue_script('jalaali-js', plugin_dir_url(__FILE__) . "../assets/js/jalaali.js", [], null, true);
        wp_enqueue_script('sab-script', plugins_url("../assets/js/simple/sab-script.js", __FILE__), ["jquery", "jalaali-js"], "1.0.0", true);
        wp_enqueue_script('swiper-bundle', plugins_url("../assets/js/swiper-bundle.min.js", __FILE__), ["jquery", "jalaali-js"], "1.0.0", true);
        wp_localize_script("sab-script", "sab_ajax_object", ["ajax_url" => admin_url("admin-ajax.php")]);
        wp_enqueue_style('sab-style', plugins_url("../assets/css/sab-style.css", __FILE__));
        wp_enqueue_style('swiper-bundle', plugins_url("../assets/css/swiper-bundle.min.css", __FILE__));
        wp_enqueue_style('dashicons'); 
    }
}
add_action("wp_enqueue_scripts", "sab_booking_form_assets");

// Create Shortcode
function sab_booking_form_shortcode() {
	$form_fields = get_option('sab_form_fields', array());
    ob_start();
    ?>
	
    <div id="sab-booking-form-container">
        <form id="sab-appointment-form">
            <?php
            foreach ($form_fields as $field) {
                echo sab_render_frontend_field($field);
            }
            ?>
			<div class="submit-container">
				<button class="plus-button button button-primary" type="submit">رزرو نوبت</button>
			</div>
        </form>
		<script>			
		jQuery(document).ready(function($) {
			$('.sab-upload-btn').on('click', function() {
				var inputId = $(this).data('input-id');
				$('#' + inputId).click(); 
			});
			$('.upld').on('change', function() {
				var inputId = $(this).attr('id');
				var fileName = $(this).val().split('\\').pop(); 
				if (fileName) {
					$('#sab-file-name-' + inputId.split('-')[2]).text(fileName);
				} else {
					$('#sab-file-name-' + inputId.split('-')[2]).text('هیچ فایلی انتخاب نشده');
				}
			});
		});
		</script>			
        <div id="sab-message"></div>
    </div>
    <?php
    return ob_get_clean();
}

// Render Fields
function sab_render_frontend_field($field) {
    $label = isset($field['label']) && !empty($field['label']) ? $field['label'] : sab_get_default_label($field['type']);
    $description = isset($field['description']) ? esc_html($field['description']) : '';
    $placeholder = isset($field['placeholder_enabled']) && $field['placeholder_enabled'] ? esc_attr($label) : '';
    $required = isset($field['required']) && $field['required'] ? 'required' : '';
    $label_color = isset($field['label_color']) ? esc_attr($field['label_color']) : '';
    $label_font = isset($field['label_font']) ? esc_attr($field['label_font']) : '';
    $css_class = isset($field['css_class']) ? esc_attr($field['css_class']) : '';

    $label_style = '';
    if (!empty($label_color)) {
        $label_style .= 'color: ' . $label_color . '; ';
    }
    if (!empty($label_font)) {
        $label_style .= 'font-family: ' . $label_font . '; ';
    }

    $label_class = '';
    if ($field['type'] === 'date') {
        $label_class = 'sab-label-date';
    } elseif ($field['type'] === 'time') {
        $label_class = 'sab-label-time';
    }

    $html = '<div class="sab-field ' . $css_class . '" style="width: ' . esc_attr($field['width']) . '%;">';

    if ($field['type'] !== 'radio' && $field['type'] !== 'checkbox' && !$placeholder) {
        $html .= '<label class="' . $label_class . '" style="' . $label_style . '">' . esc_html($label) . '</label>';
    }

    switch ($field['type']) {
	
		case 'custom_text_1':
			$field_type = isset($field['field_type']) ? esc_attr($field['field_type']) : 'text';

			if ($field_type === 'textarea') {
				$html .= '<textarea id="custom_text_1" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '></textarea>';
			} else {
				$html .= '<input type="' . $field_type . '" id="custom_text_1" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '>';
			}
			break;
			
		case 'custom_text_2':
			$field_type = isset($field['field_type']) ? esc_attr($field['field_type']) : 'text';

			if ($field_type === 'textarea') {
				$html .= '<textarea id="custom_text_2" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '></textarea>';
			} else {
				$html .= '<input type="' . $field_type . '" id="custom_text_2" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '>';
			}
			break;
			
		case 'custom_text_3':
			$field_type = isset($field['field_type']) ? esc_attr($field['field_type']) : 'text';

			if ($field_type === 'textarea') {
				$html .= '<textarea id="custom_text_3" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '></textarea>';
			} else {
				$html .= '<input type="' . $field_type . '" id="custom_text_3" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '>';
			}
			break;
			
		case 'custom_text_4':
			$field_type = isset($field['field_type']) ? esc_attr($field['field_type']) : 'text';

			if ($field_type === 'textarea') {
				$html .= '<textarea id="custom_text_4" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '></textarea>';
			} else {
				$html .= '<input type="' . $field_type . '" id="custom_text_4" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '>';
			}
			break;		
			
		case 'name':
			$field_type = isset($field['field_type']) ? esc_attr($field['field_type']) : 'text';

			if ($field_type === 'textarea') {
				$html .= '<textarea id="sab-name" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '></textarea>';
			} else {
				$html .= '<input type="' . $field_type . '" id="sab-name" name="' . esc_attr($field['type']) . '" placeholder="' . $placeholder . '" ' . $required . '>';
			}
			break;

		case 'phone':
			$field_type = isset($field['field_type']) ? esc_attr($field['field_type']) : 'text';

			if ($field_type === 'textarea') {
				$html .= '<textarea id="sab-phone" name="phone" placeholder="' . $placeholder . '" ' . $required . '></textarea>';
			} else {
				$html .= '<input type="' . $field_type . '" id="sab-phone" name="phone" placeholder="' . $placeholder . '" ' . $required . '>';
			}
			break;

		case 'mobile':
			$field_type = isset($field['field_type']) ? esc_attr($field['field_type']) : 'text';

			if ($field_type === 'textarea') {
				$html .= '<textarea id="sab-mobile" name="mobile" placeholder="' . $placeholder . '" ' . $required . '></textarea>';
			} else {
				$html .= '<input type="' . $field_type . '" id="sab-mobile" name="mobile" placeholder="' . $placeholder . '" ' . $required . '>';
			}
			break;

		case 'email':
			$field_type = isset($field['field_type']) ? esc_attr($field['field_type']) : 'text';

			if ($field_type === 'textarea') {
				$html .= '<textarea id="sab-email" name="email" placeholder="' . $placeholder . '" ' . $required . '></textarea>';
			} else {
				$html .= '<input type="' . $field_type . '" id="sab-email" name="email" placeholder="' . $placeholder . '" ' . $required . '>';
			}
			break;
        case 'radio':
            $radio_options = isset($field['radio_options']) ? explode("\n", $field['radio_options']) : array();
            if (!empty($radio_options)) {
                if (!$placeholder) {
                    $html .= '<label class="' . $label_class . '" style="' . $label_style . '">' . esc_html($label) . '</label>';
                }
                $html .= '<div class="sab-radio-container">';
                $html .= '<div class="sab-radio-options">';
                $option_id = 0;
                foreach ($radio_options as $option) {
                    $option = trim($option);
                    if (!empty($option)) {
                        $option_id++;
                        $radio_id = 'sab-radio-' . sanitize_title($field['type']) . '-' . $option_id;
                        $html .= '<div class="sab-radio-option">';
                        $html .= '<input type="radio" id="' . esc_attr($radio_id) . '" name="radio_field" value="' . esc_attr($option) . '" ' . ($option_id === 1 && $required ? 'required' : '') . '>';
                        $html .= '<label for="' . esc_attr($radio_id) . '">' . esc_html($option) . '</label>';
                        $html .= '</div>';
                    }
                }
                $html .= '</div>';
                $html .= '</div>';
            } else {
                $html .= '<p class="sab-error">گزینه ای برای نمایش وجود ندارد.</p>';
            }
            break;

        case 'checkbox':
            $checkbox_options = isset($field['checkbox_options']) ? explode("\n", $field['checkbox_options']) : array();
            if (!empty($checkbox_options)) {
                if (!$placeholder) {
                    $html .= '<label class="' . $label_class . '" style="' . $label_style . '">' . esc_html($label) . '</label>';
                }
                $html .= '<div class="sab-checkbox-container">';
                $html .= '<div class="sab-checkbox-options">';
                $option_id = 0;
                foreach ($checkbox_options as $option) {
                    $option = trim($option);
                    if (!empty($option)) {
                        $option_id++;
                        $checkbox_id = 'sab-checkbox-' . sanitize_title($field['type']) . '-' . $option_id;
                        $html .= '<div class="sab-checkbox-option">';
                        $html .= '<input type="checkbox" id="' . esc_attr($checkbox_id) . '" name="checkbox_field[]" value="' . esc_attr($option) . '">';
                        $html .= '<label for="' . esc_attr($checkbox_id) . '">' . esc_html($option) . '</label>';
                        $html .= '</div>';
                    }
                }
                $html .= '</div>';
                $html .= '</div>';
            } else {
                $html .= '<p class="sab-error">گزینه ای برای نمایش وجود ندارد.</p>';
            }
            break;

		case 'select':
			$select_options = isset($field['select_options']) ? explode("\n", $field['select_options']) : array();
			if (!empty($select_options)) {
				$html .= '<div class="sab-select-wrapper">';
				$html .= '<select name="select_field" ' . ($required ? 'required' : '') . ' class="sab-select">';
				$html .= '<option value="">یک گزینه را انتخاب کنید</option>';
				foreach ($select_options as $option) {
					$option = trim($option);
					if (!empty($option)) {
						$html .= '<option value="' . esc_attr($option) . '">' . esc_html($option) . '</option>';
					}
				}
				$html .= '</select>';
				$html .= '</div>';
			} else {
				$html .= '<p class="sab-error">گزینه ای برای نمایش وجود ندارد.</p>';
			}
			break;	
		case "file_upload":
			$upload_count = isset($field["upload_count"]) ? intval($field["upload_count"]) : 1;
			$html .= '<div class="sab-file-upload-container">';
			for ($i = 0; $i < $upload_count; $i++) {
				$html .= '<div class="sab-custom-upload">';
				$html .= '<input class="upld" type="file" id="sab-file-' . $i . '" name="file_upload_' . $i . '" ' . $required . ' style="display: none;">';
				$html .= '<div><button type="button" class="sab-upload-btn" data-input-id="sab-file-' . $i . '"><span class="dashicons dashicons-upload"></span></button></div>';
				$html .= '<div class="sab-file-name" id="sab-file-name-' . $i . '">بدون فایل</div>';
				$html .= '</div>';
			}
			$html .= '</div>';
			break;

		case 'service':
			$html .= '<select id="sab-service" name="service_id" required><option value="">لطفا انتخاب کنید</option></select>';
			break;

		case 'doctor':
			$html .= '<select id="sab-doctor" name="doctor_id" required disabled><option value="">لطفا انتخاب کنید</option></select>';
			break;

		case 'date':
			$html .= '<div class="sab-field-button"><button type="button" id="sab-select-date" class="sab-select-button" disabled>لطفا انتخاب کنید</button><input type="hidden" id="sab-days" name="date" required></div>';
			break;

		case 'time':
			$html .= '<div class="sab-field-button"><button type="button" id="sab-select-time" class="sab-select-button" disabled>لطفا انتخاب کنید</button><input type="hidden" id="sab-times" name="time" required></div>';
			break;

		case 'captcha':
			$html .= '<div id="sab-captcha-container">
				<input class="capcha-field" type="text" id="sab-captcha-input" placeholder="عدد را وارد کنید" required>
				<canvas class="capcha-image" id="sab-captcha-canvas"></canvas>
				<a class="refresh-btn" href="#" id="sab-refresh-captcha">⟲</a>
			</div>';
			break;
	}
	if (!empty($description)) {
		$html .= '<p class="field-description">' . $description . '</p>';
	}
	$html .= '</div>';
	return $html;
	}

// Default Labels
function sab_get_default_label($type) {
    $labels = array(
        'name' => 'نام و نام خانوادگی',
        'phone' => 'تلفن تماس',
        'mobile' => 'تلفن همراه',
        'email' => 'ایمیل',
        'service' => 'خدمات',
        'doctor' => 'ارائه دهنده',
        'date' => 'تاریخ',
        'time' => 'زمان',
        'file_upload' => 'آپلود فایل',		
		'custom_text_1' => 'فیلد سفارشی 1',
		'custom_text_2' => 'فیلد سفارشی 2',		
		'custom_text_3' => 'فیلد سفارشی 3',		
		'custom_text_4' => 'فیلد سفارشی 4',
		'radio' => 'رادیویی',
		'checkbox' => 'چک باکس',
		'select' => 'انتخابی'
    );
    return isset($labels[$type]) ? $labels[$type] : '';
}

add_shortcode('nobat_plus_form', 'sab_booking_form_shortcode');