<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Providers
function sab_doctors_page() {
    global $wpdb;
    $doctors_table = $wpdb->prefix . 'sab_doctors';
    $services_table = $wpdb->prefix . 'sab_services';

    if (isset($_POST['add_doctor'])) {
        $doctor_name = sanitize_text_field($_POST['doctor_name']);
        $service_id = isset($_POST['is_independent']) && $_POST['is_independent'] == 1 ? null : intval($_POST['service_id']);
        $doctor_mobile = sanitize_text_field($_POST['doctor_mobile']);
        $is_independent = isset($_POST['is_independent']) ? 1 : 0;

        if (!$is_independent && empty($service_id)) {
            echo '<div class="error"><p>لطفاً یک خدمت انتخاب کنید یا گزینه "ارائه دهنده همان خدمات است" را تیک بزنید.</p></div>';
        } else {
            $wpdb->insert($doctors_table, array(
                'name' => $doctor_name,
                'service_id' => $service_id,
                'mobile' => $doctor_mobile,
                'is_independent' => $is_independent
            ));
            if ($wpdb->last_error) {
                echo '<div class="error"><p>خطا در افزودن ارائه دهنده: ' . $wpdb->last_error . '</p></div>';
            } else {
                echo '<div class="updated"><p>ارائه دهنده با موفقیت اضافه شد.</p></div>';
            }
        }
    }

    if (isset($_POST['delete_doctors'])) {
        $doctor_ids = isset($_POST['doctor_ids']) ? array_map('intval', $_POST['doctor_ids']) : array();
        if (!empty($doctor_ids)) {
            $ids_string = implode(',', $doctor_ids);
            $wpdb->query("DELETE FROM $doctors_table WHERE id IN ($ids_string)");
        }
    }

    $doctors = $wpdb->get_results("SELECT d.*, s.name as service_name FROM $doctors_table d LEFT JOIN $services_table s ON d.service_id = s.id");
    $services = $wpdb->get_results("SELECT * FROM $services_table");

    ?>
    <div class="nobat-page">
        <div class="nobat-head">مدیریت ارائه دهندگان</div>
		<p style="font-size:16px;">اگر میخواهید فقط یک فیلد انتخابی در سایت داشته باشید در همینجا خدمات را عنوان کنید مثلا: ایمپلنت ، سپس تیک گزینه ارائه دهنده همان خدمات است را بزنید.</p>
        <h2>افزودن ارائه دهنده جدید</h2>
        <form class="phone-form" method="post">
            <input type="text" class="example-field" name="doctor_name" placeholder="مثال: دکتر احمدی یا خانم رضایی" required>
            <input type="text" class="example-field" name="doctor_mobile" placeholder="شماره موبایل جهت دریافت پیامک" required>
            <label><input type="checkbox" name="is_independent" value="1" id="is_independent_add"> ارائه دهنده، همان خدمات است</label>
            <select class="example-field serv-field" name="service_id" id="service_id_add">
                <option value="">انتخاب خدمات</option>
                <?php foreach ($services as $service): ?>
                    <option value="<?php echo $service->id; ?>"><?php echo $service->name; ?></option>
                <?php endforeach; ?>
            </select>
            <input type="submit" name="add_doctor" class="save-btn button button-primary" value="افزودن ارائه دهنده">
        </form>
        <h2>لیست ارائه دهندگان</h2>
        <form method="post">
            <input type="text" id="table-filter" placeholder="جستجو...">
            <table class="nobat-table wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th class="selection-col"><input type="checkbox" id="select-all-doctors"></th>
                        <th class="id-col">شناسه</th>
                        <th>نام ارائه دهنده</th>
                        <th>شماره موبایل</th>
                        <th>خدمات</th>
                        <th>ویرایش</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($doctors as $doctor): ?>
                        <tr>
                            <td><input type="checkbox" name="doctor_ids[]" value="<?php echo $doctor->id; ?>"></td>
                            <td><?php echo $doctor->id; ?></td>
                            <td><?php echo $doctor->name; ?></td>
                            <td><?php echo $doctor->mobile; ?></td>
                            <td><?php echo $doctor->service_name ?: 'بدون خدمات'; ?></td>
                            <td><a href="<?php echo admin_url('admin.php?page=sab-edit-doctor&doctor_id=' . $doctor->id); ?>" class="button">ویرایش</a></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <input type="submit" name="delete_doctors" class="button-secondary" value="حذف موارد انتخاب شده" onclick="return confirm('آیا از حذف موارد انتخاب شده اطمینان دارید؟');">
        </form>
    </div>
    <script>
    jQuery(document).ready(function($) {
        $('#select-all-doctors').change(function() {
            $('input[name="doctor_ids[]"]').prop('checked', this.checked);
        });
        $('#table-filter').on('keyup', function() {
            var searchTerm = $(this).val().toLowerCase();
            $('tbody tr').each(function() {
                var lineStr = $(this).text().toLowerCase();
                if(lineStr.indexOf(searchTerm) === -1) {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
        });
        $('#is_independent_add').change(function() {
            $('#service_id_add').prop('disabled', this.checked);
            if (this.checked) {
                $('#service_id_add').val('');
            }
        });
    });
    </script>
    <?php
}

// Edit Providers
function sab_edit_doctor_page() {
    global $wpdb;
    $doctors_table = $wpdb->prefix . 'sab_doctors';
    $services_table = $wpdb->prefix . 'sab_services';
    if (!isset($_GET['doctor_id']) || empty($_GET['doctor_id'])) {
        ?>
        <div class="wrap">
            <h1>ویرایش ارائه دهنده</h1>
            <div class="notice notice-warning">
                <p>لطفا از دکمه ویرایش جلوی ارائه دهنده ای که از قبل ایجاد نموده اید اقدام نمایید.</p>
            </div>
            <a href="<?php echo admin_url('admin.php?page=sab-doctors'); ?>" class="button">بازگشت به لیست ارائه دهندگان</a>
        </div>
        <?php
        return;
    }

    $doctor_id = intval($_GET['doctor_id']);
    $doctor = $wpdb->get_row($wpdb->prepare("SELECT * FROM $doctors_table WHERE id = %d", $doctor_id));
    if (!$doctor) {
        ?>
        <div class="wrap">
            <h1>ویرایش ارائه دهنده</h1>
            <div class="notice notice-error">
                <p>ارائه دهنده مورد نظر یافت نشد.</p>
            </div>
            <a href="<?php echo admin_url('admin.php?page=sab-doctors'); ?>" class="button-secondary">بازگشت به لیست ارائه دهندگان</a>
        </div>
        <?php
        return;
    }

    $services = $wpdb->get_results("SELECT * FROM $services_table");

    if (isset($_POST['update_doctor'])) {
        $doctor_name = sanitize_text_field($_POST['doctor_name']);
        $service_id = isset($_POST['is_independent']) && $_POST['is_independent'] == 1 ? null : intval($_POST['service_id']);
        $doctor_mobile = sanitize_text_field($_POST['doctor_mobile']);
        $is_independent = isset($_POST['is_independent']) ? 1 : 0;

        if (!$is_independent && empty($service_id)) {
            echo '<div class="error"><p>لطفاً یک خدمت انتخاب کنید یا گزینه "ارائه دهنده همان خدمات است" را تیک بزنید.</p></div>';
        } else {
            $wpdb->update($doctors_table, array(
                'name' => $doctor_name,
                'service_id' => $service_id,
                'mobile' => $doctor_mobile,
                'is_independent' => $is_independent
            ), array('id' => $doctor_id));
            if ($wpdb->last_error) {
                echo '<div class="error"><p>خطا در به روزرسانی ارائه دهنده: ' . $wpdb->last_error . '</p></div>';
            } else {
                echo '<div class="updated"><p>ارائه دهنده با موفقیت به روزرسانی شد.</p></div>';
                echo '<script>window.location.href="'.admin_url('admin.php?page=sab-doctors').'";</script>';
                exit;
            }
        }
    }

    ?>
    <div class="nobat-page">
        <h1>ویرایش ارائه دهنده</h1>
        <form method="post">
            <div class="editing-service">
                <label for="doctor_name">نام ارائه دهنده:</label>
                <input type="text" name="doctor_name" value="<?php echo esc_attr($doctor->name); ?>" required>
                <label for="doctor_mobile">شماره موبایل:</label>
                <input type="text" name="doctor_mobile" value="<?php echo esc_attr($doctor->mobile); ?>" required>
                <label><input type="checkbox" name="is_independent" value="1" id="is_independent_edit" <?php checked($doctor->is_independent, 1); ?>> ارائه دهنده، همان خدمات است</label>
                <label for="service_id">خدمات:</label>
                <select name="service_id" class="s-name" id="service_id_edit" <?php echo $doctor->is_independent ? 'disabled' : ''; ?>>
                    <option value="">انتخاب خدمات</option>
                    <?php foreach ($services as $service): ?>
                        <option value="<?php echo $service->id; ?>" <?php selected($doctor->service_id, $service->id); ?>><?php echo $service->name; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <input type="submit" name="update_doctor" class="button button-primary" value="ذخیره">
            <a href="<?php echo admin_url('admin.php?page=sab-doctors'); ?>" class="button-secondary">بازگشت</a>
        </form>
    </div>
    <script>
    jQuery(document).ready(function($) {
        $('#is_independent_edit').change(function() {
            $('#service_id_edit').prop('disabled', this.checked);
            if (this.checked) {
                $('#service_id_edit').val('');
            }
        });
    });
    </script>
    <?php
}