<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}   

// Form Builder
function sab_form_builder_page()
{
    if (isset($_POST['sab_save_form'])) {
        $form_fields = array();

        if (isset($_POST['sab_form_fields']) && is_array($_POST['sab_form_fields'])) {
            foreach ($_POST['sab_form_fields']['type'] as $key => $type) {
                $radio_options = !empty($_POST['sab_form_fields']['radio_options'][$key]) 
                    ? sanitize_textarea_field($_POST['sab_form_fields']['radio_options'][$key]) : '';
                $checkbox_options = !empty($_POST['sab_form_fields']['checkbox_options'][$key]) 
                    ? sanitize_textarea_field($_POST['sab_form_fields']['checkbox_options'][$key]) : '';
                $select_options = !empty($_POST['sab_form_fields']['select_options'][$key]) 
                    ? sanitize_textarea_field($_POST['sab_form_fields']['select_options'][$key]) : '';              
                $field_type = isset($_POST['sab_form_fields']['field_type'][$key]) 
                    ? sanitize_text_field($_POST['sab_form_fields']['field_type'][$key]) 
                    : 'text';                        
                $label = !empty($_POST['sab_form_fields']['label'][$key]) 
                    ? sanitize_text_field($_POST['sab_form_fields']['label'][$key]) 
                    : '';
                
                $description = !empty($_POST['sab_form_fields']['description'][$key]) 
                    ? sanitize_text_field($_POST['sab_form_fields']['description'][$key]) 
                    : '';
                
                $placeholder_enabled = !empty($_POST['sab_form_fields']['placeholder_enabled'][$key]) 
                    ? 1 
                    : 0;
                
                $label_color = !empty($_POST['sab_form_fields']['label_color'][$key]) 
                    ? sanitize_hex_color($_POST['sab_form_fields']['label_color'][$key]) 
                    : '';
                
                $label_font = !empty($_POST['sab_form_fields']['label_font'][$key]) 
                    ? sanitize_text_field($_POST['sab_form_fields']['label_font'][$key]) 
                    : '';
                
                $required = !empty($_POST['sab_form_fields']['required'][$key]) 
                    ? 1 
                    : 0;

                $unique = !empty($_POST['sab_form_fields']['unique'][$key]) 
                    ? 1 
                    : 0;

                $css_class = !empty($_POST['sab_form_fields']['css_class'][$key]) 
                    ? sanitize_text_field($_POST['sab_form_fields']['css_class'][$key]) 
                    : '';
                $form_fields[] = array(
                    'type' => sanitize_text_field($type),
                    'label' => $label,
                    'description' => $description,
                    'width' => sanitize_text_field($_POST['sab_form_fields']['width'][$key]),
                    'placeholder_enabled' => $placeholder_enabled,
                    'required' => $required,
                    'unique' => $unique,
                    'label_color' => $label_color,
                    'label_font' => $label_font,
                    'css_class' => $css_class,
                    'field_type' => $field_type,
                    'radio_options'         => $radio_options,
                    'checkbox_options'      => $checkbox_options,
                    'select_options'        => $select_options,                 
                    'upload_count' => isset($_POST['sab_form_fields']['upload_count'][$key]) ? intval($_POST['sab_form_fields']['upload_count'][$key]) : 1,
                    'key' => $key,
                );
            }
        }

        update_option('sab_form_fields', $form_fields);
        echo '<div class="updated"><p>فرم با موفقیت ذخیره شد.</p></div>';
    }

    $saved_fields = get_option('sab_form_fields', array());
    ?>

    <div class="nobat-page">
        <div class="design-info">
            <div class="nobat-head">ساخت فرم نوبت دهی</div>
			<div  style="margin:-20px 0 40px 0">
			 <li class="nobatnegal-li">لطفا توجه داشته باشید که از هر فیلد فقط یک بار میتوانید در فرم استفاده کنید</li>
			 <li class="nobatnegal-li">برای تغییر عنوان فیلدها در قسمت <span style="color:red">برچسب سفارشی</span> عنوان دلخواه خود را بنویسید (بعنوان مثال برای تغییر عنوان ارائه دهنده در برچسب سفارشی عنوان پزشک را بنویسید)</li>
			 <li class="nobatnegal-li">گزینه <span style="color:red">یکتا</span> برای جلوگیری از ارسال تکراری کاربر است</li>	 
			 </div>	
        </div>

        <form method="post" id="sab-form-builder">
            <div id="sab-form-fields">
                <?php
                if (!empty($saved_fields)) {
                    foreach ($saved_fields as $field) {
                        echo sab_render_form_field($field);
                    }
                }
                ?>
            </div>
            <button type="button" id="sab-add-field" class="button-success">افزودن فیلد جدید</button>
            <input type="submit" name="sab_save_form" class="button button-primary" value="ذخیره فرم">
        </form>
    </div>

<script>
    jQuery(document).ready(function($) {
        var $formFields = $('#sab-form-fields');

        $formFields.sortable({
            handle: '.sab-move-field',
            update: function(event, ui) {}
        });

        $('#sab-add-field').click(function() {
            var uniqueKey = Date.now();
            var fieldHtml = `
        <div class="sab-form-field">
            <span class="sab-move-field dashicons dashicons-move"></span>
            <select style="width:15%" name="sab_form_fields[type][${uniqueKey}]" class="field-type-selector">
                <option value="name">نام و نام خانوادگی</option>
                <option value="phone">تلفن تماس</option>
                <option value="mobile">تلفن همراه</option>
                <option value="email">ایمیل</option>
                <option value="service">خدمات</option>
                <option value="doctor">ارائه دهنده</option>
                <option value="date">تاریخ</option>
                <option value="time">زمان</option>
                <option value="radio">رادیویی</option>
                <option value="checkbox">چک باکس</option>
                <option value="select">انتخابی</option>
                <option value="price">قیمت</option>
                <option value="file_upload">آپلود فایل</option>
                <option value="captcha">کد امنیتی (کپچا)</option>
                <option value="custom_text_1">فیلد سفارشی 1</option>
                <option value="custom_text_2">فیلد سفارشی 2</option>
                <option value="custom_text_3">فیلد سفارشی 3</option>
                <option value="custom_text_4">فیلد سفارشی 4</option>
            </select>
            <input style="width:15%" type="text" name="sab_form_fields[label][${uniqueKey}]" placeholder="برچسب سفارشی">
            <input style="width:15%" type="text" name="sab_form_fields[label_font][${uniqueKey}]" placeholder="فونت">
            <input style="width:15%" type="text" name="sab_form_fields[css_class][${uniqueKey}]" placeholder="کلاس CSS سفارشی">
            <input style="width:25%" type="text" name="sab_form_fields[description][${uniqueKey}]" placeholder="توضیحات فیلد">
            <label class="label-space size-row">اندازه<select name="sab_form_fields[width][${uniqueKey}]">
                <option value="20">20</option>
                <option value="25">25</option>
                <option value="33.33">33.33</option>
                <option value="50">50</option>
                <option value="66">66</option>
                <option value="75">75</option>
                <option value="100">100</option>
            </select></label>
            <label class="type-bm-row" style="display:none;">نوع فیلد: 
                <select name="sab_form_fields[field_type][${uniqueKey}]">
                    <option value="text">متنی</option>
                    <option value="number">عددی</option>
                    <option value="email">ایمیل</option>
                </select>
            </label>
            <label class="label-space upload-count-row" style="display:none;">تعداد ورودی ها:
                <input type="number" name="sab_form_fields[upload_count][${uniqueKey}]" min="1" max="10" value="1">
            </label>

            <label class="label-space">رنگ برچسب<input style="vertical-align: middle;margin-right:10px;" type="color" name="sab_form_fields[label_color][${uniqueKey}]" value="#000000"></label>
            <label class="label-space"><input class="phone-check" type="checkbox" name="sab_form_fields[required][${uniqueKey}]" value="1">اجباری</label> 
            <label class="label-space"><input class="phone-check" type="checkbox" name="sab_form_fields[unique][${uniqueKey}]" value="1">یکتا</label> 
			<label class="label-space"><input class="phone-check" type="checkbox" name="sab_form_fields[placeholder_enabled]" value="1">عنوان درون فیلد</label> 
            <label class="label-space radio-options-row" style="display:none;">
                <textarea class="ra-ch-se" name="sab_form_fields[radio_options][${uniqueKey}]" placeholder="هر گزینه را در یک خط بنویسید"></textarea>
            </label>
            <label class="label-space checkbox-options-row" style="display:none;">
                <textarea class="ra-ch-se" name="sab_form_fields[checkbox_options][${uniqueKey}]" placeholder="هر گزینه را در یک خط بنویسید"></textarea>
            </label>
            <label class="label-space select-options-row" style="display:none;">
                <textarea class="ra-ch-se" name="sab_form_fields[select_options][${uniqueKey}]" placeholder="هر گزینه را در یک خط بنویسید"></textarea>
            </label>            
            <button type="button" class="sab-remove-field button-secondary">حذف</button>
        </div>
        `;
        $(document).on('change', '.field-type-selector', function() {
            var selectedValue = $(this).val();
            var $uploadCountRow = $(this).closest('.sab-form-field').find('.upload-count-row');
            var $radioOptionsRow = $(this).closest('.sab-form-field').find('.radio-options-row');
            var $checkboxOptionsRow = $(this).closest('.sab-form-field').find('.checkbox-options-row');
            var $selectOptionsRow = $(this).closest('.sab-form-field').find('.select-options-row');
            var $conditionalOptions = $(this).closest('.sab-form-field').find('.type-bm-row');
            
            $uploadCountRow.hide();
            $radioOptionsRow.hide();
            $checkboxOptionsRow.hide();
            $selectOptionsRow.hide();
            $conditionalOptions.hide();
            
            if (selectedValue === 'file_upload') {
                $uploadCountRow.show();
            } else if (selectedValue === 'radio') {
                $radioOptionsRow.show();
            } else if (selectedValue === 'checkbox') {
                $checkboxOptionsRow.show();
            } else if (selectedValue === 'select') {
                $selectOptionsRow.show();
            } else if (['name', 'phone', 'mobile', 'email', 'custom_text_1', 'custom_text_2', 'custom_text_3', 'custom_text_4'].includes(selectedValue)) {
                $conditionalOptions.show();
            }
        });

        $formFields.append(fieldHtml);
        $formFields.sortable('refresh');
        });

        $(document).on('click', '.sab-remove-field', function() {
            $(this).closest('.sab-form-field').remove();
        });
    });
</script>
    <?php
}

// Form Render
function sab_render_form_field($field)
{
    $type = isset($field['type']) ? $field['type'] : '';
    $label = isset($field['label']) ? $field['label'] : '';
    $description = isset($field['description']) ? $field['description'] : '';
    $width = isset($field['width']) ? $field['width'] : '100';
    $placeholder_enabled = !empty($field['placeholder_enabled']) ? 'checked' : ''; 
    $label_color = isset($field['label_color']) ? $field['label_color'] : '';
    $label_font = isset($field['label_font']) ? $field['label_font'] : '';
    $required = !empty($field['required']) ? 'checked' : '';
    $unique = !empty($field['unique']) ? 'checked' : '';
    $css_class = isset($field['css_class']) ? esc_attr($field['css_class']) : '';
    $key = isset($field['key']) ? $field['key'] : uniqid();

    $types = array(
        'name' => 'نام و نام خانوادگی',
        'phone' => 'تلفن تماس',
        'mobile' => 'تلفن همراه',
        'email' => 'ایمیل',
        'service' => 'خدمات',
        'radio' => 'رادیویی',
        'checkbox' => 'چک باکس',
        'select' => 'انتخابی',     
        'doctor' => 'ارائه دهنده',
        'date' => 'تاریخ',
        'time' => 'زمان',
        'file_upload' => 'آپلود فایل',
        'price' => 'قیمت',
        'captcha' => 'کد امنیتی (کپچا)',         
        'custom_text_1' => 'فیلد سفارشی 1',
        'custom_text_2' => 'فیلد سفارشی 2',       
        'custom_text_3' => 'فیلد سفارشی 3',
        'custom_text_4' => 'فیلد سفارشی 4',               
    );

    $width_options = array(
        '20' => '20',
        '25' => '25',
        '33.33' => '33.33',
        '50' => '50',
        '66' => '66',
        '75' => '75',
        '100' => '100',
    );

    $html = '<div class="sab-form-field">';
    $html .= '<span class="sab-move-field dashicons dashicons-move"></span>';
    
    // Type Select
    $html .= '<select style="width:15%" name="sab_form_fields[type][' . esc_attr($key) . ']">';
    foreach ($types as $value => $type_label) {
        $selected = ($type == $value) ? 'selected' : '';
        $html .= "<option value=\"$value\" $selected>$type_label</option>";
    }
    $html .= '</select>';

    // Label Input
    $html .= '<input style="width:15%" type="text" name="sab_form_fields[label][' . esc_attr($key) . ']" value="' . esc_attr($label) . '" placeholder="برچسب سفارشی">';

    // Label Font
    $html .= '<input style="width:15%" type="text" name="sab_form_fields[label_font][' . esc_attr($key) . ']" value="' . esc_attr($label_font) . '" placeholder="فونت">';
    $html .= '<input style="width:15%" type="text" name="sab_form_fields[css_class][' . esc_attr($key) . ']" value="' . esc_attr(isset($field['css_class']) ? $field['css_class'] : '') . '" placeholder="کلاس CSS سفارشی">';    
    $html .= '<input style="width:25%" type="text" name="sab_form_fields[description][' . esc_attr($key) . ']" value="' . esc_attr($description) . '" placeholder="توضیحات فیلد">'; 

    // Width Select
    $html .= '<label class="bm-row">اندازه<select name="sab_form_fields[width][' . esc_attr($key) . ']"></label>';
    foreach ($width_options as $value => $display) {
        $selected = ($width == $value) ? 'selected' : '';
        $html .= "<option value=\"$value\" $selected>$display</option>";
    }
    $html .= '</select>';

    // Type of Fields
    $fields_with_type_option = ['name', 'phone', 'mobile', 'email', 'custom_text_1', 'custom_text_2', 'custom_text_3', 'custom_text_4'];
    if (in_array($type, $fields_with_type_option)) {
        $field_type = isset($field['field_type']) ? esc_attr($field['field_type']) : 'text';
        $html .= '<select name="sab_form_fields[field_type][' . esc_attr($key) . ']" class="conditional-field-options">';
        $html .= '<option value="text" ' . selected($field_type, 'text', false) . '>متنی</option>';
        $html .= '<option value="number" ' . selected($field_type, 'number', false) . '>عددی</option>';
        $html .= '<option value="email" ' . selected($field_type, 'email', false) . '>ایمیل</option>';
        $html .= '<option value="textarea" ' . selected($field_type, 'textarea', false) . '>جعبه متن</option>';
        $html .= '</select>';
    }
    // Label Color
    $html .= '<label class="label-space">رنگ برچسب<input style="vertical-align: middle;margin-right:10px;" type="color" name="sab_form_fields[label_color][' . esc_attr($key) . ']" value="' . esc_attr($label_color) . '"></label>';
    
    
    // Required Checkbox
    $html .= '<label><input class="label-space phone-check" type="checkbox" name="sab_form_fields[required][' . esc_attr($key) . ']" value="1" ' . $required . '>اجباری</label>';

    // Unique Checkbox
    $html .= '<label><input class="label-space phone-check" type="checkbox" name="sab_form_fields[unique][' . esc_attr($key) . ']" value="1" ' . $unique . '>یکتا</label>';

    // Placeholder Checkbox
    $html .= '<label><input class="label-space phone-check" type="checkbox" name="sab_form_fields[placeholder_enabled][' . esc_attr($key) . ']" value="1" ' . $placeholder_enabled . '>درون فیلد</label>';


    if ($type === 'file_upload') {
        $upload_count = isset($field['upload_count']) ? intval($field['upload_count']) : 1;
        $html .= '<label class="upload-count-row">تعداد ورودی ها: ';
        $html .= '<input type="number" name="sab_form_fields[upload_count][' . esc_attr($key) . ']" min="1" max="10" value="' . esc_attr($upload_count) . '">';
        $html .= '</label>';
    }
    if ($type === 'radio') {
        $radio_options = isset($field['radio_options']) ? esc_textarea($field['radio_options']) : '';
        $html .= '<label class="label-space radio-options-row">';
        $html .= '<textarea class="ra-ch-se" name="sab_form_fields[radio_options][' . esc_attr($key) . ']" placeholder="هر گزینه را در یک خط بنویسید">' . $radio_options . '</textarea>';
        $html .= '</label>';
    }

    if ($type === 'checkbox') {
        $checkbox_options = isset($field['checkbox_options']) ? esc_textarea($field['checkbox_options']) : '';
        $html .= '<label class="label-space checkbox-options-row">';
        $html .= '<textarea class="ra-ch-se" name="sab_form_fields[checkbox_options][' . esc_attr($key) . ']" placeholder="هر گزینه را در یک خط بنویسید">' . $checkbox_options . '</textarea>';
        $html .= '</label>';
    }

    if ($type === 'select') {
        $select_options = isset($field['select_options']) ? esc_textarea($field['select_options']) : '';
        $html .= '<label class="label-space select-options-row">';
        $html .= '<textarea class="ra-ch-se" name="sab_form_fields[select_options][' . esc_attr($key) . ']" placeholder="هر گزینه را در یک خط بنویسید">' . $select_options . '</textarea>';
        $html .= '</label>';
    }
    // Remove Button
    $html .= '<button type="button" class="sab-remove-field button-secondary">حذف</button>'; 

    $html .= '</div>';

    return $html;
}