<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; 
}

// Services Table
function sab_create_services_table() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $table_name = "{$wpdb->prefix}sab_services";

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        name varchar(255) NOT NULL,
        price decimal(10, 0) NOT NULL DEFAULT 0,            
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'sab_create_services_table');

// Providers Table
function sab_create_doctors_table() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $table_name = "{$wpdb->prefix}sab_doctors";

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        name varchar(255) NOT NULL,
        service_id mediumint(9) DEFAULT NULL,
        mobile varchar(20) NOT NULL,
        PRIMARY KEY  (id),
        FOREIGN KEY (service_id) REFERENCES {$wpdb->prefix}sab_services(id) ON DELETE SET NULL
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'sab_create_doctors_table');

// Availability Table
function sab_create_availability_table() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $table_name = "{$wpdb->prefix}sab_availability";

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        doctor_id mediumint(9) NOT NULL,
        date DATE NOT NULL,
        times text NOT NULL,
        PRIMARY KEY  (id),
        end_date DATE NULL,
        FOREIGN KEY (doctor_id) REFERENCES {$wpdb->prefix}sab_doctors(id) ON DELETE CASCADE
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'sab_create_availability_table');

// Appointments Table
function sab_create_appointments_table() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $table_name = "{$wpdb->prefix}sab_appointments";

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        service_id mediumint(9) DEFAULT NULL,
        doctor_id mediumint(9) NOT NULL,
        day varchar(50) NOT NULL,
        time varchar(50) NOT NULL,
        patient_name varchar(255) NOT NULL,
        patient_phone varchar(20) NOT NULL,
        patient_mobile varchar(20),  
        patient_email varchar(255),  
        custom_text_1 text,
        custom_text_2 text,
        custom_text_3 text,
        custom_text_4 text,                    
        radio_field text,
        checkbox_field text,
        select_field text,            
        file_path varchar(255),
        created_at datetime DEFAULT NULL,
        is_read tinyint(1) DEFAULT 0,
        PRIMARY KEY  (id),
        FOREIGN KEY (service_id) REFERENCES {$wpdb->prefix}sab_services(id) ON DELETE SET NULL,
        FOREIGN KEY (doctor_id) REFERENCES {$wpdb->prefix}sab_doctors(id) ON DELETE CASCADE
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'sab_create_appointments_table');

// Create Tables
add_action('admin_init', 'sab_check_and_create_tables');
function sab_check_and_create_tables() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sab_services';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
        sab_create_services_table();
    }
    $table_name = $wpdb->prefix . 'sab_doctors';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
        sab_create_doctors_table();
    }
    $table_name = $wpdb->prefix . 'sab_availability';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
        sab_create_availability_table();
    }
    $table_name = $wpdb->prefix . 'sab_appointments';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
        sab_create_appointments_table();
    }
}

// Update Appointments Table
function sab_update_appointments_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sab_appointments';
    $columns = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'custom_text_3'");
    if (empty($columns)) {
        $wpdb->query("ALTER TABLE $table_name ADD COLUMN custom_text_3 text");
    }
    $columns = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'custom_text_4'");
    if (empty($columns)) {
        $wpdb->query("ALTER TABLE $table_name ADD COLUMN custom_text_4 text");
    }
    $columns = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'radio_field'");
    if (empty($columns)) {
        $wpdb->query("ALTER TABLE $table_name ADD COLUMN radio_field text");
    }
    $columns = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'checkbox_field'");
    if (empty($columns)) {
        $wpdb->query("ALTER TABLE $table_name ADD COLUMN checkbox_field text");
    }
    $columns = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'select_field'");
    if (empty($columns)) {
        $wpdb->query("ALTER TABLE $table_name ADD COLUMN select_field text");
    }    
    $columns = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'created_at'");
    if (empty($columns)) {
        $wpdb->query("ALTER TABLE $table_name ADD COLUMN created_at datetime DEFAULT NULL");
    }    
    $columns = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'is_read'");
    if (empty($columns)) {
        $wpdb->query("ALTER TABLE $table_name ADD COLUMN is_read tinyint(1) DEFAULT 0");
    }    
}
add_action('admin_init', 'sab_update_appointments_table');

// Update Availability Table
function sab_update_availability_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sab_availability';
    $columns = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'end_date'");
    if (empty($columns)) {
        $wpdb->query("ALTER TABLE $table_name ADD COLUMN end_date DATE NULL");
    }
}
add_action('admin_init', 'sab_update_availability_table');

// Update Doctors Table
function sab_update_doctors_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sab_doctors';
    $columns = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'mobile'");
    if (empty($columns)) {
        $wpdb->query("ALTER TABLE $table_name ADD COLUMN mobile varchar(20) NOT NULL");
    }
    $column = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'is_independent'");
    if (empty($column)) {
        $wpdb->query("ALTER TABLE $table_name ADD is_independent TINYINT(1) DEFAULT 0");
    }    
}
add_action('admin_init', 'sab_update_doctors_table');

// Update Doctors Table Structure for Nullable service_id
function sab_update_doctors_table_structure() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sab_doctors';

    if (get_option('sab_doctors_table_updated') !== '1') {
        $constraints = $wpdb->get_results("
            SELECT CONSTRAINT_NAME 
            FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
            WHERE TABLE_NAME = '$table_name' 
            AND CONSTRAINT_TYPE = 'FOREIGN KEY'
            AND COLUMN_NAME = 'service_id'
        ");
        if (!empty($constraints)) {
            foreach ($constraints as $constraint) {
                $wpdb->query("ALTER TABLE $table_name DROP FOREIGN KEY {$constraint->CONSTRAINT_NAME}");
            }
        }

        $wpdb->query("ALTER TABLE $table_name MODIFY service_id mediumint(9) DEFAULT NULL");

        $wpdb->query("
            ALTER TABLE $table_name 
            ADD CONSTRAINT sab_doctors_service_id_fk 
            FOREIGN KEY (service_id) 
            REFERENCES {$wpdb->prefix}sab_services(id) 
            ON DELETE SET NULL
        ");
        update_option('sab_doctors_table_updated', '1');
    }
}
add_action('admin_menu', 'sab_update_doctors_table_structure');