jQuery(document).ready(function ($) {
    // تغییر اندازه ورودی قیمت
    function adjustInputWidth(input) {
        const tempSpan = document.createElement("span");
        tempSpan.style.visibility = "hidden";
        tempSpan.style.whiteSpace = "pre";
        tempSpan.style.font = window.getComputedStyle(input[0]).font;
        tempSpan.textContent = input.val();
        document.body.appendChild(tempSpan);
        input.css("width", tempSpan.offsetWidth + 20 + "px");
        document.body.removeChild(tempSpan);
    }

    // نمایش پاپ آپ در حال آماده سازی
    function showLoadingPopup() {
        Swal.fire({
            title: "لطفاً صبر کنید...",
            text: "در حال بارگذاری اطلاعات",
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            },
        });
    }

    // بستن پاپ آپ در حال آماده سازی
    function closeLoadingPopup() {
        Swal.close();
    }

    // دریافت خدمات
    $.ajax({
        url: sab_ajax_object.ajax_url,
        method: "POST",
        data: { action: "sab_get_services" },
        success: function (response) {
            if (response.success) {
                const services = response.data;
                const serviceSelect = $("#sab-service");
                $.each(services, function (index, service) {
                    serviceSelect.append(`<option value="${service.id}">${service.name}</option>`);
                });
            }
        },
    });

    // دریافت ارائه دهندگان
    $("#sab-service").change(function () {
        const selectedService = $(this).val();
        const doctorSelect = $("#sab-doctor");
        doctorSelect.prop("disabled", true).empty().append('<option value="">لطفاً انتخاب کنید</option>');

        if (selectedService) {
            showLoadingPopup();
            $.ajax({
                url: sab_ajax_object.ajax_url,
                method: "POST",
                data: { action: "sab_get_doctors", service_id: selectedService },
                success: function (response) {
                    if (response.success) {
                        const doctors = response.data;
                        $.each(doctors, function (index, doctor) {
                            doctorSelect.append(`<option value="${doctor.id}">${doctor.name}</option>`);
                        });
                        doctorSelect.prop("disabled", false);
                    }
                },
                error: function () {
                    Swal.fire("خطا", "خطا در بارگذاری پزشکان.", "error");
                },
                complete: closeLoadingPopup,
            });
        }
    });

    // بارگذاری قیمت برای خدمات انتخاب شده
    $("#sab-service").change(function () {
        const selectedService = $(this).val();
        if (selectedService) {
            showLoadingPopup();
            $.ajax({
                url: sab_ajax_object.ajax_url,
                method: "POST",
                data: { action: "sab_get_service_price", service_id: selectedService },
                success: function (response) {
                    if (response.success) {
                        const formattedPrice = response.data.price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                        const priceInput = $("#sab-price");
                        priceInput.val(formattedPrice);
                        adjustInputWidth(priceInput);
                    }
                },
                error: function () {
                    Swal.fire("خطا", "خطا در بارگذاری قیمت", "error");
                },
                complete: closeLoadingPopup,
            });
        }
    });

    // بارگذاری نوبت های آزاد برای ارائه دهنده انتخاب شده
    $("#sab-doctor").change(function () {
        const selectedDoctor = $(this).val();
        if (selectedDoctor) {
            $("#sab-date-button").prop("disabled", true);
            $("#sab-time-button").prop("disabled", true);
            $("#sab-selected-date").val("");
            $("#sab-selected-time").val("");
            $("#sab-selected-date-display").text("");
            $("#sab-selected-time-display").text("");

            window.doctorAvailability = null;
            window.bookedAppointments = null;

            showLoadingPopup();

            Promise.all([
                $.ajax({
                    url: sab_ajax_object.ajax_url,
                    method: "POST",
                    data: { action: "sab_get_availability", doctor_id: selectedDoctor }
                }),
                $.ajax({
                    url: sab_ajax_object.ajax_url,
                    method: "POST",
                    data: { action: "sab_get_booked_appointments", doctor_id: selectedDoctor }
                })
            ]).then(([availabilityResponse, bookedResponse]) => {
                if (availabilityResponse.success && bookedResponse.success) {
                    window.doctorAvailability = availabilityResponse.data;
                    window.bookedAppointments = bookedResponse.data;
                    $("#sab-date-button").prop("disabled", false);
                }
            }).catch(() => {
                Swal.fire("خطا", "خطا در بارگذاری اطلاعات.", "error");
            }).finally(() => {
                closeLoadingPopup();
            });
        } else {
            $("#sab-date-button, #sab-time-button").prop("disabled", true);
        }
    });
// نمایش پاپ آپ تاریخ با Swiper (یک ماه در هر اسلاید)
$("#sab-date-button").click(function () {
    if (!window.doctorAvailability || !window.doctorAvailability.dates) {
        Swal.fire("خطا", "اطلاعات تاریخ ها در دسترس نیست. لطفاً صفحه را رفرش کنید.", "error");
        return;
    }

    const dates = window.doctorAvailability.dates;
    const today = new Date();
    today.setHours(0, 0, 0, 0);

    // فیلتر کردن تاریخ های معتبر (از امروز به بعد)
    const validDates = dates.filter(date => {
        const selectedDate = new Date(date);
        selectedDate.setHours(0, 0, 0, 0);
        return selectedDate >= today;
    }).sort((a, b) => new Date(a) - new Date(b));

    if (validDates.length === 0) {
        Swal.fire("اطلاع", "هیچ تاریخ در دسترسی وجود ندارد.", "info");
        return;
    }

    // گروه بندی تاریخ ها بر اساس ماه جلالی
    const months = {};
    validDates.forEach(date => {
        const [gYear, gMonth, gDay] = date.split('-').map(Number);
        const jalaaliDate = jalaali.toJalaali(gYear, gMonth, gDay);
        const key = `${jalaaliDate.jy}-${jalaaliDate.jm}`;
        if (!months[key]) {
            months[key] = { jYear: jalaaliDate.jy, jMonth: jalaaliDate.jm - 1 };
        }
    });

    const monthList = Object.values(months);

    // تولید HTML اسلایدر با یک ماه در هر اسلاید
    let calendarHtml = `
        <div class="swiper-container">
            <div class="swiper-wrapper">
    `;

    for (let i = 0; i < monthList.length; i++) {
        calendarHtml += `<div class="swiper-slide">`;
        calendarHtml += generateJalaaliMonthCalendar(monthList[i].jYear, monthList[i].jMonth, validDates);
        calendarHtml += `</div>`;
    }

    calendarHtml += `
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>
    `;

    Swal.fire({
        title: "انتخاب تاریخ",
        html: calendarHtml,
        confirmButtonText: "تایید",
        cancelButtonText: "انصراف",
        showCancelButton: true,
        customClass: {
            popup: "swal-rtl",
        },
        width: '450px', // عرض کمتر برای یک ماه
        didOpen: () => {
            const swiper = new Swiper('.swiper-container', {
                slidesPerView: 1,
                spaceBetween: 0,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
                autoHeight: true,
                watchOverflow: true,
            });

            $('.calendar-day.available').on('click', function () {
                $('.calendar-day').removeClass('selected');
                $(this).addClass('selected');
            });
        },
        preConfirm: () => {
            const selectedDate = $('.calendar-day.selected').data('date');
            if (!selectedDate) {
                Swal.showValidationMessage("لطفاً یک تاریخ را انتخاب کنید");
                return false;
            }
            return selectedDate;
        },
    }).then((result) => {
        if (result.isConfirmed) {
            const selectedDate = result.value;
            const jalaaliDate = convertToJalaali(selectedDate);
            const dayName = getDayName(selectedDate);
            $("#sab-selected-date").val(selectedDate);
            $("#sab-selected-date-display").text(`${dayName} ${jalaaliDate}`);
            $("#sab-time-button").prop("disabled", false);
            $("#sab-selected-time").val("");
            $("#sab-selected-time-display").text("");
        }
    });
});

 function generateJalaaliMonthCalendar(jYear, jMonth, availableDates) {
    const daysInMonth = jalaali.jalaaliMonthLength(jYear, jMonth + 1);
    const gregorianStart = jalaali.toGregorian(jYear, jMonth + 1, 1);
    
    // محاسبه صحیح روز اول ماه
    const gregorianDateObj = new Date(gregorianStart.gy, gregorianStart.gm - 1, gregorianStart.gd);
    let firstDayOfMonth = gregorianDateObj.getDay();
    firstDayOfMonth = (firstDayOfMonth + 1) % 7; // تبدیل به index جلالی

    let calendarHtml = `<div class="calendar-month">`;
    calendarHtml += `<div class="month-header">${getJalaaliMonthName(jMonth)} ${jYear}</div>`;
    calendarHtml += `<div class="calendar-days">`;

     // افزودن نام روزهای هفته
     const jalaaliDaysFull = ["شنبه", "یکشنبه", "دوشنبه", "سه شنبه", "چهارشنبه", "پنج شنبه", "جمعه"];
     let jalaaliDays;

     // چک کردن عرض صفحه برای تشخیص موبایل (مثلاً کمتر از 768 پیکسل رو موبایل فرض می‌کنیم)
     if (window.innerWidth < 768) {
         jalaaliDays = jalaaliDaysFull.map(day => day.charAt(0)); // فقط حرف اول
     } else {
         jalaaliDays = jalaaliDaysFull; // نام کامل
     }

     jalaaliDays.forEach(day => {
         calendarHtml += `<div class="day-header">${day}</div>`;
     });

    // اضافه کردن خانه های خالی قبل از روز اول
    for (let i = 0; i < firstDayOfMonth; i++) {
        calendarHtml += `<div class="calendar-day empty"></div>`;
    }

    // تولید روزهای ماه
    for (let jDay = 1; jDay <= daysInMonth; jDay++) {
        const gregorianDate = jalaali.toGregorian(jYear, jMonth + 1, jDay);
        const dateString = `${gregorianDate.gy}-${gregorianDate.gm.toString().padStart(2, '0')}-${gregorianDate.gd.toString().padStart(2, '0')}`;
        const isAvailable = availableDates.includes(dateString);

        let className = 'calendar-day';
        className += isAvailable ? ' available' : ' unavailable';
        
        calendarHtml += `<div class="${className}" data-date="${dateString}">${jDay}</div>`;
    }

    calendarHtml += `</div></div>`;
    return calendarHtml;
}


function getJalaaliMonthName(month) {
    const months = ["فروردین", "اردیبهشت", "خرداد", "تیر", "مرداد", "شهریور", "مهر", "آبان", "آذر", "دی", "بهمن", "اسفند"];
    return months[month];
}
    // Get Days Index
    function getDayName(dateString) {
        const days = ["شنبه", "یکشنبه", "دوشنبه", "سه شنبه", "چهارشنبه", "پنج شنبه", "جمعه"];
        const date = new Date(dateString);
        let dayIndex = date.getDay();
        dayIndex = (dayIndex + 1) % 7;
        return days[dayIndex];
    }

    // Convert to Persian Date
	function convertToJalaali(dateString) {
		const dateParts = dateString.split("-");
		const gregorianYear = parseInt(dateParts[0], 10);
		const gregorianMonth = parseInt(dateParts[1], 10);
		const gregorianDay = parseInt(dateParts[2], 10);
		const jalaaliDate = jalaali.toJalaali(gregorianYear, gregorianMonth, gregorianDay);
		const month = jalaaliDate.jm.toString().padStart(2, '0');
		const day = jalaaliDate.jd.toString().padStart(2, '0');
		return `${jalaaliDate.jy}/${month}/${day}`;
	}

    // Turn Off Passed Dates
    function isDatePassed(dateString) {
        const today = new Date();
        today.setHours(0, 0, 0, 0);

        const checkDate = new Date(dateString);
        checkDate.setHours(0, 0, 0, 0);

        return checkDate < today;
    }

    // نمایش پاپ آپ انتخاب زمان
	function isTimeSlotPassed(selectedDate, selectedTime) {
		const currentDate = new Date();
		const [currentHour, currentMinute] = [currentDate.getHours(), currentDate.getMinutes()];
		
		const [slotHour, slotMinute] = selectedTime.split(':').map(Number);
		
		const currentTimeInMinutes = currentHour * 60 + currentMinute;
		const slotTimeInMinutes = slotHour * 60 + slotMinute;
		
		return (
			new Date(selectedDate).toDateString() === currentDate.toDateString() &&
			currentTimeInMinutes >= slotTimeInMinutes
		);
	}

	$("#sab-time-button").click(function() {
		const selectedDate = $("#sab-selected-date").val();
		if (!selectedDate || !window.doctorAvailability || !window.bookedAppointments) return;
		
		const times = window.doctorAvailability.times[selectedDate];
		let timeHtml = '<div class="sab-time-radio-group">';
		
		times.forEach(function(time) {
			const trimmedTime = time.trim();
			const isBooked = window.bookedAppointments.some(
				appointment => appointment.day === selectedDate && 
				appointment.time === trimmedTime
			);
			
			const isTimePassed = isTimeSlotPassed(selectedDate, trimmedTime);

			timeHtml += `
				<label class="rdio-tim${isBooked || isTimePassed ? ' label-booked' : ' label-available'}">
					<input type="radio" name="popup-time" value="${trimmedTime}"
						${isBooked || isTimePassed ? 'disabled' : ''}>
					<span>${trimmedTime}</span>
				</label>`;
		});
		
		timeHtml += '</div>';

		Swal.fire({
			title: 'انتخاب ساعت',
			html: timeHtml,
			confirmButtonText: 'تایید',
			cancelButtonText: 'انصراف',
			showCancelButton: true,
			customClass: {
				container: 'sab-time-popup',
				radio: 'sab-popup-radio'
			},
			preConfirm: () => {
				const selectedTime = document.querySelector('input[name="popup-time"]:checked');
				if (!selectedTime) {
					Swal.showValidationMessage('لطفاً یک ساعت را انتخاب کنید');
					return false;
				}
				return selectedTime.value;
			}
		}).then((result) => {
			if (result.isConfirmed) {
				const selectedTime = result.value;
				$("#sab-selected-time").val(selectedTime);
				$("#sab-selected-time-display").text(selectedTime);
			}
		});
	});

    // مدیریت ارسال فرم
    $("#sab-appointment-form").submit(function (e) {
        e.preventDefault();

        if (captchaAnswer !== null) {
            const userCaptchaInput = $("#sab-captcha-input").val();
            if (userCaptchaInput !== captchaAnswer) {
                Swal.fire({
                    title: "خطا",
                    text: "کد امنیتی اشتباه است.",
                    icon: "error",
                    confirmButtonText: "تلاش مجدد"
                });
                return;
            }
        }

        const selectedDate = $("#sab-selected-date").val();
        const selectedTime = $("#sab-selected-time").val();

        if (!selectedDate || !selectedTime) {
            Swal.fire({
                title: "خطا",
                text: "لطفاً روز و ساعت مورد نظر را انتخاب کنید.",
                icon: "error",
                confirmButtonText: "بازگشت به فرم",
                customClass: { popup: "swal-rtl" }
            });
            return;
        }

        let isValid = true;
        $(".sab-field input[required], .sab-field select[required]").each(function () {
            if (!$(this).val().trim()) {
                $(this).addClass("error");
                isValid = false;
            } else {
                $(this).removeClass("error");
            }
        });

        if (isValid) {
            Swal.fire({
                title: "در حال ثبت رزرو...",
                text: "لطفاً منتظر بمانید",
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            const finalData = new FormData(this);
            finalData.append("action", "sab_book_appointment");

            $.ajax({
                url: sab_ajax_object.ajax_url,
                method: "POST",
                data: finalData,
                contentType: false,
                processData: false,
                success: function (response) {
                    if (response.success) {
                        Swal.fire({
                            title: "موفقیت",
                            text: "رزرو با موفقیت انجام شد. در حال انتقال به صفحه تسویه حساب",
                            icon: "success",
                            showConfirmButton: false,
                            timer: 1500,
                            timerProgressBar: true
                        }).then(() => {
                            window.location.href = response.data.redirect || "/cart";
                        });
                    } else {
                        Swal.fire({
                            title: "خطا",
                            text: response.data.message || "خطا در ثبت رزرو",
                            icon: "error",
                            confirmButtonText: "باشه"
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        title: "خطا",
                        text: "خطا در ارسال درخواست. لطفاً مجدداً تلاش کنید.",
                        icon: "error",
                        confirmButtonText: "باشه"
                    });
                }
            });
        } else {
            Swal.fire({
                title: "خطا",
                text: "لطفاً همه فیلدهای اجباری را پر کنید.",
                icon: "error",
                confirmButtonText: "باشه"
            });
        }
    });

    // مدیریت کپچا
    let captchaAnswer = null;
    const canvas = document.getElementById('sab-captcha-canvas');
    if (canvas) {
        const ctx = canvas.getContext('2d');
        canvas.width = 100;
        canvas.height = 50;

        function generateCaptcha() {
            const captcha = Math.floor(1000 + Math.random() * 9000).toString();
            drawCaptcha(captcha);
            return captcha;
        }

        function drawCaptcha(captcha) {
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            ctx.fillStyle = '#f3f3f3';
            ctx.fillRect(0, 0, canvas.width, canvas.height);

            for (let i = 5; i < 10; i++) {
                ctx.fillStyle = getRandomColor();
                ctx.beginPath();
                ctx.arc(Math.random() * canvas.width, Math.random() * canvas.height, Math.random() * 3, 0, Math.PI * 2);
                ctx.fill();
            }

            ctx.font = '22px estdad';
            ctx.fillStyle = '#333';
            ctx.setTransform(1, Math.random() * 0.3, Math.random() * 0.3, 1, Math.random() * 10, Math.random() * 10);
            ctx.fillText(captcha, 70, 15);
            ctx.setTransform(1, 0, 0, 1, 0, 0);
        }

        function getRandomColor() {
            const letters = '0123456789ABCDEF';
            let color = '#';
            for (let i = 0; i < 6; i++) {
                color += letters[Math.floor(Math.random() * 16)];
            }
            return color;
        }

        captchaAnswer = generateCaptcha();
        $('#sab-refresh-captcha').on('click', function (e) {
            e.preventDefault();
            captchaAnswer = generateCaptcha();
            $('#sab-captcha-input').val('');
        });
    }
});