document.addEventListener("DOMContentLoaded", function () {
    jQuery(document).ajaxSuccess(function (event, xhr, settings) {
        try {
            const response = JSON.parse(xhr.responseText);
            if (response.success && response.data === "نوبت شما با موفقیت رزرو شد") {
                const popup = document.createElement("div");
                popup.id = "success-popup";
                popup.style.cssText = `
                    position: fixed;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    padding: 20px;
                    background: #4caf50;
                    color: white;
                    font-size: 16px;
                    text-align: center;
                    border-radius: 10px;
                    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
                    z-index: 10000;
                `;
                popup.innerText = response.data;

                document.body.appendChild(popup);

                setTimeout(() => {
                    popup.remove();
                }, 3000);
            }
        } catch (e) {
            console.error("Failed to parse AJAX response:", e);
        }
    });
});