<?php

$options = [

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			'has_sticky_header' => [
				'label' => __( 'Sticky Functionality', 'noorgfx-component' ),
				'type' => 'ct-switch',
				'value' => 'no',

				'sync' => [
					'id' => 'header_placements_1'
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_sticky_header' => 'yes' ],
				'options' => [

					'sticky_rows' => [
						'label' => false,
						'type' => 'ct-image-picker',
						'value' => 'middle',
						'design' => 'block',
						'sync' => [
							'id' => 'header_placements_1'
						],

						'choices' => [
							'middle' => [
								'src' => noorgfx_image_picker_url('sticky-main.svg'),
								'title' => __('Only Main Row', 'noorgfx-component'),
							],

							'top_middle' => [
								'src' => noorgfx_image_picker_url('sticky-top-main.svg'),
								'title' => __('Top & Main Row', 'noorgfx-component'),
							],

							'entire_header' => [
								'src' => noorgfx_image_picker_url('sticky-all.svg'),
								'title' => __('All Rows', 'noorgfx-component'),
							],

							'middle_bottom' => [
								'src' => noorgfx_image_picker_url('sticky-main-bottom.svg'),
								'title' => __('Main & Bottom Row', 'noorgfx-component'),
							],

							'top' => [
								'src' => noorgfx_image_picker_url('sticky-top.svg'),
								'title' => __('Only Top Row', 'noorgfx-component'),
							],

							'bottom' => [
								'src' => noorgfx_image_picker_url('sticky-bottom.svg'),
								'title' => __('Only Bottom Row', 'noorgfx-component'),
							],
						],
					],

					'sticky_effect' => [
						'label' => __('Effect', 'noorgfx-component' ),
						'type' => 'ct-select',
						'value' => 'shrink',
						'design' => 'block',
						'sync' => [
							'id' => 'header_placements_1'
						],
						'choices' => noorgfx_ordered_keys([
							'shrink' => __('Default', 'noorgfx-component'),
							'slide' => __('Slide Down', 'noorgfx-component'),
							'fade' => __('Fade', 'noorgfx-component'),
							'auto-hide' => __('Auto Hide/Show', 'noorgfx-component'),
						]),
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							'sticky_effect' => 'slide|fade',
						],
						'options' => [
							'sticky_animation_speed' => [
								'label' => __( 'Animation Speed', 'noorgfx-component' ),
								'type' => 'ct-number',
								'design' => 'inline',
								'value' => 0.2,
								'min' => 0.1,
								'max' => 10,
								'step' => 0.1,
								'sync' => 'live'
							],
						]
					],

					'sticky_offset' => [
						'label' => __( 'Offset', 'noorgfx-component' ),
						'type' => 'ct-slider',
						'min' => 0,
						'max' => 300,
						'value' => 0,
						'responsive' => true,
						'divider' => 'top',
						'sync' => [
							'id' => 'header_placements_1'
						],
					],

					'sticky_behaviour' => [
						'label' => __( 'Enable on', 'noorgfx-component' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'divider' => 'top',
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							// 'tablet' => true,
							'mobile' => true,
						]),

						'choices' => noorgfx_ordered_keys([
							'desktop' => __('Desktop', 'noorgfx-component'),
							// 'tablet' => __('Tablet', 'noorgfx-component'),
							'mobile' => __('Mobile', 'noorgfx-component'),
						]),

						'sync' => [
							'id' => 'header_placements_1'
						],
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'has_transparent_header' => [
				'label' => __( 'Transparent Functionality', 'noorgfx-component' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'sync' => [
					'id' => 'header_placements_1'
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'has_transparent_header' => 'yes',
					'id' => 'type-1'
				],
				'options' => [
					'transparent_conditions' => [
						'type' => 'noorgfx-display-condition',
						'value' => [
							[
								'type' => 'include',
								'rule' => 'everywhere'
							],

							[
								'type' => 'exclude',
								'rule' => '404'
							],

							[
								'type' => 'exclude',
								'rule' => 'search'
							],

							[
								'type' => 'exclude',
								'rule' => 'archives'
							]
						],
						'label' => __( 'Display Conditions', 'noorgfx-component' ),
						'display' => 'modal',
						'design' => 'block',
						// 'divider' => 'top',
						'sync' => [
							'id' => 'header_placements_1'
						]
					],
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_transparent_header' => 'yes' ],
				'options' => [
					'transparent_behaviour' => [
						'label' => __( 'Enable on', 'noorgfx-component' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'sync' => 'live',
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							// 'tablet' => true,
							'mobile' => true,
						]),

						'choices' => noorgfx_ordered_keys([
							'desktop' => __('Desktop', 'noorgfx-component'),
							// 'tablet' => __('Tablet', 'noorgfx-component'),
							'mobile' => __('Mobile', 'noorgfx-component'),
						]),
					],

				],
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Background', 'noorgfx-component' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerBackground',
						'label' => __('Default State', 'noorgfx-component')
					],

					[
						'id' => 'transparentHeaderBackground',
						'label' => __('Transparent State', 'noorgfx-component'),
						'condition' => [
							'has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderBackground',
						'label' => __('Sticky State', 'noorgfx-component'),
						'condition' => [
							'has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerBackground' => [
						'label' => __( 'Background', 'noorgfx-component' ),
						'type'  => 'ct-background',
						'design' => 'block:right',
						'responsive' => true,
						'value' => noorgfx_background_default_value([
							'backgroundColor' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],
						]),
						'sync' => 'live'
					],

					'transparentHeaderBackground' => [
						'label' => __( 'Background', 'noorgfx-component' ),
						'type'  => 'ct-background',
						'design' => 'block:right',
						'responsive' => true,
						'value' => noorgfx_background_default_value([
							'backgroundColor' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],
						]),
						'sync' => 'live'
					],

					'stickyHeaderBackground' => [
						'label' => __( 'Background', 'noorgfx-component' ),
						'type'  => 'ct-background',
						'design' => 'block:right',
						'responsive' => true,
						'value' => noorgfx_background_default_value([
							'backgroundColor' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],
						]),
						'sync' => 'live'
					],

				],
			],

		],
	],

];
