<?php

$everywhere_title = __('Entire Website', 'noorgfx-component');

if (
	$filter === 'product_tabs'
	||
	$filter === 'product_waitlist'
) {
	$everywhere_title = __('All Products', 'noorgfx-component');
}

$options = [];

if (
	$filter !== 'archive'
	&&
	$filter !== 'singular'
) {
	$options[] = [
		'title' => '',
		'rules' => [
			[
				'id' => 'everywhere',
				'title' => $everywhere_title
			]
		]
	];
}

$basic_rules = [];

if (
	$filter === 'all'
	||
	$filter === 'singular'
) {
	$basic_rules[] = [
		'id' => 'singulars',
		'title' => __('All Singulars', 'noorgfx-component')
	];
}

if (
	$filter === 'all'
	||
	$filter === 'archive'
) {
	$basic_rules[] = [
		'id' => $filter === 'archive' ? 'everywhere' : 'archives',
		'title' => __('All Archives', 'noorgfx-component')
	];
}

if (! empty($basic_rules)) {
	$options[] = [
		'title' => __('Basic', 'noorgfx-component'),
		'rules' => $basic_rules
	];
}

