<?php
/**
 * Options for shares widget.
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package Noorgfx
 */

$share_options = noorgfx_get_options('single-elements/post-share-box', [
	'display_style' => 'networks_only'
]);

// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$options = array_merge(
	// [
	// 	'title' => [
	// 		'type' => 'hidden',
	// 		'label' => __('Title', 'noorgfx-component'),
	// 		'value' => __('Share Icons', 'noorgfx-component'),
	// 	],
	// ],
	$share_options,
	[
		'share_item_tooltip' => [
			'type' => 'ct-switch',
			'label' => __('Tooltip', 'noorgfx-component'),
			'value' => 'no',
			'divider' => 'top:full',
		],
	
		'link_nofollow' => [
			'type' => 'ct-switch',
			'label' => __('Set links to nofollow', 'noorgfx-component'),
			'value' => 'no',
		],
	
		'share_icons_size' => [
			'label' => __( 'Icons Size', 'noorgfx-component' ),
			'type' => 'ct-slider',
			'min' => 5,
			'max' => 50,
			'value' => '',
			'responsive' => false,
			'divider' => 'top:full',
		],
	
		'items_spacing' => [
			'label' => __( 'Icons Spacing', 'noorgfx-component' ),
			'type' => 'ct-slider',
			'min' => 5,
			'max' => 50,
			'value' => '',
			'responsive' => false,
		],
	
		'share_icons_color' => [
			'label' => __('Icons Color', 'noorgfx-component'),
			'type' => 'ct-radio',
			'value' => 'default',
			'view' => 'text',
			'divider' => 'top:full',
			'setting' => ['transport' => 'postMessage'],
			'choices' => [
				'default' => __('Custom', 'noorgfx-component'),
				'official' => __('Official', 'noorgfx-component'),
			],
		],
	
		'share_type' => [
			'label' => __('Icons Shape Type', 'noorgfx-component'),
			'type' => 'ct-radio',
			'value' => 'simple',
			'view' => 'text',
			'setting' => ['transport' => 'postMessage'],
			'choices' => [
				'simple' => __('None', 'noorgfx-component'),
				'rounded' => __('Rounded', 'noorgfx-component'),
				'square' => __('Square', 'noorgfx-component'),
			],
		],
	
		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => ['share_type' => '!simple'],
			'options' => [
				'share_icons_fill' => [
					'label' => __('Shape Fill Type', 'noorgfx-component'),
					'type' => 'ct-radio',
					'value' => 'outline',
					'view' => 'text',
					'setting' => ['transport' => 'postMessage'],
					'choices' => [
						'outline' => __('Outline', 'noorgfx-component'),
						'solid' => __('Solid', 'noorgfx-component'),
					],
				],
			],
		],
	]
);
