<?php

$tax_choices = [];

if (class_exists('woocommerce')) {
	$attribute_taxonomies = wc_get_attribute_taxonomies();
	
	foreach ($attribute_taxonomies as $tax) {
		$tax_choices[$tax->attribute_name] = $tax->attribute_label;
	}
}

$options = [
	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['field' => 'wp:excerpt'],
		'options' => [
			'excerpt_length' => [
				'label' => __('Length', 'noorgfx-component'),
				'type' => 'ct-number',
				'design' => 'inline',
				'value' => 40,
				'min' => 1,
				'max' => 300,
			],
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['field' => 'wp:date'],
		'options' => [
			'date_type' => [
				'label' => __('Date type', 'noorgfx-component'),
				'type' => 'ct-select',
				'value' => 'published',
				'design' => 'inline',
				'purpose' => 'default',
				'choices' => noorgfx_ordered_keys(
					[
						'published' => __('Published Date', 'noorgfx-component'),
						'modified' => __('Modified Date', 'noorgfx-component'),
					]
				),
			],

			'default_format' => [
				'type'  => 'ct-switch',
				'label' => __('Default format', 'noorgfx-component'),
				'value' => 'yes',
				'desc' => __('Example: January 24, 2022', 'noorgfx-component'),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['default_format' => 'no'],
				'options' => [
					'date_format' => [
						'label' => __('Date type', 'noorgfx-component'),
						'type' => 'ct-select',
						'value' => 'F j, Y',
						'design' => 'inline',
						'purpose' => 'default',
						'choices' => noorgfx_ordered_keys(
							[
								'F j, Y' => date_i18n('F j, Y'),
								'Y-m-d' => date_i18n('Y-m-d'),
								'm/d/Y' => date_i18n('m/d/Y'),
								'd/m/Y' => date_i18n('d/m/Y'),
								'd.m.Y' => date_i18n('d.m.Y'),
								'd-m-Y' => date_i18n('d-m-Y'),
								'd.m.Y.' => date_i18n('d.m.Y.'),
								'd-m-Y' => date_i18n('d-m-Y'),
								'custom' => __('Custom', 'noorgfx-component'),
							]
						),
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => ['date_format' => 'custom'],
						'options' => [
							'custom_date_format' => [
								'type' => 'text',
								'label' => __('Custom date format', 'noorgfx-component'),
								'value' => 'F j, Y',
								'desc' => noorgfx_safe_sprintf(
									'%s <a href="%s" target="_blank">format string</a>',
									__('Enter a date or time', 'noorgfx-component'),
									'https://wordpress.org/documentation/article/customize-date-and-time-format/'
								),
							],
						]
					]
				]
			],
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['field' => 'wp:comments'],
		'options' => [
			'zero_text' => [
				'type' => 'text',
				'label' => __('No comments', 'noorgfx-component'),
				'value' => __('No comments', 'noorgfx-component'),
			],

			'single_text' => [
				'type' => 'text',
				'label' => __('One comment', 'noorgfx-component'),
				'value' => __('One comment', 'noorgfx-component'),
			],

			'multiple_text' => [
				'type' => 'text',
				'label' => __('Multiple comments', 'noorgfx-component'),
				'value' => __('% comments', 'noorgfx-component'),
			]
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['field' => 'woo:attributes'],
		'options' => [
			'attribute' => [
				'label' => __('Attribute', 'noorgfx-component'),
				'type' => 'ct-select',
				'value' => '',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => noorgfx_ordered_keys($tax_choices),
			]
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['field' => 'wp:terms|woo:attributes'],
		'options' => [
			'separator' => [
				'type' => 'text',
				'label' => __('Separator', 'noorgfx-component'),
				'value' => ', ',
			],
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['field' => 'wp:author'],
		'options' => [
			'author_field' => [
				'type' => 'ct-select',
				'label' => __('Author Field', 'noorgfx-component'),
				'value' => 'display_name',
				'design' => 'inline',
				'purpose' => 'default',
				'choices' => noorgfx_ordered_keys(
					[
						'display_name' => __('Display Name', 'noorgfx-component'),
						'nicename' => __('Nickname', 'noorgfx-component'),
						'first_name' => __('First Name', 'noorgfx-component'),
						'last_name' => __('Last Name', 'noorgfx-component'),
						'description' => __('Description', 'noorgfx-component'),
						'email' => __('Email', 'noorgfx-component'),
						'user_url' => __('Website', 'noorgfx-component'),
					]
				),
			]
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [
			'any' => [
				'field' => implode('|', [
					'wp:title',
					'wp:date',
					'wp:author',
					'wp:terms',
					'wp:comments',

					'wp:term_title',
					'wp:term_count',

					'wp:author_avatar',
				]),
				'all' => [
					'viewType' => 'default',
					'field' => implode('|', [
						'wp:featured_image',
						'wp:term_image'
					]),
				],
			]
		],
		'options' => [
			'has_field_link' => [
				'type'  => 'ct-switch',
				'label' => [
					__('Link to post', 'noorgfx-component') => [
						'field' => 'wp:title|wp:date|wp:comments'
					],

					__('Link to author page', 'noorgfx-component') => [
						'field' => 'wp:author_avatar'
					],

					__('Link to author page', 'noorgfx-component') => [
						'field' => 'wp:author',
						'author_field' => 'display_name|nicename|first_name|last_name|description'
					],

					__('Link to email', 'noorgfx-component') => [
						'field' => 'wp:author',
						'author_field' => 'email'
					],

					__('Link to website', 'noorgfx-component') => [
						'field' => 'wp:author',
						'author_field' => 'user_url'
					],

					__('Link to term page', 'noorgfx-component') => [
						'field' => 'wp:terms'
					],

					__('Link to archive page', 'noorgfx-component') => [
						'field' => 'wp:term_title|wp:term_image|wp:term_count'
					],
				],
				'value' => 'no',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['has_field_link' => 'yes'],
				'options' => [
					'has_field_link_new_tab' => [
						'type'  => 'ct-switch',
						'label' => __('Open in new tab', 'noorgfx-component'),
						'value' => 'no',
					],

					'has_field_link_rel' => [
						'type' => 'text',
						'label' => __('Link Rel', 'noorgfx-component'),
						'value' => '',
					],
				]
			]
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [
			'field' => 'wp:terms',
			'has_taxonomies_customization' => 'yes'
		],
		'options' => [
			'termAccentColor' => [
				'type'  => 'ct-switch',
				'label' => __('Terms accent color', 'noorgfx-component'),
				'divider' => 'top:full',
				'value' => 'yes',
			]
		]
	]
];

