<?php
/**
 * Contact Info widget
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package Noorgfx
 */

$classes = noorgfx_default_akg('className', $atts, '');
$contact_information = noorgfx_default_akg('contact_information', $atts, [
	[
		'id' => 'address',
		'enabled' => true,
		'title' => __('Address:', 'noorgfx-component'),
		'content' => 'خیابان یکم پلاک دوم',
		'link' => '',
	],

	[
		'id' => 'phone',
		'enabled' => true,
		'title' => __('Phone:', 'noorgfx-component'),
		'content' => '021-12345678',
		'link' => 'tel:021-12345678',
	],

	[
		'id' => 'mobile',
		'enabled' => true,
		'title' => __('Mobile:', 'noorgfx-component'),
		'content' => '021-12345678',
		'link' => 'tel:021-12345678',
	],
]);

$classes = ['ct-contact-info-block', $classes];

$type = noorgfx_akg('contacts_icon_shape', $atts, 'rounded');
$fill = noorgfx_akg('contacts_icon_fill_type', $atts, 'outline');

$content = blc_get_contacts_output(
	[
		'data' => $contact_information,
		'link_target' => noorgfx_default_akg(
			'contact_link_target',
			$atts,
			'no'
		),
		'link_nofollow' => noorgfx_default_akg(
			'link_nofollow',
			$atts,
			'no'
		),
		'type' => $type,
		'fill' => $fill,
		'link_icons' => noorgfx_akg('link_icons', $atts, 'no'),
	]
);

$colors = [
	'--theme-block-text-color' => noorgfx_default_akg('customTextColor', $atts, ''),
	'--theme-link-initial-color' => noorgfx_default_akg('customTextInitialColor', $atts, ''),
	'--theme-link-hover-color' => noorgfx_default_akg('customTextHoverColor', $atts, ''),
	'--theme-icon-color' => noorgfx_default_akg('customIconsColor', $atts, ''),
	'--theme-icon-hover-color' => noorgfx_default_akg('customIconsHoverColor', $atts, ''),
];

if ($type !== 'simple') {
	$base_color = noorgfx_default_akg('customBorderColor', $atts, 'rgba(218, 222, 228, 0.5)');
	$hover_color = noorgfx_default_akg('customBorderHoverColor', $atts, 'rgba(218, 222, 228, 0.7)');

	if (isset($atts['borderColor'])) {
		$var = $atts['borderColor'];
		$base_color = "var(--wp--preset--color--$var)";
	}

	if (isset($atts['borderHoverColor'])) {
		$var = $atts['borderHoverColor'];
		$hover_color = "var(--wp--preset--color--$var)";
	}

	if ($fill === 'solid') {
		$base_color = noorgfx_default_akg('customBackgroundColor', $atts, 'rgba(218, 222, 228, 0.5)');
		$hover_color = noorgfx_default_akg('customBackgroundHoverColor', $atts, 'rgba(218, 222, 228, 0.7)');

		if (isset($atts['backgroundColor'])) {
			$var = $atts['backgroundColor'];
			$base_color = "var(--wp--preset--color--$var)";
		}

		if (isset($atts['backgroundHoverColor'])) {
			$var = $atts['backgroundHoverColor'];
			$hover_color = "var(--wp--preset--color--$var)";
		}
	}

	$colors = array_merge(
		$colors,
		[
			'--background-color' => $base_color,
			'--background-hover-color' => $hover_color
		]
	);
}

if (isset($atts['textColor'])) {
	$var = $atts['textColor'];
	$colors['--theme-block-text-color'] = "var(--wp--preset--color--$var)";
}

if (isset($atts['textInitialColor'])) {
	$var = $atts['textInitialColor'];
	$colors['--theme-link-initial-color'] = "var(--wp--preset--color--$var)";
}

if (isset($atts['textHoverColor'])) {
	$var = $atts['textHoverColor'];
	$colors['--theme-link-hover-color'] = "var(--wp--preset--color--$var)";
}

if (isset($atts['iconsColor'])) {
	$var = $atts['iconsColor'];
	$colors['--theme-icon-color'] = "var(--wp--preset--color--$var)";
}

if (isset($atts['iconsHoverColor'])) {
	$var = $atts['iconsHoverColor'];
	$colors['--theme-icon-hover-color'] = "var(--wp--preset--color--$var)";
}

$colors_css = '';

foreach ($colors as $key => $value) {
	if (empty($value)) {
		continue;
	}

	$colors_css .= $key . ':' . $value . ';';
}

$wp_styles_css = '';

if (isset($atts['style'])) {
	$wp_styles = wp_style_engine_get_styles($atts['style']);
	$wp_styles_css = noorgfx_akg('css', $wp_styles, '');
}

$style = '';

$icons_size = noorgfx_akg('contacts_icons_size', $atts, 20);

if (! empty($icons_size)) {
	$style .= '--theme-icon-size:' . $icons_size . 'px;';
}

$items_spacing = noorgfx_akg('contacts_items_spacing', $atts, '');

if (! empty($items_spacing)) {
	$style .= '--items-spacing:' . $items_spacing . 'px;';
}

if (noorgfx_default_akg('contacts_items_direction', $atts, 'column') === 'column') {
	$style .= '--items-direction:' . noorgfx_default_akg('contacts_items_direction', $atts, 'column') . ';';
}

echo noorgfx_html_tag(
	'div',
	[
		'class' => implode(' ', $classes),
		'style' => $style . $colors_css . $wp_styles_css
	],
	$content
);

