<?php

$options = [

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [
			'product_review_entity' => [
				'label' => __( 'Review Entity', 'noorgfx-component' ),
				'type' => 'ct-select',
				'value' => 'Thing',
				'view' => 'text',
				'design' => 'inline:start',
				'choices' => noorgfx_ordered_keys(
					[
						'Thing' => __( 'Default', 'noorgfx-component' ),
						'Product' => __( 'Product', 'noorgfx-component' ),
						'Book' => __( 'Book', 'noorgfx-component' ),
						// 'Course' => __( 'Course', 'noorgfx-component' ),
						'CreativeWorkSeason' => __( 'Creative Work Season', 'noorgfx-component' ),
						'CreativeWorkSeries' => __( 'Creative Work Series', 'noorgfx-component' ),
						'Episode' => __( 'Episode', 'noorgfx-component' ),
						// 'Event' => __( 'Event', 'noorgfx-component' ),
						'Game' => __( 'Game', 'noorgfx-component' ),
						// 'HowTo' => __( 'How To', 'noorgfx-component' ),
						'LocalBusiness' => __( 'Local Business', 'noorgfx-component' ),
						'MediaObject' => __( 'Media Object', 'noorgfx-component' ),
						'Movie' => __( 'Movie', 'noorgfx-component' ),
						'MusicPlaylist' => __( 'Music Playlist', 'noorgfx-component' ),
						'MusicRecording' => __( 'Music Recording', 'noorgfx-component' ),
						'Organization' => __( 'Organization', 'noorgfx-component' ),
						// 'Recipe' => __( 'Recipe', 'noorgfx-component' ),
						// 'SoftwareApplication' => __( 'Software Application', 'noorgfx-component' ),
					]
				),
				'desc' => blc_safe_sprintf(
					__(
						'More info about review entity and how to choose the right one can be found %shere%s.',
						'noorgfx-component'
					),
					'<a href="https://developers.google.com/search/blog/2019/09/making-review-rich-results-more-helpful" target="_blank">',
					'</a>'
				),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['product_review_entity' => 'Product'],
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-group',
						'label' => ' ',
						'wrapperAttr' => ['data-design' => 'inline'],
						'options' => [

							noorgfx_rand_md5() => [
								'type' => 'ct-notification',
								'text' => __( 'Please note that some of this information (price, sku, brand) won\'t be displayed on the front-end. It is solely used for Google\'s Schema.org markup.', 'noorgfx-component' ),
								'attr' => ['data-type' => 'background:yellow']
							],

						],
					],

					'product_entity_price' => [
						'type' => 'text',
						'label' => __('Product Price', 'noorgfx-component'),
						'design' => 'inline:start',
						'value' => '',
					],

					'product_entity_sku' => [
						'type' => 'text',
						'label' => __('Product SKU', 'noorgfx-component'),
						'design' => 'inline:start',
						'value' => '',
					],

					'product_entity_brand' => [
						'type' => 'text',
						'label' => __('Product Brand', 'noorgfx-component'),
						'design' => 'inline:start',
						'value' => '',
					],
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'gallery' => [
				'type' => 'ct-multi-image-uploader',
				'label' => __('Gallery', 'noorgfx-component'),
				'design' => 'inline:start',
				'value' => []
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'product_button_label' => [
				'type' => 'text',
				'label' => __('Affiliate Button Label', 'noorgfx-component'),
				'design' => 'inline:start',
				'value' => __('Buy Now', 'noorgfx-component')
			],

			'product_link' => [
				'type' => 'text',
				'label' => __('Affiliate Link', 'noorgfx-component'),
				'design' => 'inline:start',
				'value' => '#'
			],

			'product_link_target' => [
				'label' => __( 'Open Link In New Tab', 'noorgfx-component' ),
				'type'  => 'ct-switch',
				'design' => 'inline:start',
				'value' => 'no',
			],

			'product_link_sponsored' => [
				'label' => __( 'Sponsored Attribute', 'noorgfx-component' ),
				'type'  => 'ct-switch',
				'design' => 'inline:start',
				'value' => 'no',
			],

			/*
			'product_button_icon' => [
				'type' => 'icon-picker',
				'label' => __('Button Icon', 'noorgfx-component'),
				'design' => 'inline:start',
				'value' => [
					'icon' => 'fas fa-shopping-cart'
				]
			],
			 */

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'product_read_content_button_label' => [
				'type' => 'text',
				'label' => __('Read More Button Label', 'noorgfx-component'),
				'design' => 'inline:start',
				'value' => __('Read More', 'noorgfx-component')
			],

			/*
			'product_read_content_button_icon' => [
				'type' => 'icon-picker',
				'label' => __('Button Icon', 'noorgfx-component'),
				'design' => 'inline:start',
				'value' => [
					'icon' => 'fas fa-arrow-down'
				]
			],
			 */

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'product_description' => [
				'type' => 'wp-editor',
				'label' => __('Short Description', 'noorgfx-component'),
				'value' => '',
				'design' => 'inline:start',
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Rating', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			'scores' => [
				'type' => 'ct-addable-box',
				'label' => __('Scores', 'noorgfx-component'),
				'design' => 'inline:start',
				'preview-template' => '<%= label %> (<%= score === 1 ? "1 star" : score + " stars" %>)',

				'inner-options' => [
					'label' => [
						'type' => 'text',
						'value' => 'Default'
					],

					'score' => [
						'type' => 'ct-number',
						'value' => 5,
						'step' => 0.1,
						'min' => 1,
						'max' => 5
					]
				],

				'value' => [
					/*
					[
						'label' => 'Features',
						'score' => 5
					],

					[
						'label' => 'Quality',
						'score' => 5
					]
					 */
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'product_specs' => [
				'type' => 'ct-addable-box',
				'label' => __('Product specs', 'noorgfx-component'),
				'design' => 'inline:start',
				'preview-template' => '<%= label %>',

				'inner-options' => [
					'label' => [
						'type' => 'text',
						'value' => 'Default'
					],

					'value' => [
						'type' => 'text',
						'value' => ''
					]
				],

				'value' => []
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'product_pros' => [
				'type' => 'ct-addable-box',
				'label' => __('Pros', 'noorgfx-component'),
				'design' => 'inline:start',
				'preview-template' => '<%= label %>',

				'inner-options' => [
					'label' => [
						'type' => 'text',
						'value' => 'Default'
					],
				],

				'value' => []
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'product_cons' => [
				'type' => 'ct-addable-box',
				'label' => __('Cons', 'noorgfx-component'),
				'design' => 'inline:start',
				'preview-template' => '<%= label %>',

				'inner-options' => [
					'label' => [
						'type' => 'text',
						'value' => 'Default'
					],
				],

				'value' => []
			],

		],
	],

	// noorgfx_rand_md5() => [
	// 	'title' => __( 'Design', 'noorgfx-component' ),
	// 	'type' => 'tab',
	// 	'options' => [

	// 	],
	// ],
];

