<?php

$forms_type =  blc_theme_functions()->noorgfx_get_theme_mod('forms_type', 'classic-forms');

noorgfx_output_colors([
	'value' => blc_theme_functions()->noorgfx_get_theme_mod('newsletter_subscribe_title_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-newsletter-subscribe-container',
			'variable' => 'theme-heading-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => blc_theme_functions()->noorgfx_get_theme_mod('newsletter_subscribe_content'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-newsletter-subscribe-container',
			'variable' => 'text-color'
		],

		'hover' => [
			'selector' => '.ct-newsletter-subscribe-container',
			'variable' => 'theme-link-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => blc_theme_functions()->noorgfx_get_theme_mod('newsletter_subscribe_button'),
	'default' => [
		'default' => [ 'color' => 'var(--theme-palette-color-1)' ],
		'hover' => [ 'color' => 'var(--theme-palette-color-2)' ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-newsletter-subscribe-container',
			'variable' => 'theme-button-background-initial-color'
		],

		'hover' => [
			'selector' => '.ct-newsletter-subscribe-container',
			'variable' => 'theme-button-background-hover-color'
		]
	],
]);

noorgfx_output_colors([
	'value' => blc_theme_functions()->noorgfx_get_theme_mod('newsletter_subscribe_input_font_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-newsletter-subscribe-container',
			'variable' => 'theme-form-text-initial-color'
		],

		'focus' => [
			'selector' => '.ct-newsletter-subscribe-container',
			'variable' => 'theme-form-text-focus-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => blc_theme_functions()->noorgfx_get_theme_mod('newsletter_subscribe_border_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-newsletter-subscribe-container',
			'variable' => 'theme-form-field-border-initial-color'
		],

		'focus' => [
			'selector' => '.ct-newsletter-subscribe-container',
			'variable' => 'theme-form-field-border-focus-color'
		],
	],
]);

if ($forms_type !== 'classic-forms' || is_customize_preview()) {
	noorgfx_output_colors([
		'value' => blc_theme_functions()->noorgfx_get_theme_mod('newsletter_subscribe_input_background'),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
			'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => '.ct-newsletter-subscribe-container',
				'variable' => 'theme-form-field-background-initial-color'
			],

			'focus' => [
				'selector' => '.ct-newsletter-subscribe-container',
				'variable' => 'theme-form-field-background-focus-color'
			],
		],
	]);
}

noorgfx_output_background_css([
	'selector' => '.ct-newsletter-subscribe-container',
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'value' => blc_theme_functions()->noorgfx_get_theme_mod(
		'newsletter_subscribe_container_background',
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => 'var(--theme-palette-color-8)'
				],
			],
		])
	),
	'responsive' => true,
]);

noorgfx_output_border([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-newsletter-subscribe-container',
	'variableName' => 'newsletter-container-border',
	'value' => blc_theme_functions()->noorgfx_get_theme_mod('newsletter_subscribe_container_border'),
	'skip_none' => true,
	'default' => [
		'width' => 1,
		'style' => 'none',
		'color' => [
			'color' => 'var(--theme-palette-color-5)',
		],
	],
	'responsive' => true,
	'skip_none' => true
]);

noorgfx_output_box_shadow([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-newsletter-subscribe-container',
	'value' => blc_theme_functions()->noorgfx_get_theme_mod(
		'newsletter_subscribe_shadow',
		noorgfx_box_shadow_value([
			'enable' => true,
			'h_offset' => 0,
			'v_offset' => 50,
			'blur' => 90,
			'spread' => 0,
			'inset' => false,
			'color' => [
				'color' => 'rgba(210, 213, 218, 0.4)',
			],
		])
	),
	'responsive' => true
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-newsletter-subscribe-container',
	'property' => 'padding',
	'value' => blc_theme_functions()->noorgfx_get_theme_mod(
		'newsletter_subscribe_container_spacing',
		noorgfx_spacing_value()
	),
	'empty_value' => 30
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-newsletter-subscribe-container',
	'property' => 'theme-border-radius',
	'value' => blc_theme_functions()->noorgfx_get_theme_mod(
		'newsletter_subscribe_container_border_radius',
		noorgfx_spacing_value()
	)
]);
