<?php

$options = [
	'label' => __( 'Subscribe Form', 'noorgfx-component' ),
	'type' => 'ct-panel',
	'switch' => true,
	'value' => 'yes',
	'sync' => noorgfx_sync_single_post_container(),
	'inner-options' => [

		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'newsletter_subscribe_title' => [
					'type' => 'text',
					'label' => __( 'Title', 'noorgfx-component' ),
					'design' => 'block',
					'value' => __( 'Newsletter Updates', 'noorgfx-component' ),
					'disableRevertButton' => true,
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'newsletter_subscribe_text' => [
					'label' => __( 'Description', 'noorgfx-component' ),
					'type' => 'textarea',
					'value' => __( 'Enter your email address below and subscribe to our newsletter', 'noorgfx-component' ),
					'design' => 'block',
					'disableRevertButton' => true,
					'setting' => [ 'transport' => 'postMessage' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
					'attr' => [ 'data-type' => 'small' ],
				],

				'newsletter_subscribe_list_id_source' => [
					'type' => 'ct-radio',
					'label' => __( 'List Source', 'noorgfx-component' ),
					'value' => 'default',
					'view' => 'radio',
					'inline' => true,
					'design' => 'inline',
					'disableRevertButton' => true,
					'choices' => [
						'default' => __('Default', 'noorgfx-component'),
						'custom' => __('Custom', 'noorgfx-component'),
					],

					'setting' => [ 'transport' => 'postMessage' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'newsletter_subscribe_list_id_source' => 'custom' ],
					'options' => [

						'newsletter_subscribe_list_id' => [
							'label' => __( 'List ID', 'noorgfx-component' ),
							'type' => 'noorgfx-newsletter-subscribe',
							'value' => '',
							'design' => 'inline',
							'disableRevertButton' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
					'attr' => [ 'data-type' => 'small' ],
				],

				'has_newsletter_subscribe_name' => [
					'type'  => 'ct-switch',
					'label' => __( 'Name Field', 'noorgfx-component' ),
					'value' => 'no',
					'disableRevertButton' => true,
					'sync' => noorgfx_sync_single_post_container([
						'loader_selector' => '.ct-newsletter-subscribe-container'
					]),
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'has_newsletter_subscribe_name' => 'yes' ],
					'options' => [

						'newsletter_subscribe_name_required' => [
							'type' => 'ct-switch',
							'label' => __('Make Name Field Required', 'noorgfx-component'),
							'value' => 'no',
							'disableRevertButton' => true,
							'sync' => noorgfx_sync_single_post_container([
								'loader_selector' => '.ct-newsletter-subscribe-container'
							]),
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
					'attr' => [ 'data-type' => 'small' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'has_newsletter_subscribe_name' => 'yes' ],
					'options' => [

						'newsletter_subscribe_name_label' => [
							'type' => 'text',
							'label' => __( 'Name Label', 'noorgfx-component' ),
							'design' => 'inline',
							'value' => __( 'Your name', 'noorgfx-component' ),
							'disableRevertButton' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],
					],
				],

				'newsletter_subscribe_mail_label' => [
					'type' => 'text',
					'label' => __( 'Mail Label', 'noorgfx-component' ),
					'design' => 'inline',
					'value' => __( 'Your email', 'noorgfx-component' ),
					'disableRevertButton' => true,
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'newsletter_subscribe_button_text' => [
					'type' => 'text',
					'label' => __( 'Button Label', 'noorgfx-component' ),
					'design' => 'inline',
					'value' => __( 'Subscribe', 'noorgfx-component' ),
					'disableRevertButton' => true,
					'setting' => [ 'transport' => 'postMessage' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'newsletter_subscribe_subscribe_visibility' => [
					'label' => __( 'Visibility', 'noorgfx-component' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => false,
					]),

					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],

			],
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'newsletter_subscribe_title_color' => [
					'label' => __( 'Title Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-heading-color, var(--theme-heading-3-color, var(--theme-headings-color)))'
						],
					],
				],

				'newsletter_subscribe_content' => [
					'label' => __( 'Text Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'hover' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],

						[
							'title' => __( 'Hover', 'noorgfx-component' ),
							'id' => 'hover',
							'inherit' => 'var(--theme-link-hover-color)'
						],
					],
				],

				'newsletter_subscribe_input_font_color' => [
					'label' => __( 'Input Font Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'focus' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-form-text-initial-color, var(--theme-text-color))'
						],

						[
							'title' => __( 'Focus', 'noorgfx-component' ),
							'id' => 'focus',
							'inherit' => 'var(--theme-form-text-focus-color, var(--theme-text-color))'
						],
					],
				],

				'newsletter_subscribe_border_color' => [
					'label' => __( 'Input Border Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'focus' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-form-field-border-initial-color)'
						],

						[
							'title' => __( 'Focus', 'noorgfx-component' ),
							'id' => 'focus',
							'inherit' => 'var(--theme-form-field-border-focus-color)'
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => ['forms_type' => 'classic-forms'],
					'values_source' => 'global',
					'options' => [

						'newsletter_subscribe_input_background' => [
							'label' => __( 'Input Background Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
								],

								'focus' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
								],

								[
									'title' => __( 'Focus', 'noorgfx-component' ),
									'id' => 'focus',
								],
							],
						],

					],
				],

				'newsletter_subscribe_button' => [
					'label' => __( 'Button Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],

					'value' => [
						'default' => [
							'color' => 'var(--theme-palette-color-1)',
						],

						'hover' => [
							'color' => 'var(--theme-palette-color-2)',
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
						],

						[
							'title' => __( 'Hover', 'noorgfx-component' ),
							'id' => 'hover',
						],
					],
				],

				'newsletter_subscribe_container_background' => [
					'label' => __( 'Container Background', 'noorgfx-component' ),
					'type' => 'ct-background',
					'design' => 'block:right',
					'responsive' => true,
					'divider' => 'top:full',
					'sync' => 'live',
					'value' => noorgfx_background_default_value([
						'backgroundColor' => [
							'default' => [
								'color' => 'var(--theme-palette-color-8)',
							],
						],
					])
				],

				'newsletter_subscribe_container_border' => [
					'label' => __( 'Container Border', 'noorgfx-component' ),
					'type' => 'ct-border',
					'sync' => 'live',
					'design' => 'block',
					'divider' => 'top',
					'value' => [
						'width' => 1,
						'style' => 'none',
						'color' => [
							'color' => 'var(--theme-palette-color-5)',
						],
					],
					'responsive' => true,
				],

				'newsletter_subscribe_shadow' => [
					'label' => __( 'Container Shadow', 'noorgfx-component' ),
					'type' => 'ct-box-shadow',
					'responsive' => true,
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_box_shadow_value([
						'enable' => true,
						'h_offset' => 0,
						'v_offset' => 50,
						'blur' => 90,
						'spread' => 0,
						'inset' => false,
						'color' => [
							'color' => 'rgba(210, 213, 218, 0.4)',
						],
					])
				],

				'newsletter_subscribe_container_spacing' => [
					'label' => __( 'Container Inner Spacing', 'noorgfx-component' ),
					'type' => 'ct-spacing',
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_spacing_value(),
					'inputAttr' => [
						'placeholder' => '30'
					],
					'min' => 0,
					'responsive' => true
				],

				'newsletter_subscribe_container_border_radius' => [
					'label' => __( 'Container Border Radius', 'noorgfx-component' ),
					'type' => 'ct-spacing',
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_spacing_value(),
					'min' => 0,
					'responsive' => true
				],

			],
		],
	],
];
