<?php
/**
 * Newsletter Subscribe widget
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	'newsletter_subscribe_text' => [
		'label' => __('Text', 'noorgfx-component'),
		'type' => 'hidden',
		'value' => __(
			'Enter your email address below and subscribe to our newsletter',
			'noorgfx-component'
		),
		'desc' => __(
			'You can add here some arbitrary HTML code.',
			'noorgfx-component'
		),
		'disableRevertButton' => true,
		'setting' => ['transport' => 'postMessage'],

		'mediaButtons' => false,
		'tinymce' => [
			'toolbar1' => 'bold,italic,link,undo,redo',
		],
	],

	'newsletter_subscribe_list_id_source' => [
		'type' => 'ct-radio',
		'label' => __('List Source', 'noorgfx-component'),
		'value' => 'default',
		'view' => 'radio',
		'inline' => true,
		'disableRevertButton' => true,
		'choices' => [
			'default' => __('Default', 'noorgfx-component'),
			'custom' => __('Custom', 'noorgfx-component'),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['newsletter_subscribe_list_id_source' => 'custom'],
		'options' => [
			'newsletter_subscribe_list_id' => [
				'label' => __('List ID', 'noorgfx-component'),
				'type' => 'noorgfx-newsletter-subscribe',
				'value' => '',
				'disableRevertButton' => true,
			],
		],
	],

	'newsletter_subscribe_view_type' => [
		'type' => 'ct-radio',
		'label' => __('Form Style', 'noorgfx-component'),
		'value' => 'inline',
		'view' => 'radio',
		'inline' => true,
		'divider' => 'top:full',
		'disableRevertButton' => true,
		'choices' => [
			'inline' => __('Inline', 'noorgfx-component'),
			'stacked' => __('Stacked', 'noorgfx-component'),
		],
	],

	'newsletter_subscribe_container_type' => [
		'type' => 'ct-radio',
		'label' => __('Container Style', 'noorgfx-component'),
		'value' => 'default',
		'view' => 'radio',
		'inline' => true,
		'divider' => 'top:full',
		'disableRevertButton' => true,
		'choices' => [
			'default' => __('Default', 'noorgfx-component'),
			'boxed' => __('Boxed', 'noorgfx-component'),
		],
	],

	'newsletter_subscribe_height' => [
		'label' => __( 'Input Height', 'noorgfx-component' ),
		'type' => 'ct-slider',
		'min' => 40,
		'max' => 80,
		'value' => '',
		'responsive' => false,
		'divider' => 'top:full',
		'setting' => [ 'transport' => 'postMessage' ],
	],

	'newsletter_subscribe_gap' => [
		'label' => __( 'Fields Gap', 'noorgfx-component' ),
		'type' => 'ct-slider',
		'min' => 0,
		'max' => 50,
		'value' => '',
		'responsive' => false,
		'setting' => [ 'transport' => 'postMessage' ],
	],

	'has_newsletter_subscribe_name' => [
		'type' => 'ct-switch',
		'label' => __('Name Field', 'noorgfx-component'),
		'value' => 'no',
		'divider' => 'top:full',
		'disableRevertButton' => true,
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['has_newsletter_subscribe_name' => 'yes'],
		'options' => [
			'newsletter_subscribe_name_label' => [
				'type' => 'hidden',
				'label' => __('Name Label', 'noorgfx-component'),
				'value' => __('Your name', 'noorgfx-component'),
			],

			'newsletter_subscribe_name_required' => [
				'type' => 'ct-switch',
				'label' => __('Make Name Field Required', 'noorgfx-component'),
				'value' => 'no',
				'disableRevertButton' => true,
			],
		],
	],

	'newsletter_subscribe_mail_label' => [
		'type' => 'hidden',
		'label' => __('Mail Label', 'noorgfx-component'),
		'value' => __('Your email *', 'noorgfx-component'),
	],

	'newsletter_subscribe_button_text' => [
		'type' => 'hidden',
		'label' => __('Button Label', 'noorgfx-component'),
		'value' => __('Subscribe', 'noorgfx-component'),
	],
];
