<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Widget_Base;
use WP_Query;

if ( ! defined( 'ABSPATH' ) ) {exit;} 
class Woo_Product_Grid extends Widget_Base {
	public function get_name() {
		return 'nour-woo-product-grid';
	}
	public function get_title() {
		return __( 'شبکه محصولات', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-post-grid nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'woo', 'product', 'grid', 'blog', 'posts', 'query' );
	}
	public function get_style_depends() {

		return array( 'cubeportfolio', 'animate' );
	}
	public function get_script_depends() {
		return array( 'cubeportfolio', 'wc-add-to-cart-variation' );
	}
	protected function register_controls() {
		$post_types['product']        = __( 'محصول', 'nour-elementor-addons' );
		$post_types['by_id']          = __( 'انتخاب دستی', 'nour-elementor-addons' );
		$post_types['source_dynamic'] = __( 'پویا', 'nour-elementor-addons' );

		$taxonomies = get_taxonomies( array(), 'objects' );

		$this->start_controls_section(
			'section_general',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
			)
		);
		if ( ! class_exists( '\WooCommerce' ) ) {
			$this->add_control(
				'woo_missing_notice',
				array(
					'type'            => Controls_Manager::RAW_HTML,
					'raw'             => sprintf(
						__( 'به نظر می رسد %1$s در سایت شما وجود ندارد. لطفاً روی پیوند زیر کلیک کنید و %1$s را نصب/فعال کنید. مطمئن شوید که این صفحه را پس از نصب یا فعال سازی به روز کنید.', 'nour-elementor-addons' ),
						'<a href="' . esc_url( admin_url( 'plugin-install.php?s=woocommerce&tab=search&type=term' ) )
						. '" target="_blank" rel="noopener">افزونه ووکامرس</a>'
					),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-danger',
				)
			);

			$this->add_control(
				'woo_install',
				array(
					'type' => Controls_Manager::RAW_HTML,
					'raw'  => '<a href="' . esc_url( admin_url( 'plugin-install.php?s=woocommerce&tab=search&type=term' ) ) . '" target="_blank" rel="noopener">برای نصب ووکامرس اینجا کلیک کنید</a>',
				)
			);
			$this->end_controls_section();

			return;
		}

		$this->add_control(
			'layout',
			array(
				'label'   => __( 'طرح', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'1'  => __( 'طرح 1', 'nour-elementor-addons' ),
					'2'  => __( 'طرح 2', 'nour-elementor-addons' ),
					'3'  => __( 'طرح 3', 'nour-elementor-addons' ),
					'4'  => __( 'طرح 4', 'nour-elementor-addons' ),
					'5'  => __( 'طرح 5', 'nour-elementor-addons' ),
					'6'  => __( 'طرح 6', 'nour-elementor-addons' ),
					'7'  => __( 'طرح 7', 'nour-elementor-addons' ),
					'8'  => __( 'طرح 8', 'nour-elementor-addons' ),
					'9'  => __( 'طرح 9', 'nour-elementor-addons' ),
					'10' => __( 'طرح 10', 'nour-elementor-addons' ),
				),
			)
		);

		$this->add_responsive_control(
			'column_grid',
			array(
				'label'              => __( 'ستون ها', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'desktop_default'    => '3',
				'tablet_default'     => '2',
				'mobile_default'     => '1',
				'options'            => array(
					'1' => __( '1', 'nour-elementor-addons' ),
					'2' => __( '2', 'nour-elementor-addons' ),
					'3' => __( '3', 'nour-elementor-addons' ),
					'4' => __( '4', 'nour-elementor-addons' ),
					'5' => __( '5', 'nour-elementor-addons' ),
					'6' => __( '6', 'nour-elementor-addons' ),
				),
				'render_type'        => 'template',
				'frontend_available' => true,
			)
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'    => 'thumbnail',
				'exclude' => array( 'custom' ),
				'default' => 'medium',
			)
		);
		$this->add_control(
			'show_category',
			array(
				'label'        => __( 'نمایش دسته', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'separator'    => 'before',
			)
		);
		$this->add_control(
			'show_title',
			array(
				'label'        => __( 'عنوان', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);
		$this->add_control(
			'show_content',
			array(
				'label'        => __( 'توضیحات', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'no',
			)
		);
		$this->add_control(
			'content_length',
			array(
				'label'     => __( 'محدودیت توضیحات', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::NUMBER,
				'min'       => 0,
				'max'       => 500,
				'step'      => 5,
				'default'   => 10,
				'condition' => array(
					'show_content' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_rating',
			array(
				'label'        => __( 'امتیازات', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);
		$this->add_control(
			'show_price',
			array(
				'label'        => __( 'قیمت', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);
		$this->add_control(
			'show_qv_action',
			array(
				'label'        => __( 'دکمه ها', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);
		$this->add_control(
			'show_qv_icon',
			array(
				'label'        => __( 'دکمه نمایش سریع', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'show_qv_action' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_cart_icon',
			array(
				'label'        => __( 'سبد خرید', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'show_qv_action' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_cta',
			array(
				'label'        => __( 'سبد خرید مجزا', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'no',
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_query',
			array(
				'label' => __( 'پرس و جو', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'post_type',
			array(
				'label'   => __( 'منبع', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => $post_types,
				'default' => key( $post_types ),
			)
		);

		$this->add_control(
			'posts_ids',
			array(
				'label'       => __( 'جستجو و انتخاب', 'nour-elementor-addons' ),
				'type'        => 'nour-select',
				'options'     => nour_elementor_get_query_post_list(),
				'label_block' => true,
				'multiple'    => true,
				'source_name' => 'post_type',
				'source_type' => 'any',
				'condition'   => array(
					'post_type' => 'by_id',
				),
			)
		);

		$this->add_control(
			'authors',
			array(
				'label'       => __( 'نویسنده', 'nour-elementor-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'default'     => array(),
				'options'     => nour_elementor_get_authors_list(),
				'condition'   => array(
					'post_type!' => array( 'by_id', 'source_dynamic' ),
				),
			)
		);

		$this->add_control(
			'terms',
			array(
				'label'     => __( 'شروط', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->get_taxonomies(),
				'default'   => '',
				'condition' => array(
					'post_type' => array( 'source_dynamic' ),
				),
			)
		);

		foreach ( $taxonomies as $taxonomy => $object ) {
			if ( ! isset( $object->object_type[0] ) || ! in_array( $object->object_type[0], array_keys( $post_types ), true ) ) {
				continue;
			}

			$this->add_control(
				$taxonomy . '_ids',
				array(
					'label'       => $object->label,
					'type'        => 'nour-select',
					'label_block' => true,
					'multiple'    => true,
					'source_name' => 'taxonomy',
					'source_type' => $taxonomy,
					'condition'   => array(
						'post_type' => $object->object_type,
					),
				)
			);
		}

		$this->add_control(
			'post__not_in',
			array(
				'label'       => __( 'مستثنی کردن', 'nour-elementor-addons' ),
				'type'        => 'nour-select',
				'label_block' => true,
				'multiple'    => true,
				'source_name' => 'post_type',
				'source_type' => 'any',
				'condition'   => array(
					'post_type!' => array( 'by_id', 'source_dynamic' ),
				),
			)
		);

		$this->add_control(
			'posts_per_page',
			array(
				'label'     => __( 'تعداد در برگه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 3,
				'condition' => array(
					'post_type!' => array( 'source_dynamic' ),
				),
			)
		);

		$this->add_control(
			'offset',
			array(
				'label'     => __( 'فاصله گذاری', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::NUMBER,
				'condition' => array(
					'orderby!'         => 'rand',
					'show_pagination!' => 'yes',
				),
			)
		);

		$this->add_control(
			'filter_by',
			array(
				'label'     => __( 'فیلتر کردن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '',
				'options'   => array(
					''             => __( 'هیچ', 'nour-elementor-addons' ),
					'featured'     => __( 'ویژه', 'nour-elementor-addons' ),
					'sale'         => __( 'فروش', 'nour-elementor-addons' ),
					'top_rated'    => __( 'محبوبیت', 'nour-elementor-addons' ),
					'best_selling' => __( 'پرفروسترین', 'nour-elementor-addons' ),
				),
				'condition' => array(
					'post_type!' => array( 'by_id', 'source_dynamic' ),
				),
			)
		);

		$this->add_control(
			'orderby',
			array(
				'label'   => __( 'مرتب سازی', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => nour_elementor_get_post_orderby_options(),
				'default' => 'date',

			)
		);

		$this->add_control(
			'order',
			array(
				'label'   => __( 'مرتب سازی', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'asc'  => 'نزولی',
					'desc' => 'سعودی',
				),
				'default' => 'desc',

			)
		);

		$this->add_control(
			'post_only_image',
			array(
				'label'        => __( 'اندازه تصویر', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'qv_section',
			array(
				'label'     => __( 'نمایش سریع', 'nour-elementor-addons' ),
				'condition' => array(
					'show_qv_action' => 'yes',
					'show_qv_icon'   => 'yes',
				),
			)
		);

		$this->add_control(
			'qv_layout',
			array(
				'label'     => __( 'طرح', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '1',
				'options'   => array(
					'1' => __( 'طرح 1', 'nour-elementor-addons' ),
					'2' => __( 'طرح 2', 'nour-elementor-addons' ),
					'3' => __( 'طرح 3', 'nour-elementor-addons' ),
					'4' => __( 'طرح 4', 'nour-elementor-addons' ),
				),
				'condition' => array(
					'show_qv_action' => 'yes',
				),
			)
		);

		$this->add_control(
			'qv_animation',
			array(
				'label'              => esc_html__( 'Animation', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::ANIMATION,
				'render_type'        => 'template',
				'frontend_available' => true,
				'default'            => 'fadeInUp',
				'condition'          => array(
					'show_qv_action' => 'yes',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'badges_section',
			array(
				'label' => __( 'برچسب', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'show_badges',
			array(
				'label'        => __( 'نمایش برچسب ها', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);
		$this->add_responsive_control(
			'woo_badges_style',
			array(
				'label'                => __( 'سبک', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::SELECT,
				'options'              => array(
					'square' => __( 'مربعی', 'nour-elementor-addons' ),
					'circle' => __( 'دایره', 'nour-elementor-addons' ),
				),
				'default'              => 'square',
				'condition'            => array(
					'show_badges' => 'yes',
				),

				'selectors_dictionary' => array(
					'circle' => '    width: 50px;height: 50px;display: flex;justify-content: center;align-items: center; border-radius: 100%',
				),

				'selectors'            => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-sale-flash-btn, 
					{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-featured-flash-btn
					' => '{{VALUE}};',
				),

			)
		);
		$this->add_responsive_control(
			'badges_direction',
			array(
				'label'                => __( 'جهت', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::SELECT,
				'options'              => array(
					'column' => __( 'ستون', 'nour-elementor-addons' ),
					'row'    => __( 'ردیف', 'nour-elementor-addons' ),
				),
				'default'              => 'column',
				'condition'            => array(
					'show_badges' => 'yes',
				),

				'selectors_dictionary' => array(
					'row' => 'display: flex; flex-direction: row; justify-content: stretch; align-items: baseline;',
				),

				'selectors'            => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-product-grid-badges-innner-wrapper' => '{{VALUE}};',
				),

			)
		);
		$this->add_responsive_control(
			'sale_badge_type',
			array(
				'label'     => __( 'نوع برچسب فروش', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					'text'       => __( 'متن', 'nour-elementor-addons' ),
					'percentage' => __( 'درصد', 'nour-elementor-addons' ),
				),
				'default'   => 'text',
				'condition' => array(
					'show_badges' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_sale_badge',
			array(
				'label'        => __( 'نمایش برچسب فروش', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'separator'    => 'before',
				'condition'    => array(
					'show_badges' => 'yes',
				),
			)
		);
		$this->add_control(
			'show_featured_badge',
			array(
				'label'        => __( 'نمایش برچسب ویژه', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => array(
					'show_badges' => 'yes',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_pagination',
			array(
				'label' => __( 'صفحه بندی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'show_pagination',
			array(
				'label'        => __( 'نمایش صفحه بندی', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'prev_label',
			array(
				'label'     => __( 'برچسب قبلی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'قبلی', 'nour-elementor-addons' ),
				'dynamic'   => array(
					'active' => true,
				),
				'condition' => array(
					'show_pagination' => 'yes',
				),
			)
		);

		$this->add_control(
			'next_label',
			array(
				'label'     => __( 'برچسب بعدی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'بعدی', 'nour-elementor-addons' ),
				'dynamic'   => array(
					'active' => true,
				),
				'condition' => array(
					'show_pagination' => 'yes',
				),
			)
		);

		$this->add_control(
			'arrow',
			array(
				'label'     => __( 'نوع پیکان ها', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					'fas fa-arrow-left'          => __( 'پیکان', 'nour-elementor-addons' ),
					'fas fa-angle-left'          => __( 'زاویه', 'nour-elementor-addons' ),
					'fas fa-angle-double-left'   => __( 'پیکان دوتایی', 'nour-elementor-addons' ),
					'fas fa-chevron-left'        => __( 'زاویه دایره', 'nour-elementor-addons' ),
					'fas fa-chevron-circle-left' => __( 'زاویه دایره زمینه دار', 'nour-elementor-addons' ),
					'fas fa-caret-left'          => __( 'کارت', 'nour-elementor-addons' ),
					'xi xi-long-arrow-left'      => __( 'پیکان بلند', 'nour-elementor-addons' ),
					'fas fa-arrow-circle-left'   => __( 'دایره پیکان', 'nour-elementor-addons' ),
				),
				'default'   => 'fas fa-arrow-left',
				'condition' => array(
					'show_pagination' => 'yes',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_general_style',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'image_height',
			array(
				'label'              => __( 'ارتفاع تصویر', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px', 'vh', '%' ),
				'range'              => array(
					'px' => array(
						'min' => 10,
						'max' => 1200,
					),
					'vh' => array(
						'min' => 0,
						'max' => 100,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
				'selectors'          => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-img' => 'height: {{SIZE}}{{UNIT}}; min-height: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_responsive_control(
			'object-fit',
			array(
				'label'     => __( 'تنظیم اندازه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'condition' => array(
					'image_height[size]!' => '',
				),
				'options'   => array(
					''        => __( 'پیشفرض', 'nour-elementor-addons' ),
					'fill'    => __( 'پرکردن', 'nour-elementor-addons' ),
					'cover'   => __( 'پوشش', 'nour-elementor-addons' ),
					'contain' => __( 'اصلی', 'nour-elementor-addons' ),
				),
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-img' => 'object-fit: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'space_between',
			array(
				'label'              => __( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px' ),
				'default'            => array(
					'size' => 15,
				),
				'tablet_default'     => array(
					'size' => 15,
				),
				'mobile_default'     => array(
					'size' => 15,
				),
				'range'              => array(
					'px' => array(
						'min' => 0,
						'max' => 500,
					),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'item_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-item',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'item_box_shadow',
				'label'    => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-item',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'item_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-item',
			)
		);

		$this->add_responsive_control(
			'item_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-item' => 'overflow:hidden; border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'item_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs(
			'overlay_style_tabs'
		);

		$this->start_controls_tab(
			'overlay_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'overlay_color',
			array(
				'label'     => __( 'رنگ پوشش', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-img-section::after' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'overlay_hover_tab_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'overlay_hover_color',
			array(
				'label'     => __( 'رنگ پوشش', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-img:hover .nour-woo-product-img-section::after' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
		$this->start_controls_section(
			'section_content_style',
			array(
				'label' => __( 'محتوا', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'alignment',
			array(
				'label'                => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::CHOOSE,
				'options'              => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'prefix_class'         => 'nour-product-grid-align%s-',

				'selectors_dictionary' => array(
					'left'   => 'justify-content: left; align-items: center; text-align:left;',
					'center' => 'justify-content: center; align-items: center; text-align:center;',
					'right'  => 'justify-content: right; align-items: center; text-align:right',
				),

				'selectors'            => array(
					'{{WRAPPER}} .nour-woo-product-grid-content-sec, {{WRAPPER}} .nour-woo-product-grid-star-rating-wrapper' => '{{VALUE}};',
				),

			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'      => 'content_background',
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'types'     => array( 'classic', 'gradient' ),
				'exclude'   => array( 'image' ),
				'selector'  => '{{WRAPPER}} .nour-woo-product-grid-content-sec',
				'condition' => array(
					'layout!' => array( '5' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'      => 'content_box_shadow',
				'label'     => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-content-sec',
				'condition' => array(
					'layout!' => array( '5' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'content_border',
				'selector'  => '{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-content-sec',
				'condition' => array(
					'layout!' => array( '5' ),
				),
			)
		);

		$this->add_responsive_control(
			'content_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-content-sec' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout!' => array( '5' ),
				),
			)
		);

		$this->add_responsive_control(
			'content_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-content-sec' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'content_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-content-sec' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		// ---
		$this->add_control(
			'category_title',
			array(
				'label'     => __( 'دسته بندی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'show_category' => array( 'yes' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'category_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-product-grid-wrapper .nour_elementor_category_term_name',
				'condition' => array(
					'show_category' => array( 'yes' ),
				),
			)
		);

		$this->add_control(
			'category_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour_elementor_category_term_name' => 'color: {{VALUE}}',
					'{{WRAPPER}} .nour-woo-product-grid-category-wrapper::before'               => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'show_category' => array( 'yes' ),
				),
			)
		);

		$this->add_control(
			'category_hover_color',
			array(
				'label'     => __( 'رنگ شناور', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour_elementor_category_term_name:hover'                                                 => 'color: {{VALUE}}',
					'{{WRAPPER}} .nour-product-grid-wrapper .nour_elementor_category_term_name:hover .nour-woo-product-grid-category-wrapper::before' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'show_category' => array( 'yes' ),
				),
			)
		);

		$this->add_responsive_control(
			'category_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-category-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'show_category' => array( 'yes' ),
				),
			)
		);

		$this->add_control(
			'heading_title',
			array(
				'label'     => __( 'عنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'show_title' => array( 'yes' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'title_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-title',
				'condition' => array(
					'show_title' => array( 'yes' ),
				),
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-title' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'show_title' => array( 'yes' ),
				),
			)
		);

		$this->add_control(
			'title_hover_color',
			array(
				'label'     => __( 'رنگ شناور', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-title:hover' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'show_title' => array( 'yes' ),
				),
			)
		);

		$this->add_responsive_control(
			'title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'show_title' => array( 'yes' ),
				),
			)
		);

		$this->add_control(
			'desc_excerpt',
			array(
				'label'     => __( 'توضیحات', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'show_content' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'description_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-excerpt',
				'condition' => array(
					'show_content' => 'yes',
				),
			)
		);

		$this->add_control(
			'excerpt_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-excerpt' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'show_content' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'excerpt_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'show_content' => 'yes',
				),
			)
		);
		// ---
		$this->add_control(
			'rating_title',
			array(
				'label'     => __( 'امتیازات', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'show_rating' => 'yes',
				),
			)
		);
		$this->add_responsive_control(
			'rating_size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 100,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-star-rating-wrapper .star-rating' => 'font-size: {{SIZE}}{{UNIT}}',
				),
				'condition'  => array(
					'show_rating' => 'yes',
				),
			)
		);

		$this->add_control(
			'rating_front_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .star-rating span::before' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'rating_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .star-rating::before' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'show_rating' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'rating_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-star-rating-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'show_rating' => 'yes',
				),
			)
		);

		$this->add_control(
			'price_title',
			array(
				'label'     => __( 'قیمت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'show_price' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'price_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-woo-product-grid-price-wrapper .price',
				'condition' => array(
					'show_price' => 'yes',
				),
			)
		);

		$this->add_control(
			'price_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-woo-product-grid-price-wrapper .price' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'show_price' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'space_between_price',
			array(
				'label'      => __( 'فاصله قیمت و فروش', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-price-wrapper ins' => 'padding-left: {{SIZE}}{{UNIT}}',
				),
				'condition'  => array(
					'show_price' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'sale_typography',
				'label'     => __( 'تایپوگرافی فروش', 'nour-elementor-addons' ),
				'separator' => 'before',
				'selector'  => '{{WRAPPER}} .nour-woo-product-grid-price-wrapper del .woocommerce-Price-amount',
				'condition' => array(
					'show_price' => 'yes',
				),
			)
		);

		$this->add_control(
			'sale_price_color',
			array(
				'label'     => __( 'رنگ فروش', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-woo-product-grid-price-wrapper del, {{WRAPPER}} .nour-woo-product-grid-price-wrapper del .woocommerce-Price-amount' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'show_price' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'price_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-wrapper .nour-woo-product-grid-price-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'show_price' => 'yes',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'qv_action_style',
			array(
				'label'     => __( 'دکمه ها', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_qv_action' => 'yes',
				),
			)
		);
		$this->add_responsive_control(
			'icons_size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-cta-btn i,
					{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-qv-cart-btn .button::before' => 'font-size: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_control(
			'icons_bg_size',
			array(
				'label'      => esc_html__( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 500,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-hv-qv-btn.nour-cta-btn,
					 {{WRAPPER}} .nour-hv-cart-btn.nour-cta-btn' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'icons_space_between',
			array(
				'label'      => esc_html__( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 500,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-hv-cta-section' => 'grid-gap: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs(
			'actions_style_tabs'
		);

		$this->start_controls_tab(
			'actions_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'qv_icons_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-cta-btn i,
					{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-qv-cart-btn .button::before
					' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'qv_icons_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-cta-btn',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'actions_hover_tab_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'qv_icons_hcolor',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-cta-btn:hover i,
					{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-qv-cart-btn:hover .button::before
					' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'qv_icons_hbackground',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-cta-btn:hover',
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'qv_icons_btns_border',
				'selector' => '{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-cta-btn',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'qv_icons_btns_shadow',
				'label'    => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-cta-btn',
			)
		);

		$this->add_responsive_control(
			'qv_icons_btn_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-cta-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'qv_icons_btn_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-product-grid-hv-cta-section .nour-cta-btn' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'qv_style',
			array(
				'label'     => __( 'محتوای پاپ آپ', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_qv_action' => 'yes',
					'show_qv_icon'   => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'qv_main_content_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .nour-qv-popup-inner',
			)
		);
		$this->add_control(
			'qv_overlay_color',
			array(
				'label'     => __( 'رنگ پوشش', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-qv-popup-overlay' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'qv_main_content_border',
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .nour-qv-popup-inner',
			)
		);

		$this->add_responsive_control(
			'qv_main_content_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-qv-popup-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_main_content_padding',
			array(
				'label'      => __( 'فاصله محتوا', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-content-sec' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_main_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-qv-popup-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'qv_sku_title',
			array(
				'label'     => __( 'شناسه SKU', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'qv_meta_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .sku_wrapper',
			)
		);

		$this->add_control(
			'qv_sku_color',
			array(
				'label'     => __( 'رنگ سرفصل', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .sku_wrapper' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'qv_sku_title_color',
			array(
				'label'     => __( 'رنگ عنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .sku_wrapper .sku' => 'color: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'qv_tax_title',
			array(
				'label'     => __( 'طبقه بندی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'qv_tax_typography',
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .product_meta .posted_in',
			)
		);

		$this->add_control(
			'qv_tax_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .product_meta .posted_in' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'qv_tax_link_color',
			array(
				'label'     => __( 'رنگ پیوند', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .product_meta .posted_in a' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'qv_tax_link_hv_color',
			array(
				'label'     => __( 'پیوند شناور', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .product_meta .posted_in a:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'qv_tax_seprator_color',
			array(
				'label'     => __( 'رنگ جداکننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-content-sec .sku_wrapper' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_seprator_size',
			array(
				'label'      => __( 'اندازه جداکننده', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'vh', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 20,
					),
					'vh' => array(
						'min' => 0,
						'max' => 20,
					),
					'%'  => array(
						'min' => 0,
						'max' => 20,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-content-sec .sku_wrapper' => 'border-width: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'qv_sku_background',
				'label'    => esc_html__( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .product_meta',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'qv_meta_border',
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .product_meta',
			)
		);

		$this->add_responsive_control(
			'qv_meta_link_padding',
			array(
				'label'      => __( 'فاصله داخلی پیوند', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .product_meta .posted_in a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_meta_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .product_meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_meta_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .product_meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'qv_heading_title',
			array(
				'label'     => __( 'عنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'qv_title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .product_title',
			)
		);

		$this->add_control(
			'qv_title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .product_title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'qv_title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .product_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'qv_desc_style',
			array(
				'label'     => __( 'توضیحات', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'qv_description_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .woocommerce-product-details__short-description',
			)
		);

		$this->add_control(
			'qv_desc_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .woocommerce-product-details__short-description' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'qv_desc_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .woocommerce-product-details__short-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_desc_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .woocommerce-product-details__short-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		// ---
		$this->add_control(
			'qv_rating_title',
			array(
				'label'     => __( 'امتیازات', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'qv_rating_txt_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .woocommerce-review-link' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'qv_rating_txt_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .woocommerce-review-link',
			)
		);
		$this->add_responsive_control(
			'qv_rating_size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 100,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .star-rating' => 'font-size: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_control(
			'qv_rating_front_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .star-rating span::before' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'qv_rating_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .star-rating::before' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'qv_rating_txt_margin',
			array(
				'label'      => __( 'فاصله متن', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .woocommerce-review-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_rating_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .woocommerce-product-rating' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_control(
			'qv_price_title',
			array(
				'label'     => __( 'قیمت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'qv_price_typography',
				'label'    => __( 'تایپوگرافی قیمت', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .price',
			)
		);

		$this->add_control(
			'qv_price_color',
			array(
				'label'     => __( 'رنگ قیمت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .price' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_space_between_price',
			array(
				'label'      => __( 'فاصله فروش و قیمت', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .price ins' => 'padding-left: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'qv_sale_typography',
				'label'     => __( 'تایپوگرافی فروش', 'nour-elementor-addons' ),
				'separator' => 'before',
				'selector'  => '{{WRAPPER}} .nour-qv-main-wrapper .price del .woocommerce-Price-amount',
			)
		);

		$this->add_control(
			'qv_sale_price_color',
			array(
				'label'     => __( 'رنگ فروش', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .price del .woocommerce-Price-amount' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_price_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'qv_section_button_style',
			array(
				'label'     => __( 'دکمه های پاپ آپ', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_qv_action' => 'yes',
					'show_qv_icon'   => 'yes',
				),
			)
		);

		$this->add_control(
			'qv_close_title',
			array(
				'label'     => __( 'دکمه بستن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_responsive_control(
			'qv_close_icon_size',
			array(
				'label'      => __( 'اندازه نماد', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'vh', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 50,
					),
					'vh' => array(
						'min' => 0,
						'max' => 50,
					),
					'%'  => array(
						'min' => 0,
						'max' => 50,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-cross i' => 'font-size: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_control(
			'qv_close_icon_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-cross i' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'qv_close_icon_hv_color',
			array(
				'label'     => __( 'رنگ شناور نماد', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-cross i:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'qv_close_icon_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-cross',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'qv_close_icon_border',
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-cross',
			)
		);

		$this->add_responsive_control(
			'qv_close_icon_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-cross' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_close_icon_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-cross' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_close_icon_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .nour-woo-qv-cross' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'qv_quantity_btn_input_heading',
			array(
				'label'     => __( 'ورودی تعداد', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'qv_quantity_btn_input_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-popup-wrapper input[type="number"]' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'qv_quantity_btn_input_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-woo-qv-content-sec .quantity'          => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .nour-qv-popup-wrapper input[type="number"]' => 'background-color: transparent',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'qv_quantity_btn_input_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-woo-qv-content-sec .quantity',
			)
		);

		$this->add_control(
			'qv_quantity_btn_input_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-qv-content-sec .quantity' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'qv_btn_heading',
			array(
				'label'     => __( 'دکمه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'qv_button_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button',
			)
		);

		$this->start_controls_tabs(
			'qv_button_style_tabs'
		);

		$this->start_controls_tab(
			'qv_button_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'qv_button_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'qv_button_bg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'qv_button_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'qv_button_hover_tab_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'qv_button_hcolor',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button:hover,{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button:focus' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'qv_button_hbg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button:hover,{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button:focus',
			)
		);

		$this->add_control(
			'qv_button_hborder',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button:hover,{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button:focus' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'qv_button_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_button_item_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'qv_button_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-qv-main-wrapper .single_add_to_cart_button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'variations_styles',
			array(
				'label' => esc_html__( 'پاپ آپ تنوع', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->start_controls_tabs( 'variation_tabs' );

		$this->start_controls_tab(
			'variation_label_tab',
			array(
				'label' => esc_html__( 'برچسب', 'nour-elementor-addons' ),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'variation_label_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .variations label, {{WRAPPER}} .variations select',
			)
		);

		$this->add_control(
			'variation_label_color',
			array(
				'label'     => esc_html__( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'selectors' => array(
					'{{WRAPPER}} .variations label,{{WRAPPER}} .variations select' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'variation_inline_label_space_between',
			array(
				'label'      => esc_html__( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 10,
				),
				'selectors'  => array(
					'{{WRAPPER}} .variations td.value .nour_swatches'         => 'grid-gap: {{SIZE}}{{UNIT}}; display: flex; flex-wrap: wrap',
					'{{WRAPPER}} .variations td.value .nour_swatches .swatch' => 'margin-right: 0;',
				),
			)
		);

		$this->add_control(
			'variation_label_display_style',
			array(
				'label'                => esc_html__( 'سبک نمایش', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::CHOOSE,
				'default'              => 'row',
				'options'              => array(
					'row'    => array(
						'title' => __( 'خطی', 'nour-elementor-addons' ),
						'icon'  => 'eicon-editor-list-ul',
					),
					'column' => array(
						'title' => __( 'بلوکی', 'nour-elementor-addons' ),
						'icon'  => 'eicon-ellipsis-h',
					),
				),
				'selectors_dictionary' => array(
					'row'    => 'flex-direction: row; display:flex; align-items: center',
					'column' => 'flex-direction: column;display:flex;',
				),
				'selectors'            => array(
					'{{WRAPPER}} .variations tr' => '{{VALUE}}',
				),
			)
		);

		$this->add_control(
			'variation_inline_label_width',
			array(
				'label'      => esc_html__( 'اندازه برچسب', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 200,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .variations th.label' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .variations td.value' => 'width: 100%;',
				),
				'condition'  => array(
					'variation_label_display_style' => 'row',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'variation_description_tab',
			array(
				'label'     => esc_html__( 'توضیحات', 'nour-elementor-addons' ),
				'condition' => array(
					'show_variation_description' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'variation_description_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .woocommerce-variation-description',
				'exclude'  => array( 'font_family', 'font_style', 'text_decoration' ),
			)
		);

		$this->add_control(
			'variation_description_color',
			array(
				'label'     => esc_html__( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'default'   => '#666666',
				'selectors' => array(
					'{{WRAPPER}} .woocommerce-variation-description p' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'variation_description_margin',
			array(
				'label'      => esc_html__( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .woocommerce-variation-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'variation_price_tab',
			array(
				'label' => esc_html__( 'قیمت', 'nour-elementor-addons' ),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'variation_price_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} :is(.price, .price del, .price ins )',
				'exclude'  => array( 'text_transform' ),
			)
		);

		$this->add_control(
			'variation_price_color',
			array(
				'label'     => esc_html__( 'رنگ قیمت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} :is(.price, .price del, .price ins )' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'variation_sale_price_color',
			array(
				'label'     => esc_html__( 'رنگ قیمت فروش', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .price ins .amount' => 'background: transparent; color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'variation_price_discount_badge_color',
			array(
				'label'     => esc_html__( 'رنگ برچسب تخفیف', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'default'   => '#FFFFFF',
				'selectors' => array(
					'{{WRAPPER}} .nour-badge' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'variation_price_discount_badge_bg_color',
			array(
				'label'     => esc_html__( 'زمینه برچسب تخفیف', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'selectors' => array(
					'{{WRAPPER}} .nour-badge' => 'background: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'variation_price_discount_badge_font_size',
			array(
				'label'      => esc_html__( 'اندازه فونت', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-badge' => 'font-size: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'variation_price_margin',
			array(
				'label'      => esc_html__( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .woocommerce-variation-price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; display: block;',
				),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_control(
			'variation_dropdown',
			array(
				'label'     => esc_html__( 'کشویی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'variation_dropdown_color',
			array(
				'label'     => esc_html__( 'رنگ کشویی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .variations select' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'variation_dropdown_border',
				'label'    => esc_html__( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .variations select',
			)
		);

		$this->add_control(
			'variation_dropdown_border_radius',
			array(
				'label'      => esc_html__( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .variations select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'variation_dropdown_border_border!' => '',
				),
			)
		);

		$this->add_responsive_control(
			'variation_item_margin',
			array(
				'label'      => esc_html__( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .variations tr' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'separator'  => 'before',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'variation_swatches_styles',
			array(
				'label' => esc_html__( 'پاپ تنوع رنگی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->start_controls_tabs( 'variation_swatch_tabs' );

		$this->start_controls_tab(
			'variation_swatch_color_tab',
			array(
				'label' => esc_html__( 'رنگ', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'variation_swatch_color_width',
			array(
				'label'      => esc_html__( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 150,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour_swatches .swatch.swatch_color' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'variation_swatch_color_height',
			array(
				'label'      => esc_html__( 'ارتفاع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 150,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour_swatches .swatch.swatch_color' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'variation_swatch_color_border_radius',
			array(
				'label'      => esc_html__( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour_swatches .swatch_color' => 'border-radius: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'variation_swatch_color_label_border',
				'label'     => esc_html__( 'لبه', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour_swatches .swatch_color',
				'separator' => 'before',
			)
		);

		$this->add_control(
			'variation_swatch_color_selected_label_border',
			array(
				'label'     => esc_html__( 'لبه انتخاب شده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour_swatches .swatch_color.selected' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'variation_swatch_image_tab',
			array(
				'label' => esc_html__( 'تصویر', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'variation_swatch_image_width',
			array(
				'label'      => esc_html__( 'عرض تنوع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 150,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour_swatches .swatch.swatch_image' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'variation_swatch_image_height',
			array(
				'label'      => esc_html__( 'ارتفاع تنوع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 150,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour_swatches .swatch.swatch_image' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'variation_swatch_image_border_radius',
			array(
				'label'      => esc_html__( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour_swatches .swatch_image' => 'border-radius: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'variation_swatch_image_label_border',
				'label'     => esc_html__( 'لبه', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour_swatches .swatch_image',
				'separator' => 'before',
			)
		);

		$this->add_control(
			'variation_swatch_image_selected_label_border',
			array(
				'label'     => esc_html__( 'لبه انتخاب شده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour_swatches .swatch_image.selected' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'variation_swatch_label_tab',
			array(
				'label' => esc_html__( 'برچسب', 'nour-elementor-addons' ),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'variation_swatch_label_typography',
				'label'    => esc_html__( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour_swatches .swatch_label',
			)
		);

		$this->add_control(
			'variation_swatch_label_text_color',
			array(
				'label'     => esc_html__( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour_swatches .swatch_label' => 'color: {{VALUE}} !important;',
				),
			)
		);

		$this->add_control(
			'variation_swatch_label_background_color',
			array(
				'label'     => esc_html__( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour_swatches .swatch_label' => 'background-color: {{VALUE}} !important;',
				),
			)
		);

		$this->add_control(
			'variation_swatch_label_selected_label_border',
			array(
				'label'     => esc_html__( 'لبه انتخاب شده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour_swatches .swatch_label.selected' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'variation_swatch_label_label_border',
				'label'     => esc_html__( 'لبه', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour_swatches .swatch_label',
				'separator' => 'before',
			)
		);

		$this->add_control(
			'variation_swatch_label_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour_swatches .swatch_label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'variation_swatch_label_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour_swatches .swatch_label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'badges_style',
			array(
				'label'     => __( 'برچسب ها', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_badges' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'badges_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-badges-btn',
			)
		);

		$this->add_responsive_control(
			'badges_bg_size',
			array(
				'label'              => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px', 'vh', '%' ),
				'range'              => array(
					'px' => array(
						'min' => 10,
						'max' => 1200,
					),
					'vh' => array(
						'min' => 0,
						'max' => 100,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
				'selectors'          => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-sale-flash-btn, {{WRAPPER}} .nour-woo-product-grid-item .nour-woo-featured-flash-btn' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}',
				),
				'condition'          => array(
					'woo_badges_style' => 'circle',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'      => 'badges_btn_shadow',
				'label'     => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'separator' => 'before',
				'selector'  => '{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-badges-btn',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'badges_btn_border',
				'selector' => '{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-badges-btn',
			)
		);

		$this->add_responsive_control(
			'badges_btn_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-badges-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'badges_btn_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-badges-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'badges_btn_margin',
			array(
				'label'      => __( 'فاصله دکمه ها', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-product-grid-badges-wrapper' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'sale_badge_heading',
			array(
				'label'     => __( 'فروش', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'show_sale_badge' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'      => 'sale_btn_background',
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'types'     => array( 'classic', 'gradient' ),
				'exclude'   => array( 'image' ),
				'selector'  => '{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-sale-flash-btn',
				'condition' => array(
					'show_sale_badge' => 'yes',
				),
			)
		);

		$this->add_control(
			'sale_btn_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-sale-flash-btn' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'show_sale_badge' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'sale_btn_margin',
			array(
				'label'      => __( 'فاصله', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-sale-flash-btn' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'show_sale_badge' => 'yes',
				),
			)
		);

		$this->add_control(
			'featured_badge_heading',
			array(
				'label'     => __( 'ویژه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'show_featured_badge' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'      => 'featured_btn_background',
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'types'     => array( 'classic', 'gradient' ),
				'exclude'   => array( 'image' ),
				'selector'  => '{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-featured-flash-btn',
				'condition' => array(
					'show_featured_badge' => 'yes',
				),
			)
		);

		$this->add_control(
			'featured_btn_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-featured-flash-btn' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'show_featured_badge' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'featured_btn_margin',
			array(
				'label'      => __( 'فاصله', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-featured-flash-btn' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'show_featured_badge' => 'yes',
				),
			)
		);

		$this->add_control(
			'out_stock_heading',
			array(
				'label'     => __( 'ناموجود', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'out_stock_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-out-of-stock-btn',
			)
		);

		$this->add_control(
			'out_stock_btn_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-out-of-stock-btn' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'out_stock_margin',
			array(
				'label'      => __( 'فاصله', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-item .nour-woo-out-of-stock-btn' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_style',
			array(
				'label'     => __( 'دکمه', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_cta' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'button_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button',
			)
		);

		$this->start_controls_tabs(
			'button_style_tabs'
		);

		$this->start_controls_tab(
			'button_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'button_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'button_bg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'button_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'button_hover_tab_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'button_hcolor',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button:hover,{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button:focus' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'button_hbg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button:hover,{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button:focus',
			)
		);

		$this->add_control(
			'button_hborder',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button:hover,{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button:focus' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'button_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'button_item_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'button_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-woo-product-grid-add-to-cart-btn .button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_pagination_style',
			array(
				'label'     => __( 'صفحه بندی', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_pagination' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'pagination_alignment',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination' => 'justify-content: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'pagination_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-elementor-post-pagination .page-numbers',
			)
		);

		$this->add_responsive_control(
			'pagination_space_between',
			array(
				'label'      => __( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-elementor-post-pagination' => 'grid-gap: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'pagination_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-elementor-post-pagination .page-numbers',
			)
		);

		$this->add_responsive_control(
			'pagination_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'pagination_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'pagination_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-elementor-post-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs(
			'pagination_style_tabs'
		);

		$this->start_controls_tab(
			'pagination_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'pagination_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'pagination_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'pagination_hover_tab',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'pagination_hover_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers:hover' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'pagination_bg_hover_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers:hover' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'pagination_active_tab',
			array(
				'label' => __( 'فعال', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'pagination_active_color',
			array(
				'label'     => __( 'رنگ متن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers.current' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'pagination_bg_arctive_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-elementor-post-pagination .page-numbers.current' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}
	public static function get_taxonomies() {
		$list     = nour_elementor_get_taxonomies( array( 'public' => true ), 'object', true );
		$list[''] = __( 'None', 'nour-elementor-addons' );
		return $list;
	}
	protected function render() {

		if ( ! class_exists( 'WooCommerce' ) ) {
			return;
		}

		$settings = $this->get_settings_for_display();

		global $product;

		$get_all_product = array(
			'orderby'     => 'date',
			'numberposts' => - 1,
			'order'       => 'ASC',
			'return'      => 'ids',
			'status'      => 'publish',
		);

		$get_all_product_ids = wc_get_products( $get_all_product );

		if ( empty( $product ) && Plugin::$instance->editor->is_edit_mode() && ( empty( $get_all_product_ids ) ) ) {
			?>
			<div class="nour-alert nour-alert-warning" role="alert">
				<span class="nour-alert-title">
					<?php esc_html_e( 'محصولی یافت نشد', 'nour-elementor-addons' ); ?>
				</span>
				<span class="nour-alert-description">
					<?php esc_html_e( 'شما هیچ محصولی ندارید لطفاً ابتدا برخی از محصولات را اضافه کنید. این متن پس از بستن حالت ویرایشگر ناپدید می شود.', 'nour-elementor-addons' ); ?>
				</span>
			</div>
			<?php
			return;
		}

		?>

		<div class="nour-product-grid-wrapper nour-woo-product-grid-layout-<?php echo esc_attr( $settings['layout'] ); ?>">

			<?php

			$args = nour_elementor_get_query_args( $settings );
			$args = nour_elementor_get_dynamic_args( $settings, $args );

			if ( 'source_dynamic' === $settings['post_type'] && ( 'nour-themer' === get_post_type() || 'nour_content' === get_post_type() ) ) {
				$document     = Plugin::instance()->documents->get_doc_or_auto_save( get_the_ID() );
				$dynamic_args = $document->get_document_query_args();
				if ( empty( $dynamic_args ) ) {
					$dynamic_args['post_type']      = 'post';
					$dynamic_args['posts_per_page'] = get_option( 'posts_per_page' );
				}
				$args = array_merge( $args, $dynamic_args );
			}

			$found_posts = 0;
			$paged       = 1;

			if ( 'yes' === $settings['show_pagination'] ) {
				$args['offset'] = '';
				if ( get_query_var( 'paged' ) ) {
					$paged = get_query_var( 'paged' );
				} elseif ( get_query_var( 'page' ) ) {
					$paged = get_query_var( 'page' );
				}
			}

			$args['paged'] = $paged;

			if ( 'sale' === $settings['filter_by'] ) {

				$args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
			} elseif ( 'featured' === $settings['filter_by'] ) {

				$args['tax_query'][] = array(
					'taxonomy' => 'product_visibility',
					'field'    => 'term_taxonomy_id',
					'terms'    => 'featured',
				);
			} elseif ( 'top_rated' === $settings['filter_by'] ) {
				$args['meta_key']   = '_wc_average_rating';
				$args['orderby']    = 'meta_value_num';
				$args['meta_query'] = WC()->query->get_meta_query();
				$args['tax_query']  = WC()->query->get_tax_query();
			} elseif ( 'best_selling' === $settings['filter_by'] ) {
				$args['meta_key'] = 'total_sales';
				$args['order']    = 'DESC';
				$args['orderby']  = 'meta_value_num';
			}

			$query = new WP_Query( $args );

			if ( $query->have_posts() ) {

				$found_posts      = $query->found_posts;
				$max_page         = ceil( $found_posts / absint( $args['posts_per_page'] ) );
				$args['max_page'] = $max_page;
				?>

				<div class="nour-woo-product-grid-main cbp">
					<?php
					while ( $query->have_posts() ) {
						$query->the_post();

						require NOUR_ELEMENTOR_ADDONS_WIDGET . 'woo-product-grid/layout/frontend.php';
					}
					?>
				</div>

				<?php

				if ( $found_posts > $args['posts_per_page'] && 'yes' === $settings['show_pagination'] ) {

					$prev_icon_class = esc_attr($settings['arrow']);
					$next_icon_class = str_replace( 'left', 'right', esc_attr($settings['arrow']) );

					$prev_text = '<i class="' . $prev_icon_class . '"></i><span class="nour-elementor-post-pagination-prev-text">' . esc_attr($settings['prev_label']) . '</span>';
					$next_text = '<span class="nour-elementor-post-pagination-next-text">' . esc_attr($settings['next_label']) . '</span><i class="' . $next_icon_class . '"></i>';

					$paginate_args = array(
						'type'      => 'array',
						'current'   => max( 1, get_query_var( 'paged' ), get_query_var( 'page' ) ),
						'total'     => $query->max_num_pages,
						'prev_next' => true,
						'prev_text' => $prev_text,
						'next_text' => $next_text,
					);

					if ( is_singular() && ! is_front_page() ) {
						global $wp_rewrite;
						if ( $wp_rewrite->using_permalinks() ) {
							$paginate_args['format'] = user_trailingslashit( 'page%#%', 'single_paged' ); // Change Occurs For Fixing Pagination Issue.
						} else {
							$paginate_args['format'] = '?page=%#%';
						}
					}

					$links = paginate_links( $paginate_args );
					?>

					<nav class="nour-elementor-post-pagination" role="navigation" aria-label="<?php esc_attr_e( 'صفحه بندی', 'nour-elementor-addons' ); ?>">
						<?php echo implode( PHP_EOL, $links ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</nav>
					<?php
				}

				wp_reset_postdata();
			} else {
				if ( Plugin::$instance->editor->is_edit_mode() ) {
					?>
					<p class="nour-alert nour-alert-warning">
						<span class="nour-alert-title"><?php echo esc_html( 'محصولی یافت نشد!' ); ?></span>
						<span class="nour-alert-description"><?php echo esc_html( 'متأسفیم، اما هیچ چیزی با انتخاب شما مطابقت نداشت. لطفاً با چند کلمه کلیدی مختلف دوباره امتحان کنید.' ); ?></span>
					</p>
					<?php
				}
			}
			?>
		</div>
		<div class="nour-qv-main-wrapper">
			<div class="nour-qv-inner-wrapper nour-qv-layouts nour-qv-layout-<?php echo esc_attr( $settings['qv_layout'] ); ?>">
				<div class="nour-qv-loader-wrapper nour-qv-preloader-layout">
					<div class="nour-qv-preloader">
						<div class="nour-qv-preloader-box">
							<div class="nour-qv-loader-spinner spinner-1"></div>
							<div class="nour-qv-loader-spinner spinner-2"></div>
							<div class="nour-qv-loader-spinner spinner-3"></div>
						</div>
					</div>
				</div>
				<!-- quick view -->
				<div class="nour-qv-popup-overlay"></div>
				<div class="nour-qv-popup-wrapper">
					<div class="nour-qv-popup-inner animated <?php echo esc_attr( $settings['qv_animation'] ); ?>">
						<div id="nour_elementor_fetch_qv_data" class="nour-fetch-qv-cls"></div>
					</div>
				</div>
			</div>
		</div>
		<?php

	}
}
