<?php
global $post, $product;

$limit   = $settings['content_length'] ? $settings['content_length'] : 15;
$content = explode( ' ', get_the_excerpt(), $limit );

if ( count( $content ) >= $limit ) {
	array_pop( $content );
	$content = implode( ' ', $content ) . '...';
} else {
	$content = implode( ' ', $content );
}
$content = preg_replace( '`[[^]]*]`', '', $content );

$product_id = $post->ID;

if ( isset( $product_id ) && '' !== $product_id ) {

	$product = wc_get_product( $product_id );
	if ( $product ) :
		$product_data = $product->get_data();
		$post         = get_post( $product_id, OBJECT ); 

		setup_postdata( $post );
		do_action( 'nour_elementor_woo_before_product' );
		?>

		<div id="nour-woo-product-grid-id-<?php echo esc_attr( $product_id ); ?>" class="cbp-item nour-woo-product-grid-item">
			<a class="nour-woo-product-grid-title-wrapper" href="<?php echo esc_url( get_permalink( $product_id ) ); ?>">
				<div class="nour-woo-product-grid-img">
					<div class="nour-woo-product-img-section">
						<?php
						$product        = wc_get_product( $product_id );
						$attachment_ids = $product->get_gallery_image_ids();
						if ( is_array( $attachment_ids ) && ! empty( $attachment_ids ) ) {

							$img_url         = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), $settings['thumbnail_size'], true );
							$placeholder_url = WC()->plugin_url() . '/assets/images/placeholder.png';
							if ( has_post_thumbnail( $product_id ) ) {
								$img_src = $img_url[0];
							} else {
								$img_src = $placeholder_url;
							}

							?>
							<img class="nour-woo-product-grid-img nour-gallery-first-img-url" src="<?php echo esc_url( $img_src ); ?>" alt="product-image">
							<?php
							if ( isset( $attachment_ids[0] ) ) {
								$second_image_url = wp_get_attachment_image_src( $attachment_ids[0], $settings['thumbnail_size'], true );
								?>
								<img class="nour-woo-product-grid-img nour-gallery-second-img-url" src="<?php echo esc_url( $second_image_url[0] ); ?>" alt="product-image">
								<?php
							}
						} else {
							$img_url         = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), $settings['thumbnail_size'], true );
							$placeholder_url = WC()->plugin_url() . '/assets/images/placeholder.png';
							if ( has_post_thumbnail( $product_id ) ) {
								$img_src = $img_url[0];
							} else {
								$img_src = $placeholder_url;
							}
							?>
							<img class="nour-woo-product-grid-img nour-product-img-url" src="<?php echo esc_url( $img_src ); ?>" alt="product-image">
							<?php
						}
						if ( 'yes' === $settings['show_badges'] ) {
							?>
							<div class="nour-woo-product-grid-badges-wrapper">
								<div class="nour-woo-product-grid-badges-innner-wrapper">
									<?php
									if ( $product->is_in_stock() ) {
										if ( 'yes' === $settings['show_sale_badge'] ) {
											if ( 'text' === $settings['sale_badge_type'] ) {
												$sale_text = __( 'فروش!', 'nour-elementor-addons' );
											} else {
												if ( 'variable' === $product->get_type() ) {
													$regular_price = $product->get_variation_regular_price();
												} else {
													$regular_price = $product->get_regular_price();
												}

												if ( 'variable' === $product->get_type() ) {
													$sale_price = $product->get_variation_sale_price();
												} else {
													$sale_price = $product->get_sale_price();
												}

												if ( 'grouped' === $product->get_type() ) {
													$sale_text = __( 'فروش!', 'nour-elementor-addons' );
												}

												if ( $sale_price ) {
													$percent_sale = round( ( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 ), 0 );
													$sale_text    = '-[value]%';
													$sale_text    = str_replace( '[value]', $percent_sale, $sale_text );
												}
											}
											if ( $product->is_on_sale() ) :
												nour_elementor_kses( apply_filters( 'nour-woo-product_sale_flash_inner', '<div class="nour-sale-flash-wrap nour-woo-sale-flash-btn nour-woo-badges-btn"><span class="nour-onsale nour-woo-sale-flash-btn-inner">' . $sale_text . '</span></div>', $post, $product ) );
											endif;
										}

										if ( 'yes' === $settings['show_featured_badge'] ) {										
											$featured_text = __( 'جدید', 'nour-elementor-addons' );
											if ( $product->is_featured() ) :
												nour_elementor_kses( apply_filters( 'nour-woo-product_featured_flash_inner', '<div class="nour-featured-flash-wrap nour-woo-featured-flash-btn nour-woo-badges-btn"><span class="nour-featured nour-woo-featured-flash-btn-inner">' . $featured_text . '</span></div>', $post, $product ) ); 
											endif;
										}
									} else {
										$out_stock_text = __( 'ناموجود', 'nour-elementor-addons' );
										?>
										<div class="nour-woo-out-of-stock-btn nour-woo-badges-btn"><span><?php nour_elementor_kses( $out_stock_text ); ?></span></div>
										<?php
									}
									?>
								</div>
							</div>
							<?php
						}
						if ( 'yes' === $settings['show_qv_action'] && '10' !== $settings['layout'] ) {
							?>
							<div class="nour-product-grid-hv-cta-section">
								<?php if ( 'yes' === $settings['show_qv_icon'] ) { ?>
									<div id="<?php echo esc_attr( $product_id ); ?>" class="nour-hv-qv-btn nour-cta-btn">
										<i class="xi xi-eye"></i>
									</div>
									<?php
								}
								if ( 'yes' === $settings['show_cart_icon'] ) {
									?>
									<div class="nour-hv-cart-btn nour-cta-btn">
										<div class="nour-qv-cart-btn">
											<?php
											do_action( 'nour_elementor_woo_products_add_to_cart_before', $product_id, $settings );
											woocommerce_template_loop_add_to_cart();
											do_action( 'nour_elementor_woo_products_add_to_cart_after', $product_id, $settings );
											?>
										</div>
									</div>
								<?php } ?>
							</div>
						<?php } ?>

						<?php if ( 'yes' === $settings['show_cta'] && ( '1' === $settings['layout'] || '4' === $settings['layout'] || '5' === $settings['layout'] ) ) { ?>
							<div class="nour-woo-product-grid-btn-section">
								<div class="nour-woo-product-grid-add-to-cart-btn">
									<?php
									do_action( 'nour_elementor_woo_products_add_to_cart_before', $product_id, $settings );
									woocommerce_template_loop_add_to_cart();
									do_action( 'nour_elementor_woo_products_add_to_cart_after', $product_id, $settings );
									?>
								</div>
							</div>
						<?php } ?>

					</div>
				</div>
			</a>
			<div class="nour-woo-product-grid-content-sec">
				<?php
				if ( 'yes' === $settings['show_category'] ) {
					?>
					<h4 class="nour-woo-product-grid-category-wrapper">
						<?php
						$terms_data = get_the_terms( $product_id, 'product_cat' );
						foreach ( $terms_data as $t ) {
							?>
							<a href="<?php echo esc_url( get_term_link( $t ) ); ?>">
								<span class="nour_elementor_category_term_name">
									<?php echo esc_html( $t->name ); ?>
								</span>
							</a>
						<?php } ?>
					</h4>
				<?php } ?>

				<?php
				if ( 'yes' === $settings['show_title'] ) {
					?>
					<a class="nour-woo-product-grid-title-wrapper" href="<?php echo esc_url( get_permalink( $product_id ) ); ?>">
						<h2 class="nour-woo-product-grid-title"><?php the_title(); ?></h2>
					</a>
				<?php } ?>

				<?php
				if ( 'yes' === $settings['show_rating'] ) {
					?>
					<div class="nour-woo-product-grid-star-rating-wrapper">
						<?php
						do_action( 'nour_elementor_woo_products_rating_before', $product_id, $settings );
						woocommerce_template_loop_rating();
						do_action( 'nour_elementor_woo_products_rating_after', $product_id, $settings );
						?>
					</div>
				<?php } ?>

				<?php if ( 'yes' === $settings['show_price'] ) { ?>
					<div class="nour-woo-product-grid-price-wrapper">
						<?php
						woocommerce_template_loop_price();
						?>
					</div>
				<?php } ?>

				<?php if ( 'yes' === $settings['show_content'] ) { ?>
					<p class="nour-woo-product-grid-excerpt"><?php echo wp_kses_post( $content ); ?></p>
				<?php } ?>

				<?php if ( 'yes' === $settings['show_qv_action'] && '10' === $settings['layout'] ) { ?>
					<div class="nour-product-grid-hv-cta-section">
						<?php if ( 'yes' === $settings['show_qv_icon'] ) { ?>
							<div id="<?php echo esc_attr( $product_id ); ?>" class="nour-hv-qv-btn nour-cta-btn">
								<i class="xi xi-eye"></i>
							</div>
							<?php
						}
						if ( 'yes' === $settings['show_cart_icon'] ) {
							?>
							<div class="nour-hv-cart-btn nour-cta-btn">
								<div class="nour-qv-cart-btn">
									<?php
									do_action( 'nour_elementor_woo_products_add_to_cart_before', $product_id, $settings );
									woocommerce_template_loop_add_to_cart();
									do_action( 'nour_elementor_woo_products_add_to_cart_after', $product_id, $settings );
									?>
								</div>
							</div>
						<?php } ?>
					</div>
				<?php } ?>

				<?php if ( 'yes' === $settings['show_cta'] && ( '1' !== $settings['layout'] && '4' !== $settings['layout'] && '5' !== $settings['layout'] ) ) { ?>
					<div class="nour-woo-product-grid-btn-section">
						<div class="nour-woo-product-grid-add-to-cart-btn">
							<?php
							do_action( 'nour_elementor_woo_products_add_to_cart_before', $product_id, $settings );
							woocommerce_template_loop_add_to_cart();
							do_action( 'nour_elementor_woo_products_add_to_cart_after', $product_id, $settings );
							?>
						</div>
					</div>
				<?php } ?>

			</div>
		</div>
		<?php

		do_action( 'nour_elementor_woo_after_product' );
		wp_reset_postdata();
	endif;
}
?>
