<?php
namespace NourElementorAddons\Widget;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;
use NourElementorAddons\Control\Nour_Elementor_Group_Control_Foreground;
use NourElementorAddons\Control\Nour_Elementor_Image_Selector;

if ( ! defined( 'ABSPATH' ) ) {	exit;}
class Team extends Widget_Base {
	public function get_name() {
		return 'nour-team';
	}
	public function get_title() {
		return __( 'اعضای تیم', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-team-grid nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'team', 'grid' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_general',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'layout',
			array(
				'label'              => esc_html__( 'طرح', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'default'            => '1',
				'options'            => array(
					'1'  => esc_html__( 'طرح 1', 'nour-elementor-addons' ),
					'2'  => esc_html__( 'طرح 2', 'nour-elementor-addons' ),
					'3'  => esc_html__( 'طرح 3', 'nour-elementor-addons' ),
					'4'  => esc_html__( 'طرح 4', 'nour-elementor-addons' ),
					'7'  => esc_html__( 'طرح 5', 'nour-elementor-addons' ),
					'10' => esc_html__( 'طرح 6', 'nour-elementor-addons' ),
					'11' => esc_html__( 'طرح 7', 'nour-elementor-addons' ),
					'12' => esc_html__( 'طرح 8', 'nour-elementor-addons' ),
					'13' => esc_html__( 'طرح 9', 'nour-elementor-addons' ),
					'14' => esc_html__( 'طرح 10', 'nour-elementor-addons' ),
				),
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'image',
			array(
				'label'   => __( 'انتخاب تصویر', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => array(
					'active' => true,
				),
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
			)
		);

		$this->add_control(
			'mask_image',
			array(
				'label'        => __( 'ماسک تصویر', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'label_off'    => __( 'پیشفرض', 'nour-elementor-addons' ),
				'label_on'     => __( 'سفارشی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$this->start_popover();

		$this->add_control(
			'mask_shape',
			array(
				'label'   => __( 'نوع ماسک', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'default',
				'options' => array(
					'default' => array(
						'title' => _x( 'اشکال پیشفرض', 'Mask Image', 'nour-elementor-addons' ),
						'icon'  => 'eicon-image-bold',
					),
					'custom'  => array(
						'title' => _x( 'شکل سفارشی', 'Mask Image', 'nour-elementor-addons' ),
						'icon'  => 'eicon-upload',
					),
				),
				'toggle'  => false,
			)
		);

		$this->add_control(
			'mask_shape_default',
			array(
				'label'                => _x( 'پیشفرض', 'تصویر ماسک', 'nour-elementor-addons' ),
				'label_block'          => true,
				'show_label'           => false,
				'type'                 => Nour_Elementor_Image_Selector::TYPE,
				'default'              => 'shape1',
				'options'              => nour_elementor_masking_shape_list( 'list' ),
				'selectors'            => array(
					'{{WRAPPER}} .nour-team-image > img' => '-webkit-mask-image: url({{VALUE}}); mask-image: url({{VALUE}});',
				),
				'selectors_dictionary' => nour_elementor_masking_shape_list( 'url' ),
				'condition'            => array(
					'mask_image' => 'yes',
					'mask_shape' => 'default',
				),
			)
		);

		$this->add_control(
			'mask_custom_shape',
			array(
				'label'       => _x( 'شکل سفارشی', 'Mask Image', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::MEDIA,
				'show_label'  => false,
				'selectors'   => array(
					'{{WRAPPER}} .nour-team-image > img' => '-webkit-mask-image: url({{URL}}); mask-image: url({{URL}});',
				),
				'condition'   => array(
					'mask_image' => 'yes',
					'mask_shape' => 'custom',
				),
			)
		);

		$this->add_control(
			'mask_position',
			array(
				'label'                => _x( 'موقعیت', 'Mask Image', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::SELECT,
				'default'              => 'center-center',
				'options'              => array(
					'center-center' => _x( 'وسط وسط', 'Mask Image', 'nour-elementor-addons' ),
					'center-left'   => _x( 'وسط چپ', 'Mask Image', 'nour-elementor-addons' ),
					'center-right'  => _x( 'وسط راست', 'Mask Image', 'nour-elementor-addons' ),
					'top-center'    => _x( 'بالا وسط', 'Mask Image', 'nour-elementor-addons' ),
					'top-left'      => _x( 'بالا چپ', 'Mask Image', 'nour-elementor-addons' ),
					'top-right'     => _x( 'بالا راست', 'Mask Image', 'nour-elementor-addons' ),
					'bottom-center' => _x( 'پایین وسط', 'Mask Image', 'nour-elementor-addons' ),
					'bottom-left'   => _x( 'پایین چپ', 'Mask Image', 'nour-elementor-addons' ),
					'bottom-right'  => _x( 'پایین راست', 'Mask Image', 'nour-elementor-addons' ),
				),
				'selectors_dictionary' => array(
					'center-center' => 'center center',
					'center-left'   => 'center left',
					'center-right'  => 'center right',
					'top-center'    => 'top center',
					'top-left'      => 'top left',
					'top-right'     => 'top right',
					'bottom-center' => 'bottom center',
					'bottom-left'   => 'bottom left',
					'bottom-right'  => 'bottom right',
				),
				'selectors'            => array(
					'{{WRAPPER}} .nour-team-image > img' => '-webkit-mask-position: {{VALUE}}; mask-position: {{VALUE}};',
				),
				'condition'            => array(
					'mask_image' => 'yes',
				),
			)
		);

		$this->add_control(
			'mask_size',
			array(
				'label'     => _x( 'اندازه', 'تصویر ماسک', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'contain',
				'options'   => array(
					'auto'    => _x( 'خودکار', 'Mask Image', 'nour-elementor-addons' ),
					'cover'   => _x( 'پوشش', 'Mask Image', 'nour-elementor-addons' ),
					'contain' => _x( 'اصلی', 'Mask Image', 'nour-elementor-addons' ),
					'initial' => _x( 'سفارشی', 'Mask Image', 'nour-elementor-addons' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-team-image > img' => '-webkit-mask-size: {{VALUE}}; mask-size: {{VALUE}};',
				),
				'condition' => array(
					'mask_image' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'mask_custom_size',
			array(
				'label'      => _x( 'اندازه سفارشی', 'Mask Image', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', '%', 'vw' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
					'em' => array(
						'min' => 0,
						'max' => 100,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
					'vw' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'size' => 100,
					'unit' => '%',
				),
				'required'   => true,
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-image > img' => '-webkit-mask-size: {{SIZE}}{{UNIT}}; mask-size: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'mask_image' => 'yes',
					'mask_size'  => 'initial',
				),
			)
		);

		$this->add_control(
			'mask_repeat',
			array(
				'label'                => _x( 'تکرار', 'Mask Image', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::SELECT,
				'default'              => 'no-repeat',
				'options'              => array(
					'repeat'          => _x( 'تکرار', 'Mask Image', 'nour-elementor-addons' ),
					'repeat-x'        => _x( 'تکرار-x', 'Mask Image', 'nour-elementor-addons' ),
					'repeat-y'        => _x( 'تکرار-y', 'Mask Image', 'nour-elementor-addons' ),
					'space'           => _x( 'فاصله', 'Mask Image', 'nour-elementor-addons' ),
					'round'           => _x( 'گرد', 'Mask Image', 'nour-elementor-addons' ),
					'no-repeat'       => _x( 'بدون تکرار', 'Mask Image', 'nour-elementor-addons' ),
					'repeat-space'    => _x( 'تکرار فاصله', 'Mask Image', 'nour-elementor-addons' ),
					'round-space'     => _x( 'تکرار گرد', 'Mask Image', 'nour-elementor-addons' ),
					'no-repeat-round' => _x( 'گرد بدون تکرار', 'Mask Image', 'nour-elementor-addons' ),
				),
				'selectors_dictionary' => array(
					'repeat'          => 'repeat',
					'repeat-x'        => 'repeat-x',
					'repeat-y'        => 'repeat-y',
					'space'           => 'space',
					'round'           => 'round',
					'no-repeat'       => 'no-repeat',
					'repeat-space'    => 'repeat space',
					'round-space'     => 'round space',
					'no-repeat-round' => 'no-repeat round',
				),
				'selectors'            => array(
					'{{WRAPPER}} .nour-team-image > img' => '-webkit-mask-repeat: {{VALUE}}; mask-repeat: {{VALUE}};',
				),
				'condition'            => array(
					'mask_image' => 'yes',
				),
			)
		);

		$this->end_popover();

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'thumbnail',
				'default'   => 'large',
				'separator' => 'none',
			)
		);

		$this->add_control(
			'title',
			array(
				'label'       => __( 'نام', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'جعفر اصغری', 'nour-elementor-addons' ),
				'label_block' => true,
				'separator'   => 'before',
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'title_link',
			array(
				'label'       => __( 'پیوند', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::URL,
				'placeholder' => 'https://example.com',
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'designation',
			array(
				'label'       => __( 'سمت', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'مدیر روابط عمومی', 'nour-elementor-addons' ),
				'label_block' => true,
				'separator'   => 'before',
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'description',
			array(
				'label'       => __( 'توضیخات', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __( 'هر چیزی در زمان صحیح برای آن کس که میداند چطور منتظر بماند اتفاق می افتد.', 'nour-elementor-addons' ),
				'placeholder' => __( 'توضیحات خود را در این قسمت بنویسید', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'align',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'separator' => 'before',
				'selectors' => array(
					'{{WRAPPER}} .nour-team-wrapper' => 'text-align: {{VALUE}};',
				),
				'condition' => array(
					'layout!' => array( '8', '9' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_social',
			array(
				'label' => __( 'شبکه اجتماعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'social_enable',
			array(
				'label'        => __( 'فعال', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'فعال', 'nour-elementor-addons' ),
				'label_off'    => __( 'غیرفعال', 'nour-elementor-addons' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'social_icon',
			array(
				'label'   => __( 'نماد', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::ICONS,
				'default' => array(
					'value'   => 'fab fa-wordpress',
					'library' => 'fa-brands',
				),
			)
		);

		$repeater->add_control(
			'icon_link',
			array(
				'label'       => __( 'پیوند', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::URL,
				'default'     => array(
					'is_external' => 'true',
				),
				'dynamic'     => array(
					'active' => true,
				),
				'placeholder' => __( 'https://your-link.com', 'nour-elementor-addons' ),
			)
		);

		$repeater->add_control(
			'icon_inline_style',
			array(
				'label'        => __( 'سبک درون خطی', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'فعال', 'nour-elementor-addons' ),
				'label_off'    => __( 'غیرفعال', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$repeater->start_controls_tabs( 'icon_inline_style_tab' );

		$repeater->start_controls_tab(
			'icon_inline_normal',
			array(
				'label'     => __( 'طبیعی', 'nour-elementor-addons' ),
				'condition' => array(
					'icon_inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'icon_inline_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon > i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon > svg' => 'fill: {{VALUE}};',
				),
				'condition' => array(
					'icon_inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'icon_inline_bg',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon' => 'background: {{VALUE}};',
				),
				'condition' => array(
					'icon_inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'icon_inline_border',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon' => 'border-color: {{VALUE}};',
				),
				'condition' => array(
					'icon_inline_style' => 'yes',
				),
			)
		);

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'icon_inline_hover',
			array(
				'label'     => __( 'شناور', 'nour-elementor-addons' ),
				'condition' => array(
					'icon_inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'icon_inline_hover_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon:hover > i, {{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon:focus > i'     => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon:hover > svg, {{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon:focus > svg' => 'fill: {{VALUE}};',
				),
				'condition' => array(
					'icon_inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'icon_inline_hover_bg',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon:hover, {{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon:focus' => 'background: {{VALUE}};',
				),
				'condition' => array(
					'icon_inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'icon_inline_border_hcolor',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon:hover, {{WRAPPER}} .nour-team-social-list {{CURRENT_ITEM}} .nour-team-social-icon:focus' => 'border-color: {{VALUE}};',
				),
				'condition' => array(
					'icon_inline_style' => 'yes',
				),
			)
		);

		$repeater->end_controls_tab();
		$repeater->end_controls_tabs();

		$this->add_control(
			'social_icon_list',
			array(
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => array(
					array(
						'social_icon' => array(
							'value'   => 'fab fa-whatsapp',
							'library' => 'fa-brands',
						),
					),
					array(
						'social_icon' => array(
							'value'   => 'fab fa-telegram',
							'library' => 'fa-brands',
						),
					),
					array(
						'social_icon' => array(
							'value'   => 'fab fa-instagram',
							'library' => 'fa-brands',
						),
					),
				),
				'title_field' => '<# var migrated = "undefined" !== typeof __fa4_migrated, social = ( "undefined" === typeof social ) ? false : social; #>{{{ elementor.helpers.getSocialNetworkNameFromIcon( social_icon, social, true, migrated, true ) }}}',
				'condition'   => array(
					'social_enable' => 'yes',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_image_style',
			array(
				'label' => __( 'تصویر', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'width',
			array(
				'label'      => __( 'عرض', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => array(
					'unit' => 'px',
				),
				'size_units' => array( 'px', '%', 'vw' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-image > img' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'height',
			array(
				'label'          => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => array(
					'unit' => 'px',
				),
				'tablet_default' => array(
					'unit' => 'px',
				),
				'mobile_default' => array(
					'unit' => 'px',
				),
				'size_units'     => array( 'px', 'vh' ),
				'range'          => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors'      => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-image > img' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'object-fit',
			array(
				'label'     => __( 'تنظیم اندازه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'condition' => array(
					'height[size]!' => '',
				),
				'options'   => array(
					''        => __( 'پیشفرض', 'nour-elementor-addons' ),
					'fill'    => __( 'پرکردن', 'nour-elementor-addons' ),
					'cover'   => __( 'پوشش', 'nour-elementor-addons' ),
					'contain' => __( 'اصلی', 'nour-elementor-addons' ),
				),
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-image > img' => 'object-fit: {{VALUE}};',
				),
			)
		);

		$this->start_controls_tabs( 'image_effects' );

		$this->start_controls_tab(
			'normal',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'shape_color',
			array(
				'label'     => __( 'رنگ شکل', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-layout-13::after' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'layout' => array( '13' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			array(
				'name'     => 'css_filters',
				'selector' => '{{WRAPPER}} .nour-team-wrapper .nour-team-image img',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'hover',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'image_overlay',
			array(
				'label'     => __( 'رنگ همپوشانی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-layout-5 .nour-team-image::before, {{WRAPPER}} .nour-team-layout-12 .nour-team-image::after' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'layout' => array( '5', '12' ),
				),
			)
		);

		$this->add_control(
			'shape_hcolor',
			array(
				'label'     => __( 'رنگ شکل', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-layout-13:hover::after' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'layout' => array( '13' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			array(
				'name'     => 'css_filters_hover',
				'selector' => '{{WRAPPER}} .nour-team-wrapper:hover .nour-team-image img',
			)
		);

		$this->add_control(
			'background_hover_transition',
			array(
				'label'     => __( 'مدت انیمیشن', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'max'  => 3,
						'step' => 0.1,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-image img' => 'transition-duration: {{SIZE}}s',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'image_border',
				'selector'  => '{{WRAPPER}} .nour-team-wrapper .nour-team-image > img',
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'image_box_shadow',
				'exclude'  => array(
					'box_shadow_position',
				),
				'selector' => '{{WRAPPER}} .nour-team-wrapper .nour-team-image > img',
			)
		);

		$this->add_responsive_control(
			'image_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-image,{{WRAPPER}} .nour-team-wrapper .nour-team-image > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'image_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => '9',
				),
			)
		);

		$this->add_responsive_control(
			'image_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_content_style',
			array(
				'label' => __( 'محتوا', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'content_height',
			array(
				'label'      => esc_html__( 'ارتفاع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-layout-6 .nour-team-content' => 'height: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => '6',
				),
			)
		);

		$this->add_control(
			'content_backdrop_blur',
			array(
				'label'     => esc_html__( 'تاری زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10,
						'step' => 1,
					),
				),
				'default'   => array(
					'size' => 3,
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-team-layout-6 .nour-team-content:before' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
				),
				'condition' => array(
					'layout' => '6',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'      => 'content_background',
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'types'     => array( 'classic', 'gradient' ),
				'exclude'   => array( 'image' ),
				'selector'  => '{{WRAPPER}} .nour-team-wrapper .nour-team-content,{{WRAPPER}} .nour-team-layout-9 .nour-team-inner-content',
				'condition' => array(
					'layout!' => array( '15' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'content_border',
				'selector' => '{{WRAPPER}} .nour-team-wrapper .nour-team-content',
			)
		);

		$this->add_responsive_control(
			'content_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'separator_color',
			array(
				'label'     => __( 'رنگ جداکننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-layout-9 .nour-team-description::before' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'layout' => '9',
				),
			)
		);

		$this->add_responsive_control(
			'content_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-content,{{WRAPPER}} .nour-team-layout-9 .nour-team-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'heading_title',
			array(
				'label'     => __( 'عنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'title!' => '',
				),
			)
		);

		$this->add_group_control(
			Nour_Elementor_Group_Control_Foreground::get_type(),
			array(
				'name'      => 'title_color',
				'label'     => __( 'رنگ عنوان', 'nour-elementor-addons' ),
				'types'     => array( 'classic', 'gradient' ),
				'selector'  => '{{WRAPPER}} .nour-team-wrapper .nour-team-title',
				'condition' => array(
					'title!' => '',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'title_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-team-wrapper .nour-team-title',
				'condition' => array(
					'title!' => '',
				),
			)
		);

		$this->add_responsive_control(
			'title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'title!' => '',
				),
			)
		);

		$this->add_control(
			'heading_designation',
			array(
				'label'     => __( 'سمت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'designation!' => '',
				),
			)
		);

		$this->add_control(
			'designation_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-designation' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'designation!' => '',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'designation_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-team-wrapper .nour-team-designation',
				'condition' => array(
					'designation!' => '',
				),
			)
		);

		$this->add_responsive_control(
			'designation_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'designation!' => '',
				),
			)
		);

		$this->add_control(
			'heading_description',
			array(
				'label'     => __( 'توضیحات', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'description!' => '',
				),
			)
		);

		$this->add_control(
			'description_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-description' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'description!' => '',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'description_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-team-wrapper .nour-team-description',
				'condition' => array(
					'description!' => '',
				),
			)
		);

		$this->add_responsive_control(
			'description_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'description!' => '',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_social_icon_style',
			array(
				'label'     => __( 'اجتماعی', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'social_enable' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'icon_size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'size' => 16,
					'unit' => 'px'
				),
				'range'      => array(
					'px' => array(
						'min' => 1,
						'max' => 50,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon > i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon > svg' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'icon_bg_size',
			array(
				'label'      => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'size' => 50,
					'unit' => 'px'
				),
				'range'      => array(
					'px' => array(
						'min' => 1,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'icon_space',
			array(
				'label'      => __( 'فاصله بینابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => - 100,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-wrapper .nour-team-social-list > li'                       => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-team-layout-9 .nour-team-social-list > li,
					 {{WRAPPER}} .nour-team-layout-13 .nour-team-social-list > li,
					 {{WRAPPER}} .nour-team-layout-15 .nour-team-social-list > li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs( 'social_icon_style' );

		$this->start_controls_tab(
			'icon_normal',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon > i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon > svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'icon_bg',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'icon_wrapper_bg',
			array(
				'label'     => __( 'زمینه نگهدارنده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-team-layout-15 .nour-team-social-list' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'layout' => array( '15' ),
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'icon_hover',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'icon_hover_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon:hover > i, {{WRAPPER}} .nour-team-social-list .nour-team-social-icon:focus > i'    => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon:hover > svg, {{WRAPPER}} .nour-team-social-list .nour-team-social-icon:focus  svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'icon_hbg',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon:hover,{{WRAPPER}} .nour-team-social-list .nour-team-social-icon:focus' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'icon_border_hover_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon:hover, {{WRAPPER}} .nour-team-social-list .nour-team-social-icon:focus' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'icon_border',
				'selector'  => '{{WRAPPER}} .nour-team-social-list .nour-team-social-icon',
				'separator' => 'before',
			)
		);

		$this->add_responsive_control(
			'icon_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-social-list .nour-team-social-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout!' => array( '13' ),
				),
			)
		);

		$this->add_control(
			'heading_social_wrapper',
			array(
				'label'     => __( 'نگهدارنده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => array( '8', '9', '15' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'      => 'icon_wrapper_background',
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'types'     => array( 'classic', 'gradient' ),
				'exclude'   => array( 'image' ),
				'selector'  => '{{WRAPPER}} .nour-team-layout-8 .nour-team-social-list,{{WRAPPER}} .nour-team-layout-9 .nour-team-social-list,{{WRAPPER}} .nour-team-layout-15 .nour-team-social-list',
				'condition' => array(
					'layout' => array( '8', '9', '15' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'icon_wrapper_border',
				'selector'  => '{{WRAPPER}} .nour-team-layout-8 .nour-team-social-list,{{WRAPPER}} .nour-team-layout-9 .nour-team-social-list,{{WRAPPER}} .nour-team-layout-15 .nour-team-social-list',
				'condition' => array(
					'layout' => array( '8', '9', '15' ),
				),
			)
		);

		$this->add_responsive_control(
			'icon_wrapper_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-layout-8 .nour-team-social-list' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => array( '8' ),
				),
			)
		);

		$this->add_responsive_control(
			'icon_wrapper_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-layout-8 .nour-team-social-list'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .nour-team-layout-15 .nour-team-social-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .nour-team-layout-9 .nour-team-social-list'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => array( '8', '15', '9' ),
				),
			)
		);

		$this->add_responsive_control(
			'icon_wrapper_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-team-layout-8 .nour-team-social-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => array( '8' ),
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'team/layout/frontend.php';
	}
}
