<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
class Progress_Bar extends Widget_Base {
	public function get_name() {
		return 'nour-progress-bar';
	}
	public function get_title() {
		return __( 'نوار پیشرفت', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-progress-bar nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'skill', 'progress', 'bar' );
	}
	public function get_script_depends() {
		return array( 'elementor-waypoints' );
	}
	protected function register_controls() {
		$this->start_controls_section(
			'section_general',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'layout',
			array(
				'label'   => esc_html__( 'طرح', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'1'  => esc_html__( 'طرح 1', 'nour-elementor-addons' ),
					'2'  => esc_html__( 'طرح 2', 'nour-elementor-addons' ),
					'3'  => esc_html__( 'طرح 3', 'nour-elementor-addons' ),
					'4'  => esc_html__( 'طرح 4', 'nour-elementor-addons' ),
					'5'  => esc_html__( 'طرح 5', 'nour-elementor-addons' ),
					'6'  => esc_html__( 'طرح 6', 'nour-elementor-addons' ),
					'7'  => esc_html__( 'طرح 7', 'nour-elementor-addons' ),
					'8'  => esc_html__( 'طرح 8', 'nour-elementor-addons' ),
					'9'  => esc_html__( 'طرح 9', 'nour-elementor-addons' ),
					'10' => esc_html__( 'طرح 10', 'nour-elementor-addons' ),
					'11' => esc_html__( 'طرح 11', 'nour-elementor-addons' ),
					'12' => esc_html__( 'طرح 12', 'nour-elementor-addons' ),
					'13' => esc_html__( 'طرح 13', 'nour-elementor-addons' ),
					'14' => esc_html__( 'طرح 14', 'nour-elementor-addons' ),
					'15' => esc_html__( 'طرح 15', 'nour-elementor-addons' ),
				),
			)
		);

		$this->add_control(
			'title',
			array(
				'label'       => esc_html__( 'عنوان', 'nour-elementor-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'وردپرس', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'value',
			array(
				'label'              => esc_html__( 'درصد', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::NUMBER,
				'min'                => 1,
				'max'                => 100,
				'step'               => 1,
				'default'            => 90,
				'frontend_available' => true,
				'dynamic'            => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'show_count',
			array(
				'label'              => __( 'اعداد', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'label_on'           => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'          => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'duration',
			array(
				'label'              => esc_html__( 'مدت انیمیشن', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px' ),
				'frontend_available' => true,
				'range'              => array(
					'px' => array(
						'min'  => 1,
						'max'  => 10,
						'step' => 1,
					),

				),
				'default'            => array(
					'size' => 3,
				),

			)
		);

		$this->add_control(
			'align',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-progress-content' => 'text-align: {{VALUE}}',
				),
				'condition' => array(
					'layout' => array( '15' ),
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_title',
			array(
				'label' => __( 'عنوان', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-progress-title',
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-progress-title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-progress-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_counter',
			array(
				'label' => __( 'شمارنده', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'counter_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-progress-counter',
			)
		);

		$this->add_control(
			'counter_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-progress-counter' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'counter_secondary_color',
			array(
				'label'     => __( 'کاهش رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-progress-bar-layout-6 .nour-progress-count-less-wrapper' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'layout' => array( '6' ),
				),
			)
		);

		$this->add_control(
			'counter_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-progress-bar-layout-3 .nour-progress-counter,{{WRAPPER}} .nour-progress-bar-layout-7 .nour-progress-counter,
					 {{WRAPPER}}  .nour-progress-bar-layout-11 .nour-progress-track::after,{{WRAPPER}} .nour-progress-bar-layout-12 .nour-progress-counter,
					 {{WRAPPER}} .nour-progress-bar-layout-13 .nour-progress-counter,{{WRAPPER}} .nour-progress-bar-layout-14 .nour-progress-counter'               => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .nour-progress-bar-layout-7 .nour-progress-counter::after,{{WRAPPER}} .nour-progress-bar-layout-13 .nour-progress-counter::before' => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .nour-progress-bar-layout-14 .nour-progress-counter::before'                                                                       => 'border-bottom-color: {{VALUE}}',
				),
				'condition' => array(
					'layout' => array( '3', '7', '11', '12', '13', '14' ),
				),
			)
		);

		$this->add_control(
			'counter_shape_color',
			array(
				'label'     => __( 'رنگ شکل', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-progress-control' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .nour-progress-control:before,{{WRAPPER}} .nour-progress-bar-layout-10 .nour-progress-counter::after' => 'border-top-color: {{VALUE}}',
				),
				'condition' => array(
					'layout' => array( '5', '10' ),
				),
			)
		);

		$this->add_control(
			'counter_bg_size',
			array(
				'label'      => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-progress-bar-layout-7 .nour-progress-counter,{{WRAPPER}} .nour-progress-bar-layout-11 .nour-progress-track::after,{{WRAPPER}} .nour-progress-bar-layout-12 .nour-progress-counter' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'layout' => array( '7', '11', '12' ),
				),
			)
		);

		$this->add_control(
			'counter_border_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-progress-bar-layout-7 .nour-progress-counter::before,{{WRAPPER}} .nour-progress-bar-layout-11 .nour-progress-track::after,{{WRAPPER}} .nour-progress-bar-layout-12 .nour-progress-counter' => 'border-color: {{VALUE}}',
				),
				'condition' => array(
					'layout' => array( '7', '11', '12' ),
				),
			)
		);

		$this->add_responsive_control(
			'counter_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-progress-counter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_bar',
			array(
				'label' => __( 'دنباله', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'bar_height',
			array(
				'label'      => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-progress-bar' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'bar_bg',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-progress-bar,{{WRAPPER}}  .nour-progress-bar-layout-11 .nour-progress-track::after',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'bar_shadow',
				'label'    => __( 'نمایش نوار', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-progress-bar',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'bar_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-progress-bar',
			)
		);

		$this->add_responsive_control(
			'bar_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-progress-bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'bar_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-progress-bar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'bar_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-progress-bar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_track',
			array(
				'label' => __( 'نوار', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'track_striped',
			array(
				'label'        => __( 'راه راه', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'    => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
				'selectors'    => array(
					'{{WRAPPER}} .nour-progress-track' => 'background-size: 1rem 1rem; background-image: linear-gradient(45deg,rgba(255,255,255,.15) 25%,transparent 25%,transparent 50%,rgba(255,255,255,.15) 50%,rgba(255,255,255,.15) 75%,transparent 75%,transparent);',
				),
				'condition'    => array(
					'layout!' => array( '9', '10' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'      => 'track_bg',
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'types'     => array( 'classic', 'gradient' ),
				'exclude'   => array( 'image' ),
				'selector'  => '{{WRAPPER}} .nour-progress-track',
				'condition' => array(
					'layout!' => array( '9', '10' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'track_border',
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-progress-track',
				'condition' => array(
					'layout!' => array( '9', '10' ),
				),
			)
		);

		$this->add_control(
			'track_striped_color',
			array(
				'label'     => __( 'رنگ راه راه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-progress-track' => 'background: repeating-linear-gradient(to right,{{VALUE}},{{VALUE}} 10px,transparent 10px,transparent 12px)',
				),
				'condition' => array(
					'layout' => array( '9', '10' ),
				),
			)
		);

		$this->add_responsive_control(
			'track_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-progress-track' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();
		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'progress-bar/layout/frontend.php';
	}
}
