<?php

namespace NourElementorAddons\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {exit;}
class Pie_Chart extends Widget_Base {
	public function get_name() {
		return 'nour-pie-chart';
	}
	public function get_title() {
		return __( 'شمارنده دایره ای', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-pie-chart nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'skill', 'progress', 'bar', 'chart' );
	}
	public function get_script_depends() {
		return array( 'elementor-waypoints', 'easypiechart' );
	}
	protected function register_controls() {
		$this->start_controls_section(
			'section_general',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'layout',
			array(
				'label'              => esc_html__( 'سبک شمارنده', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'default'            => 'round',
				'options'            => array(
					'round' => esc_html__( 'سبک 1', 'nour-elementor-addons' ),
					'butt'  => esc_html__( 'سبک 2', 'nour-elementor-addons' ),
				),
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'chart_media',
			array(
				'label'       => __( 'رسانه شمارنده', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options'     => array(
					'icon'       => array(
						'title' => __( 'نماد', 'nour-elementor-addons' ),
						'icon'  => 'eicon-star-o',
					),
					'percentage' => array(
						'title' => __( 'درصد', 'nour-elementor-addons' ),
						'icon'  => 'eicon-countdown',
					),
				),
				'default'     => 'percentage',
			)
		);

		$this->add_control(
			'icon',
			array(
				'label'     => __( 'نماد', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::ICONS,
				'default'   => array(
					'value'   => 'fas fa-check',
					'library' => 'solid',
				),
				'condition' => array(
					'chart_media' => 'icon',
				),
			)
		);

		$this->add_control(
			'value',
			array(
				'label'              => esc_html__( 'درصد', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::NUMBER,
				'min'                => 1,
				'max'                => 100,
				'step'               => 1,
				'default'            => 70,
				'frontend_available' => true,
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'duration',
			array(
				'label'              => esc_html__( 'مدت زمان انیمیشن', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px' ),
				'frontend_available' => true,
				'range'              => array(
					'px' => array(
						'min'  => 1,
						'max'  => 10,
						'step' => 1,
					),

				),
				'default'            => array(
					'size' => 3,
				),

			)
		);

		$this->add_control(
			'title',
			array(
				'label'       => esc_html__( 'عنوان', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'متن عنوان', 'nour-elementor-addons' ),
				'placeholder' => esc_html__( 'عنوان را در اینجا بنویسید', 'nour-elementor-addons' ),
				'label_block' => true,
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'description',
			array(
				'label'       => esc_html__( 'توضیحات', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 5,
				'default'     => esc_html__( 'توضیحات', 'nour-elementor-addons' ),
				'placeholder' => esc_html__( 'توضیحات خود را در این قسمت بنویسید', 'nour-elementor-addons' ),
				'label_block' => true,
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'content_position',
			array(
				'label'   => __( 'موقعیت محتوا', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'inside',
				'options' => array(
					'inside'  => __( 'درون', 'nour-elementor-addons' ),
					'outside' => __( 'بیرون', 'nour-elementor-addons' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_chart_style',
			array(
				'label' => __( 'نوار شمارنده', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'chart_size',
			array(
				'label'              => __( 'اندازه', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px' ),
				'range'              => array(
					'px' => array(
						'min'  => 0,
						'max'  => 500,
						'step' => 5,
					),
				),
				'default'            => array(
					'size' => 250,
				),
				'selectors'          => array(
					'{{WRAPPER}} .nour-pie-chart' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
				),
				'render_type'        => 'template',
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'chart_bar_size',
			array(
				'label'              => __( 'اندازه نوار', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px' ),
				'range'              => array(
					'px' => array(
						'min'  => 0,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'            => array(
					'size' => 10,
				),
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'bar_color_1',
			array(
				'label'              => __( 'رنگ نوار 1', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::COLOR,
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'bar_color_2',
			array(
				'label'              => __( 'رنگ نوار 2', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::COLOR,
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'track_color',
			array(
				'label'              => __( 'رنگ دنبال کننده', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::COLOR,
				'frontend_available' => true,
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_counter_style',
			array(
				'label'     => __( 'شمارنده', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'chart_media' => 'percentage',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'counter_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-pie-chart-count',
			)
		);

		$this->add_control(
			'counter_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-pie-chart-count' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'counter_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-pie-chart-count' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_icon_style',
			array(
				'label'     => __( 'نماد', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'chart_media' => 'icon',
				),
			)
		);

		$this->add_responsive_control(
			'icon_size',
			array(
				'label'      => __( 'اندازه نماد', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'default'    => array(
					'size' => 40,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-pie-chart-media > i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-pie-chart-media > svg' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-pie-chart-media > i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .nour-pie-chart-media > svg' => 'fill: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'icon_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-pie-chart-media > i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_title_style',
			array(
				'label' => __( 'عنوان', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-pie-chart-title',
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-pie-chart-title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-pie-chart-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_description_style',
			array(
				'label' => __( 'توضیحات', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'description_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-pie-chart-desc',
			)
		);

		$this->add_control(
			'description_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-pie-chart-desc' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'description_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-pie-chart-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'pie-chart/layout/frontend.php';
	}
}
