<?php
namespace NourElementorAddons\Widget;
use Elementor\Controls_Manager; use Elementor\Group_Control_Background; use Elementor\Group_Control_Border; use Elementor\Group_Control_Box_Shadow; use Elementor\Group_Control_Image_Size; use Elementor\Group_Control_Typography; use Elementor\Repeater; use Elementor\Utils; use Elementor\Widget_Base;
if ( ! defined( 'ABSPATH' ) ) {exit;}
class Horizontal_Timeline extends Widget_Base {
	public function get_name() {return 'nour-horizontal-timeline';}
	public function get_title() {return __( 'نوار زمان', 'nour-elementor-addons' );}
	public function get_icon() {return 'xi-horizontal-timeline nour-widget-label';}
	public function get_categories() {return array( 'nour-widgets' );}
	public function get_keywords() {return array( 'nour', 'horizontal', 'timeline', 'carousel' );}
	public function get_style_depends() {return array( 'owl-carousel' );}
	public function get_script_depends() {return array( 'owl-carousel' );}
	protected function register_controls() {$this->start_controls_section('section_horizontal_timeline',array('label' => __( 'عمومی', 'nour-elementor-addons' ),'tab'   => Controls_Manager::TAB_CONTENT,));

		$repeater = new Repeater();

		$repeater->add_control(
			'date_media_type',
			array(
				'label'       => __( 'رسانه برای تاریخ', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options'     => array(
					'none'   => array(
						'title' => __( 'هیچ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-ban',
					),
					'image'  => array(
						'title' => __( 'تصویر', 'nour-elementor-addons' ),
						'icon'  => 'eicon-image',
					),
					'custom' => array(
						'title' => __( 'سفارشی', 'nour-elementor-addons' ),
						'icon'  => ' eicon-font',
					),
				),
				'default'     => 'custom',
				'toggle'      => false,
			)
		);

		$repeater->add_control(
			'date_image',
			array(
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'date_media_type' => 'image',
				),
				'dynamic'   => array(
					'active' => true,
				),
			)
		);

		$repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'date_image_thumbnail',
				'default'   => 'large',
				'separator' => 'none',
				'condition' => array(
					'date_media_type' => 'image',
				),
			)
		);

		$repeater->add_control(
			'title',
			array(
				'label'       => __( 'عنوان', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'عنوان پروژه', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
				'condition'   => array(
					'date_media_type' => 'custom',
				),
			)
		);

		$repeater->add_control(
			'date_custom',
			array(
				'label'     => __( 'تاریخ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => gmdate( 'Y-m-d', strtotime( '+ 1 day' ) ),
				'condition' => array(
					'date_media_type' => 'custom',
				),
			)
		);

		$repeater->add_control(
			'content_media_type',
			array(
				'label'       => __( 'رسانه برای محتوا', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'separator'   => 'before',
				'options'     => array(
					'none'  => array(
						'title' => __( 'هیرچ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-ban',
					),
					'image' => array(
						'title' => __( 'تصویر', 'nour-elementor-addons' ),
						'icon'  => 'eicon-image',
					),
				),
				'default'     => 'image',
				'toggle'      => false,
			)
		);

		$repeater->add_control(
			'content_image',
			array(
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'content_media_type' => 'image',
				),
				'dynamic'   => array(
					'active' => true,
				),
			)
		);

		$repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'content_image_thumbnail',
				'default'   => 'large',
				'separator' => 'none',
				'condition' => array(
					'content_media_type' => 'image',
				),
			)
		);

		$repeater->add_control(
			'sub_title',
			array(
				'label'       => __( 'عنوان', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'سرفصل', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),

			)
		);

		$repeater->add_control(
			'description',
			array(
				'label'       => __( 'توضیحات', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'توضیحات خود را اینجا بنویسید', 'nour-elementor-addons' ),
				'default'     => __( 'این یک واقعیت ثابت شده است که خواننده با محتوای خواندنی حواسش پرت می شود.', 'nour-elementor-addons' ),
			)
		);

		$repeater->add_control(
			'bullet_media_type',
			array(
				'label'       => __( 'رسانه برای گلوله ها', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'separator'   => 'before',
				'options'     => array(
					'icon'   => array(
						'title' => __( 'نماد', 'nour-elementor-addons' ),
						'icon'  => 'eicon-star-o',
					),
					'image'  => array(
						'title' => __( 'تصویر', 'nour-elementor-addons' ),
						'icon'  => 'eicon-image',
					),
					'custom' => array(
						'title' => __( 'سفارشی', 'nour-elementor-addons' ),
						'icon'  => ' eicon-font',
					),
				),
				'default'     => 'icon',
				'toggle'      => false,
			)
		);

		$repeater->add_control(
			'icon',
			array(
				'type'      => Controls_Manager::ICONS,
				'default'   => array(
					'value'   => 'fas fa-calendar-alt',
					'library' => 'fa-solid',
				),
				'condition' => array(
					'bullet_media_type' => 'icon',
				),
			)
		);

		$repeater->add_control(
			'image',
			array(
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'bullet_media_type' => 'image',
				),
				'dynamic'   => array(
					'active' => true,
				),
			)
		);

		$repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'bullet_image_thumbnail',
				'default'   => 'large',
				'separator' => 'none',
				'condition' => array(
					'bullet_media_type' => 'image',
				),
			)
		);

		$repeater->add_control(
			'custom',
			array(
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => '1',
				'dynamic'     => array(
					'active' => true,
				),
				'condition'   => array(
					'bullet_media_type' => 'custom',
				),
			)
		);

		$repeater->add_control(
			'inline_style',
			array(
				'label'        => esc_html__( 'سبک درون خطی', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'نمایش', 'nour-elementor-addons' ),
				'label_off'    => esc_html__( 'مخفی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
				'separator'    => 'before',
			)
		);

		$repeater->start_controls_tabs( 'inline_bullet_media_icon' );

		$repeater->start_controls_tab(
			'inline_bullet_media_normal',
			array(
				'label'     => __( 'طبیعی', 'nour-elementor-addons' ),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_date_bg',
			array(
				'label'     => __( 'زمینه تاریخ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-dates' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_bullet_media_normal_color',
			array(
				'label'     => __( 'رنگ گلوله', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-media > i'                                      => 'color: {{VALUE}};',
					'{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-media > svg'                                      => 'fill: {{VALUE}};',
					'{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-media > .nour-horizontal-timeline-media-custom' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_bullet_media_normal_bg_color',
			array(
				'label'     => __( 'زمینه گلوله', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-media' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_bullet_media_separator_color',
			array(
				'label'     => __( 'رنگ جداکننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-dates:before,
					{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-content-inner:after,
					{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-media:before,
					{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-media:after' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_content_bg',
			array(
				'label'     => __( 'زمینه محتوا', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}} .nour-horizontal-timeline-content-inner' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'inline_bullet_media_hover',
			array(
				'label'     => __( 'شناور', 'nour-elementor-addons' ),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_hdate_bg',
			array(
				'label'     => __( 'زمینه تاریخ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-dates' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_bullet_media_hover_color',
			array(
				'label'     => __( 'رنگ گلوله', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-media > i,
					{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-media > svg,
					{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-media > .nour-horizontal-timeline-media-custom' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_bullet_media_hover_bg_color',
			array(
				'label'     => __( 'زمینه گلوله', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-media' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_bullet_media_separator_hcolor',
			array(
				'label'     => __( 'رنگ جداکننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-dates:before,
					{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-content-inner:after,
					{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-media:before,
					{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-media:after' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_hcontent_bg',
			array(
				'label'     => __( 'زمینه محتوا', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} {{CURRENT_ITEM}}:hover .nour-horizontal-timeline-content-inner' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();

		$this->add_control(
			'horizontal_timeline_item',
			array(
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ sub_title }}}',
				'separator'   => 'after',
				'default'     => array(
					array(
						'sub_title'   => __( 'مرحله 1', 'nour-elementor-addons' ),
						'description' => __( 'رویای خودتون رو بسازید، وگرنه کسی شما را استخدام میکند تا رویای او را بسازید.', 'nour-elementor-addons' ),
					),
					array(
						'sub_title'   => __( 'مرحله 2', 'nour-elementor-addons' ),
						'description' => __( 'رویای خودتون رو بسازید، وگرنه کسی شما را استخدام میکند تا رویای او را بسازید.', 'nour-elementor-addons' ),
					),
					array(
						'sub_title'   => __( 'مرحله 3', 'nour-elementor-addons' ),
						'description' => __( 'رویای خودتون رو بسازید، وگرنه کسی شما را استخدام میکند تا رویای او را بسازید.', 'nour-elementor-addons' ),
					),
					array(
						'sub_title'   => __( 'مرحله 4', 'nour-elementor-addons' ),
						'description' => __( 'رویای خودتون رو بسازید، وگرنه کسی شما را استخدام میکند تا رویای او را بسازید.', 'nour-elementor-addons' ),
					),
				),
			)
		);

		$this->add_control(
			'direction',
			array(
				'label'          => __( 'جهت', 'nour-elementor-addons' ),
				'type'           => Controls_Manager::CHOOSE,
				'default'        => 'col',
				'options'        => array(
					'col'         => array(
						'title' => __( 'بالا', 'nour-elementor-addons' ),
						'icon'  => 'eicon-v-align-top',
					),
					'col-reverse' => array(
						'title' => __( 'پایین', 'nour-elementor-addons' ),
						'icon'  => 'eicon-v-align-bottom',
					),
				),
				'style_transfer' => true,
				'toggle'         => false,
			)
		);

		$this->add_control(
			'reverse',
			array(
				'label'              => esc_html__( 'برعکس', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'نمایش', 'nour-elementor-addons' ),
				'label_off'          => esc_html__( 'مخفی', 'nour-elementor-addons' ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
			)
		);

		$this->add_responsive_control(
			'direction_space_between',
			array(
				'label'      => __( 'فاصله مابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 1,
						'max' => 200,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 10,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item .nour-horizontal-timeline-date,
					{{WRAPPER}} .nour-horizontal-timeline-item .nour-horizontal-timeline-content' => 'padding: 0 {{SIZE}}{{UNIT}} ;',
				),
			)
		);

		$this->add_responsive_control(
			'direction_space_bottom',
			array(
				'label'      => __( 'فاصله از پایین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 1,
						'max' => 200,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 50,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-col .nour-horizontal-timeline-item'                                                                                                                 => 'grid-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-horizontal-timeline-col .nour-horizontal-timeline-dates:before,{{WRAPPER}} .nour-horizontal-timeline-col .nour-horizontal-timeline-content-inner:after'                 => 'height: calc({{SIZE}}{{UNIT}} + 50px);',
					'{{WRAPPER}} .nour-horizontal-timeline-col-reverse .nour-horizontal-timeline-item'                                                                                                         => 'grid-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-horizontal-timeline-col-reverse .nour-horizontal-timeline-dates:before,{{WRAPPER}} .nour-horizontal-timeline-col-reverse .nour-horizontal-timeline-content-inner:after' => 'height: calc({{SIZE}}{{UNIT}} + 50px);',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_horiz_timeline_carousel',
			array(
				'label' => __( 'تنظیمات', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_responsive_control(
			'item_per_row',
			array(
				'label'              => __( 'آیتم ها برای نمایش', 'nour-elementor-addons' ),
				'description'        => __( 'تنظیم تعداد آیتم ها در ردیف', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::NUMBER,
				'placeholder'        => 2,
				'desktop_default'    => 3,
				'tablet_default'     => 2,
				'mobile_default'     => 1,
				'min'                => 1,
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'loop',
			array(
				'label'              => __( 'حلقه', 'nour-elementor-addons' ),
				'description'        => __( 'آیتم های آخر و اول را کپی کنید تا توهم حلقه ایجاد شود.', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->add_control(
			'mouse_drag',
			array(
				'label'              => __( 'حرکت  با موس', 'nour-elementor-addons' ),
				'description'        => __( 'فعال کردن گرفتن و کشیدن با موس', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->add_control(
			'rtl',
			array(
				'label'              => __( 'راست چین', 'nour-elementor-addons' ),
				'description'        => __( 'تغییر جهت از راست به چپ', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'default'            => 'yes',				
				'frontend_available' => true,
				'render_type'        => 'template',
				'selectors'          => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel' => 'direction: rtl;',
				),
			)
		);

		$this->add_control(
			'auto_height',
			array(
				'label'              => __( 'ارتفاع خودکار', 'nour-elementor-addons' ),
				'description'        => __( 'تنظیم ارتفاع بصورت خودکار', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->add_control(
			'autoplay',
			array(
				'label'              => __( 'پخش خودکار', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->add_control(
			'autoplay_timeout',
			array(
				'label'              => __( 'زمان توقف پخش خودکار', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px' ),
				'default'            => array(
					'size' => 3,
				),
				'range'              => array(
					'px' => array(
						'min' => 1,
						'max' => 10,
					),
				),
				'frontend_available' => true,
				'render_type'        => 'template',
				'condition'          => array(
					'autoplay' => 'yes',
				),
			)
		);

		$this->add_control(
			'nav',
			array(
				'label'              => __( 'نمایش ناوبری', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'frontend_available' => true,
				'render_type'        => 'template',
				'default'            => 'yes',
			)
		);

		$this->add_control(
			'dots',
			array(
				'label'              => __( 'نمایش نقطه ها', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'return_value'       => 'yes',
				'frontend_available' => true,
				'render_type'        => 'template',
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_media_style',
			array(
				'label' => __( 'تاریخ', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->start_controls_tabs( 'date_styling_tabs' );

		$this->start_controls_tab(
			'date_normal',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'media_media_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-dates',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'media_box_shadow',
				'label'    => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-dates',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'date_hover',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'media_media_background_hover',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-dates',
			)
		);

		$this->add_control(
			'media_border_hover_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-dates' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'media_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-dates',
			)
		);

		$this->add_responsive_control(
			'media_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-dates' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'media_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-dates' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'media_title_options',
			array(
				'label'     => __( 'عنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'media_title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-title',
			)
		);

		$this->add_control(
			'media_title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,

				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'media_title_hcolor',
			array(
				'label'     => __( 'شناور', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,

				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'media_title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'media_date_options',
			array(
				'label'     => __( 'تاریخ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'media_date_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-time',
			)
		);

		$this->add_control(
			'media_date_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,

				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-time,{{WRAPPER}} .nour-horizontal-timeline-content-time' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'media_date_hcolor',
			array(
				'label'     => __( 'شناور', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,

				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-time' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'media_date_margin',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-time' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'media_image_options',
			array(
				'label'     => __( 'تصویر', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_responsive_control(
			'media_image_width',
			array(
				'label'      => __( 'عرض', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'%'  => array(
						'min' => 1,
						'max' => 100,
					),
					'px' => array(
						'min' => 1,
						'max' => 1000,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 100,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-inner .nour-horizontal-timeline-dates > img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'media_image_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-inner .nour-horizontal-timeline-dates > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_bullet_media_style',
			array(
				'label' => __( 'گلوله', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'bullet_media_size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 1,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-media > i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-horizontal-timeline-media > img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-horizontal-timeline-media > svg' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
				),
			)
		);

		$this->add_responsive_control(
			'bullet_media_bg_size',
			array(
				'label'      => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'%'  => array(
						'min' => 1,
						'max' => 100,
					),
					'px' => array(
						'min' => 1,
						'max' => 1000,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-media' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs( 'bullet_media_icon' );

		$this->start_controls_tab(
			'bullet_media_normal',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'bullet_media_normal_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-media > i'                                      => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-horizontal-timeline-media > svg'                                      => 'fill: {{VALUE}};',
					'{{WRAPPER}} .nour-horizontal-timeline-media > .nour-horizontal-timeline-media-custom' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'bullet_media_normal_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-media' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'bullet_media_separator_color',
			array(
				'label'     => __( 'رنگ جداکننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-dates:before,
					{{WRAPPER}} .nour-horizontal-timeline-content-inner:after,
					{{WRAPPER}} .nour-horizontal-timeline-media:before,
					{{WRAPPER}} .nour-horizontal-timeline-media:after' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'divider_line_color',
			array(
				'label'     => __( 'رنگ جداکننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-bullet-line' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'bullet_media_hover',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'bullet_media_hover_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-media > i,
					{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-media > svg,
					{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-media > .nour-horizontal-timeline-media-custom' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'bullet_media_hover_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-media' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'bullet_media_separator_hcolor',
			array(
				'label'     => __( 'رنگ جداکننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-dates:before,
					{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-content-inner:after,
					{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-media:before,
					{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-media:after' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'bullet_media_hover_border_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-media' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'bullet_media_border',
				'separator' => 'before',
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-horizontal-timeline-media',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'bullet_media_box_shadow',
				'label'    => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-media',
			)
		);

		$this->add_responsive_control(
			'bullet_media_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-media' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'bullet_media_custom_options',
			array(
				'label'     => __( 'سفارشی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'bullet_media_custom_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-media > .nour-horizontal-timeline-media-custom',
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_general_style_content',
			array(
				'label' => __( 'محتوا', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'content_alignment',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-content-inner' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'content_width',
			array(
				'label'      => esc_html__( 'عرض', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-content-inner' => 'max-width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs( 'content_styling_tabs' );

		$this->start_controls_tab(
			'content_normal',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'content_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-content-inner',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'content_box_shadow',
				'label'    => __( 'سایه جعبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-content-inner',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'content_hover',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'content_background_hover',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-content-inner',
			)
		);

		$this->add_control(
			'content_border_hover_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-content-inner' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'content_border',
				'separator' => 'before',
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-horizontal-timeline-content-inner',
			)
		);

		$this->add_responsive_control(
			'content_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-content-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'content_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-content-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'content_image_heading',
			array(
				'label'     => __( 'تصویر', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'inline',
			array(
				'label'       => __( 'طرح بندی', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'default'     => 'inline-block',
				'options'     => array(
					'inline-flex'  => array(
						'title' => __( 'خطی', 'nour-elementor-addons' ),
						'icon'  => 'eicon-editor-list-ul',
					),
					'inline-block' => array(
						'title' => __( 'جعبه ای', 'nour-elementor-addons' ),
						'icon'  => 'eicon-ellipsis-h',
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} .nour-horizontal-timeline-content-inner' => 'display: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'content_media_size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'%'  => array(
						'min' => 1,
						'max' => 100,
					),
					'px' => array(
						'min' => 1,
						'max' => 1000,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-content-inner .nour-horizontal-timeline-content-media > img' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
				),

			)
		);

		$this->add_responsive_control(
			'content_media_space_between',
			array(
				'label'      => __( 'فاصله مابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 1,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 10,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-content-inner'                                               => 'grid-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-horizontal-timeline-content-inner .nour-horizontal-timeline-content-media > img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'content_media_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-content-inner .nour-horizontal-timeline-content-media > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'content_title_heading',
			array(
				'label'     => __( 'عنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'content_title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-sub-title',
			)
		);

		$this->add_control(
			'content_title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-sub-title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'content_title_hover',
			array(
				'label'     => __( 'شناور', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-sub-title' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'content_title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'content_description_heading',
			array(
				'label'     => __( 'توضیحات', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'content_desc_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-horizontal-timeline-text',
			)
		);

		$this->add_control(
			'content_desc_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-text' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'content_desc_hover',
			array(
				'label'     => __( 'شناور', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-horizontal-timeline-item:hover .nour-horizontal-timeline-text' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'content_desc_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-horizontal-timeline-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_horizontal_timeline_nav_style',
			array(
				'label'     => __( 'ناوبری', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'nav' => 'yes',
				),
			)
		);

		$this->add_control(
			'nav_layout',
			array(
				'label'   => __( 'طرح بندی', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style-1' => __( 'استایل 1', 'nour-elementor-addons' ),
					'style-2' => __( 'استایل 2', 'nour-elementor-addons' ),
					'style-3' => __( 'استایل 3', 'nour-elementor-addons' ),
					'style-4' => __( 'استایل 4', 'nour-elementor-addons' ),
					'style-5' => __( 'استایل 5', 'nour-elementor-addons' ),
					'style-6' => __( 'استایل 6', 'nour-elementor-addons' ),
					'style-7' => __( 'استایل 7', 'nour-elementor-addons' ),
				),
				'default' => 'style-1',
			)
		);

		$this->add_responsive_control(
			'nav_size',
			array(
				'label'      => __( 'اندازه نماد', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 16,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev,
					 {{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next' => 'font-size: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'nav_bg_size',
			array(
				'label'      => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 50,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev,
					 {{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'nav_offset_y',
			array(
				'label'      => __( 'فاصله عمودی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev,
					{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next' => 'top: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'reverse!' => 'yes',
				),
			)
		);

		$this->start_controls_tabs(
			'news_ticker_nav_style_tabs'
		);

		$this->start_controls_tab(
			'news_ticker_nav_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'nav_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev,
					{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'nav_bg_color',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'selectors' => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev,
					{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'news_ticker_nav_hover_tab_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'nav_hover_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev:hover,
					{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'nav_hover_bg',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'alpha'     => false,
				'selectors' => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev:hover,
					 {{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next:hover' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'nav_hover_border',
			array(
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev:hover,
					{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next:hover' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'nav_border',
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'separator' => 'before',
				'selector'  => '{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev,
				{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next',
			)
		);

		$this->add_responsive_control(
			'nav_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-prev, 
					{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-nav button.owl-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'timeline_dots_styling',
			array(
				'label'     => __( 'نقطه ها', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'dots' => 'yes',
				),
			)
		);

		$this->add_control(
			'dots_layout',
			array(
				'label'   => __( 'طرح بندی', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style-1' => __( 'سبک 1', 'nour-elementor-addons' ),
					'style-2' => __( 'سبک 2', 'nour-elementor-addons' ),
					'style-3' => __( 'سبک 3', 'nour-elementor-addons' ),
				),
				'default' => 'style-1',
			)
		);

		$this->add_responsive_control(
			'dots_bg_height',
			array(
				'label'      => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'size' => 12,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-dot' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'dots_bg_width',
			array(
				'label'      => __( 'عرض', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'size' => 12,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-dot'  => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-owl-dots-horizontal-style-2.owl-carousel .owl-dot.active' => 'width: calc({{SIZE}}{{UNIT}} * 2);',
				),
			)
		);

		$this->add_responsive_control(
			'dots_space_between',
			array(
				'label'      => __( 'فاصله مابین', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'size' => 5,
				),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 20,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-dot' => 'margin: 0 {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_responsive_control(
			'dots_space',
			array(
				'label'      => __( 'فاصله گذاری', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'size' => 20,
				),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 50,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-dots' => 'bottom: -{{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->start_controls_tabs(
			'horiz_timeline_dots_style_tabs'
		);

		$this->start_controls_tab(
			'horiz_timeline_dots_normal_tab',
			array(
				'label' => __( 'طبیعی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'dots_bg_color',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-dot' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'horiz_timeline_dots_active_tab_style',
			array(
				'label' => __( 'فعال', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'dots_hover_bg',
			array(
				'label'     => __( 'زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-dot.active' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'dots_hover_border',
			array(
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-dot.active' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'dots_border',
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'separator' => 'before',
				'selector'  => '{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-dot',
			)
		);

		$this->add_responsive_control(
			'dots_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-owl-theme.owl-carousel .owl-dot' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'horizontal-timeline/layout/frontend.php';

	}

}
