<?php
namespace NourElementorAddons\Widget;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Widget_Base;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class Business_Hours extends Widget_Base {
	public function get_name() {
		return 'nour-business-hours';
	}
	public function get_title() {
		return __( 'ساعات کاری', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-business-hours nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'nour', 'business', 'hours' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_general',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'show_title',
			array(
				'label'        => __( 'سرفصل', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'    => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);

		$this->add_control(
			'title',
			array(
				'label'       => __( 'عنوان', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'ساعات کاری', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
				'condition'   => array(
					'show_title' => 'yes',
				),
			)
		);

		$this->add_control(
			'sub_title',
			array(
				'label'       => __( 'زیرعنوان', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'همین امروز وقت مشاوره دریافت کنید!', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
				'condition'   => array(
					'show_title' => 'yes',
				),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'business_day',
			array(
				'label'       => __( 'روز', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'ساعات کاری', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$repeater->add_control(
			'business_time',
			array(
				'label'       => __( 'زمان', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( '10:00AM - 07:00PM', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$repeater->add_control(
			'inline_style',
			array(
				'label'        => __( 'سبک درون خطی', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'    => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value' => 'yes',
			)
		);

		$repeater->start_controls_tabs(
			'row_style_item',
			array(
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->start_controls_tab(
			'item_normal_style',
			array(
				'label' => __( 'عادی', 'nour-elementor-addons' ),
			)
		);

		$repeater->add_control(
			'inline_item_day_color',
			array(
				'label'     => __( 'رنگ روز', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} ul > {{CURRENT_ITEM}}.nour-business-hour-item .nour-business-hour-day' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_item_time_color',
			array(
				'label'     => __( 'رنگ زمان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} ul > {{CURRENT_ITEM}}.nour-business-hour-item .nour-business-hour-time' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_item_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} ul > {{CURRENT_ITEM}}.nour-business-hour-item' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_separator_color',
			array(
				'label'     => __( 'رنگ جداکننده', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} ul > {{CURRENT_ITEM}}.nour-business-hour-item .nour-business-hour-separator-horizontal > span' => 'border-bottom-color: {{VALUE}}',
					'{{WRAPPER}} ul > {{CURRENT_ITEM}}.nour-business-hour-item .nour-business-hour-separator-vertical'          => 'border-right-color: {{VALUE}}',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'item_hover_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$repeater->add_control(
			'inline_item_day_hcolor',
			array(
				'label'     => __( 'رنگ روز', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} ul > {{CURRENT_ITEM}}.nour-business-hour-item:hover .nour-business-hour-day' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_item_time_hcolor',
			array(
				'label'     => __( 'رنگ زمان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} ul > {{CURRENT_ITEM}}.nour-business-hour-item:hover .nour-business-hour-time' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->add_control(
			'inline_item_bg',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} ul > {{CURRENT_ITEM}}.nour-business-hour-item:hover' => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'inline_style' => 'yes',
				),
			)
		);

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();

		$this->add_control(
			'business_item',
			array(
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ business_day }}}',
				'fields'      => $repeater->get_controls(),
				'separator'   => 'before',
				'default'     => array(
					array(
						'business_day'  => __( 'شنبه', 'nour-elementor-addons' ),
						'business_time' => __( '10:00AM - 07:00PM', 'nour-elementor-addons' ),
					),
					array(
						'business_day'  => __( 'یکشنبه', 'nour-elementor-addons' ),
						'business_time' => __( '10:00AM - 07:00PM', 'nour-elementor-addons' ),
					),				
					array(
						'business_day'  => __( 'دوشنبه', 'nour-elementor-addons' ),
						'business_time' => __( '10:00AM - 07:00PM', 'nour-elementor-addons' ),
					),
					array(
						'business_day'  => __( 'سه شنبه', 'nour-elementor-addons' ),
						'business_time' => __( '10:00AM - 07:00PM', 'nour-elementor-addons' ),
					),
					array(
						'business_day'  => __( 'چهارشنبه', 'nour-elementor-addons' ),
						'business_time' => __( '10:00AM - 07:00PM', 'nour-elementor-addons' ),
					),
					array(
						'business_day'  => __( 'پنج شنبه', 'nour-elementor-addons' ),
						'business_time' => __( 'تعطیل', 'nour-elementor-addons' ),
					),
					array(
						'business_day'  => __( 'جمعه', 'nour-elementor-addons' ),
						'business_time' => __( 'تعطیل', 'nour-elementor-addons' ),
					),
				),
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_title',
			array(
				'label'     => __( 'سرفصل', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_title' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'heading_align',
			array(
				'label'     => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),

				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-header' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'heading_background',
				'label'    => __( 'زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'classic', 'gradient' ),
				'exclude'  => array( 'image' ),
				'selector' => '{{WRAPPER}} .nour-business-hour-header',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'heading_border',
				'label'    => __( 'لبه', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-business-hour-header',
			)
		);

		$this->add_control(
			'heading_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-business-hour-header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'heading_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-business-hour-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'title_options',
			array(
				'label'     => __( 'عنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'title!' => '',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'title_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-business-hour-title',
				'condition' => array(
					'title!' => '',
				),
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-title' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'title!' => '',
				),
			)
		);

		$this->add_control(
			'title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-business-hour-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'title!' => '',
				),
			)
		);

		$this->add_control(
			'sub_title_options',
			array(
				'label'     => __( 'زیرعنوان', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'sub_title!' => '',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'sub_title_typography',
				'label'     => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector'  => '{{WRAPPER}} .nour-business-hour-sub-title',
				'condition' => array(
					'sub_title!' => '',
				),
			)
		);

		$this->add_control(
			'sub_title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-sub-title' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'sub_title!' => '',
				),
			)
		);

		$this->add_control(
			'sub_title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-business-hour-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'sub_title!' => '',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_item',
			array(
				'label' => __( 'لیست آیتم ها', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'item_align',
			array(
				'label'        => __( 'Alignment', 'nour-elementor-addons' ),
				'type'         => Controls_Manager::CHOOSE,
				'options'      => array(
					'left'  => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'right' => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'default'      => 'row',
				'prefix_class' => 'elementor%s-align-',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'item_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-business-hour-day,{{WRAPPER}} .nour-business-hour-time',
			)
		);

		$this->add_responsive_control(
			'item_content_width',
			array(
				'label'      => __( 'عرض محتوا', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-business-hour-day,{{WRAPPER}} .nour-business-hour-time' => 'width: {{SIZE}}{{UNIT}};',
				),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 500,
					),
				),
				'condition'  => array(
					'separator_layout' => 'horizontal',
				),
			)
		);

		$this->start_controls_tabs(
			'row_style_item'
		);

		$this->start_controls_tab(
			'item_normal_style',
			array(
				'label' => __( 'عادی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'item_day_color_odd',
			array(
				'label'     => __( 'رنگ روز (فرد)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(odd) .nour-business-hour-day' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_day_color_even',
			array(
				'label'     => __( 'رنگ روز (زوج)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(even) .nour-business-hour-day' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_time_color_odd',
			array(
				'label'     => __( 'رنگ زمان (فرد)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(odd) .nour-business-hour-time' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_time_color_even',
			array(
				'label'     => __( 'رنگ زمان (زوج)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(even) .nour-business-hour-time' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_bg_color_odd',
			array(
				'label'     => __( 'رنگ زمینه (فرد)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(odd)' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_bg_color_even',
			array(
				'label'     => __( 'رنگ زمینه (زوج)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(even)' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'item_hover_style',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'item_day_hcolor_odd',
			array(
				'label'     => __( 'رنگ روز (فرد)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(odd):hover .nour-business-hour-day' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_day_hcolor_even',
			array(
				'label'     => __( 'رنگ روز (زوج)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(even):hover .nour-business-hour-day' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_time_hcolor_odd',
			array(
				'label'     => __( 'رنگ زمان (فرد)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(odd):hover .nour-business-hour-time' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_time_hcolor_even',
			array(
				'label'     => __( 'رنگ زمان (زوج)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(even):hover .nour-business-hour-time' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_bg_hcolor_odd',
			array(
				'label'     => __( 'رنگ زمینه (فرد)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(odd):hover' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_bg_hcolor_even',
			array(
				'label'     => __( 'رنگ زمینه (زوج)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(even):hover' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'item_border_style',
			array(
				'label'     => __( 'لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'dashed',
				'separator' => 'before',
				'options'   => array(
					'none'   => __( 'هیچ', 'nour-elementor-addons' ),
					'solid'  => __( 'جامد', 'nour-elementor-addons' ),
					'dashed' => __( 'خط تیره', 'nour-elementor-addons' ),
					'dotted' => __( 'نقطه', 'nour-elementor-addons' ),
					'double' => __( 'دوتایی', 'nour-elementor-addons' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item' => 'border-bottom-style: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'item_border_width',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'size' => 1,
				),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 10,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-business-hour-item' => 'border-bottom-width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'item_border_style!' => 'none',
				),
			)
		);

		$this->add_control(
			'item_border_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item' => 'border-bottom-color: {{VALUE}}',
				),
				'condition' => array(
					'item_border_style!' => 'none',
				),
			)
		);

		$this->add_control(
			'item_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-business-hour-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'item_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-business-hour-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_separator',
			array(
				'label' => __( 'جداکننده', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'separator_layout',
			array(
				'label'   => __( 'طرح بندی جداکننده', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'none',
				'options' => array(
					'none'       => array(
						'title' => __( 'هیچ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-ban',
					),
					'horizontal' => array(
						'title' => __( 'افقی', 'nour-elementor-addons' ),
						'icon'  => 'eicon-ellipsis-h',
					),
					'vertical'   => array(
						'title' => __( 'عمودی', 'nour-elementor-addons' ),
						'icon'  => 'eicon-editor-list-ul',
					),
				),
			)
		);

		$this->add_control(
			'separator_width',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'default'    => array(
					'size' => 60,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-business-hour-separator-vertical,{{WRAPPER}} .nour-business-hour-item' => 'height: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'separator_layout' => 'vertical',
				),
			)
		);

		$this->add_control(
			'separator_color_odd',
			array(
				'label'     => __( 'رنگ (فرد)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(odd) .nour-business-hour-separator-horizontal > span' => 'border-bottom-color: {{VALUE}}',
					'{{WRAPPER}} .nour-business-hour-item:nth-child(odd) .nour-business-hour-separator-vertical'          => 'border-right-color: {{VALUE}}',
				),
				'condition' => array(
					'separator_layout!' => 'none',
				),
			)
		);

		$this->add_control(
			'separator_color_even',
			array(
				'label'     => __( 'رنگ (زوج)', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-business-hour-item:nth-child(even) .nour-business-hour-separator-horizontal > span' => 'border-bottom-color: {{VALUE}}',
					'{{WRAPPER}} .nour-business-hour-item:nth-child(even) .nour-business-hour-separator-vertical'          => 'border-right-color: {{VALUE}}',
				),
				'condition' => array(
					'separator_layout!' => 'none',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'business-hours/layout/frontend.php';
	}
}
