<?php
namespace NourElementorAddons\Widget;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Widget_Base;
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}
class Block_Quote extends Widget_Base {
	public function get_name() {
		return 'nour-block-quote';
	}
	public function get_title() {
		return __( 'نقل قول', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-block-quote nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'nour', 'block', 'quote' );
	}
	protected function register_controls() {

		$this->start_controls_section(
			'section_blockquote',
			array(
				'label' => __( 'نقل قول', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'quote_position',
			array(
				'label'   => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'layout-1',
				'options' => array(
					'layout-1'  => __( 'طرح بندی 1', 'nour-elementor-addons' ),
					'layout-2'  => __( 'طرح بندی 2', 'nour-elementor-addons' ),
					'layout-3'  => __( 'طرح بندی 3', 'nour-elementor-addons' ),
					'layout-4'  => __( 'طرح بندی 4', 'nour-elementor-addons' ),
					'layout-5'  => __( 'طرح بندی 5', 'nour-elementor-addons' ),
					'layout-6'  => __( 'طرح بندی 6', 'nour-elementor-addons' ),
					'layout-7'  => __( 'طرح بندی 7', 'nour-elementor-addons' ),
					'layout-8'  => __( 'طرح بندی 8', 'nour-elementor-addons' ),
					'layout-9'  => __( 'طرح بندی 9', 'nour-elementor-addons' ),
					'layout-10' => __( 'طرح بندی 10', 'nour-elementor-addons' ),
				),
			)
		);
		$this->add_control(
			'quote_icon',
			array(
				'label'     => esc_html__( 'نمادها', 'nour-elementor-addons' ),
				'type'      => \Elementor\Controls_Manager::ICONS,
				'default'   => array(
					'value'   => 'fas fa-quote-left',
					'library' => 'solid',
				),
				'condition' => array(
					'quote_position!' => array( 'layout-3', 'layout-6' ),
				),
			)
		);
		$this->add_control(
			'image',
			array(
				'label'     => __( 'تصویر', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'quote_position' => array( 'layout-4' ),
				),
				'dynamic'   => array(
					'active' => true,
				),
			)
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'media_thumbnail',
				'default'   => 'full',
				'separator' => 'none',
				'exclude'   => array(
					'custom',
				),
				'condition' => array(
					'quote_position' => array( 'layout-4' ),
				),
			)
		);

		$this->add_control(
			'quote_title',
			array(
				'label'       => __( 'عنوان', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => __( 'کاربر راست چین', 'nour-elementor-addons' ),
				'placeholder' => __( 'عنوان نقل قول را بنویسید', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'quote_designation',
			array(
				'label'       => __( 'جایگاه', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => __( 'توسط توسعه دهنده', 'nour-elementor-addons' ),
				'placeholder' => __( 'سمت خود را بنویسید', 'nour-elementor-addons' ),
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->add_control(
			'quote_description',
			array(
				'label'       => esc_html__( 'توضیحات', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 5,
				'placeholder' => esc_html__( 'توضیحات خود را اینجا بنویسید', 'nour-elementor-addons' ),
				'default'     => 'تنها راه انجام دادن کارهای عظیم، دوست داشتن کاری است که میکنید.اگر تا الان آنرا پیدا نکردید،
				به گشتنتان ادامه دهید و تا زمانی که آنرا پیدا نکردید، متوقف نشوید.',
				'label_block' => true,
				'dynamic'     => array(
					'active' => true,
				),
			)
		);

		$this->end_controls_section();

		//Styling Tab
		$this->start_controls_section(
			'section_style_general',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'box_alignment',
			array(
				'label'          => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'           => Controls_Manager::CHOOSE,
				'options'        => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'toggle'         => false,
				'default'        => 'left',
				'tablet_default' => 'left',
				'mobile_default' => 'center',
				'prefix_class'   => 'elementor%s-align-',
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'box_background',
				'label'    => __( 'پس زمینه', 'nour-elementor-addons' ),
				'types'    => array( 'کلاسیک', 'gradient' ),
				'selector' => '{{WRAPPER}} .nour-block-quote-inner, {{WRAPPER}} .nour-block-quote-layout-3 .nour-block-quote-inner::before, {{WRAPPER}} .nour-block-quote-layout-6 .nour-block-quote-text::before',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'style_border',
				'selector' => '{{WRAPPER}} .nour-block-quote-inner',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'box_shadow',
				'exclude'  => array(
					'box_shadow_position',
				),
				'selector' => '{{WRAPPER}} .nour-block-quote-inner',
			)
		);

		$this->add_responsive_control(
			'box_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'box_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		// Image
		$this->start_controls_section(
			'section_block_quote_image',
			array(
				'label'     => __( 'تصویر', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'quote_position' => 'layout-4',
				),
			)
		);

		$this->add_responsive_control(
			'image_size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 100,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-layout-4 .nour-block-quote-content-img > img' => 'min-width: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'image_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-layout-4 .nour-block-quote-content-img > img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		// Separator
		$this->start_controls_section(
			'section_block_quote_separator',
			array(
				'label'     => __( 'جداکننده', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'quote_position' => 'layout-5',
				),
			)
		);

		$this->add_responsive_control(
			'separator_size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'vw' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 100,
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-layout-5 .nour-block-quote-content-wrap::before' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'separator_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-block-quote-layout-5 .nour-block-quote-content-wrap::before' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'separator_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-layout-5 .nour-block-quote-content-wrap::before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		// Quote
		$this->start_controls_section(
			'section_block_quote',
			array(
				'label'     => __( 'نقل قول', 'nour-elementor-addons' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'quote_position!' => array( 'layout-3', 'layout-6' ),
				),
			)
		);

		$this->add_responsive_control(
			'quote_size',
			array(
				'label'      => __( 'اندازه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 5,
						'max' => 300,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-icon > i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-block-quote-icon > svg' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
				),
			)
		);

		$this->add_responsive_control(
			'quote_bg_size',
			array(
				'label'      => __( 'اندازه زمینه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 5,
						'max' => 300,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-icon' => 'min-width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'quote_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-block-quote-icon > i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-block-quote-icon > svg' => 'fill: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'quote_bg_color',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-block-quote-icon' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'quote_border',
				'selector' => '{{WRAPPER}} .nour-block-quote-icon',
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'quote_shadow',
				'exclude'  => array(
					'box_shadow_position',
				),
				'selector' => '{{WRAPPER}} .nour-block-quote-icon',
			)
		);

		$this->add_responsive_control(
			'quote_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'quote_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'quote_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		//Description
		$this->start_controls_section(
			'section_block_quote_desc',
			array(
				'label' => __( 'توضیحات', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'desc_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-block-quote-content-wrap > .nour-block-quote-text',
			)
		);

		$this->add_control(
			'desc_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-block-quote-content-wrap > .nour-block-quote-text' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'desc_border',
				'selector'  => '{{WRAPPER}} .nour-block-quote-content-wrap > .nour-block-quote-text,
				{{WRAPPER}} .nour-block-quote-layout-6 .nour-block-quote-text::after',
				'condition' => array(
					'quote_position' => 'layout-6',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'      => 'desc_shadow',
				'exclude'   => array(
					'box_shadow_position',
				),
				'selector'  => '{{WRAPPER}} .nour-block-quote-content-wrap > .nour-block-quote-text',
				'condition' => array(
					'quote_position' => 'layout-6',
				),
			)
		);

		$this->add_responsive_control(
			'desc_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-content-wrap > .nour-block-quote-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'quote_position' => 'layout-6',
				),
			)
		);

		$this->add_responsive_control(
			'desc_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-content-wrap > .nour-block-quote-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition'  => array(
					'quote_position' => 'layout-6',
				),
			)
		);

		$this->add_responsive_control(
			'desc_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-content-wrap > .nour-block-quote-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_block_quote_title',
			array(
				'label' => __( 'عنوان', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-block-quote-desc > .nour-block-quote-title',
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-block-quote-desc > .nour-block-quote-title'         => 'color: {{VALUE}};',
					'{{WRAPPER}} .nour-block-quote-desc > .nour-block-quote-title::before' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'title_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-desc > .nour-block-quote-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_block_quote_designation',
			array(
				'label' => __( 'جایگاه', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'designation_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-block-quote-desc > .nour-block-quote-designation',
			)
		);

		$this->add_control(
			'designation_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-block-quote-desc > .nour-block-quote-designation' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'designation_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-block-quote-desc > .nour-block-quote-designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'block-quote/layout/frontend.php';
	}
}