<?php
namespace NourElementorAddons\Widget;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Widget_Base;
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}
class Before_After extends Widget_Base {
	public function get_name() {
		return 'nour-before-after';
	}
	public function get_title() {
		return __( 'نمایش قبل و بعد', 'nour-elementor-addons' );
	}
	public function get_icon() {
		return 'xi-before-after nour-widget-label';
	}
	public function get_categories() {
		return array( 'nour-widgets' );
	}
	public function get_keywords() {
		return array( 'before', 'after', 'compare', 'comparison' );
	}
	public function get_style_depends() {
		return array( 'nour-compare' );
	}
	public function get_script_depends() {
		return array( 'nour-compare' );
	}
	protected function register_controls() {
		$this->start_controls_section(
			'section_before',
			array(
				'label' => __( 'قبل', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'before_label',
			array(
				'label'       => __( 'برچسب', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => true,
				),
				'default'     => __( 'قبل از', 'nour-elementor-addons' ),
				'placeholder' => __( 'نوشته قبل از', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'before_image',
			array(
				'label'   => __( 'انتخاب تصویر', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => array(
					'active' => true,
				),
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
			)
		);
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'before_thumbnail',
				'default'   => 'large',
				'separator' => 'none',
				'exclude'   => array(
					'custom',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_after',
			array(
				'label' => __( 'بعد از', 'nour-elementor-addons' ),
			)
		);
		$this->add_control(
			'after_label',
			array(
				'label'       => __( 'برچسب', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => true,
				),
				'default'     => __( 'بعد از', 'nour-elementor-addons' ),
				'placeholder' => __( 'متن بعد از', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'after_image',
			array(
				'label'   => __( 'انتخاب تصویر', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => array(
					'active' => true,
				),
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
			)
		);
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'      => 'after_thumbnail',
				'default'   => 'large',
				'separator' => 'none',
				'exclude'   => array(
					'custom',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_settings',
			array(
				'label' => __( 'تنظیمات', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'orientation',
			array(
				'label'              => __( 'جهت حرکت', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SELECT,
				'options'            => array(
					'horizontal'  => __( 'افقی', 'nour-elementor-addons' ),
					'vertical'    => __( 'عمودی', 'nour-elementor-addons' ),
					'sides'       => __( 'مورب چپ', 'nour-elementor-addons' ),
					'sides-right' => __( 'مورب راست', 'nour-elementor-addons' ),
				),
				'default'            => 'horizontal',
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'display_label',
			array(
				'label'   => __( 'نمایش برچسب', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'on-hover' => __( 'در حالت شناور', 'nour-elementor-addons' ),
					'always'   => __( 'همیشه', 'nour-elementor-addons' ),
				),
				'default' => 'always',
			)
		);

		$this->add_control(
			'display_handle',
			array(
				'label'   => __( 'نمایش اهرم', 'nour-elementor-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'on-hover' => __( 'در حالت شناور', 'nour-elementor-addons' ),
					'always'   => __( 'همیشه', 'nour-elementor-addons' ),
				),
				'default' => 'always',
			)
		);

		$this->add_control(
			'mouse_move',
			array(
				'label'              => __( 'حرکت در حالت شناور', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'label_on'           => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'          => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value'       => 'yes',
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'wiggle',
			array(
				'label'              => __( 'جلب توجه', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SWITCHER,
				'label_on'           => __( 'نمایش', 'nour-elementor-addons' ),
				'label_off'          => __( 'مخفی', 'nour-elementor-addons' ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'wiggle_timeout',
			array(
				'label'              => __( 'تاخیر تکان خوردن', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'default'            => array(
					'size' => 1.5,
				),
				'size_units'         => array( 'px' ),
				'range'              => array(
					'px' => array(
						'min'  => 0.1,
						'max'  => 3,
						'step' => 0.1,
					),
				),
				'condition'          => array(
					'wiggle' => 'yes',
				),
				'frontend_available' => true,
			)
		);

		$this->add_control(
			'visible_ratio',
			array(
				'label'              => __( 'جایگاه اهرم', 'nour-elementor-addons' ),
				'type'               => Controls_Manager::SLIDER,
				'separator'          => 'before',
				'default'            => array(
					'size' => 50,
				),
				'size_units'         => array( '%' ),
				'range'              => array(
					'px' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 5,
					),
				),
				'frontend_available' => true,
			)
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_general_style',
			array(
				'label' => __( 'عمومی', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'item_height',
			array(
				'label'       => __( 'ارتفاع', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => array( 'px', 'vh', '%' ),
				'default'     => array(
					'unit' => 'vh',
				),
				'range'       => array(
					'px' => array(
						'min' => 1,
						'max' => 1000,
					),
				),
				'render_type' => 'template',
				'selectors'   => array(
					'{{WRAPPER}} .nour-compare-wrapper, {{WRAPPER}} .nour-compare-item img' => 'height: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_control(
			'overlay_color',
			array(
				'label'     => __( 'رنگ همپوشانی', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-container .nour-compare-overlay' => 'background-color: {{VALUE}};',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_label_style',
			array(
				'label' => __( 'برچسب', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'label_typography',
				'label'    => __( 'تایپوگرافی', 'nour-elementor-addons' ),
				'selector' => '{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label, {{WRAPPER}} .nour-compare-overlay .nour-compare-after-label',
			)
		);

		$this->start_controls_tabs( 'label_before_after_tabs' );

		$this->start_controls_tab(
			'label_before_tab',
			array(
				'label' => __( 'قبل', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'label_before_hpos',
			array(
				'label'                => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::CHOOSE,
				'options'              => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'default'              => 'center',
				'selectors_dictionary' => array(
					'left'   => 'left: 0;',
					'center' => 'left:50%; transform:translateX(-50%);',
					'right'  => 'right:0;',
				),
				'selectors'            => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label' => '{{VALUE}};',
				),
				'toggle'               => false,
				'condition'            => array(
					'orientation' => 'vertical',
				),
			)
		);

		$this->add_control(
			'label_before_vpos',
			array(
				'label'                => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::CHOOSE,
				'options'              => array(
					'top'    => array(
						'title' => __( 'بالا', 'nour-elementor-addons' ),
						'icon'  => 'eicon-v-align-top',
					),
					'middle' => array(
						'title' => __( 'مرکز', 'nour-elementor-addons' ),
						'icon'  => 'eicon-v-align-middle',
					),
					'bottom' => array(
						'title' => __( 'پایین', 'nour-elementor-addons' ),
						'icon'  => 'eicon-v-align-bottom',
					),
				),
				'default'              => 'middle',
				'toggle'               => false,
				'selectors_dictionary' => array(
					'top'    => 'top: 0;',
					'middle' => 'top:50%; transform:translateY(-50%);',
					'bottom' => 'bottom:0;',
				),
				'selectors'            => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label' => '{{VALUE}};',
				),
				'condition'            => array(
					'orientation!' => 'vertical',
				),
			)
		);

		$this->add_control(
			'before_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'before_bg',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'before_border_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label' => 'border-color: {{VALUE}};',
				),
				'condition' => array(
					'label_border_border!' => '',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'label_after_tab',
			array(
				'label' => __( 'بعد', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'label_after_hpos',
			array(
				'label'                => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::CHOOSE,
				'options'              => array(
					'left'   => array(
						'title' => __( 'چپ', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'وسط', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => __( 'راست', 'nour-elementor-addons' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'default'              => 'center',
				'selectors_dictionary' => array(
					'left'   => 'left: 0;',
					'center' => 'left:50%; transform:translateX(-50%);',
					'right'  => 'right:0;',
				),
				'selectors'            => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-after-label' => '{{VALUE}};',
				),
				'toggle'               => false,
				'condition'            => array(
					'orientation' => 'vertical',
				),
			)
		);

		$this->add_control(
			'label_after_vpos',
			array(
				'label'                => __( 'موقعیت', 'nour-elementor-addons' ),
				'type'                 => Controls_Manager::CHOOSE,
				'options'              => array(
					'top'    => array(
						'title' => __( 'بالا', 'nour-elementor-addons' ),
						'icon'  => 'eicon-v-align-top',
					),
					'middle' => array(
						'title' => __( 'مرکز', 'nour-elementor-addons' ),
						'icon'  => 'eicon-v-align-middle',
					),
					'bottom' => array(
						'title' => __( 'پایین', 'nour-elementor-addons' ),
						'icon'  => 'eicon-v-align-bottom',
					),
				),
				'default'              => 'middle',
				'toggle'               => false,
				'selectors_dictionary' => array(
					'top'    => 'top: 0;',
					'middle' => 'top:50%; transform:translateY(-50%);',
					'bottom' => 'bottom:0;',
				),
				'selectors'            => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-after-label' => '{{VALUE}};',
				),
				'condition'            => array(
					'orientation!' => 'vertical',
				),
			)
		);

		$this->add_control(
			'after_color',
			array(
				'label'     => __( 'رنگ', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-after-label' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'after_bg',
			array(
				'label'     => __( 'رنگ زمینه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-after-label' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'after_border_color',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-after-label' => 'border-color: {{VALUE}};',
				),
				'condition' => array(
					'label_border_border!' => '',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'label_border',
				'selector'  => '{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label, {{WRAPPER}} .nour-compare-overlay .nour-compare-after-label',
				'separator' => 'before',
			)
		);

		$this->add_responsive_control(
			'label_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label, {{WRAPPER}} .nour-compare-overlay .nour-compare-after-label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'label_padding',
			array(
				'label'      => __( 'فاصله داخلی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label, {{WRAPPER}} .nour-compare-overlay .nour-compare-after-label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'label_margin',
			array(
				'label'      => __( 'فاصله خارجی', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-compare-overlay .nour-compare-before-label, {{WRAPPER}} .nour-compare-overlay .nour-compare-after-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		//Handle
		$this->start_controls_section(
			'section_separator_style',
			array(
				'label' => __( 'اهرم', 'nour-elementor-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'separator_line_size',
			array(
				'label'      => __( 'اندازه خط', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 1,
						'max' => 10,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .nour-compare-vertical .nour-compare-handle:after, {{WRAPPER}} .nour-compare-vertical .nour-compare-handle:before'     => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .nour-compare-horizontal .nour-compare-handle:after, {{WRAPPER}} .nour-compare-horizontal .nour-compare-handle:before' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'orientation' => array( 'vertical', 'horizontal' ),
				),
			)
		);

		$this->start_controls_tabs( 'separator_tabs' );

		$this->start_controls_tab(
			'separator_normal_tab',
			array(
				'label' => __( 'عادی', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'separator_icon_color',
			array(
				'label'     => __( 'رنگ نماد', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-container .nour-compare-handle .nour-compare-up-arrow'    => 'border-bottom-color: {{VALUE}};',
					'{{WRAPPER}} .nour-compare-container .nour-compare-handle .nour-compare-down-arrow'  => 'border-top-color: {{VALUE}};',
					'{{WRAPPER}} .nour-compare-container .nour-compare-handle .nour-compare-left-arrow'  => 'border-right-color: {{VALUE}};',
					'{{WRAPPER}} .nour-compare-container .nour-compare-handle .nour-compare-right-arrow' => 'border-left-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'separator_icon_bg',
			array(
				'label'     => __( 'زمینه نماد', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-handle' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'separator_line_color',
			array(
				'label'     => __( 'رنک خط', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-handle:after,{{WRAPPER}} .nour-compare-handle:before' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'orientation' => array( 'vertical', 'horizontal' ),
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'separator_hover_tab',
			array(
				'label' => __( 'شناور', 'nour-elementor-addons' ),
			)
		);

		$this->add_control(
			'separator_icon_hcolor',
			array(
				'label'     => __( 'رنگ نماد', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-handle:hover .nour-compare-up-arrow'    => 'border-bottom-color: {{VALUE}};',
					'{{WRAPPER}} .nour-compare-handle:hover .nour-compare-down-arrow'  => 'border-top-color: {{VALUE}};',
					'{{WRAPPER}} .nour-compare-handle:hover .nour-compare-left-arrow'  => 'border-right-color: {{VALUE}};',
					'{{WRAPPER}} .nour-compare-handle:hover .nour-compare-right-arrow' => 'border-left-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'separator_icon_hbg',
			array(
				'label'     => __( 'زمینه نماد', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-handle:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'separator_border_hcolor',
			array(
				'label'     => __( 'رنگ لبه', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-handle:hover' => 'border-color: {{VALUE}};',
				),
				'condition' => array(
					'separator_border_border!' => '',
				),
			)
		);

		$this->add_control(
			'separator_line_hcolor',
			array(
				'label'     => __( 'رنگ خط', 'nour-elementor-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .nour-compare-handle:hover::after, .nour-compare-handle:hover::before' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'orientation' => array( 'vertical', 'horizontal' ),
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'      => 'separator_border',
				'selector'  => '{{WRAPPER}} .nour-compare-handle',
				'separator' => 'before',
			)
		);

		$this->add_responsive_control(
			'separator_border_radius',
			array(
				'label'      => __( 'شعاع لبه', 'nour-elementor-addons' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .nour-compare-handle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		require NOUR_ELEMENTOR_ADDONS_WIDGET . 'before-after/layout/frontend.php';
	}
}
