<?php
namespace NourElementorAddons\Module;
use Elementor\Controls_Manager;
use Elementor\Element_Base;
defined( 'ABSPATH' ) || die();
class Nour_Elementor_Entrance_Animation {
	public static function init() {
		add_filter( 'elementor/controls/animations/additional_animations', array( __CLASS__, 'additional_animations' ) );
		add_action( 'elementor/element/column/section_effects/before_section_end', array( __CLASS__, 'register' ), 10 );
		add_action( 'elementor/element/common/section_effects/before_section_end', array( __CLASS__, 'register' ), 10 );
		add_action( 'elementor/element/section/section_effects/before_section_end', array( __CLASS__, 'register' ), 10 );
		add_action( 'elementor/element/container/section_effects/before_section_end', array( __CLASS__, 'register' ), 10, 1 );
	}
	public static function additional_animations( $list ) {
		$animations = array(
			'ماسک'   => array(
				'nour-anim-mask-from-up'    => 'ماسک از بالا',
				'nour-anim-mask-from-down'  => 'ماسک از پایین',
				'nour-anim-mask-from-left'  => 'ماسک از چپ',
				'nour-anim-mask-from-right' => 'ماسک از راست',
			),
			'آشکارسازی' => array(
				'nour-anim-reveal-from-up'    => 'آشکارسازی از بالا',
				'nour-anim-reveal-from-down'  => 'آشکارسازی از پایین',
				'nour-anim-reveal-from-left'  => 'آشکارسازی از چپ',
				'nour-anim-reveal-from-right' => 'آشکارسازی از راست',
			),
			'چرخش'   => array(
				'flipInX' => 'چرخش افقی',
				'flipInY' => 'چرخش عمودی',
			),
		);
		return array_merge( $animations, $list );
	}
	public static function register( Element_Base $element ) {

		$element->add_control(
			'nour_elementor_reveal_color',
			array(
				'label'       => __( 'رنگ آشکارسازی', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::COLOR,
				'selectors'   => array(
					'{{WRAPPER}}[class*=nour-anim-reveal-from] > .elementor-container::after'   => 'background-color: {{VALUE}};',
					'{{WRAPPER}}[class*=nour-anim-reveal-from] > .elementor-element-populated::after'   => 'background-color: {{VALUE}};',
					'{{WRAPPER}}[class*=nour-anim-reveal-from] > .elementor-widget-container::after'   => 'background-color: {{VALUE}};',
					'{{WRAPPER}}[class*=nour-anim-reveal-from] > .e-con-inner::after'   => 'background-color: {{VALUE}};',
				),
				'condition'   => array(
					'_animation' => array( 'nour-anim-reveal-from-up', 'nour-anim-reveal-from-down', 'nour-anim-reveal-from-left', 'nour-anim-reveal-from-right' ),
				),
				'render_type' => 'template',
			)
		);
		$element->add_control(
			'nour_elementor_reveal_bg_color',
			array(
				'label'       => __( 'رنگ آشکارسازی', 'nour-elementor-addons' ),
				'type'        => Controls_Manager::COLOR,
				'selectors'   => array(
					'{{WRAPPER}}[class*=nour-anim-reveal-from] > .elementor-container::after'   => 'background-color: {{VALUE}};',
					'{{WRAPPER}}[class*=nour-anim-reveal-from] > .elementor-element-populated::after'   => 'background-color: {{VALUE}};',
					'{{WRAPPER}}[class*=nour-anim-reveal-from] > .elementor-widget-container::after'   => 'background-color: {{VALUE}};',
					'{{WRAPPER}}[class*=nour-anim-reveal-from] > .e-con-inner::after'   => 'background-color: {{VALUE}};',
				),
				'condition'   => array(
					'animation' => array( 'nour-anim-reveal-from-up', 'nour-anim-reveal-from-down', 'nour-anim-reveal-from-left', 'nour-anim-reveal-from-right' ),
				),
				'render_type' => 'template',
			)
		);
	}
}
Nour_Elementor_Entrance_Animation::init();
