<?php
namespace NourElementorAddons;
use Elementor\Plugin;
use NourElementorAddons\Control\Nour_Elementor_Group_Control_Foreground;
use NourElementorAddons\Control\Nour_Elementor_Image_Selector;
use NourElementorAddons\Control\Nour_Elementor_Select;
use NourElementorAddons\Control\Nour_Elementor_Widget_Area;
use NourElementorAddons\Inc\Nour_Elementor_Module_List;
use NourElementorAddons\Inc\Nour_Elementor_Widget_List;
use NourElementorAddons\Libs\Nour_Elementor_Dashboard;
defined( 'ABSPATH' ) || die();
class Nour_Elementor_Addons {
	private static $instance = null;
	public static function instance() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
			self::$instance->init();
		}

		return self::$instance;
	}

	public function init() {

		$this->include_files();

		if ( ! did_action( 'elementor/loaded' ) ) {
			return;
		}
		add_action( 'elementor/init', array( $this, 'nour_elementor_init' ) );
		add_action( 'elementor/frontend/after_register_scripts', array( $this, 'widget_scripts' ) );
		add_action( 'elementor/widgets/register', array( $this, 'register_widgets' ) );
		add_action( 'init', array( $this, 'register_modules' ) );
		add_action( 'elementor/editor/before_enqueue_styles', array( $this, 'editor_enqueue_styles' ) );
		add_action( 'elementor/editor/after_enqueue_scripts', array( $this, 'editor_enqueue_script' ) );
		add_action( 'elementor/frontend/after_enqueue_styles', array( $this, 'control_enqueue_styles' ) );
		add_action( 'elementor/frontend/after_enqueue_scripts', array( $this, 'control_enqueue_scripts' ), 22 );
		add_action( 'elementor/preview/enqueue_styles', array( $this, 'enqueue_preview_styles' ) );
		add_action( 'elementor/controls/controls_registered', array( $this, 'register_controls' ) );
		add_filter( 'upload_mimes', array( $this, 'add_custom_font_mimes' ) );
		add_filter( 'admin_footer_text', array( $this, 'admin_footer_text' ), 22 );
		add_action( 'elementor/documents/register', array( $this, 'register_elementor_document_type' ) );
		add_filter( 'plugin_action_links_' . NOUR_ELEMENTOR_ADDONS_BASE, array( $this, 'plugin_action_links' ) );
	}
	public function include_files() {
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'admin/dashboard/dashboard.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/helper-functions.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/controls/widget-area-utils.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/widgets.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/modules.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'handlers/handler-nour-navigations.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'handlers/handler-ajax-handler.php';

		if ( in_array( 'sitepress-multilingual-cms/sitepress.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) && in_array( 'wpml-string-translation/plugin.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
			require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/wpml/wpml-compatibility.php';
		}

	}
	public function widget_scripts() {
		wp_enqueue_style(
			'nour-elementor-addons-widgets',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'css/nour-widgets.css',
			null,
			NOUR_ELEMENTOR_ADDONS_VERSION
		);
		wp_enqueue_style(
			'nour-elementor-addons-responsive',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'css/nour-responsive.css',
			null,
			NOUR_ELEMENTOR_ADDONS_VERSION
		);
		wp_enqueue_style(
			'font-awesome',
			ELEMENTOR_ASSETS_URL . 'lib/font-awesome/css/all.min.css',
			null,
			'5.15.3'
		);
		wp_enqueue_style(
			'nour-icons',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'css/nour-icons.min.css',
			null,
			'1.0.0'
		);
		wp_enqueue_script(
			'nour-elementor-addons-widgets',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'js/nour-widgets.js',
			array( 'jquery' ),
			NOUR_ELEMENTOR_ADDONS_VERSION,
			true
		);

		$nour_localize = apply_filters(
			'nour_elementor_addons_localize',
			array(
				'ajax_url' => admin_url( 'admin-ajax.php' ),
				'nonce'    => wp_create_nonce( 'nour-elementor-addons-nonce' ),
			)
		);

		wp_localize_script(
			'nour-elementor-addons-widgets',
			'NourElementorAddons',
			$nour_localize
		);

		wp_script_add_data( 'nour-elementor-addons-widgets', 'async', true );

		if ( class_exists( 'WooCommerce' ) ) {
			wp_enqueue_style(
				'nour-elementor-addons-woo',
				NOUR_ELEMENTOR_ADDONS_ASSETS . 'css/nour-woocommerce-widgets.css',
				null,
				NOUR_ELEMENTOR_ADDONS_VERSION
			);
		}
		wp_register_style(
			'cubeportfolio',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/nourportfolio.min.css',
			null,
			'4.4.0'
		);
		wp_register_style(
			'owl-carousel',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/owl.carousel.min.css',
			null,
			'2.3.4'
		);
		wp_register_style(
			'lightgallery',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/gallery.min.css',
			null,
			'1.6.12'
		);
		wp_register_style(
			'slick',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/slick.min.css',
			null,
			'1.8.0'
		);
		wp_register_style(
			'animate',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/animate.min.css',
			null,
			'3.4.0'
		);
		wp_register_style(
			'nour-compare',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/nour-compare.min.css',
			null,
			NOUR_ELEMENTOR_ADDONS_VERSION
		);
		wp_register_style(
			'hover',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/hover.min.css',
			null,
			'2.3.2'
		);
		wp_register_style(
			'leaflet',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/noor-leaflet.min.css',
			null,
			'16.0'
		);
		wp_register_style(
			'plyr',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/video-plyer.css',
			null,
			'3.6.12'
		);
		wp_register_style(
			'fancybox',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/fancybox.css',
			null,
			'4.0.22'
		);
		wp_register_style(
			'prism',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/noorspecial.min.css',
			null,
			'1.16.0'
		);
		wp_register_script(
			'cubeportfolio',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/jquery.cubeportfolio.min.js',
			array( 'jquery' ),
			'4.4.0',
			true
		);
		wp_register_script(
			'owl-carousel',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/owl.carousel.min.js',
			array( 'jquery' ),
			'2.3.4',
			true
		);
		wp_register_script(
			'lightgallery',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/all-gallery.min.js',
			array( 'jquery' ),
			'1.6.12',
			true
		);
		wp_register_script(
			'gsap',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/gsap.min.js',
			array( 'jquery' ),
			'3.2.4',
			true
		);
		wp_register_script(
			'slick',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/slick.min.js',
			array( 'jquery' ),
			'1.8.0',
			true
		);
		wp_register_script(
			'morphext',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/morphext.min.js',
			array( 'jquery' ),
			'2.4.4',
			true
		);
		wp_register_script(
			'typed',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/typed.min.js',
			array( 'jquery' ),
			'2.0.12',
			true
		);
		wp_register_script(
			'anime',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/anime.min.js',
			array( 'jquery' ),
			'3.0.1',
			true
		);
		wp_register_script(
			'lax',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/lax.min.js',
			array( 'jquery' ),
			'2.0.0',
			true
		);
		wp_register_script(
			'vanilla-tilt',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/vanilla-tilt.min.js',
			array( 'jquery' ),
			'1.7.0',
			true
		);
		wp_register_script(
			'lottie',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/lottie.min.js',
			array( 'jquery' ),
			NOUR_ELEMENTOR_ADDONS_VERSION,
			true
		);
		wp_register_script(
			'easypiechart',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/jquery.easypiechart.min.js',
			array( 'jquery' ),
			'2.1.7',
			true
		);
		wp_register_script(
			'sliding-menu',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/sliding-menu.min.js',
			array( 'jquery' ),
			'1.8.0',
			true
		);
		wp_register_script(
			'spritespin',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/spritespin.min.js',
			array( 'jquery' ),
			'4.0.11',
			true
		);
		wp_register_script(
			'nour-compare',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/compare.min.js',
			array( 'jquery' ),
			NOUR_ELEMENTOR_ADDONS_VERSION,
			true
		);
		wp_register_script(
			'sharer',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/sharer.min.js',
			array( 'jquery' ),
			NOUR_ELEMENTOR_ADDONS_VERSION,
			true
		);
		wp_register_script(
			'countdown',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/countdown.min.js',
			array( 'jquery' ),
			'0.1.2',
			true
		);
		wp_register_script(
			'jquery-cookie',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/jquery.cookie.min.js',
			array( 'jquery' ),
			'1.4.1',
			true
		);
		wp_register_script(
			'isotope',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/isotope.pkgd.min.js',
			array( 'jquery' ),
			'3.0.6',
			true
		);
		wp_register_script(
			'drawsvg',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/jquery.drawsvg.min.js',
			array( 'jquery' ),
			'0.1.2',
			true
		);
		wp_register_script(
			'leaflet',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/leaflet.min.js',
			array( 'jquery' ),
			'1.6.0',
			true
		);
		wp_register_script(
			'recaptcha',
			'https://www.google.com/recaptcha/api.js',
			array( 'jquery' ),
			NOUR_ELEMENTOR_ADDONS_VERSION,
			true
		);
		wp_register_script(
			'plyr',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/plyr.js',
			array( 'jquery' ),
			'3.6.12',
			true
		);
		wp_register_script(
			'fancybox',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/fancybox.umd.js',
			array( 'jquery' ),
			'4.0.22',
			true
		);
		wp_register_script(
			'prism',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/prism.min.js',
			array( 'jquery' ),
			'1.16.0',
			true
		);
		wp_register_script(
			'parallaxie',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/parallaxie.min.js',
			array( 'jquery' ),
			'0.5',
			true
		);
		wp_register_script(
			'particles',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/particles.min.js',
			array( 'jquery' ),
			'2.0.0',
			true
		);
		wp_register_script(
			'elevatezoom',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/jquery.elevatezoom.min.js',
			array( 'jquery' ),
			'3.0.8',
			true
		);

		wp_register_script(
			'asRange',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/jquery-asRange.min.js',
			array( 'jquery' ),
			'0.3.4',
			true
		);

		wp_register_script(
			'jplayer',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/jquery.jplayer.min.js',
			array( 'jquery' ),
			'2.9.2',
			true
		);

		wp_register_script(
			'clipboard',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/clipboard.min.js',
			array( 'jquery' ),
			'1.5.12',
			true
		);

		wp_register_script(
			'granim',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/granim.min.js',
			array( 'jquery' ),
			'2.0.0',
			true
		);

		wp_register_script(
			'3dflipbook',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/3dflipbook.min.js',
			array( 'jquery' ),
			'2.0.0',
			true
		);

	}
	public function enqueue_preview_styles() {
		if ( class_exists( '\WPForms\WPForms' ) && defined( 'WPFORMS_PLUGIN_SLUG' ) ) {
			wp_enqueue_style(
				'nour-wpforms',
				plugins_url( '/' . WPFORMS_PLUGIN_SLUG . '/assets/css/wpforms-full.css', WPFORMS_PLUGIN_SLUG ),
				null,
				NOUR_ELEMENTOR_ADDONS_VERSION
			);
		}

		if ( class_exists( '\GFForms' ) ) {
			wp_enqueue_style(
				'nour-gravity-forms',
				plugins_url( '/gravityforms/css/theme.min.css', 'gravityforms' ),
				null,
				NOUR_ELEMENTOR_ADDONS_VERSION
			);
		}
	}
	public function editor_enqueue_styles() {
		wp_enqueue_style(
			'nour-elementor-addons-editor',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'css/nour-editor.css',
			null,
			NOUR_ELEMENTOR_ADDONS_VERSION
		);
		wp_enqueue_style(
			'nour-icons',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'css/nour-icons.min.css',
			null,
			NOUR_ELEMENTOR_ADDONS_VERSION
		);
	}
	public function editor_enqueue_script() {
		wp_enqueue_script(
			'nour-elementor-addons-editor',
			NOUR_ELEMENTOR_ADDONS_ASSETS . 'js/nour-editor.js',
			array( 'jquery' ),
			NOUR_ELEMENTOR_ADDONS_VERSION,
			true
		);

		wp_localize_script(
			'nour-elementor-addons-editor',
			'NourEditor',
			array(
				'homeUrl'    => get_site_url(),
				'ajaxURL'    => admin_url( 'admin-ajax.php' ),
				'nonce'      => wp_create_nonce( 'nour-editor-nonce' ),
				'serverBusy' => __( 'سرور مشغول است لطفاً بعداً دوباره امتحان کنید.', 'nour-elementor-addons' ),
			)
		);

	}
	public function control_enqueue_styles() {
		wp_enqueue_style(
			'nour-elementor-widgetarea-editor',
			NOUR_ELEMENTOR_ADDONS_DIR_URL . 'inc/controls/assets/css/widgetarea-editor.css',
			null,
			NOUR_ELEMENTOR_ADDONS_VERSION
		);
	}
	public function control_enqueue_scripts() {
		wp_enqueue_script(
			'nour-elementor-widgetarea-editor',
			NOUR_ELEMENTOR_ADDONS_DIR_URL . 'inc/controls/assets/js/widgetarea-editor.js',
			array( 'jquery' ),
			NOUR_ELEMENTOR_ADDONS_VERSION,
			true
		);

		wp_localize_script(
			'nour-elementor-widgetarea-editor',
			'NourWidgetAreaEditorParams',
			array(
				'rest_api_url' => get_rest_url(),
			)
		);
	}
	public function register_widgets( $widgets_manager ) {

		$all_widgets    = Nour_Elementor_Widget_List::instance()->get_list();
		$active_widgets = Nour_Elementor_Dashboard::instance()->utils->get_option( 'nour_elementor_widget_list', array_keys( $all_widgets ) );

		if ( ! empty( $active_widgets ) && is_array( $active_widgets ) ) {
			foreach ( $active_widgets as $widget_slug ) {
				if ( array_key_exists( $widget_slug, $all_widgets ) ) {
					if ( 'pro-disabled' !== $all_widgets[ $widget_slug ]['package'] && 'pro' !== $all_widgets[ $widget_slug ]['package'] ) {
						require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'widgets/' . str_replace( '_', '-', $widget_slug ) . '/' . str_replace( '_', '-', $widget_slug ) . '.php';
						$class_name = '\NourElementorAddons\Widget\\' . $this->make_classname( $widget_slug );
						if ( class_exists( $class_name ) ) {
							$widgets_manager->register( new $class_name() );
						}
					}
				}
			}
		}
	}
	public static function make_classname( $dirname ) {
		$dirname    = pathinfo( $dirname, PATHINFO_FILENAME );
		$class_name = explode( '-', $dirname );
		$class_name = array_map( 'ucfirst', $class_name );
		$class_name = implode( '_', $class_name );

		return $class_name;
	}
	public function register_modules() {

		$all_modules    = Nour_Elementor_Module_List::instance()->get_list();
		$active_modules = Nour_Elementor_Dashboard::instance()->utils->get_option( 'nour_elementor_module_list', array_keys( $all_modules ) );

		if ( ! empty( $active_modules ) && is_array( $active_modules ) ) {
			foreach ( $active_modules as $module_slug ) {
				if ( array_key_exists( $module_slug, $all_modules ) ) {
					if ( 'pro-disabled' !== $all_modules[ $module_slug ]['package'] && 'pro' !== $all_modules[ $module_slug ]['package'] && 'undefined' !== $all_modules[ $module_slug ]['package'] ) {
						if ( isset( $all_modules[ $module_slug ]['dependencies'] ) && ! class_exists( $all_modules[ $module_slug ]['dependencies'] ) ) {
							continue;
						}
						include_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'modules/' . str_replace( '_', '-', $module_slug ) . '/' . str_replace( '_', '-', $module_slug ) . '.php';
					}
				}
			}
		}
	}
	public function register_controls() {

		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/controls/image-selector.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/controls/foreground.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/controls/widget-area.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'inc/controls/select.php';

		\Elementor\Plugin::instance()->controls_manager->register( new Nour_Elementor_Image_Selector() );
		\Elementor\Plugin::instance()->controls_manager->register( new Nour_Elementor_Select() );
		\Elementor\Plugin::instance()->controls_manager->register( new Nour_Elementor_Widget_Area() );
		\Elementor\Plugin::instance()->controls_manager->add_group_control( Nour_Elementor_Group_Control_Foreground::get_type(), new Nour_Elementor_Group_Control_Foreground() );

	}
	public function nour_elementor_init() {
		Plugin::$instance->elements_manager->add_category(
			'nour-widgets',
			array(
				'title' => esc_html__( 'ابزارک های قالب', 'nour-elementor-addons' ),
				'icon'  => 'xi xi-nour',
			)
		);
	}
	public function add_custom_font_mimes( $mimes = array() ) {
		$mimes['otf']   = 'application/x-font-otf';
		$mimes['woff']  = 'application/x-font-woff';
		$mimes['woff2'] = 'application/x-font-woff2';
		$mimes['ttf']   = 'application/x-font-ttf';
		$mimes['eot']   = 'application/vnd.ms-fontobject';
		return $mimes;
	}
	public function admin_footer_text( $footer_text ) {
		$current_screen      = get_current_screen();
		$is_elementor_screen = ( $current_screen && false !== strpos( $current_screen->parent_base, 'nour-elementor-addons' ) );
		return $footer_text;
	}
	public function register_elementor_document_type( $documents_manager ) {
		if ( get_post_type() === 'nour_content' ) {
			update_post_meta( get_the_ID(), '_elementor_template_type', 'nour_content' );
		}
		if ( get_post_type() === 'nour-themer' ) {
			update_post_meta( get_the_ID(), '_elementor_template_type', 'nour-themer' );
		}
	}
	public function plugin_action_links( $links ) {
		$settings_link = sprintf( '<a href="%1$s">%2$s</a>', admin_url( 'admin.php?page=nour-elementor-addons' ), esc_html__( 'تنظیمات', 'nour-elementor-addons' ) );
		array_unshift( $links, $settings_link );
		return $links;
	}
}
Nour_Elementor_Addons::instance();