<?php
use NourElementorAddons\Inc\Nour_Elementor_Widget_List;
$widgets_all    = Nour_Elementor_Widget_List::instance()->get_list();
$widgets_active = $this->utils->get_option( 'nour_elementor_widget_list', array_keys( $widgets_all ) );
$widgets_active = ( is_array( $widgets_active ) && ! isset( $widgets_active[0] ) && is_array( $widgets_active[0] ) ? array_keys( $widgets_active ) : $widgets_active );
?>
<div class="nour-dashboard-tab-content nour-dashboard-tab-widgets" id="nour-widgets">
	<div style="padding:20px; background: #ffffff; margin: 20px;" class="nour-dashboard-tab-content-inner">
		<div class="nour-dashboard-tab-content-header">
			<h2 class="nour-dashboard-tab-content-title">
				<?php echo esc_html__( 'ابزارک های قالب', 'nour-elementor-addons' ); ?>
			</h2>
		</div>
		<div class="nour-dashboard-item-wrapper">
			<div class="nour-row">
				<?php foreach ( $widgets_all as $widget => $widget_config ) : ?>
					<div class="nour-col-lg-4">
						<?php
						$this->utils->input(
							array(
								'type'    => 'switch',
								'name'    => 'nour_elementor_widget_list[]',
								'label'   => $widget_config['title'],
								'value'   => $widget,
								'attr'    => ( 'pro-disabled' !== $widget_config['package'] ? array() : array( 'disabled' => 'disabled' ) ),
								'class'   => 'nour-content-type-' . $widget_config['package'],
								'options' => array(
									'checked' => is_array( $widgets_active ) && ( in_array( $widget, $widgets_active, true ) && 'pro-disabled' !== $widget_config['package'] ),
								),
							)
						);
						?>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
			<button style="margin-top:15px;display: flex;align-items: center;column-gap: 5px;" class="button-primary nour-dashboard-save-button">
				<i class="dashicons dashicons-update"></i>
				<?php echo esc_html__( 'ذخیره تغییرات', 'nour-elementor-addons' ); ?>
			</button>
	</div>
</div>
