<?php
use NourElementorAddons\Inc\Nour_Elementor_Module_List;
$modules_all    = Nour_Elementor_Module_List::instance()->get_list();
$modules_active = $this->utils->get_option( 'nour_elementor_module_list', array_keys( $modules_all ) );
$modules_active = ( is_array( $modules_active ) && ! isset( $modules_active[0] ) ? array_keys( $modules_active ) : $modules_active );
?>
<div class="nour-dashboard-tab-content nour-dashboard-tab-modules" id="nour-modules">
	<div style="padding:20px; background: #ffffff; margin: 20px;" class="nour-dashboard-tab-content-inner">
		<div class="nour-dashboard-tab-content-header">
			<h2 class="nour-dashboard-tab-content-title">
				<?php echo esc_html__( 'امکانات پیشرفته المنتور', 'nour-elementor-addons' ); ?>
			</h2>
		</div>
		<div class="nour-dashboard-item-wrapper">
			<div class="nour-row">
				<?php
				foreach ( $modules_all as $module => $module_config ) :

					if ( ! did_action( 'nour_theme_builder_loaded' ) && 'undefined' === $module_config['package'] ) {
						continue;
					}
					?>
					<div class="nour-col-lg-4">
						<?php
						$this->utils->input(
							array(
								'type'    => 'switch',
								'name'    => 'nour_elementor_module_list[]',
								'label'   => $module_config['title'],
								'value'   => $module,
								'attr'    => ( 'pro-disabled' !== $module_config['package'] ? array() : array( 'disabled' => 'disabled' ) ),
								'class'   => 'nour-content-type-' . $module_config['package'],
								'options' => array(
									'checked' => is_array( $modules_active ) && ( in_array( $module, $modules_active, true ) && 'pro-disabled' !== $module_config['package'] ),
								),
							)
						);
						?>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
			<button style="margin-top:15px;display: flex;align-items: center;column-gap: 5px;" class="button-primary nour-dashboard-save-button">
				<i class="dashicons dashicons-update"></i>
				<?php echo esc_html__( 'ذخیره تغییرات', 'nour-elementor-addons' ); ?>
			</button>
	</div>
</div>