<?php
namespace NourElementorAddons\Libs;
use Nour_Elementor_Addons;
use NourElementorAddons\Libs\Dashboard\Classes;
class Nour_Elementor_Dashboard {
	private static $instance = null;
	public $utils;
	public function __construct() {
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'admin/dashboard/classes/utils.php';
		require_once NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'admin/dashboard/classes/ajax.php';

		$this->utils = Classes\Nour_Elementor_Dashboard_Utils::instance();
		new Classes\Nour_Elementor_Dashboard_Ajax();

		add_action( 'admin_menu', array( $this, 'register_settings_menus' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	public function enqueue_scripts() {
		if ( isset( $_GET['page'] ) && ( Nour_Elementor_Addons::PAGE_SLUG === $_GET['page'] || Nour_Elementor_Addons::LICENSE_PAGE_SLUG === $_GET['page'] ) ) {
			wp_enqueue_style(
			'nour-elementor-addons-admin',
			NOUR_ELEMENTOR_ADDONS_ASSETS . '/css/dashboard.css',
			'',
			NOUR_ELEMENTOR_ADDONS_VERSION
			);			
			wp_enqueue_style(
				'owl-carousel',
				NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/css/owl.carousel.min.css',
				'',
				'2.3.4'
			);
			wp_enqueue_style(
				'nour-elementor-addons-grid',
				NOUR_ELEMENTOR_ADDONS_ASSETS . '/css/nour-grid.min.css',
				'',
				NOUR_ELEMENTOR_ADDONS_VERSION
			);
			wp_enqueue_style(
				'nour-icons',
				NOUR_ELEMENTOR_ADDONS_ASSETS . 'css/nour-icons.min.css',
				null,
				NOUR_ELEMENTOR_ADDONS_VERSION
			);
			wp_enqueue_script(
				'owl-carousel',
				NOUR_ELEMENTOR_ADDONS_ASSETS . 'output/js/owl.carousel.min.js',
				array( 'jquery' ),
				'2.3.4',
				true
			);
			wp_enqueue_script(
				'theme-elementor-widgets-dashboard',
				NOUR_ELEMENTOR_ADDONS_ASSETS . 'dashboard.js',
				array( 'jquery' ),
				NOUR_ELEMENTOR_ADDONS_VERSION,
				true
			);			
		}
	}
	public function register_settings_menus() {
		add_menu_page(
			esc_html__( 'تنظیمات ابزارک های قالب', 'nour-elementor-addons' ),
			esc_html__( 'ابزارک ها', 'nour-elementor-addons' ),
			'manage_options',
			Nour_Elementor_Addons::PAGE_SLUG,
			array( $this, 'register_settings_contents' ),
			NOUR_ELEMENTOR_ADDONS_ASSETS . '/images/nour-icon.svg',
			'3'
		);
	}
	public function register_settings_contents() {

		include __DIR__ . '/views/settings-init.php';
	}
}
Nour_Elementor_Dashboard::instance();