<?php

namespace Noorgfx;

/*
add_action('noorgfx:customizer:load:before', function () {
	$_REQUEST['wp_customize'] = 'on';
	_wp_customize_include();

	global $wp_customize;

	$wp_customize->wp_loaded();
});
 */

/**
 * Manages Noorgfx theme extensions, tools, license activation, and starter site installation.
 *
 * ## EXAMPLES
 *
 *     # List all available extensions
 *     $ wp noorgfx extension list
 *
 *     # Activate an extension
 *     $ wp noorgfx extension activate custom-fonts
 *
 *     # Deactivate an extension
 *     $ wp noorgfx extension deactivate custom-fonts
 *
 *     # List all available tools
 *     $ wp noorgfx tool list
 *
 *     # Run a specific tool
 *     $ wp noorgfx tool run tool-name
 *
 *     # List all available demos
 *     $ wp noorgfx demo list
 *
 *     # Install a demo
 *     $ wp noorgfx demo install demo-name
 *
 *     # Activate license
 *     $ wp noorgfx license activate your-license-key
 *
 *     # Move all widgets to inactive area
 *     $ wp noorgfx widgets drop
 */
class Cli {
	public function __construct() {
		\WP_CLI::add_command('noorgfx', $this);

		new DemoCli();
		new ToolCli();
		new LicenseCli();
		new ExtensionCli();
		new WidgetsCli();
	}
}

