<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Noorgfx
 */

$maybe_custom_output = apply_filters(
	'noorgfx:posts-listing:canvas:custom-output',
	null
);

if ($maybe_custom_output) {
	echo $maybe_custom_output;
	return;
}

$container_class = 'ct-container';


/**
 * Note to code reviewers: This line doesn't need to be escaped.
 * Function noorgfx_output_hero_section() used here escapes the value properly.
 */
echo noorgfx_output_hero_section([
	'type' => 'type-2'
]);

$section_class = '';

if (! have_posts()) {
	$section_class = 'class="ct-no-results"';
}

?>

<div class="<?php echo $container_class ?>" <?php echo wp_kses_post(noorgfx_sidebar_position_attr()); ?> <?php echo noorgfx_get_v_spacing() ?>>
	<section <?php echo $section_class ?>>
		<?php
			/**
			 * Note to code reviewers: This line doesn't need to be escaped.
			 * Function noorgfx_output_hero_section() used here
			 * escapes the value properly.
			 */
			echo noorgfx_output_hero_section([
				'type' => 'type-1'
			]);

			echo noorgfx_render_archive_cards();
		?>
	</section>

	<?php get_sidebar(); ?>
</div>
