import { __ } from 'ct-i18n'

export const getDefaultFonts = ({ isDefault }) => ({
	system: {
		type: 'system',
		families: [
			...(!isDefault ? ['Default'] : []),
			'System Default',
			'DanaFN',
			'IRsans',
			'Shabnam-Normal',
			'Vazir-Normal',
			'PinarBlack',
			'Morabba',
			'Morabba-Black',
			'Anjoman',
			'Aviny',
			'Iranyk',
			'Iranyk-Light',
			'Estedad-Light', 'Estedad-Regular', 'Estedad-Medium', 'Estedad-Bold', 'Estedad-Black',
			'Iranyk-Black',
		].map((family) => ({
			source: 'system',
			family,
			display:
				family === 'System Default'
					? __('System Default', 'noorgfx')
					: family,
			variations: [],
			all_variations: [
				...(family === 'Default' ? ['Default'] : []),
				'n1',
				'i1',
				'n2',
				'i2',
				'n3',
				'i3',
				'n4',
				'i4',
				'n5',
				'i5',
				'n6',
				'i6',
				'n7',
				'i7',
				'n8',
				'i8',
				'n9',
				'i9',
			],
		})),
	},
})
