import { createElement, createRoot } from '@wordpress/element'
import Notification from './Notification'
import $ from 'jquery'

export const mount = (el) => {
	if (el.querySelector('.notice-noorgfx-plugin-root')) {
		const root = createRoot(el.querySelector('.notice-noorgfx-plugin-root'))
		root.render(
			<Notification
				initialStatus={
					el.querySelector('.notice-noorgfx-plugin-root').dataset
						.pluginStatus
				}
				url={
					el.querySelector('.notice-noorgfx-plugin-root').dataset.url
				}
				pluginUrl={
					el.querySelector('.notice-noorgfx-plugin-root').dataset
						.pluginUrl
				}
				pluginLink={
					el.querySelector('.notice-noorgfx-plugin-root').dataset.link
				}
			/>
		)
	}

	;[...document.querySelectorAll('[data-dismiss]')].map((el) => {
		el.addEventListener('click', (e) => {
			e.preventDefault()

			el.closest('.notice-noorgfx-woo-deprecation').remove()

			$.ajax(ajaxurl, {
				type: 'POST',
				data: {
					action: 'noorgfx_dismissed_notice_woo_deprecation',
				},
			})
		})
	})
}
