<?php
/**
 * Sidebar helpers
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

add_filter('widget_nav_menu_args', function ($nav_menu_args) {
	$nav_menu_args['menu_class'] = 'widget-menu';
	return $nav_menu_args;
}, 10, 1);

add_action(
	'dynamic_sidebar_before',
	function () {
		ob_start();
	}
);

add_action(
	'dynamic_sidebar_after',
	function () {
		$text = preg_replace(
			'/<div class="ct-widget[^>]*><\\/div[^>]*>/',
			'',
			ob_get_clean()
		);

		echo $text;
	}
);

if (! function_exists('noorgfx_sidebar_position_attr')) {
	function noorgfx_sidebar_position_attr($args = []) {
		$args = wp_parse_args(
			$args,
			[
				'attr_id' => 'data-sidebar',
				'array' => false
			]
		);

		if ($args['array']) {
			if (noorgfx_sidebar_position() !== 'none') {
				return [
					$args['attr_id'] => noorgfx_sidebar_position()
				];
			} else {
				return [];
			}
		}

		return (
			noorgfx_sidebar_position() === 'none'
		) ? '' : $args['attr_id'] . '="' . noorgfx_sidebar_position() . '"';
	}
}

if (! function_exists('noorgfx_get_single_page_structure')) {
	function noorgfx_get_single_page_structure() {
		$default_page_structure = noorgfx_default_akg(
			'page_structure_type',
			noorgfx_get_post_options(),
			'default'
		);

		if ($default_page_structure !== 'default') {
			return $default_page_structure;
		}

		$prefix = noorgfx_manager()->screen->get_prefix();

		$result = 'none';

		if (
			! is_singular()
			&&
			$prefix !== 'bbpress_single'
			&&
			$prefix !== 'buddypress_single'
			&&
			(
				$prefix !== 'courses_archive'
				&&
				function_exists('tutor')
				||
				! function_exists('tutor')
			)
			&&
			(
				$prefix !== 'tribe_events_archive'
				&&
				class_exists('Tribe__Events__Main')
				||
				! class_exists('Tribe__Events__Main')
			)
		) {
			$result = 'none';
		} else {
			$default_structure = ($prefix === 'single_blog_post') ? 'type-3' : 'type-4';

			if ($prefix === 'courses_single' && function_exists('tutor')) {
				$default_structure = 'type-1';
			}

			$result = noorgfx_get_theme_mod($prefix . '_structure', $default_structure);

			if ($prefix === 'courses_single' && function_exists('tutor')) {
				$current_template = noorgfx_manager()->get_current_template();

				if ($current_template !== tutor_get_template('single-course')) {
					$result = 'type-4';
				}
			}
		}

		if ($prefix === 'lms') {
			$result = 'none';
		}

		return apply_filters('noorgfx:global:page_structure', $result);
	}
}

if (! function_exists('noorgfx_sidebar_position')) {
	function noorgfx_sidebar_position() {
		return apply_filters(
			'noorgfx:general:sidebar-position',
			noorgfx_sidebar_position_unfiltered()
		);
	}
}

if (! function_exists('noorgfx_sidebar_position_unfiltered')) {
	function noorgfx_sidebar_position_unfiltered($prefix = null) {
		$prefix = noorgfx_manager()->screen->get_prefix();

		if ($prefix === 'lms') {
			return 'right';
		}

		global $noorgfx_template_output;

		if (
			isset($noorgfx_template_output)
			&&
			$noorgfx_template_output
		) {
			$page_structure_type = noorgfx_get_single_page_structure();

			if ('type-1' === $page_structure_type) {
				return 'right';
			}

			if ('type-2' === $page_structure_type) {
				return 'left';
			}

			return 'none';
		}

		$is_dokan_store = (
			class_exists('WeDevs_Dokan')
			&&
			function_exists('dokan_is_store_page')
			&&
			dokan_is_store_page()
		);

		if ($is_dokan_store) {
			return 'none';
		}

		if (! $prefix) {
			return 'none';
		}

		$blog_post_structure = noorgfx_listing_page_structure([
			'prefix' => $prefix
		]);

		$allows_custom_sidebar = (
			$prefix !== 'courses_archive'
			&&
			function_exists('tutor')
			||
			! function_exists('tutor')
		) && (
			$prefix !== 'tribe_events_archive'
			&&
			class_exists('Tribe__Events__Main')
			||
			! class_exists('Tribe__Events__Main')
		);

		if (
			strpos($prefix, '_archive') !== false
			||
			$prefix === 'search'
			||
			$prefix === 'categories'
			||
			$prefix === 'author'
			||
			$prefix === 'blog'
			||
			$prefix === 'woo_categories'
		) {
			if ($allows_custom_sidebar) {
				if (
					noorgfx_get_theme_mod($prefix . '_has_sidebar', 'no') === 'no'
					||
					$blog_post_structure === 'gutenberg'
				) {
					return 'none';
				}

				return noorgfx_get_theme_mod($prefix . '_sidebar_position', 'right');
			}
		}

		if (
			$prefix !== 'single_page'
			&&
			$prefix !== 'single_blog_post'
			&&
			$prefix !== 'product'
			&&
			strpos($prefix, '_single') === false
			&&
			$allows_custom_sidebar
		) {
			return 'right';
		}

		$page_structure_type = noorgfx_get_single_page_structure();

		if ('type-1' === $page_structure_type) {
			return 'right';
		}

		if ('type-2' === $page_structure_type) {
			return 'left';
		}

		return 'none';
	}
}

if (! function_exists('noorgfx_get_page_structure')) {
	function noorgfx_get_page_structure() {
		$page_structure_type = noorgfx_get_single_page_structure();

		if ('type-3' === $page_structure_type) {
			return 'narrow';
		}

		if (
			$page_structure_type === 'type-4'
			||
			$page_structure_type === 'type-5'
		) {
			return 'normal';
		}

		return 'none';
	}
}

