<?php

if (! function_exists('noorgfx_switch_theme')) {
	function noorgfx_switch_theme() {
		switch_theme( WP_DEFAULT_THEME );
		unset( $_GET['activated'] );
		add_action( 'admin_notices', 'noorgfx_upgrade_notice' );
	}
}
add_action( 'after_switch_theme', 'noorgfx_switch_theme' );

if (! function_exists('noorgfx_upgrade_notice')) {
	function noorgfx_upgrade_notice() {
		$message = noorgfx_safe_sprintf(
			// translators: placeholder here is the actual PHP version.
			__( 'Noorgfx requires at least PHP version 5.7.0. You are running version %s. Please upgrade and try again.', 'noorgfx' ),
			PHP_VERSION
		);

		printf( '<div class="error"><p>%s</p></div>', wp_kses_post($message) );
	}
}

if (! function_exists('noorgfx_customize')) {
	function noorgfx_customize() {
		wp_die( noorgfx_safe_sprintf(
			// translators: placeholder here is the actual PHP version.
			esc_html(__( 'Noorgfx requires at least PHP version 5.7.0. You are running version %s. Please upgrade and try again.', 'noorgfx' )),
			PHP_VERSION
		), '', array(
			'back_link' => true,
		) );
	}
}
add_action( 'load-customize.php', 'noorgfx_customize' );

if (! function_exists('noorgfx_preview')) {
	function noorgfx_preview() {
		if ( isset( $_GET['preview'] ) ) {
			wp_die( noorgfx_safe_sprintf(
				// translators: placeholder here is the actual PHP version.
				esc_html(__( 'Noorgfx requires at least PHP version 5.7.0. You are running version %s. Please upgrade and try again.', 'noorgfx' )),
				PHP_VERSION
			) );
		}
	}
}
add_action( 'template_redirect', 'noorgfx_preview' );
