<?php

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'mobile_menu_trigger_type' => [
				'label' => false,
				'type' => 'ct-image-picker',
				'value' => 'type-1',
				'attr' => [
					'data-columns' => '3',
					'data-ratio' => '2:1',
				],
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [

					'type-1' => [
						'src'   => noorgfx_image_picker_file( 'trigger-1' ),
						'title' => __( 'Type 1', 'noorgfx' ),
					],

					'type-2' => [
						'src'   => noorgfx_image_picker_file( 'trigger-2' ),
						'title' => __( 'Type 2', 'noorgfx' ),
					],

					'type-3' => [
						'src'   => noorgfx_image_picker_file( 'trigger-3' ),
						'title' => __( 'Type 3', 'noorgfx' ),
					],
				],
			],

			'trigger_icon_size' => [
				'label' => __( 'Icon Size', 'noorgfx' ),
				'type' => 'ct-slider',
				'min' => 5,
				'max' => 50,
				'value' => 18,
				'divider' => 'top',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'trigger_icon_visibility' => [
				'label' => __('Icon Visibility', 'noorgfx'),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top',
				'allow_empty' => true,
				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __('Desktop', 'noorgfx'),
					'tablet' => __('Tablet', 'noorgfx'),
					'mobile' => __('Mobile', 'noorgfx'),
				]),
			],

			'trigger_design' => [
				'type' => 'ct-radio',
				'label' => __( 'Style', 'noorgfx' ),
				'value' => 'simple',
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top:full',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'simple' => __( 'Simple', 'noorgfx' ),
					'outline' => __( 'Outline', 'noorgfx' ),
					'solid' => __( 'Solid', 'noorgfx' ),
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'trigger_design' => '!simple' ],
				'options' => [

					'trigger_icon_container_spacing' => [
						'label' => __( 'Container Spacing', 'noorgfx' ),
						'type' => 'ct-slider',
						'min' => 5,
						'max' => 50,
						'value' => 10,
						'divider' => 'top',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'trigger_label_visibility' => [
				'label' => __( 'Label Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'allow_empty' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_default_responsive_value([
					'desktop' => false,
					'tablet' => false,
					'mobile' => false,
				]),
				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx' ),
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'trigger_label_visibility/desktop' => true,
						'trigger_label_visibility/tablet' => true,
						'trigger_label_visibility/mobile' => true,
					]
				],
				'options' => [
					'trigger_label_alignment' => [
						'type' => 'ct-radio',
						'label' => __( 'Label Position', 'noorgfx' ),
						'value' => 'right',
						'view' => 'text',
						'divider' => 'top',
						'design' => 'block',
						'responsive' => [ 'tablet' => 'skip' ],
						'choices' => [
							'left' => __( 'Left', 'noorgfx' ),
							'right' => __( 'Right', 'noorgfx' ),
							'bottom' => __( 'Bottom', 'noorgfx' ),
						],
					],

					'trigger_label' => [
						'label' => __( 'Label Text', 'noorgfx' ),
						'type' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'value' => __( 'Menu', 'noorgfx' ),
						'responsive' => [
							'tablet' => 'skip'
						],
						'setting' => [ 'transport' => 'postMessage' ],
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'wp_customizer_current_view' => 'tablet|mobile' ],
				'options' => [

					'header_trigger_visibility' => [
						'label' => __( 'Element Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'divider' => 'top:full',
						'setting' => [ 'transport' => 'postMessage' ],
						'allow_empty' => true,
						'value' => noorgfx_default_responsive_value([
							'tablet' => true,
							'mobile' => true,
						]),
						'choices' => noorgfx_ordered_keys([
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
					],

				],
			],
		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'trigger_label_visibility/desktop' => true,
						'trigger_label_visibility/tablet' => true,
						'trigger_label_visibility/mobile' => true,
					]
				],
				'options' => [
					'trigger_label_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Label Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '12px',
							'variation' => 'n6',
							'text-transform' => 'uppercase',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Label Font Color', 'noorgfx' ),
						'responsive' => true,
						'choices' => [
							[
								'id' => 'header_trigger_font_color',
								'label' => __('Default State', 'noorgfx')
							],

							[
								'id' => 'transparent_header_trigger_font_color',
								'label' => __('Transparent State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'sticky_header_trigger_font_color',
								'label' => __('Sticky State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [
							'header_trigger_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-link-hover-color)'
									],
								],
							],

							'transparent_header_trigger_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],
								],
							],

							'sticky_header_trigger_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],
								],
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Icon Color', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'triggerIconColor',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentTriggerIconColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyTriggerIconColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'triggerIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-2)',
							],
						],
					],

					'transparentTriggerIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'stickyTriggerIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => [
					__('Border Color', 'noorgfx') => [
						'trigger_design' => 'outline'
					],

					__('Background Color', 'noorgfx') => [
						'trigger_design' => 'solid'
					]
				],
				'divider' => 'top',
				'responsive' => true,
				'choices' => [
					[
						'id' => 'triggerSecondColor',
						'label' => __('Default State', 'noorgfx'),
						'condition' => [ 'trigger_design' => '!simple' ],
					],

					[
						'id' => 'transparentTriggerSecondColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'trigger_design' => '!simple',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyTriggerSecondColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'trigger_design' => '!simple',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'triggerSecondColor' => [
						'label' => __( 'Trigger Border Color', 'noorgfx' ),
						'label' => [
							__('Border Color', 'noorgfx') => [
								'trigger_design' => 'outline'
							],

							__('Background Color', 'noorgfx') => [
								'trigger_design' => 'solid'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'rgba(224, 229, 235, 0.9)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'rgba(224, 229, 235, 0.9)'
							],
						],
					],

					'transparentTriggerSecondColor' => [
						'label' => __( 'Trigger Border Color', 'noorgfx' ),
						'label' => [
							__('Border Color', 'noorgfx') => [
								'trigger_design' => 'outline'
							],

							__('Background Color', 'noorgfx') => [
								'trigger_design' => 'solid'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'stickyTriggerSecondColor' => [
						'label' => __( 'Trigger Border Color', 'noorgfx' ),
						'label' => [
							__('Border Color', 'noorgfx') => [
								'trigger_design' => 'outline'
							],

							__('Background Color', 'noorgfx') => [
								'trigger_design' => 'solid'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'trigger_design' => '!simple' ],
				'options' => [

					'trigger_border_radius' => [
						'label' => __( 'Border Radius', 'noorgfx' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 3,
						'min' => 0,
						'max' => 100,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],


			'triggerMargin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true,
				'divider' => 'top'
			],

		],
	],
];
