<?php

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => array_merge(
			[
				'header_text' => [
					'label' => false,
					'type' => 'wp-editor',
					'value' => __( 'Sample text', 'noorgfx' ),
					'desc' => __( 'You can add here some arbitrary HTML code.', 'noorgfx' ),
					'divider' => 'bottom:full',
					'disableRevertButton' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'tinymce' => apply_filters(
						'noorgfx:' . $panel_type . ':text:tinymce:settings',
						[]
					),
				],

				'has_header_text_full_width' => [
					'label' => __( 'Stretch Container', 'noorgfx' ),
					'desc' => __( 'Allow the item container to expand and fill in all the available space.', 'noorgfx' ),
					'type' => 'ct-switch',
					'value' => 'no',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'has_header_text_full_width' => 'yes' ],
					'options' => [

						'headerTextMaxWidth' => [
							'label' => __( 'Max Width', 'noorgfx' ),
							'type' => 'ct-slider',
							'min' => 10,
							'max' => 100,
							'value' => [
								'mobile' => '100',
								'tablet' => '100',
								'desktop' => '100',
							],
							'defaultUnit' => '%',
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],

					],
				]

			], $panel_type === 'header' ? [
				'header_html_horizontal_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Content Alignment', 'noorgfx' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'responsive' => true,
					'attr' => [ 'data-type' => 'alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'left' => '',
						'center' => '',
						'right' => '',
					],
				],

			] : [],

			$panel_type === 'footer' ? [

				'footer_html_horizontal_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Horizontal Alignment', 'noorgfx' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'responsive' => true,
					'attr' => [ 'data-type' => 'alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'footer_html_vertical_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Vertical Alignment', 'noorgfx' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top',
					'responsive' => true,
					'attr' => [ 'data-type' => 'vertical-alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'footer_visibility' => [
					'label' => __('Element Visibility', 'noorgfx'),
					'type' => 'ct-visibility',
					'design' => 'block',
					'divider' => 'top',
					'sync' => 'live',
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),
					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx' ),
						'tablet' => __( 'Tablet', 'noorgfx' ),
						'mobile' => __( 'Mobile', 'noorgfx' ),
					]),
				]
			] : [],

			[
				'user_visibility' => [
					'label' => __( 'User Visibility', 'noorgfx' ),
					'type' => 'ct-checkboxes',
					'design' => 'block',
					'view' => 'text',
					'divider' => 'top:full',
					'value' => [
						'logged_in' => true,
						'logged_out' => true,
					],
					'choices' => noorgfx_ordered_keys([
						'logged_in' => __( 'Logged In', 'noorgfx' ),
						'logged_out' => __( 'Logged Out', 'noorgfx' ),
					]),
				]
			]
		)
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'headerTextFont' => [
				'type' => 'ct-typography',
				'label' => __( 'Font', 'noorgfx' ),
				'value' => noorgfx_typography_default_values([
					'size' => '15px',
					'line-height' => '1.3',
				]),
				'setting' => [ 'transport' => 'postMessage' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Font Color', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerTextColor',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderTextColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderTextColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerTextColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_initial' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Text Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Link Initial', 'noorgfx' ),
								'id' => 'link_initial',
								'inherit' => 'var(--theme-link-initial-color)'
							],

							[
								'title' => __( 'Link Hover', 'noorgfx' ),
								'id' => 'link_hover',
								'inherit' => 'var(--theme-link-hover-color)'
							],
						],
					],

					'transparentHeaderTextColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_initial' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Text Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Link Initial', 'noorgfx' ),
								'id' => 'link_initial',
							],

							[
								'title' => __( 'Link Hover', 'noorgfx' ),
								'id' => 'link_hover',
							],
						],
					],

					'stickyHeaderTextColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_initial' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Text Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Link Initial', 'noorgfx' ),
								'id' => 'link_initial',
							],

							[
								'title' => __( 'Link Hover', 'noorgfx' ),
								'id' => 'link_hover',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Heading Color', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerTextHeadingColor',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderTextHeadingColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderTextHeadingColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerTextHeadingColor' => [
						'label' => __( 'Heading Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial Color', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-headings-color)'
							],
						],
					],

					'transparentHeaderTextHeadingColor' => [
						'label' => __( 'Heading Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial Color', 'noorgfx' ),
								'id' => 'default',
							],
						],
					],

					'stickyHeaderTextHeadingColor' => [
						'label' => __( 'Heading Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial Color', 'noorgfx' ),
								'id' => 'default',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'headerTextMargin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],
];

if ($panel_type === 'header') {
	$options[noorgfx_rand_md5()] = [
		'type' => 'ct-condition',
		'condition' => [
			'wp_customizer_current_view' => 'tablet|mobile'
		],
		'options' => [
			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'visibility' => [
				'label' => __( 'Element Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'setting' => [ 'transport' => 'postMessage' ],
				'allow_empty' => true,
				'value' => noorgfx_default_responsive_value([
					'tablet' => true,
					'mobile' => true,
				]),
				'choices' => noorgfx_ordered_keys([
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

		],
	];
}
