<?php

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'header_socials' => [
				'label' => false,
				'type' => 'ct-layers',
				'manageable' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => [
					[
						'id' => 'facebook',
						'enabled' => true,
					],

					[
						'id' => 'twitter',
						'enabled' => true,
					],

					[
						'id' => 'instagram',
						'enabled' => true,
					],
				],

				'settings' => apply_filters(
					'noorgfx:socials:options:icon',
					noorgfx_get_social_networks_list()
				),
				'desc' => noorgfx_safe_sprintf(
					// translators: placeholder here means the actual URL.
					__( 'Configure the social links in General ➝ %sSocial Network Accounts%s.', 'noorgfx' ),
					noorgfx_safe_sprintf(
						'<a data-trigger-section="general:social_section_options" href="%s">',
						admin_url('/customize.php?autofocus[section]=general&ct_autofocus=general:social_section_options')
					),
					'</a>'
				),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'link_target' => [
				'type'  => 'ct-switch',
				'label' => __( 'Open links in new tab', 'noorgfx' ),
				'value' => 'no',
			],

			'link_nofollow' => [
				'type'  => 'ct-switch',
				'label' => __( 'Set links to nofollow', 'noorgfx' ),
				'value' => 'no',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'socialsIconSize' => [
				'label' => __( 'Icons Size', 'noorgfx' ),
				'type' => 'ct-slider',
				'min' => 5,
				'max' => 50,
				'value' => 15,
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'socialsIconSpacing' => [
				'label' => __( 'Icons Spacing', 'noorgfx' ),
				'type' => 'ct-slider',
				'min' => 0,
				'max' => 50,
				'value' => 15,
				'responsive' => true,
				'divider' => 'bottom',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'headerSocialsColor' => [
				'label' => __('Icons Color', 'noorgfx'),
				'type' => 'ct-radio',
				'value' => 'custom',
				'view' => 'text',
				'design' => 'block',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'custom' => __( 'Custom', 'noorgfx' ),
					'official' => __( 'Official', 'noorgfx' ),
				],
			],

			'socialsType' => [
				'label' => __('Icons Shape Type', 'noorgfx'),
				'type' => 'ct-radio',
				'value' => 'simple',
				'view' => 'text',
				'design' => 'block',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'simple' => __( 'None', 'noorgfx' ),
					'rounded' => __( 'Rounded', 'noorgfx' ),
					'square' => __( 'Square', 'noorgfx' ),
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'socialsType' => '!simple' ],
				'options' => [

					'socialsFillType' => [
						'label' => __('Shape Fill Type', 'noorgfx'),
						'type' => 'ct-radio',
						'value' => 'outline',
						'view' => 'text',
						'design' => 'block',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'outline' => __( 'Outline', 'noorgfx' ),
							'solid' => __( 'Solid', 'noorgfx' ),
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'socialsLabelVisibility' => [
				'label' => __( 'Label Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'allow_empty' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_default_responsive_value([
					'desktop' => false,
					'tablet' => false,
					'mobile' => false,
				]),
				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx' ),
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'wp_customizer_current_view' => 'tablet|mobile' ],
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

					'visibility' => [
						'label' => __( 'Element Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'setting' => [ 'transport' => 'postMessage' ],
						'allow_empty' => true,
						'value' => noorgfx_default_responsive_value([
							'tablet' => true,
							'mobile' => true,
						]),
						'choices' => noorgfx_ordered_keys([
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
					],

				],
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'socialsLabelVisibility/desktop' => true,
						'socialsLabelVisibility/tablet' => true,
						'socialsLabelVisibility/mobile' => true,
					]
				],
				'options' => [

					'socials_label_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Label Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '12px',
							'variation' => 'n6',
							'text-transform' => 'uppercase',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Label Font Color', 'noorgfx' ),
						'responsive' => true,
						'choices' => [
							[
								'id' => 'header_socials_font_color',
								'label' => __('Default State', 'noorgfx'),
								'condition' => [
									'headerSocialsColor' => 'custom',
								],
							],

							[
								'id' => 'transparent_header_socials_font_color',
								'label' => __('Transparent State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'headerSocialsColor' => 'custom',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'sticky_header_socials_font_color',
								'label' => __('Sticky State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'headerSocialsColor' => 'custom',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [
							'header_socials_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-link-hover-color)'
									],
								],
							],

							'transparent_header_socials_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],
								],
							],

							'sticky_header_socials_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],
								],
							],
						],
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Icons Color', 'noorgfx' ),
				'responsive' => true,
				'divider' => 'top:full',
				'choices' => [
					[
						'id' => 'headerSocialsIconColor',
						'label' => __('Default State', 'noorgfx'),
						'condition' => [ 'headerSocialsColor' => 'custom' ],
					],

					[
						'id' => 'transparentHeaderSocialsIconColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'headerSocialsColor' => 'custom',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderSocialsIconColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'headerSocialsColor' => 'custom',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerSocialsIconColor' => [
						'label' => __( 'Icons Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top:full',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-2)'
							],
						],
					],

					'transparentHeaderSocialsIconColor' => [
						'label' => __( 'Icons Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top:full',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'stickyHeaderSocialsIconColor' => [
						'label' => __( 'Icons Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top:full',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => [
					__('Icons Background Color', 'noorgfx') => [
						'socialsFillType' => 'solid'
					],

					__('Icons Border Color', 'noorgfx') => [
						'socialsFillType' => 'outline'
					]
				],
				'responsive' => true,
				'divider' => 'top:full',
				'choices' => [
					[
						'id' => 'headerSocialsIconBackground',
						'label' => __('Default State', 'noorgfx'),
						'condition' => [
							'headerSocialsColor' => 'custom',
							'socialsType' => '!simple'
						],
					],

					[
						'id' => 'transparentHeaderSocialsIconBackground',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'headerSocialsColor' => 'custom',
							'socialsType' => '!simple',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderSocialsIconBackground',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'headerSocialsColor' => 'custom',
							'socialsType' => '!simple',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerSocialsIconBackground' => [
						'label' => [
							__('Icons Background Color', 'noorgfx') => [
								'socialsFillType' => 'solid'
							],

							__('Icons Border Color', 'noorgfx') => [
								'socialsFillType' => 'outline'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top:full',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => 'rgba(218, 222, 228, 0.3)',
							],

							'hover' => [
								'color' => 'var(--theme-palette-color-1)',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'transparentHeaderSocialsIconBackground' => [
						'label' => [
							__('Icons Background Color', 'noorgfx') => [
								'socialsFillType' => 'solid'
							],

							__('Icons Border Color', 'noorgfx') => [
								'socialsFillType' => 'outline'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top:full',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'stickyHeaderSocialsIconBackground' => [
						'label' => [
							__('Icons Background Color', 'noorgfx') => [
								'socialsFillType' => 'solid'
							],

							__('Icons Border Color', 'noorgfx') => [
								'socialsFillType' => 'outline'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top:full',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

				],
			],

			'headerSocialsMargin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true,
				'divider' => 'top:full',
			],

		],
	],

];
