<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

// Icon size
$socialsIconSize = noorgfx_akg( 'socialsIconSize', $atts, 15 );

if ($socialsIconSize !== 15) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'theme-icon-size',
		'value' => $socialsIconSize,
		'responsive' => true
	]);
}


// Icon spacing
$socialsIconSpacing = noorgfx_akg( 'socialsIconSpacing', $atts, 15 );

if ($socialsIconSpacing !== 15) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'items-spacing',
		'value' => $socialsIconSpacing,
		'responsive' => true
	]);
}

$has_label = (
	is_customize_preview()
	||
	noorgfx_some_device(noorgfx_default_akg(
		'socialsLabelVisibility',
		$atts,
		[
			'desktop' => false,
			'tablet' => false,
			'mobile' => false,
		]
	))
);

if ($has_label) {
	noorgfx_output_font_css([
		'font_value' => noorgfx_akg( 'socials_label_font', $atts,
			noorgfx_typography_default_values([
				'size' => '12px',
				'variation' => 'n6',
				'text-transform' => 'uppercase',
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-label'
			])
		)
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('header_socials_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => 'a'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => 'a'
					])
				),
				'variable' => 'theme-link-hover-color'
			],
		],
		'responsive' => true
	]);
}

// Icons custom color
noorgfx_output_colors([
	'value' => noorgfx_akg('headerSocialsIconColor', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,

	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '[data-color="custom"]'
			])),
			'variable' => 'theme-icon-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '[data-color="custom"]'
			])),
			'variable' => 'theme-icon-hover-color'
		]
	],

	'responsive' => true
]);

// Icons custom background
noorgfx_output_colors([
	'value' => noorgfx_akg('headerSocialsIconBackground', $atts),
	'default' => [
		'default' => [ 'color' => 'rgba(218, 222, 228, 0.3)' ],
		'hover' => [ 'color' => 'var(--theme-palette-color-1)' ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,

	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '[data-color="custom"]'
			])),
			'variable' => 'background-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '[data-color="custom"]'
			])),
			'variable' => 'background-hover-color'
		]
	],

	'responsive' => true
]);

// Margin
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'headerSocialsMargin',
		$atts,
		noorgfx_spacing_value()
	)
]);

// transparent state
if (isset($has_transparent_header) && $has_transparent_header) {

	if ($has_label) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('transparent_header_socials_font_color', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => 'a'
							]),
							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-link-initial-color'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => 'a'
							]),
							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-link-hover-color'
				],
			],
			'responsive' => true
		]);
	}

	// Icons custom color
	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentHeaderSocialsIconColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '[data-color="custom"]'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-icon-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '[data-color="custom"]'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-icon-hover-color'
			]
		],

		'responsive' => true
	]);

	// Icons custom background
	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentHeaderSocialsIconBackground', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '[data-color="custom"]'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'background-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '[data-color="custom"]'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'background-hover-color'
			]
		],

		'responsive' => true
	]);
}


// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {

	if ($has_label) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('sticky_header_socials_font_color', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => 'a'
							]),
							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-link-initial-color'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => 'a'
							]),
							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-link-hover-color'
				],
			],
			'responsive' => true
		]);
	}

	// Icons custom color
	noorgfx_output_colors([
		'value' => noorgfx_akg('stickyHeaderSocialsIconColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '[data-color="custom"]'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-icon-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '[data-color="custom"]'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-icon-hover-color'
			]
		],

		'responsive' => true
	]);

	// Icons custom background
	noorgfx_output_colors([
		'value' => noorgfx_akg('stickyHeaderSocialsIconBackground', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '[data-color="custom"]'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'background-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '[data-color="custom"]'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'background-hover-color'
			]
		],

		'responsive' => true
	]);
}
