<?php

$is_pro = function_exists('blc_site_has_feature') && blc_site_has_feature('base_pro');

$cpt_choices = [
	'post' => __('Posts', 'noorgfx'),
	'page' => __('Pages', 'noorgfx')
];

$cpt_options = [
	'post' => true,
	'page' => true
];

if (class_exists('WooCommerce')) {
	$cpt_choices['product'] = __('Products', 'noorgfx');
	$cpt_options['product'] = true;
}

$all_cpts = noorgfx_manager()->post_types->get_supported_post_types();

if (function_exists('is_bbpress')) {
	$all_cpts[] = 'forum';
	$all_cpts[] = 'topic';
	$all_cpts[] = 'reply';
}

if (class_exists('Tribe__Events__Main')) {
	$all_cpts[] = 'tribe_events';
}

foreach ($all_cpts as $single_cpt) {
	if (get_post_type_object($single_cpt)) {
		$cpt_choices[$single_cpt] = get_post_type_labels(
			get_post_type_object($single_cpt)
		)->singular_name;
	} else {
		$cpt_choices[$single_cpt] = ucfirst($single_cpt);
	}

	$cpt_options[$single_cpt] = false;
}

foreach ($cpt_choices as $cpt => $value) {
	$post_type_object = get_post_type_object($cpt);

	if ($post_type_object && isset($post_type_object->show_in_rest) && $post_type_object->show_in_rest) {
		continue;
	}

	unset($cpt_choices[$cpt]);
	unset($cpt_options[$cpt]);
}

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [
			apply_filters(
				'noorgfx:header:search:options:icon',
				[]
			),

			'searchHeaderIconSize' => [
				'label' => __( 'Icon Size', 'noorgfx' ),
				'type' => 'ct-slider',
				'min' => 5,
				'max' => 50,
				'value' => 15,
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'search_icon_visibility' => [
				'label' => __('Icon Visibility', 'noorgfx'),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top',
				'allow_empty' => true,
				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __('Desktop', 'noorgfx'),
					'tablet' => __('Tablet', 'noorgfx'),
					'mobile' => __('Mobile', 'noorgfx'),
				]),
			],

			'search_label_visibility' => [
				'label' => __( 'Label Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top:full',
				'allow_empty' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_default_responsive_value([
					'desktop' => false,
					'tablet' => false,
					'mobile' => false,
				]),
				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx' ),
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'search_label_visibility/desktop' => true,
						'search_label_visibility/tablet' => true,
						'search_label_visibility/mobile' => true,
					]
				],
				'options' => [
					'search_label_position' => [
						'type' => 'ct-radio',
						'label' => __( 'Label Position', 'noorgfx' ),
						'value' => 'left',
						'view' => 'text',
						'divider' => 'top',
						'design' => 'block',
						'responsive' => [ 'tablet' => 'skip' ],
						'choices' => [
							'left' => __( 'Left', 'noorgfx' ),
							'right' => __( 'Right', 'noorgfx' ),
							'bottom' => __( 'Bottom', 'noorgfx' ),
						],
					],

					'search_label' => [
						'label' => __( 'Label Text', 'noorgfx' ),
						'type' => 'text',
						'divider' => 'top',
						'design' => 'block',
						'value' => __( 'Search', 'noorgfx' ),
						'sync' => 'live',
						'responsive' => [
							'tablet' => 'skip'
						],
					],
				],
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'search_label_visibility/desktop' => true,
						'search_label_visibility/tablet' => true,
						'search_label_visibility/mobile' => true,
					]
				],
				'options' => [
					'search_label_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Label Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '12px',
							'variation' => 'n6',
							'text-transform' => 'uppercase',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Label Font Color', 'noorgfx' ),
						'responsive' => true,
						'choices' => [
							[
								'id' => 'header_search_font_color',
								'label' => __('Default State', 'noorgfx')
							],

							[
								'id' => 'transparent_header_search_font_color',
								'label' => __('Transparent State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'sticky_header_search_font_color',
								'label' => __('Sticky State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [
							'header_search_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-link-hover-color)'
									],
								],
							],

							'transparent_header_search_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],
								],
							],

							'sticky_header_search_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],
								],
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Icon Color', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'searchHeaderIconColor',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentSearchHeaderIconColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickySearchHeaderIconColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'searchHeaderIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-2)'
							],
						],
					],

					'transparentSearchHeaderIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'stickySearchHeaderIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],
				],
			],

			'headerSearchMargin' => [
				'label' => __( 'Icon Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-title',
		'label' => __( 'Search Results', 'noorgfx' ),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			[
				'header_search_placeholder' => [
					'label' => __( 'Placeholder Text', 'noorgfx' ),
					'type' => 'text',
					'design' => 'block',
					'value' => __( 'Search', 'noorgfx' ),
					'sync' => 'live'
				],

				'enable_live_results' => [
					'label' => __( 'Live Results', 'noorgfx' ),
					'type' => 'ct-switch',
					'value' => 'yes',
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'enable_live_results' => 'yes' ],
					'options' => [

						'searchHeaderImages' => [
							'label' => __( 'Live Results Images', 'noorgfx' ),
							'type' => 'ct-switch',
							'value' => 'yes',
							'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'search_through/product' => true ],
							'options' => [
								'searchHeaderProductPrice' => [
									'label' => __( 'Live Results Product Price', 'noorgfx' ),
									'type' => 'ct-switch',
									'value' => 'no',
									'divider' => 'top',
									'setting' => [ 'transport' => 'postMessage' ],
								],

								'searchHeaderProductStatus' => [
									'label' => __( 'Live Results Product Status', 'noorgfx' ),
									'type' => 'ct-switch',
									'value' => 'no',
									'divider' => 'top',
									'setting' => [ 'transport' => 'postMessage' ],
								],
							]
						],

					],
				],


				noorgfx_rand_md5() => [
					'type' => 'ct-title',
					'label' => __('Search Through Criteria', 'noorgfx'),
					'desc' => __(
						'Chose in which post types do you want to perform searches.',
						'noorgfx'
					)
				],

				'search_through' => [
					'label' => false,
					'type' => 'ct-checkboxes',
					'attr' => ['data-columns' => '2'],
					'disableRevertButton' => true,
					'choices' => noorgfx_ordered_keys($cpt_choices),
					'value' => $cpt_options
				],
			],

			$is_pro ? [
				'search_through_taxonomy' => [
					'label' => __('Search Through Taxonomies', 'noorgfx'),
					'type' => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
					'desc' => __('Search through taxonomies from selected custom post types.', 'noorgfx'),
				]
			] : []

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'searchHeaderModalFont' => [
				'type' => 'ct-typography',
				'label' => __( 'Font', 'noorgfx' ),
				'value' => noorgfx_typography_default_values([
					'size' => '14px',
					'variation' => 'n5',
					'line-height' => '1.4',
				]),
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'searchHeaderLinkColor' => [
				'label' => __( 'Font Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'divider' => 'bottom',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => '#ffffff',
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-link-hover-color)'
					],
				],
			],

			'searchHeaderInputColor' => [
				'label' => __( 'Input Font Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => '#ffffff',
					],

					'focus' => [
						'color' => '#ffffff',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Focus', 'noorgfx' ),
						'id' => 'focus',
					],
				],
			],

			'searchHeaderInputBorderColor' => [
				'label' => __( 'Input Border Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'divider' => 'bottom',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => 'rgba(255, 255, 255, 0.2)',
					],

					'focus' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Focus', 'noorgfx' ),
						'id' => 'focus',
						'inherit' => 'var(--theme-form-field-border-focus-color)'
					],
				],
			],

			'search_button_icon_color' => [
				'label' => __( 'Search Icon Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => 'rgba(255, 255, 255, 0.7)',
					],

					'hover' => [
						'color' => '#ffffff',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
					],
				],
			],

			'search_button_background_color' => [
				'label' => __( 'Search Button Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => 'var(--theme-palette-color-1)',
					],

					'hover' => [
						'color' => 'var(--theme-palette-color-1)',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
					],
				],
			],

			'searchHeaderBackground' => [
				'label' => __( 'Modal Background', 'noorgfx' ),
				'type'  => 'ct-background',
				'design' => 'inline',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_background_default_value([
					'backgroundColor' => [
						'default' => [
							'color' => 'rgba(18, 21, 25, 0.98)'
						],
					],
				])
			],

			'search_close_button_type' => [
				'label' => __('Close Button Type', 'noorgfx'),
				'type' => 'ct-select',
				'value' => 'type-1',
				'view' => 'text',
				'design' => 'inline',
				'divider' => 'top:full',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => noorgfx_ordered_keys(
					[
						'type-1' => __( 'Simple', 'noorgfx' ),
						'type-2' => __( 'Border', 'noorgfx' ),
						'type-3' => __( 'Background', 'noorgfx' ),
					]
				),
			],

			'search_close_button_icon_size' => [
				'label' => __( 'Icon Size', 'noorgfx' ),
				'type' => 'ct-number',
				'design' => 'inline',
				'value' => 12,
				'min' => 5,
				'max' => 50,
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'search_close_button_color' => [
				'label' => __( 'Icon Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
						'inherit' => 'rgba(255, 255, 255, 0.7)'
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => '#ffffff'
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'search_close_button_type' => 'type-2' ],
				'options' => [

					'search_close_button_border_color' => [
						'label' => __( 'Border Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'search_close_button_type' => 'type-3' ],
				'options' => [

					'search_close_button_shape_color' => [
						'label' => __( 'Background Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'search_close_button_type' => '!type-1' ],
				'options' => [

					'search_close_button_border_radius' => [
						'label' => __( 'Border Radius', 'noorgfx' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 5,
						'min' => 0,
						'max' => 100,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'wp_customizer_current_view' => 'tablet|mobile' ],
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'header_search_visibility' => [
				'label' => __( 'Element Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'setting' => [ 'transport' => 'postMessage' ],
				'allow_empty' => true,
				'value' => noorgfx_default_responsive_value([
					'tablet' => true,
					'mobile' => true,
				]),
				'choices' => noorgfx_ordered_keys([
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

		],
	],
];
