<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

// Icon size
$search_header_icon_size = noorgfx_akg('searchHeaderIconSize', $atts, 15);

if ($search_header_icon_size !== 15) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'theme-icon-size',
		'value' => $search_header_icon_size
	]);
}

// Icon color
noorgfx_output_colors([
	'value' => noorgfx_akg('searchHeaderIconColor', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-icon-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-icon-hover-color'
		],
	],
	'responsive' => true
]);

$has_label = (
	is_customize_preview()
	||
	noorgfx_some_device(noorgfx_default_akg(
		'search_label_visibility',
		$atts,
		[
			'desktop' => false,
			'tablet' => false,
			'mobile' => false,
		]
	))
);

if ($has_label) {
	noorgfx_output_font_css([
		'font_value' => noorgfx_akg( 'search_label_font', $atts,
			noorgfx_typography_default_values([
				'size' => '12px',
				'variation' => 'n6',
				'text-transform' => 'uppercase',
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-label'
			])
		)
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('header_search_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector($root_selector),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector($root_selector),
				'variable' => 'theme-link-hover-color'
			],
		],
		'responsive' => true
	]);
}

// transparent state
if (isset($has_transparent_header) && $has_transparent_header) {

	if ($has_label) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('transparent_header_search_font_color', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])),
					'variable' => 'theme-link-initial-color'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])),
					'variable' => 'theme-link-hover-color'
				],
			],
			'responsive' => true
		]);
	}

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentSearchHeaderIconColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'between',
					'to_add' => '[data-transparent-row="yes"]'
				])),
				'variable' => 'theme-icon-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'between',
					'to_add' => '[data-transparent-row="yes"]'
				])),
				'variable' => 'theme-icon-hover-color'
			],
		],
		'responsive' => true
	]);
}


// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {

	if ($has_label) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('sticky_header_search_font_color', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])),
					'variable' => 'theme-link-initial-color'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])),
					'variable' => 'theme-link-hover-color'
				],
			],
			'responsive' => true
		]);
	}

	noorgfx_output_colors([
		'value' => noorgfx_akg('stickySearchHeaderIconColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'between',
					'to_add' => '[data-sticky*="yes"]'
				])),
				'variable' => 'theme-icon-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'between',
					'to_add' => '[data-sticky*="yes"]'
				])),
				'variable' => 'theme-icon-hover-color'
			],
		],
		'responsive' => true
	]);
}

noorgfx_output_font_css([
	'font_value' => noorgfx_akg( 'searchHeaderModalFont', $atts,
		noorgfx_typography_default_values([
			'size' => '14px',
			'variation' => 'n5',
			'line-height' => '1.4',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		$root_selector[0] . ' #search-modal .ct-search-results'
	),
]);

// Links color
noorgfx_output_colors([
	'value' => noorgfx_akg('searchHeaderLinkColor', $atts),
	'default' => [
		'default' => [ 'color' => '#ffffff' ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-link-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-link-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('searchHeaderInputColor', $atts),
	'default' => [
		'default' => [ 'color' => '#ffffff' ],
		'focus' => [ 'color' => '#ffffff' ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-form-text-initial-color'
		],

		'focus' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-form-text-focus-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('searchHeaderInputBorderColor', $atts),
	'default' => [
		'default' => [ 'color' => 'rgba(255, 255, 255, 0.2)' ],
		'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-form-field-border-initial-color'
		],

		'focus' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-form-field-border-focus-color'
		],
	],
]);

// Search button colors
noorgfx_output_colors([
	'value' => noorgfx_akg('search_button_icon_color', $atts),
	'default' => [
		'default' => [ 'color' => 'rgba(255, 255, 255, 0.7)' ],
		'hover' => [ 'color' => '#ffffff' ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-button-text-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-button-text-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('search_button_background_color', $atts),
	'default' => [
		'default' => [ 'color' => 'var(--theme-palette-color-1)' ],
		'hover' => [ 'color' => 'var(--theme-palette-color-1)' ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-button-background-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-search-form'
			),
			'variable' => 'theme-button-background-hover-color'
		],
	],
]);


// Close button
$close_button_type = noorgfx_akg('search_close_button_type', $atts, 'type-1');

noorgfx_output_colors([
	'value' => noorgfx_akg('search_close_button_color', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,

	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-toggle-close'
			),
			'variable' => 'theme-icon-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-toggle-close:hover'
			),
			'variable' => 'theme-icon-color'
		]
	],
]);

if ($close_button_type === 'type-2') {
	noorgfx_output_colors([
		'value' => noorgfx_akg('search_close_button_border_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #search-modal .ct-toggle-close[data-type="type-2"]'
				),
				'variable' => 'toggle-button-border-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #search-modal .ct-toggle-close[data-type="type-2"]:hover'
				),
				'variable' => 'toggle-button-border-color'
			]
		],
	]);
}

if ($close_button_type === 'type-3') {
	noorgfx_output_colors([
		'value' => noorgfx_akg('search_close_button_shape_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #search-modal .ct-toggle-close[data-type="type-3"]'
				),
				'variable' => 'toggle-button-background'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #search-modal .ct-toggle-close[data-type="type-3"]:hover'
				),
				'variable' => 'toggle-button-background'
			]
		],
	]);
}

$search_close_button_icon_size = noorgfx_akg( 'search_close_button_icon_size', $atts, 12 );

if ($search_close_button_icon_size !== 12) {
	$css->put(
		noorgfx_assemble_selector(
			$root_selector[0] . ' #search-modal .ct-toggle-close'
		),
		'--theme-icon-size: ' . $search_close_button_icon_size . 'px'
	);
}


if ($close_button_type !== 'type-1') {
	$search_close_button_border_radius = noorgfx_akg( 'search_close_button_border_radius', $atts, 5 );

	if ($search_close_button_border_radius !== 5) {
		$css->put(
			noorgfx_assemble_selector(
				$root_selector[0] . ' #search-modal .ct-toggle-close'
			),
			'--toggle-button-radius: ' . $search_close_button_border_radius . 'px'
		);
	}
}

// Modal background
noorgfx_output_background_css([
	'selector' => noorgfx_assemble_selector(
		$root_selector[0] . ' #search-modal'
	),
	'css' => $css,
	'value' => noorgfx_akg('searchHeaderBackground', $atts,
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => 'rgba(18, 21, 25, 0.98)'
				],
			],
		])
	)
]);


// Icon margin
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'headerSearchMargin',
		$atts,
		noorgfx_spacing_value()
	)
]);
