<?php

$options = [

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [
			[
				'custom_logo' => [
					'label' => __( 'Logo', 'noorgfx' ),
					'type' => 'ct-image-uploader',
					'value' => noorgfx_get_theme_mod('custom_logo', ''),
					'inline_value' => true,
					'responsive' => [
						'tablet' => 'skip'
					],
					'attr' => [ 'data-type' => 'small' ],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'custom_logo:truthy' => 'yes',
						'all' => [
							'builderSettings/has_transparent_header' => 'yes',
							'transparent_logo:truthy' => 'yes',
						]
					]
				],
				'options' => [
					apply_filters(
						'noorgfx:panel-builder:offcanvas-logo:options:general',
						[],
						$panel_type
					),
				]
			],

			'off_canvas_logo_max_height' => [
				'label' => __( 'Logo Height', 'noorgfx' ),
				'type' => 'ct-slider',
				'divider' => 'top:full',
				'min' => 0,
				'max' => 300,
				'value' => 50,
				'responsive' => true,
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'has_svg_logo' => 'yes'
				],
				'computed_fields' => ['has_svg_logo'],
				'options' => [
					'inline_svg_logos' => [
						'label' => __('Inline SVG File', 'noorgfx'),
						'type' => 'ct-switch',
						'value' => 'no',
						'divider' => 'top:full',
					]
				]
			],
		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'off_canvas_logo_margin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],

];
