<?php

$options = [
	'menu' => [
		'label' => __('Select Menu', 'noorgfx'),
		'type' => 'ct-select',
		'value' => 'noorgfx_location',
		'view' => 'text',
		'design' => 'inline',
		'setting' => [ 'transport' => 'postMessage' ],
		'placeholder' => __('Select menu...', 'noorgfx'),
		'choices' => noorgfx_ordered_keys(noorgfx_get_menus_items()),
		'desc' => noorgfx_safe_sprintf(
			// translators: placeholder here means the actual URL.
			__( 'Manage your menus in the %sMenus screen%s.', 'noorgfx' ),
			noorgfx_safe_sprintf(
				'<a href="%s" target="_blank">',
				admin_url('/nav-menus.php')
			),
			'</a>'
		),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'row' => 'offcanvas' ],
				'options' => [

					'mobile_menu_interactive' => [
						'label' => __( 'Interactive Collapse', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'yes',
						'setting' => [ 'transport' => 'postMessage' ],
						'desc' => __('This option will collapse/expand the sub menu items on click/touch.', 'noorgfx'),
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'mobile_menu_interactive' => 'yes' ],
						'options' => [

							'mobile_menu_type' => [
								'label' => __( 'Dropdown Toggle Icon', 'noorgfx' ),
								'type' => 'ct-image-picker',
								'value' => 'type-1',
								'divider' => 'top',
								'attr' => [
									'data-type' => 'background',
									'data-columns' => '3',
								],
								'setting' => [ 'transport' => 'postMessage' ],
								'choices' => [
									'type-1' => [
										'src'   => noorgfx_image_picker_file( 'mobile-toggle-type-1' ),
										'title' => __( 'Type 1', 'noorgfx' ),
									],

									'type-2' => [
										'src'   => noorgfx_image_picker_file( 'mobile-toggle-type-2' ),
										'title' => __( 'Type 2', 'noorgfx' ),
									],

									'type-3' => [
										'src'   => noorgfx_image_picker_file( 'mobile-toggle-type-3' ),
										'title' => __( 'Type 3', 'noorgfx' ),
									],
								],
							],

							'mobile_menu_toggle_shape' => [
								'label' => __('Dropdown Toggle Shape', 'noorgfx'),
								'type' => 'ct-radio',
								'value' => 'type-1',
								'view' => 'text',
								'design' => 'block',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
								'choices' => [
									'type-1' => __( 'Simple', 'noorgfx' ),
									'type-2' => __( 'Border', 'noorgfx' ),
								],
							],

						],
					],

					'mobile_menu_submenu_dots' => [
						'label' => __( 'Submenu Dots', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'yes',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'mobile_menu_items_spacing' => [
						'label' => __( 'Items Vertical Spacing', 'noorgfx' ),
						'type' => 'ct-slider',
						'min' => 0,
						'max' => 50,
						'value' => 5,
						'responsive' => true,
						'divider' => 'top:full',
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'row' => '!offcanvas' ],
				'options' => [

					'inline_menu_items_spacing' => [
						'label' => __( 'Items Spacing', 'noorgfx' ),
						'type' => 'ct-slider',
						'value' => 25,
						'min' => 5,
						'max' => 100,
						'divider' => 'top',
						'responsive' => [
							'desktop' => 'skip'
						],
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'inline_menu_stretch_menu' => [
						'label' => __( 'Stretch Menu', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'no',
						'divider' => 'top',
						'desc' => __('Enabling this option will make the menu to stretch and fit the width of its parent column. ', 'noorgfx'),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'inline_menu_horizontal_alignment' => [
						'type' => 'ct-radio',
						'label' => __( 'Horizontal Alignment', 'noorgfx' ),
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'responsive' => [
							'desktop' => 'skip'
						],
						'attr' => [ 'data-type' => 'alignment' ],
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => 'CT_CSS_SKIP_RULE',
						'choices' => [
							'flex-start' => '',
							'center' => '',
							'flex-end' => '',
						],
					],

					'inline_menu_visibility' => [
						'label' => __( 'Element Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'divider' => 'top:full',
						'setting' => [ 'transport' => 'postMessage' ],
						'allow_empty' => true,
						'value' => noorgfx_default_responsive_value([
							'tablet' => true,
							'mobile' => true,
						]),
						'choices' => noorgfx_ordered_keys([
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
					],

				],
			],


		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'row' => 'offcanvas' ],
				'options' => [

					'mobileMenuFont' => [
						'type' => 'ct-typography',
						'label' => __( 'Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '20px',
							'variation' => 'n7',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'mobileMenuColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => '#ffffff',
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-link-hover-color)'
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'self:hover'
							],
						],
					],

					'mobileMenuDropdownFont' => [
						'type' => 'ct-typography',
						'label' => __( 'Dropdown Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([]),
						'setting' => [ 'transport' => 'postMessage' ],
						'divider' => 'top',
					],

					'mobileMenuDropdownColor' => [
						'label' => __( 'Dropdown Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								// 'inherit' => 'var(--theme-link-hover-color)'
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'self:hover'
							],
						],
					],

					'mobile_menu_items_divider' => [
						'label' => __( 'Items Divider', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'inline',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => 'rgba(255, 255, 255, 0.2)',
							],
						]
					],

					'mobileMenuMargin' => [
						'label' => __( 'Container Margin', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_spacing_value([
							'left' => 'auto',
							'right' => 'auto',
						]),
						'responsive' => true
					],

				],
			],


			// inline menu
			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'row' => '!offcanvas' ],
				'options' => [

					'inline_mobile_menu_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '12px',
							'variation' => 'n7',
							'line-height' => '1.3',
							'text-transform' => 'uppercase',
						]),
						'typography_responsive' => [
							'desktop' => false,
							'tablet' => true,
							'mobile' => true,
						],
						'setting' => [ 'transport' => 'postMessage' ],
					],


					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Font Color', 'noorgfx' ),
						'responsive' => false,
						'choices' => [
							[
								'id' => 'inline_menu_font_color',
								'label' => __('Default State', 'noorgfx')
							],

							[
								'id' => 'transparent_inline_menu_font_color',
								'label' => __('Transparent State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'sticky_inline_menu_font_color',
								'label' => __('Sticky State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [

							'inline_menu_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => 'var(--theme-text-color)',
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'active' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-link-hover-color)',
									],

									[
										'title' => __( 'Active', 'noorgfx' ),
										'id' => 'active',
										'inherit' => 'self:hover'
									],
								],
							],

							'transparent_inline_menu_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'active' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],

									[
										'title' => __( 'Active', 'noorgfx' ),
										'id' => 'active',
										'inherit' => 'self:hover'
									],
								],
							],

							'sticky_inline_menu_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'active' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],

									[
										'title' => __( 'Active', 'noorgfx' ),
										'id' => 'active',
										'inherit' => 'self:hover'
									],
								],
							],

						],
					],

					'inline_menu_margin' => [
						'label' => __( 'Margin', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_spacing_value()
					],

				],
			],

		],
	],
];
