<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

// off canvas menu styles
if (isset($row_id) && $row_id === 'offcanvas') {

	$mobile_menu_items_spacing = noorgfx_akg('mobile_menu_items_spacing', $atts, 5);

	if ($mobile_menu_items_spacing !== 5) {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_assemble_selector($root_selector),
			'variableName' => 'items-vertical-spacing',
			'value' => $mobile_menu_items_spacing
		]);
	}

	noorgfx_output_font_css([
		'font_value' => noorgfx_akg('mobileMenuFont', $atts,
		noorgfx_typography_default_values([
			'size' => '20px',
			'variation' => 'n7',
		])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector)
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('mobileMenuColor', $atts),
		'default' => [
			'default' => [ 'color' => '#ffffff' ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector($root_selector),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector($root_selector),
				'variable' => 'theme-link-hover-color'
			],

			'active' => [
				'selector' => noorgfx_assemble_selector($root_selector),
				'variable' => 'theme-link-active-color'
			],
		],
	]);

	noorgfx_output_font_css([
		'font_value' => noorgfx_akg('mobileMenuDropdownFont', $atts,
			noorgfx_typography_default_values([])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.sub-menu'
		])),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('mobileMenuDropdownColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.sub-menu'
				])),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.sub-menu'
				])),
				'variable' => 'theme-link-hover-color'
			],

			'active' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.sub-menu'
				])),
				'variable' => 'theme-link-active-color'
			],
		],
	]);

	noorgfx_output_border([
		'css' => $css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'mobile-menu-divider',
		'value' => noorgfx_akg('mobile_menu_items_divider', $atts),
		'default' => [
			'width' => 1,
			'style' => 'none',
			'color' => [
				'color' => 'rgba(255, 255, 255, 0.2)',
			],
		]
	]);

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'value' => noorgfx_default_akg(
			'mobileMenuMargin', $atts,
			noorgfx_spacing_value([
				'left' => 'auto',
				'right' => 'auto',
			])
		)
	]);

	return;
}

// inline menu styles
$menu_items_spacing = noorgfx_akg('inline_menu_items_spacing', $atts, 25);

if ($menu_items_spacing !== 25) {
	if (isset($menu_items_spacing['desktop'])) {
		$menu_items_spacing['desktop'] = 'CT_CSS_SKIP_RULE';
	}

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'menu-items-spacing',
		'value' => $menu_items_spacing
	]);
}

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'variableName' => 'horizontal-alignment',
	'value' => noorgfx_akg( 'inline_menu_horizontal_alignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);

noorgfx_output_font_css([
	'font_value' => noorgfx_akg( 'inline_mobile_menu_font', $atts,
		noorgfx_typography_default_values([
			'size' => '12px',
			'variation' => 'n7',
			'line-height' => '1.3',
			'text-transform' => 'uppercase',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'suffix',
		'to_add' => 'ul'
	])),
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('inline_menu_font_color', $atts),
	'default' => [
		'default' => [ 'color' => 'var(--theme-text-color)' ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> ul > li > a'
			])),
			'variable' => 'theme-link-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> ul > li > a'
			])),
			'variable' => 'theme-link-hover-color'
		],

		'active' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> ul > li > a'
			])),
			'variable' => 'theme-link-active-color'
		],
	],
]);

// transparent state
if (isset($has_transparent_header) && $has_transparent_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('transparent_inline_menu_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '> ul > li > a'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '> ul > li > a'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-link-hover-color'
			],

			'active' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '> ul > li > a'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-link-active-color'
			],
		],
	]);
}

// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('sticky_inline_menu_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '> ul > li > a'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '> ul > li > a'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-link-hover-color'
			],

			'active' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '> ul > li > a'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-link-active-color'
			],
		],
	]);
}

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'inline_menu_margin',
		$atts,
		noorgfx_spacing_value()
	)
]);
