<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

if (empty($default_height)) {
	$default_height = [
		'mobile' => 70,
		'tablet' => 70,
		'desktop' => 120,
	];
}

if (empty($default_background)) {
	$default_background = noorgfx_background_default_value([
		'backgroundColor' => [
			'default' => [
				'color' => 'var(--theme-palette-color-8)',
			],
		],
	]);
}

// Row height
$headerRowHeight = noorgfx_akg('headerRowHeight', $atts, $default_height);

$headerRowHeight = noorgfx_expand_responsive_value($headerRowHeight);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'variableName' => 'height',
	'value' => $headerRowHeight
]);

// Row background
$headerRowBackground = noorgfx_expand_responsive_value(
	noorgfx_akg('headerRowBackground', $atts, $default_background)
);

$headerRowWidth = noorgfx_expand_responsive_value(
	noorgfx_akg('headerRowWidth', $atts, 'fixed')
);

unset($headerRowWidth['tablet']);

$rowBackgroundValue = $headerRowBackground;
$containerBackgroundValue = $headerRowBackground;

if ($headerRowWidth['desktop'] === 'boxed') {
	$rowBackgroundValue['desktop']['background_type'] = 'color';
	$rowBackgroundValue['desktop']['backgroundColor'][
		'default'
	]['color'] = 'transparent';
} else {
	$containerBackgroundValue['desktop']['background_type'] = 'color';
	$containerBackgroundValue['desktop']['backgroundColor'][
		'default'
	]['color'] = 'transparent';
}

if ($headerRowWidth['mobile'] === 'boxed') {
	$rowBackgroundValue['tablet']['background_type'] = 'color';
	$rowBackgroundValue['tablet']['backgroundColor'][
		'default'
	]['color'] = 'transparent';

	$rowBackgroundValue['mobile']['background_type'] = 'color';
	$rowBackgroundValue['mobile']['backgroundColor'][
		'default'
	]['color'] = 'transparent';
} else {
	$containerBackgroundValue['tablet']['background_type'] = 'color';
	$containerBackgroundValue['tablet']['backgroundColor'][
		'default'
	]['color'] = 'transparent';

	$containerBackgroundValue['mobile']['background_type'] = 'color';
	$containerBackgroundValue['mobile']['backgroundColor'][
		'default'
	]['color'] = 'transparent';
}

if (
	noorgfx_some_device($headerRowWidth, 'fixed')
	||
	noorgfx_some_device($headerRowWidth, 'fluid')
) {
	noorgfx_output_background_css([
		'selector' => noorgfx_assemble_selector($root_selector),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'value' => $rowBackgroundValue,
		'responsive' => true,
		'forced_background_image' => true
	]);
}

if (noorgfx_some_device($headerRowWidth, 'boxed')) {
	noorgfx_output_background_css([
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> div'
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'value' => $containerBackgroundValue,
		'responsive' => true,
		'forced_background_image' => true
	]);

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'property' => 'row-padding',
		'value' => noorgfx_akg(
			'header_row_padding',
			$atts,
			[
				'desktop' => noorgfx_spacing_value([
					'top' => 'auto',
					'left' => '35px',
					'right' => '35px',
					'bottom' => 'auto',
				]),
				'tablet' => noorgfx_spacing_value([
					'top' => 'auto',
					'left' => '4vw',
					'right' => '4vw',
					'bottom' => 'auto',
				]),
				'mobile'=> noorgfx_spacing_value([
					'top' => 'auto',
					'left' => '5vw',
					'right' => '5vw',
					'bottom' => 'auto',
				]),
				'__changed' => ['tablet', 'mobile']
			]
		)
	]);

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'property' => 'row-border-radius',
		'value' => noorgfx_akg(
			'header_row_border_radius',
			$atts,
			noorgfx_spacing_value()
		)
	]);
}

// Top Border
$headerRowTopBorderFullWidth = noorgfx_akg('headerRowTopBorderFullWidth', $atts, 'no');

$top_has_border_selector = noorgfx_mutate_selector([
	'selector' => $root_selector,
	'operation' => 'suffix',
	'to_add' => '> div'
]);

$top_has_no_border_selector = $root_selector;

if ($headerRowTopBorderFullWidth === 'yes') {
	$top_has_border_selector = $root_selector;

	$top_has_no_border_selector = noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'suffix',
		'to_add' => '> div'
	]);
}

noorgfx_output_border([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($top_has_border_selector),
	'variableName' => 'theme-border-top',
	'value' => noorgfx_akg('headerRowTopBorder', $atts),
	'default' => [
		'width' => 1,
		'style' => 'none',
		'color' => [
			'color' => 'rgba(44,62,80,0.2)',
		],
	],
	'responsive' => true
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($top_has_no_border_selector),
	'variableName' => 'theme-border-top',
	'value' => [
		'desktop' => 'none',
		'tablet' => 'none',
		'mobile' => 'none'
	],
	'unit' => ''
]);


// Bottom Border
$headerRowBottomBorderFullWidth = noorgfx_akg('headerRowBottomBorderFullWidth', $atts, 'no');

$bottom_has_border_selector = noorgfx_mutate_selector([
	'selector' => $root_selector,
	'operation' => 'suffix',
	'to_add' => '> div'
]);
$bottom_has_no_border_selector = $root_selector;

if ($headerRowBottomBorderFullWidth === 'yes') {
	$bottom_has_border_selector = $root_selector;

	$bottom_has_no_border_selector = noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'suffix',
		'to_add' => '> div'
	]);
}

noorgfx_output_border([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($bottom_has_border_selector),
	'variableName' => 'theme-border-bottom',
	'value' => noorgfx_akg('headerRowBottomBorder', $atts),
	'default' => [
		'width' => 1,
		'style' => 'none',
		'color' => [
			'color' => 'rgba(44,62,80,0.2)',
		],
	],
	'responsive' => true
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($bottom_has_no_border_selector),
	'variableName' => 'theme-border-bottom',
	'value' => [
		'desktop' => 'none',
		'tablet' => 'none',
		'mobile' => 'none'
	],
	'unit' => ''
]);

// Box shadow
noorgfx_output_box_shadow([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'value' => noorgfx_akg('headerRowShadow', $atts, noorgfx_box_shadow_value([
		'enable' => false,
		'h_offset' => 0,
		'v_offset' => 10,
		'blur' => 20,
		'spread' => 0,
		'inset' => false,
		'color' => [
			'color' => 'rgba(44,62,80,0.05)',
		],
	])),
	'responsive' => true,
	'should_skip_output' => false
]);

// Backdrop Blur
$headerRowBlur = noorgfx_akg('headerRowBlur', $atts, 0);

if($headerRowBlur !== 0) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'theme-backdrop-blur',
		'value' => $headerRowBlur,
		'unit' => 'px',
		'should_skip_output' => false
	]);
}


// transparent state
if (isset($has_transparent_header) && $has_transparent_header) {
	// background
	$transparentHeaderRowBackground = noorgfx_expand_responsive_value(
		noorgfx_akg(
			'transparentHeaderRowBackground',
			$atts,
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => 'rgba(255,255,255,0)',
					],
				],
			])
		)
	);

	$rowBackgroundValue = $transparentHeaderRowBackground;
	$containerBackgroundValue = $transparentHeaderRowBackground;

	if ($headerRowWidth['desktop'] === 'boxed') {
		$rowBackgroundValue['desktop']['background_type'] = 'color';
		$rowBackgroundValue['desktop']['backgroundColor'][
			'default'
		]['color'] = 'transparent';
	} else {
		$containerBackgroundValue['desktop']['background_type'] = 'color';
		$containerBackgroundValue['desktop']['backgroundColor'][
			'default'
		]['color'] = 'transparent';
	}

	if ($headerRowWidth['mobile'] === 'boxed') {
		$rowBackgroundValue['tablet']['background_type'] = 'color';
		$rowBackgroundValue['tablet']['backgroundColor'][
			'default'
		]['color'] = 'transparent';

		$rowBackgroundValue['mobile']['background_type'] = 'color';
		$rowBackgroundValue['mobile']['backgroundColor'][
			'default'
		]['color'] = 'transparent';
	} else {
		$containerBackgroundValue['tablet']['background_type'] = 'color';
		$containerBackgroundValue['tablet']['backgroundColor'][
			'default'
		]['color'] = 'transparent';

		$containerBackgroundValue['mobile']['background_type'] = 'color';
		$containerBackgroundValue['mobile']['backgroundColor'][
			'default'
		]['color'] = 'transparent';
	}

	if (
		noorgfx_some_device($headerRowWidth, 'fixed')
		||
		noorgfx_some_device($headerRowWidth, 'fluid')
	) {
		noorgfx_output_background_css([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'el-prefix',
				'to_add' => '[data-transparent-row="yes"]'
			])),

			'value' => $rowBackgroundValue,
			'responsive' => true,
			'forced_background_image' => true
		]);
	}

	if (noorgfx_some_device($headerRowWidth, 'boxed')) {
		noorgfx_output_background_css([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'el-prefix',
						'to_add' => '[data-transparent-row="yes"]'
					]),
					'operation' => 'suffix',
					'to_add' => '> div'
				])
			),

			'value' => $containerBackgroundValue,
			'responsive' => true,
			'forced_background_image' => true
		]);
	}

	// Border top
	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $top_has_border_selector,
			'operation' => 'el-prefix',
			'to_add' => '[data-transparent-row="yes"]'
		])),
		'variableName' => 'theme-border-top',
		'value' => noorgfx_akg('transparentHeaderRowTopBorder', $atts),
		'default' => [
			'width' => 1,
			'style' => 'none',
			'color' => [
				'color' => 'rgba(44,62,80,0.2)',
			],
		],
		'responsive' => true
	]);

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $top_has_no_border_selector,
			'operation' => 'el-prefix',
			'to_add' => '[data-transparent-row="yes"]'
		])),

		'variableName' => 'theme-border-top',
		'value' => [
			'desktop' => 'none',
			'tablet' => 'none',
			'mobile' => 'none'
		],
		'unit' => ''
	]);

	// Border bottom
	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $bottom_has_border_selector,
			'operation' => 'el-prefix',
			'to_add' => '[data-transparent-row="yes"]'
		])),

		'variableName' => 'theme-border-bottom',
		'value' => noorgfx_akg('transparentHeaderRowBottomBorder', $atts),
		'default' => [
			'width' => 1,
			'style' => 'none',
			'color' => [
				'color' => 'rgba(44,62,80,0.2)',
			],
		],
		'responsive' => true
	]);

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $bottom_has_no_border_selector,
			'operation' => 'el-prefix',
			'to_add' => '[data-transparent-row="yes"]'
		])),

		'variableName' => 'theme-border-bottom',
		'value' => [
			'desktop' => 'none',
			'tablet' => 'none',
			'mobile' => 'none'
		],
		'unit' => ''
	]);

	// box shadow
	noorgfx_output_box_shadow([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'el-prefix',
			'to_add' => '[data-transparent-row="yes"]'
		])),

		'value' => noorgfx_akg('transparentHeaderRowShadow', $atts, noorgfx_box_shadow_value([
			'enable' => false,
			'h_offset' => 0,
			'v_offset' => 10,
			'blur' => 20,
			'spread' => 0,
			'inset' => false,
			'color' => [
				'color' => 'rgba(44,62,80,0.05)',
			],
		])),
		'responsive' => true,
		'should_skip_output' => false
	]);

	// Backdrop Blur
	$transparentHeaderRowBlur = noorgfx_akg('transparentHeaderRowBlur', $atts, 0);

	if($transparentHeaderRowBlur !== 0) {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'el-prefix',
				'to_add' => '[data-transparent-row="yes"]'
			])),
			'variableName' => 'theme-backdrop-blur',
			'value' => $transparentHeaderRowBlur,
			'unit' => 'px',
			'should_skip_output' => false
		]);
	}
}

// sticky state
if (
	isset($has_sticky_header)
	&&
	$has_sticky_header
) {
	// background
	$stickyHeaderRowBackground = noorgfx_expand_responsive_value(noorgfx_akg(
		'stickyHeaderRowBackground',
		$atts,
		$default_background
	));

	$rowBackgroundValue = $stickyHeaderRowBackground;
	$containerBackgroundValue = $stickyHeaderRowBackground;

	if ($headerRowWidth['desktop'] === 'boxed') {
		$rowBackgroundValue['desktop']['background_type'] = 'color';
		$rowBackgroundValue['desktop']['backgroundColor'][
			'default'
		]['color'] = 'transparent';
	} else {
		$containerBackgroundValue['desktop']['background_type'] = 'color';
		$containerBackgroundValue['desktop']['backgroundColor'][
			'default'
		]['color'] = 'transparent';
	}

	if ($headerRowWidth['mobile'] === 'boxed') {
		$rowBackgroundValue['tablet']['background_type'] = 'color';
		$rowBackgroundValue['tablet']['backgroundColor'][
			'default'
		]['color'] = 'transparent';

		$rowBackgroundValue['mobile']['background_type'] = 'color';
		$rowBackgroundValue['mobile']['backgroundColor'][
			'default'
		]['color'] = 'transparent';
	} else {
		$containerBackgroundValue['tablet']['background_type'] = 'color';
		$containerBackgroundValue['tablet']['backgroundColor'][
			'default'
		]['color'] = 'transparent';

		$containerBackgroundValue['mobile']['background_type'] = 'color';
		$containerBackgroundValue['mobile']['backgroundColor'][
			'default'
		]['color'] = 'transparent';
	}

	if (
		noorgfx_some_device($headerRowWidth, 'fixed')
		||
		noorgfx_some_device($headerRowWidth, 'fluid')
	) {
		noorgfx_output_background_css([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'to_add' => '[data-sticky*="yes"]'
			])),

			'value' => $rowBackgroundValue,
			'forced_background_image' => true,
			'responsive' => true
		]);
	}

	if (noorgfx_some_device($headerRowWidth, 'boxed')) {
		noorgfx_output_background_css([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'to_add' => '[data-sticky*="yes"]'
					]),
					'operation' => 'suffix',
					'to_add' => '> div'
				])
			),

			'value' => $containerBackgroundValue,
			'forced_background_image' => true,
			'responsive' => true
		]);
	}

	if (
		noorgfx_akg('has_sticky_shrink', $atts, 'no') === 'yes'
		&&
		isset($root_selector_header)
		&&
		isset($has_sticky_header['behaviour'])
		&&
		(
			strpos($has_sticky_header['behaviour'], 'middle') !== false
			||
			$has_sticky_header['behaviour'] === 'entire_header'
		)
	) {
		if (
			$has_sticky_header['effect'] !== 'shrink'
			&&
			$has_sticky_header['effect'] !== 'auto-hide'
		) {
			$stickyHeaderRowShrink = noorgfx_expand_responsive_value(noorgfx_akg(
				'stickyHeaderRowShrink',
				$atts,
				70
			));

			$shrinkedHeight = [
				'desktop' => intval(floatval(
					$headerRowHeight['desktop']
				) * floatval($stickyHeaderRowShrink['desktop']) / 100) . 'px',
				'tablet' => intval(floatval(
					$headerRowHeight['tablet']
				) * intval($stickyHeaderRowShrink['tablet']) / 100) . 'px',
				'mobile' => intval(floatval(
					$headerRowHeight['mobile']
				) * intval($stickyHeaderRowShrink['mobile']) / 100) . 'px'
			];

			noorgfx_output_responsive([
				'css' => $css,
				'tablet_css' => $tablet_css,
				'mobile_css' => $mobile_css,
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'to_add' => '[data-sticky*="yes"]'
						]),
						'operation' => 'suffix',
						'to_add' => '> div'
					])
				),
				'variableName' => 'shrink-height',
				'value' => $shrinkedHeight,
				'unit' => ''
			]);
		}

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_assemble_selector($root_selector_header),
			'variableName' => 'sticky-shrink',
			'value' => noorgfx_akg('stickyHeaderRowShrink', $atts, 70),
			'unit' => ''
		]);
	}

	// Border top
	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $top_has_border_selector,
			'to_add' => '[data-sticky*="yes"]'
		])),
		'variableName' => 'theme-border-top',
		'value' => noorgfx_akg('stickyHeaderRowTopBorder', $atts),
		'default' => [
			'width' => 1,
			'style' => 'none',
			'color' => [
				'color' => 'rgba(44,62,80,0.2)',
			],
		],
		'responsive' => true
	]);

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $top_has_no_border_selector,
			'to_add' => '[data-sticky*="yes"]'
		])),

		'variableName' => 'theme-border-top',
		'value' => [
			'desktop' => 'none',
			'tablet' => 'none',
			'mobile' => 'none'
		],
		'unit' => ''
	]);

	// Border bottom
	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $bottom_has_border_selector,
			'to_add' => '[data-sticky*="yes"]'
		])),

		'variableName' => 'theme-border-bottom',
		'value' => noorgfx_akg('stickyHeaderRowBottomBorder', $atts),
		'default' => [
			'width' => 1,
			'style' => 'none',
			'color' => [
				'color' => 'rgba(44,62,80,0.2)',
			],
		],
		'responsive' => true
	]);

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $bottom_has_no_border_selector,
			'to_add' => '[data-sticky*="yes"]'
		])),

		'variableName' => 'theme-border-bottom',
		'value' => [
			'desktop' => 'none',
			'tablet' => 'none',
			'mobile' => 'none'
		],
		'unit' => ''
	]);

	// box shadow
	noorgfx_output_box_shadow([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $root_selector,
			'to_add' => '[data-sticky*="yes"]'
		])),
		'value' => noorgfx_akg('stickyHeaderRowShadow', $atts, noorgfx_box_shadow_value([
			'enable' => false,
			'h_offset' => 0,
			'v_offset' => 10,
			'blur' => 20,
			'spread' => 0,
			'inset' => false,
			'color' => [
				'color' => 'rgba(44,62,80,0.05)',
			],
		])),
		'responsive' => true,
		'should_skip_output' => false
	]);

	// Backdrop Blur
	$stickyHeaderRowBlur = noorgfx_akg('stickyHeaderRowBlur', $atts, 0);

	if($stickyHeaderRowBlur !== 0) {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'to_add' => '[data-sticky*="yes"]'
			])),
			'variableName' => 'theme-backdrop-blur',
			'value' => $stickyHeaderRowBlur,
			'unit' => 'px',
			'should_skip_output' => false
		]);
	}
}