<?php

if (! isset($location)) {
	$location = 'Header Menu 1';
}

$options = [
	'menu' => [
		'label' => __('Select Menu', 'noorgfx'),
		'type' => 'ct-select',
		'value' => 'noorgfx_location',
		'view' => 'text',
		'design' => 'inline',
		'setting' => ['transport' => 'postMessage'],
		'placeholder' => __('Select menu...', 'noorgfx'),
		'choices' => noorgfx_ordered_keys(noorgfx_get_menus_items($location)),
		'desc' => noorgfx_safe_sprintf(
			// translators: placeholder here means the actual URL.
			__( 'Manage your menu items in the %sMenus screen%s.', 'noorgfx' ),
			noorgfx_safe_sprintf(
				'<a href="%s" target="_blank">',
				admin_url('/nav-menus.php')
			),
			'</a>'
		),
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-title',
		'label' => __( 'Top Level Options', 'noorgfx' ),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'header_menu_type' => [
				'label' => false,
				'type' => 'ct-image-picker',
				'value' => 'type-1',
				'attr' => [ 'data-type' => 'background' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'switchDeviceOnChange' => 'desktop',
				'divider' => 'bottom',
				'choices' => [

					'type-1' => [
						'src'   => noorgfx_image_picker_url( 'menu-type-1.svg' ),
						'title' => __( 'Type 1', 'noorgfx' ),
					],

					'type-2' => [
						'src'   => noorgfx_image_picker_url( 'menu-type-2.svg' ),
						'title' => __( 'Type 2', 'noorgfx' ),
					],

					'type-3' => [
						'src'   => noorgfx_image_picker_url( 'menu-type-3.svg' ),
						'title' => __( 'Type 3', 'noorgfx' ),
					],

					'type-4' => [
						'src'   => noorgfx_image_picker_url( 'menu-type-4.svg' ),
						'title' => __( 'Type 4', 'noorgfx' ),
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'header_menu_type' => 'type-2' ],
				'options' => [

					'menu_indicator_effect' => [
						'label' => __( 'Indicator Effect', 'noorgfx' ),
						'type' => 'ct-select',
						'value' => 'default',
						'view' => 'text',
						'divider' => 'bottom',
						'design' => 'inline',
						'choices' => noorgfx_ordered_keys(
							[
								'default' => __( 'Default', 'noorgfx' ),
								'center' => __( 'Center to Sides', 'noorgfx' ),
								'left' => __( 'Left to Right', 'noorgfx' ),
							]
						),
					],

				],
			],

			'headerMenuItemsGap' => [
				'label' => __( 'Items Spacing', 'noorgfx' ),
				'type' => 'ct-slider',
				'value' => 0,
				'min' => 0,
				'max' => 100,
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'headerMenuItemsSpacing' => [
				'label' => __('Items Inner Spacing', 'noorgfx'),
				'type' => 'ct-slider',
				'value' => 25,
				'min' => 0,
				'max' => 100,
				// 'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'header_menu_type' => '!type-1' ],
				'options' => [

					'headerMenuItemsHeight' => [
						'label' => __( 'Items Height', 'noorgfx' ),
						'type' => 'ct-slider',
						'value' => 100,
						'min' => 0,
						'max' => 100,
						'defaultUnit' => '%',
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],

			'stretch_menu' => [
				'label' => __( 'Stretch Menu', 'noorgfx' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'divider' => 'top',
				'desc' => __('Enabling this option will make the menu to stretch and fit the width of its parent column. ', 'noorgfx'),
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'collapse_non_fitting_menu_items' => [
				'label' => __('Collapse Non Fitting Items', 'noorgfx'),
				'type' => 'ct-switch',
				'value' => 'yes',
				'divider' => 'top',
				'desc' => __('Collapse menu items in to a dropdown if there is no enough room in the row. ', 'noorgfx'),
				'setting' => [ 'transport' => 'postMessage' ],
			],
		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'headerMenuFont' => [
				'type' => 'ct-typography',
				'label' => __( 'Font', 'noorgfx' ),
				'value' => noorgfx_typography_default_values([
					'size' => '12px',
					'variation' => 'n7',
					'line-height' => '1.3',
					'text-transform' => 'uppercase',
				]),
				'typography_responsive' => [
					'desktop' => true,
					'tablet' => false,
					'mobile' => false,
				],
				'setting' => [ 'transport' => 'postMessage' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Font Color', 'noorgfx' ),
				'responsive' => false,
				'choices' => [
					[
						'id' => 'menuFontColor',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentMenuFontColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyMenuFontColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'menuFontColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => 'var(--theme-text-color)',
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover-type-3' => [
								'color' => '#ffffff',
							],

							'active-type-3' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-link-hover-color)',
								'condition' => [ 'header_menu_type' => '!type-3' ]
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'condition' => [ 'header_menu_type' => '!type-3' ],
								'inherit' => 'self:hover'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover-type-3',
								'condition' => [ 'header_menu_type' => 'type-3' ]
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active-type-3',
								'condition' => [ 'header_menu_type' => 'type-3' ],
								'inherit' => 'self:hover-type-3'
							],
						],
					],

					'transparentMenuFontColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover-type-3' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active-type-3' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'condition' => [ 'header_menu_type' => '!type-3' ]
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'condition' => [ 'header_menu_type' => '!type-3' ],
								'inherit' => 'self:hover'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover-type-3',
								'condition' => [ 'header_menu_type' => 'type-3' ],
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active-type-3',
								'condition' => [ 'header_menu_type' => 'type-3' ],
								'inherit' => 'self:hover-type-3'
							],
						],
					],

					'stickyMenuFontColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover-type-3' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active-type-3' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'condition' => [ 'header_menu_type' => '!type-3' ]
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'condition' => [ 'header_menu_type' => '!type-3' ],
								'inherit' => 'self:hover'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover-type-3',
								'condition' => [ 'header_menu_type' => 'type-3' ]
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active-type-3',
								'condition' => [ 'header_menu_type' => 'type-3' ],
								'inherit' => 'self:hover-type-3'
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => [
					__('Indicator Color', 'noorgfx') => [
						'header_menu_type' => '!type-3'
					],

					__('Background Color', 'noorgfx') => [
						'header_menu_type' => 'type-3'
					]
				],
				'responsive' => false,
				'divider' => 'top',
				'choices' => [
					[
						'id' => 'menuIndicatorColor',
						'label' => __('Default State', 'noorgfx'),
						'condition' => [ 'header_menu_type' => '!type-1' ],
					],

					[
						'id' => 'transparentMenuIndicatorColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'header_menu_type' => '!type-1',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyMenuIndicatorColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'header_menu_type' => '!type-1',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'menuIndicatorColor' => [
						'label' => [
							__('Indicator Color', 'noorgfx') => [
								'header_menu_type' => '!type-3'
							],

							__('Background Color', 'noorgfx') => [
								'header_menu_type' => 'type-3'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-2)',
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'self:hover'
							],
						],
					],

					'transparentMenuIndicatorColor' => [
						'label' => [
							__('Indicator Color', 'noorgfx') => [
								'header_menu_type' => '!type-3'
							],

							__('Background Color', 'noorgfx') => [
								'header_menu_type' => 'type-3'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'self:hover'
							],
						],
					],

					'stickyMenuIndicatorColor' => [
						'label' => [
							__('Indicator Color', 'noorgfx') => [
								'header_menu_type' => '!type-3'
							],

							__('Background Color', 'noorgfx') => [
								'header_menu_type' => 'type-3'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'self:hover'
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'header_menu_type' => 'type-3' ],
				'options' => [

					'headerToplevelBorderRadius' => [
						'label' => __( 'Items Border Radius', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_spacing_value(),
						'min' => 0,
					],

				],
			],

			'headerMenuMargin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(
					// [
					// 	'top' => 'auto',
					// 	'bottom' => 'auto',
					// ]
				),
				// 'responsive' => true
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-title',
		'label' => __( 'Dropdown Options', 'noorgfx' ),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'dropdown_interaction' => [
				'label' => __('Interaction Type', 'noorgfx'),
				'type' => 'ct-radio',
				'value' => 'hover',
				'view' => 'text',
				'design' => 'block',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'hover' => __( 'Hover', 'noorgfx' ),
					'click' => __( 'Click', 'noorgfx' ),
				],
				'desc' => __( 'Choose the interaction mode with the menu dropdown. ', 'noorgfx' ),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'dropdown_interaction' => 'click' ],
				'options' => [

					'dropdown_click_interaction' => [
						'label' => __('Click Area', 'noorgfx'),
						'type' => 'ct-radio',
						'value' => 'item',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'item' => __( 'Entire Item', 'noorgfx' ),
							'arrow' => __( 'Only Arrow', 'noorgfx' ),
						],
					],

				],
			],

			'dropdown_items_type' => [
				'label' => __('Items Hover Effect', 'noorgfx'),
				'type' => 'ct-radio',
				'value' => 'simple',
				'view' => 'radio',
				'design' => 'block',
				'divider' => 'top:full',
				'attr' => [ 'data-columns' => '2' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'simple' => __( 'Simple', 'noorgfx' ),
					'solid' => __( 'Solid Color', 'noorgfx' ),
					'padded' => __( 'Boxed Color', 'noorgfx' ),
					// 'bordered' => __( 'Bordered', 'noorgfx' ),
				],
			],

			'dropdownItemsSpacing' => [
				'label' => __( 'Items Spacing', 'noorgfx' ),
				'type' => 'ct-slider',
				'value' => 13,
				'min' => 5,
				'max' => 30,
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'dropdown_animation' => [
				'label' => __('Reveal Effect', 'noorgfx'),
				'type' => 'ct-radio',
				'value' => 'type-1',
				'view' => 'radio',
				'design' => 'block',
				'divider' => 'top:full',
				'attr' => [ 'data-columns' => '2' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'type-1' => __( 'Default', 'noorgfx' ),
					'type-3' => __( 'Inner Reveal', 'noorgfx' ),
					'type-2' => __( 'Opacity', 'noorgfx' ),
					'type-4' => __( 'Simple', 'noorgfx' ),
				],
			],

			'dropdownMenuWidth' => [
				'label' => __( 'Width', 'noorgfx' ),
				'type' => 'ct-slider',
				'value' => 200,
				'min' => 100,
				'max' => 300,
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'dropdownTopOffset' => [
				'label' => __( 'Top Offset', 'noorgfx' ),
				'type' => 'ct-slider',
				'value' => 0,
				'min' => -150,
				'max' => 150,
				'steps' => 'half',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'builderSettings/has_sticky_header' => 'yes',
				],
				'options' => [

					'stickyStateDropdownTopOffset' => [
						'label' => __( 'Top Offset (Sticky State)', 'noorgfx' ),
						'type' => 'ct-slider',
						'value' => 0,
						'min' => -150,
						'max' => 150,
						'steps' => 'half',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

				]
			],

			'dropdown_horizontal_offset' => [
				'label' => __( 'Horizontal Offset', 'noorgfx' ),
				'type' => 'ct-slider',
				'value' => 5,
				'min' => 0,
				'max' => 20,
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'desc' => __( 'Please note, this option will affect only submenus on 3rd level and below.', 'noorgfx' ),
			],
		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'headerDropdownFont' => [
				'type' => 'ct-typography',
				'label' => __( 'Font', 'noorgfx' ),
				'value' => noorgfx_typography_default_values([
					'size' => '12px',
					'variation' => 'n5',
				]),
				'typography_responsive' => [
					'desktop' => true,
					'tablet' => false,
					'mobile' => false,
				],
				'setting' => [ 'transport' => 'postMessage' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Font Color', 'noorgfx' ),
				'responsive' => false,
				'divider' => 'bottom',
				'choices' => [
					[
						'id' => 'headerDropdownFontColor',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderDropdownFontColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderDropdownFontColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerDropdownFontColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => 'var(--theme-palette-color-8)',
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-link-hover-color)'
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'self:hover'
							],
						],
					],

					'transparentHeaderDropdownFontColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'self:hover'
							],
						],
					],

					'stickyHeaderDropdownFontColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'self:hover'
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Items Background Color', 'noorgfx' ),
				'responsive' => false,
				'divider' => 'bottom',
				'choices' => [
					[
						'id' => 'headerDropdownBackground',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderDropdownBackground',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderDropdownBackground',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerDropdownBackground' => [
						'label' => __( 'Items Background Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-palette-color-4)'
							],

							[
								'title' => __( 'Hover/Active', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'rgba(255, 255, 255, 0.03)',
								'condition' => [ 'dropdown_items_type' => 'solid|padded' ]
							],
						],
					],

					'transparentHeaderDropdownBackground' => [
						'label' => __( 'Items Background Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover/Active', 'noorgfx' ),
								'id' => 'hover',
								'condition' => [ 'dropdown_items_type' => 'solid|padded' ]
							],
						],
					],

					'stickyHeaderDropdownBackground' => [
						'label' => __( 'Items Background Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover/Active', 'noorgfx' ),
								'id' => 'hover',
								'condition' => [ 'dropdown_items_type' => 'solid|padded' ]
							],
						],
					],

				],
			],

			'headerDropdownDivider' => [
				'label' => __( 'Items Divider', 'noorgfx' ),
				'type' => 'ct-border',
				'design' => 'inline',
				'divider' => 'bottom',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => [
					'width' => 1,
					'style' => 'dashed',
					'color' => [
						'color' => 'rgba(255, 255, 255, 0.1)',
					],
				]
			],

			'headerDropdownShadow' => [
				'label' => __( 'Dropdown Shadow', 'noorgfx' ),
				'type' => 'ct-box-shadow',
				'design' => 'inline',
				'divider' => 'bottom',
				'value' => noorgfx_box_shadow_value([
					'enable' => true,
					'h_offset' => 0,
					'v_offset' => 10,
					'blur' => 20,
					'spread' => 0,
					'inset' => false,
					'color' => [
						'color' => 'rgba(41, 51, 61, 0.1)',
					],
				])
			],

			'headerDropdownRadius' => [
				'label' => __( 'Dropdown Border Radius', 'noorgfx' ),
				'type' => 'ct-spacing',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value([
					'top' => '0px',
					'left' => '2px',
					'right' => '0px',
					'bottom' => '2px',
				]),
				'min' => 0,
			],

		],
	],
];
