<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

// Logo size
$logo_max_height = noorgfx_akg('logoMaxHeight', $atts, 50);

if ($logo_max_height !== 50) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.site-logo-container'
			])
		),
		'variableName' => 'logo-max-height',
		'value' => $logo_max_height,
	]);
}

$logo_max_height = noorgfx_expand_responsive_value($logo_max_height);

// Site title font
noorgfx_output_font_css([
	'font_value' => noorgfx_akg('siteTitle', $atts,
		noorgfx_typography_default_values([
			'size' => '25px',
			'variation' => 'n7',
			'line-height' => '1.5'
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.site-title'
		])
	),
]);

// Site title color
noorgfx_output_colors([
	'value' => noorgfx_akg('siteTitleColor', $atts),
	'default' => [
		'default' => [ 'color' => 'var(--theme-palette-color-4)' ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.site-title'
				])
			),
			'variable' => 'theme-link-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.site-title'
				])
			),
			'variable' => 'theme-link-hover-color'
		],
	],
	'responsive' => true
]);

if (isset($has_transparent_header) && $has_transparent_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentSiteTitleColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.site-title'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.site-title'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-link-hover-color'
			],
		],
		'responsive' => true
	]);

	// Site tagline color
	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentSiteTaglineColor', $atts),
		'default' => [
			'default' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.site-description'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-text-color'
			],
		],
		'responsive' => true
	]);
}

// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('stickySiteTitleColor', $atts),
		'default' => [
			'default' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')],
			'hover' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.site-title'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.site-title'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-link-hover-color'
			],
		],
		'responsive' => true
	]);

	// Site tagline color
	noorgfx_output_colors([
		'value' => noorgfx_akg('stickySiteTaglineColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.site-description'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-text-color'
			],
		],
		'responsive' => true
	]);

	if (noorgfx_akg('has_sticky_logo_shrink', $atts, 'no') === 'yes') {
		$sticky_logo_shrink = noorgfx_expand_responsive_value(noorgfx_akg(
			'sticky_logo_shrink',
			$atts,
			70
		));

		$sticky_logo_shrink['desktop'] = intval($sticky_logo_shrink['desktop']) / 100;
		$sticky_logo_shrink['tablet'] = intval($sticky_logo_shrink['tablet']) / 100;
		$sticky_logo_shrink['mobile'] = intval($sticky_logo_shrink['mobile']) / 100;

		if (
			$has_sticky_header['effect'] !== 'shrink'
			&&
			$has_sticky_header['effect'] !== 'auto-hide'
		) {
			$shrinkedHeight = [
				'desktop' => intval($logo_max_height['desktop'] * $sticky_logo_shrink['desktop']) . 'px',
				'tablet' => intval($logo_max_height['tablet'] * $sticky_logo_shrink['tablet']) . 'px',
				'mobile' => intval($logo_max_height['mobile'] * $sticky_logo_shrink['mobile']) . 'px'
			];

			noorgfx_output_responsive([
				'css' => $css,
				'tablet_css' => $tablet_css,
				'mobile_css' => $mobile_css,
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variableName' => 'logo-shrink-height',
				'value' => $shrinkedHeight,
				'unit' => ''
			]);
		} else {
			noorgfx_output_responsive([
				'css' => $css,
				'tablet_css' => $tablet_css,
				'mobile_css' => $mobile_css,
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'to_add' => '[data-sticky]'
				])),
				'variableName' => 'logo-sticky-shrink',
				'value' => $sticky_logo_shrink,
				'unit' => ''
			]);
		}
	}
}

// Site tagline font
$has_tagline = noorgfx_akg('has_tagline', $atts, 'no');

if ($has_tagline === 'yes') {
	noorgfx_output_font_css([
		'font_value' => noorgfx_akg('siteTagline', $atts,
			noorgfx_typography_default_values([
				'size' => '13px',
				'variation' => 'n5',
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.site-description'
			])
		),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('siteTaglineColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.site-description'
					])
				),
				'variable' => 'theme-text-color'
			],
		],
		'responsive' => true
	]);
}

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'headerLogoMargin',
		$atts,
		noorgfx_spacing_value()
	)
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'variableName' => 'horizontal-alignment',
	'value' => noorgfx_akg( 'header_logo_horizontal_alignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);


// footer logo
noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => '[data-column="logo"]'
	])),
	'variableName' => 'horizontal-alignment',
	'value' => noorgfx_akg( 'footer_logo_horizontal_alignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);


noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => '[data-column="logo"]'
	])),
	'variableName' => 'vertical-alignment',
	'value' => noorgfx_akg( 'footer_logo_vertical_alignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);
