<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

$cart_drawer_type = noorgfx_akg( 'cart_drawer_type', $atts, 'dropdown' );

// Icon size
$cartIconSize = noorgfx_akg('cartIconSize', $atts, 15);

if ($cartIconSize !== 15) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'theme-icon-size',
		'value' => $cartIconSize
	]);
}

noorgfx_output_colors([
	'value' => noorgfx_akg('cartHeaderIconColor', $atts),
	'default' => [
		'default' => [ 'color' => 'var(--theme-text-color)' ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.ct-cart-item'
				])
			),
			'variable' => 'theme-icon-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.ct-cart-item'
				])
			),
			'variable' => 'theme-icon-hover-color'
		],
	],
	'responsive' => true
]);

$has_subtotal = (
	is_customize_preview()
	||
	noorgfx_some_device(noorgfx_default_akg(
		'cart_subtotal_visibility',
		$atts,
		[
			'desktop' => true,
			'tablet' => true,
			'mobile' => true,
		]
	))
);

$has_badge = (
	is_customize_preview()
	||
	noorgfx_default_akg('has_cart_badge', $atts, 'yes') === 'yes'
);

if ($has_badge) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('cartBadgeColor', $atts),
		'default' => [
			'background' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'text' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'background' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-cart-item'
					])
				),
				'variable' => 'theme-cart-badge-background'
			],

			'text' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-cart-item'
					])
				),
				'variable' => 'theme-cart-badge-text'
			],
		],
		'responsive' => true
	]);
}

if ($has_subtotal) {
	noorgfx_output_font_css([
		'font_value' => noorgfx_akg( 'cart_total_font', $atts,
		noorgfx_typography_default_values([
			'size' => '12px',
			'variation' => 'n6',
			'text-transform' => 'uppercase',
		])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-label'
			])
		)
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('cart_total_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-cart-item'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-cart-item'
					])
				),
				'variable' => 'theme-link-hover-color'
			],
		],
		'responsive' => true
	]);
}

// transparent state
if (isset($has_transparent_header) && $has_transparent_header) {
	if ($has_subtotal) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('transparent_cart_total_font_color', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-cart-item'
							]),
							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-link-initial-color'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-cart-item'
							]),
							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-link-hover-color'
				],
			],
			'responsive' => true
		]);
	}

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentCartHeaderIconColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-cart-item'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-icon-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-cart-item'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-icon-hover-color'
			],
		],
		'responsive' => true
	]);

	// Badge color
	if ($has_badge) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('transparentCartBadgeColor', $atts),
			'default' => [
				'background' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'text' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'background' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-cart-item'
							]),
							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-cart-badge-background'
				],

				'text' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-cart-item'
							]),
							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-cart-badge-text'
				],
			],
			'responsive' => true
		]);
	}
}


// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {
	if ($has_subtotal) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('sticky_cart_total_font_color', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-cart-item'
							]),
							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-link-initial-color'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-cart-item'
							]),
							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-link-hover-color'
				],
			],
			'responsive' => true
		]);
	}

	noorgfx_output_colors([
		'value' => noorgfx_akg('stickyCartHeaderIconColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-cart-item'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-icon-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-cart-item'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-icon-hover-color'
			],
		],
		'responsive' => true
	]);


	// Badge color
	if ($has_badge) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('stickyCartBadgeColor', $atts),
			'default' => [
				'background' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'text' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'background' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-cart-item'
							]),
							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-cart-badge-background'
				],

				'text' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-cart-item'
							]),
							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-cart-badge-text'
				],
			],
			'responsive' => true
		]);
	}
}

// dropdown type
if ($cart_drawer_type === 'dropdown' || is_customize_preview()) {

	// Dropdown top offset
	$cartDropdownTopOffset = noorgfx_akg( 'cartDropdownTopOffset', $atts, 15 );
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-cart-content'
			])
		),
		'--dropdownTopOffset: ' . $cartDropdownTopOffset . 'px'
	);

	// Cart font color
	noorgfx_output_colors([
		'value' => noorgfx_akg('cartFontColor', $atts),
		'default' => [
			'default' => [ 'color' => '#ffffff' ],
			'link_initial' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'link_hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-cart-content'
					])
				),
				'variable' => 'theme-text-color'
			],

			'link_initial' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-cart-content'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'link_hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-cart-content'
					])
				),
				'variable' => 'theme-link-hover-color'
			],
		],
	]);

	// Cart total font color
	noorgfx_output_colors([
		'value' => noorgfx_akg('cartTotalFontColor', $atts),
		'default' => [
			'default' => [ 'color' => '#ffffff' ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-cart-content .total'
					])
				),
				'variable' => 'theme-text-color'
			],
		],
	]);

	// Cart dropdown
	noorgfx_output_colors([
		'value' => noorgfx_akg('cartDropDownBackground', $atts),
		'default' => [
			'default' => ['color' => '#29333C']
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-cart-content'
					])
				),
				'variable' => 'mini-cart-background-color'
			]
		],
	]);
}


// offcanvas type
if ($cart_drawer_type === 'offcanvas' || is_customize_preview()) {

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			$root_selector[0] . ' #woo-cart-panel'
		),
		'variableName' => 'side-panel-width',
		'responsive' => true,
		'unit' => '',
		'value' => noorgfx_akg('cart_panel_width', $atts, [
			'desktop' => '500px',
			'tablet' => '65vw',
			'mobile' => '90vw',
		])
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('cart_panel_heading_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #woo-cart-panel .ct-panel-actions'
				),
				'variable' => 'theme-text-color'
			],
		],
		'responsive' => true
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('cart_panel_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'link_initial' => [ 'color' => 'var(--theme-headings-color)' ],
			'link_hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #woo-cart-panel .cart_list, ' . $root_selector[0] . ' #woo-cart-panel [class*="empty-message"]'
				),
				'variable' => 'theme-text-color'
			],

			'link_initial' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #woo-cart-panel .cart_list'
				),
				'variable' => 'theme-link-initial-color'
			],

			'link_hover' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #woo-cart-panel .cart_list'
				),
				'variable' => 'theme-link-hover-color'
			],
		],
		'responsive' => true
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('cart_panel_total_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #woo-cart-panel .total'
				),
				'variable' => 'theme-text-color'
			],
		],
		'responsive' => true
	]);

	noorgfx_output_box_shadow([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			$root_selector[0] . ' #woo-cart-panel'
		),
		'value' => noorgfx_akg('cart_panel_shadow', $atts, noorgfx_box_shadow_value([
			'enable' => true,
			'h_offset' => 0,
			'v_offset' => 0,
			'blur' => 70,
			'spread' => 0,
			'inset' => false,
			'color' => [
				'color' => 'rgba(0, 0, 0, 0.35)',
			],
		])),
		'responsive' => true
	]);

	noorgfx_output_background_css([
		'selector' => noorgfx_assemble_selector(
			$root_selector[0] . ' #woo-cart-panel .ct-panel-inner'
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'responsive' => true,
		'value' => noorgfx_akg('cart_panel_background', $atts,
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => 'var(--theme-palette-color-8)'
					],
				],
			])
		)
	]);

	noorgfx_output_background_css([
		'selector' => noorgfx_assemble_selector(
			$root_selector[0] . ' #woo-cart-panel'
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'responsive' => true,
		'value' => noorgfx_akg('cart_panel_backdrop', $atts,
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => 'rgba(18, 21, 25, 0.6)'
					],
				],
			])
		)
	]);

	$close_button_type = noorgfx_akg('cart_panel_close_button_type', $atts, 'type-1');

	noorgfx_output_colors([
		'value' => noorgfx_akg('cart_panel_close_button_color', $atts),
		'default' => [
			'default' => [ 'color' => 'rgba(0, 0, 0, 0.5)' ],
			'hover' => [ 'color' => 'rgba(0, 0, 0, 0.8)' ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'responsive' => true,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #woo-cart-panel .ct-toggle-close'
				),
				'variable' => 'theme-icon-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					$root_selector[0] . ' #woo-cart-panel .ct-toggle-close:hover'
				),
				'variable' => 'theme-icon-color'
			]
		],
	]);

	if ($close_button_type === 'type-2') {
		noorgfx_output_colors([
			'value' => noorgfx_akg('cart_panel_close_button_border_color', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'responsive' => true,
			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(
						$root_selector[0] . ' #woo-cart-panel .ct-toggle-close[data-type="type-2"]'
					),
					'variable' => 'toggle-button-border-color'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(
						$root_selector[0] . ' #woo-cart-panel .ct-toggle-close[data-type="type-2"]:hover'
					),
					'variable' => 'toggle-button-border-color'
				]
			],
		]);
	}

	if ($close_button_type === 'type-3') {
		noorgfx_output_colors([
			'value' => noorgfx_akg('cart_panel_close_button_shape_color', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'responsive' => true,
			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(
						$root_selector[0] . ' #woo-cart-panel .ct-toggle-close[data-type="type-3"]'
					),
					'variable' => 'toggle-button-background'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(
						$root_selector[0] . ' #woo-cart-panel .ct-toggle-close[data-type="type-3"]:hover'
					),
					'variable' => 'toggle-button-background'
				]
			],
		]);
	}

	$cart_panel_close_button_icon_size = noorgfx_akg( 'cart_panel_close_button_icon_size', $atts, 12 );

	if ($cart_panel_close_button_icon_size !== 12) {
		$css->put(
			noorgfx_assemble_selector(
				$root_selector[0] . ' #woo-cart-panel .ct-toggle-close'
			),
			'--theme-icon-size: ' . $cart_panel_close_button_icon_size . 'px'
		);
	}


	if ($close_button_type !== 'type-1') {
		$cart_panel_close_button_border_radius = noorgfx_akg( 'cart_panel_close_button_border_radius', $atts, 5 );

		if ($cart_panel_close_button_border_radius !== 5) {
			$css->put(
				noorgfx_assemble_selector(
					$root_selector[0] . ' #woo-cart-panel .ct-toggle-close'
				),
				'--toggle-button-radius: ' . $cart_panel_close_button_border_radius . 'px'
			);
		}
	}
}

// Image border radius
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		$root_selector[0] . ' .woocommerce-mini-cart'
	),
	'property' => 'theme-border-radius',
	'value' => noorgfx_default_akg('mini_cart_image_radius', $atts,
		noorgfx_spacing_value(),
	),
	'empty_value' => 3,
]);


// Margin
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'headerCartMargin',
		$atts,
		noorgfx_spacing_value()
	)
]);
