<?php

$header_button_user_visibility = noorgfx_akg(
	'user_visibility',
	$atts,
	[
		'logged_in' => true,
		'logged_out' => true,
	]
);

if (
	get_current_user_id() && ! $header_button_user_visibility['logged_in']
	||
	! get_current_user_id() && ! $header_button_user_visibility['logged_out']
) {
	return;
}

$class = 'ct-header-cta';

$visibility = noorgfx_default_akg('visibility', $atts, [
	'tablet' => true,
	'mobile' => true,
]);

$class .= ' ' . noorgfx_visibility_classes($visibility);

$header_button_open = noorgfx_akg(
	'header_button_open',
	$atts,
	'link'
);

$type = noorgfx_default_akg('header_button_type', $atts, 'type-1');
$size = noorgfx_default_akg('header_button_size', $atts, 'small');
$link = do_shortcode(
	noorgfx_translate_dynamic(
		noorgfx_default_akg('header_button_link', $atts, '#'),
		$panel_type . ':' . $section_id . ':' . $item_id . ':header_button_link'
	)
);

if ($header_button_open === 'popup') {
	$popup_id = noorgfx_akg(
		'header_button_select_popup',
		$atts,
		''
	);

	$link = '#';

	if (
		$popup_id
		&&
		class_exists('\Noorgfx\Plugin')
		&&
		\Noorgfx\Plugin::instance()->premium
		&&
		\Noorgfx\Plugin::instance()
			->premium
			->content_blocks
			->is_hook_eligible_for_display($popup_id, [
				'match_conditions' => false
			])
	) {
		$values = noorgfx_get_post_options($popup_id);

		if (noorgfx_default_akg('is_hook_enabled', $values, 'yes') === 'yes') {
			$link = '#ct-popup-' . $popup_id;
		}
	}
}

$link_attr = [];

$text = do_shortcode(
	noorgfx_translate_dynamic(
		noorgfx_default_akg(
			'header_button_text',
			$atts,
			__('Download', 'noorgfx')
		),
		$panel_type . ':' . $section_id . ':' . $item_id . ':header_button_text'
	)
);

$secondary_text = do_shortcode(
	noorgfx_translate_dynamic(
		noorgfx_default_akg(
			'header_button_secondary_text',
			$atts,
			__('Hurry Up!', 'noorgfx')
		),
		$panel_type . ':' . $section_id . ':' . $item_id . ':header_button_secondary_text'
	)
);

$aria_label = do_shortcode(
	noorgfx_translate_dynamic(
		noorgfx_default_akg(
			'button_aria_label',
			$atts,
			''
		),
		$panel_type . ':' . $section_id . ':' . $item_id . ':header_button_aria_label'
	)
);

if (empty(trim($aria_label)) && ! empty($text)) {
	$aria_label = $text;
}

$link_attr['data-size'] = $size;

if (! empty($aria_label)) {
	$link_attr['aria-label'] = $aria_label;
}

if (noorgfx_default_akg('header_button_target', $atts, 'no') === 'yes') {
	$link_attr['target'] = '_blank';
	$link_attr['rel'] = 'noopener noreferrer';
}

if (noorgfx_default_akg('header_button_nofollow', $atts, 'no') === 'yes') {
	if (! isset($link_attr['rel'])) {
		$link_attr['rel'] = '';
	}

	$link_attr['rel'] .= ' nofollow';
	$link_attr['rel'] = trim($link_attr['rel']);
}

if (noorgfx_default_akg('header_button_sponsored', $atts, 'no') === 'yes') {
	if (! isset($link_attr['rel'])) {
		$link_attr['rel'] = '';
	}

	$link_attr['rel'] .= ' sponsored';
	$link_attr['rel'] = trim($link_attr['rel']);
}


$button_class = 'ct-button';

if ($type === 'type-2') {
	$button_class = 'ct-button-ghost';
}

$button_class = trim($button_class . ' ' . noorgfx_default_akg(
	'header_button_class',
	$atts,
	''
));


$icon = '';

$icon_position = noorgfx_akg('icon_position', $atts, 'left');

if (function_exists('blc_get_icon')) {
	$icon = blc_get_icon([
		'icon_descriptor' => noorgfx_akg('icon', $atts, [
			'icon' => ''
		]),
		'icon_container' => false,
		'icon_html_atts' => [
			'class' => 'ct-icon',
		]
	]);
}

if (
	noorgfx_akg('has_header_button_secondary_text', $atts, 'no') === 'yes'
	&&
	(
		! empty(trim($secondary_text))
		||
		is_customize_preview()
	)
) {
	$text = noorgfx_html_tag(
		'span',
		[
			'class' => 'ct-button-text'
		],
		$text .
		noorgfx_html_tag(
			'span',
			[
				'class' => 'ct-button-secondary-text'
			],
			$secondary_text
		)
	);
}

if ($icon_position === 'left') {
	$text = $icon . $text;
}

if ($icon_position === 'right') {
	$text .= $icon;
}

?>

<div
	class="<?php echo esc_attr(trim($class)) ?>"
	<?php echo noorgfx_attr_to_html($attr) ?>>
	<a
		href="<?php echo esc_url(do_shortcode($link)) ?>"
		class="<?php echo $button_class ?>"
		<?php echo noorgfx_attr_to_html($link_attr) ?>>
		<?php echo $text ?>
	</a>
</div>
